/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.controller.impl;

import com.ibm.jbatch.container.IController;
import com.ibm.jbatch.container.artifact.proxy.InjectionReferences;
import com.ibm.jbatch.container.artifact.proxy.PartitionCollectorProxy;
import com.ibm.jbatch.container.artifact.proxy.ProxyFactory;
import com.ibm.jbatch.container.artifact.proxy.StepListenerProxy;
import com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl;
import com.ibm.jbatch.container.exception.BatchContainerServiceException;
import com.ibm.jbatch.container.execution.impl.RuntimeWorkUnitExecution;
import com.ibm.jbatch.container.validation.ArtifactValidationException;
import com.ibm.jbatch.container.ws.PartitionReplyMsg;
import com.ibm.jbatch.jsl.model.Collector;
import com.ibm.jbatch.jsl.model.Property;
import com.ibm.jbatch.jsl.model.Step;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public abstract class SingleThreadedStepControllerImpl
extends BaseStepControllerImpl
implements IController {
    private static final Logger logger = Logger.getLogger(SingleThreadedStepControllerImpl.class.getName());
    protected PartitionCollectorProxy collectorProxy;
    List<StepListenerProxy> stepListeners;
    static final long serialVersionUID = 7846431935189321911L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected SingleThreadedStepControllerImpl(RuntimeWorkUnitExecution runtimeWorkUnitExecution, Step step) {
        super(runtimeWorkUnitExecution, step);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.SingleThreadedStepControllerImpl", "<init>", new Object[]{runtimeWorkUnitExecution, step});
        }
        this.collectorProxy = null;
        this.stepListeners = null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.SingleThreadedStepControllerImpl", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected boolean isPartitionedStep() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.SingleThreadedStepControllerImpl", "isPartitionedStep", new Object[0]);
        }
        boolean bl = this.getStep().getPartition() != null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.jbatch.container.controller.impl.SingleThreadedStepControllerImpl", "isPartitionedStep", bl);
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void setupStepArtifacts() {
        Collector collector;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.SingleThreadedStepControllerImpl", "setupStepArtifacts", new Object[0]);
        }
        InjectionReferences injectionRef = new InjectionReferences(this.runtimeWorkUnitExecution.getWorkUnitJobContext(), this.runtimeStepExecution, null);
        this.stepListeners = this.runtimeWorkUnitExecution.getListenerFactory().getStepListeners(this.getStep(), injectionRef, this.runtimeStepExecution);
        if (this.isPartitionedStep() && (collector = this.getStep().getPartition().getCollector()) != null) {
            List<Property> propList = collector.getProperties() == null ? null : collector.getProperties().getPropertyList();
            injectionRef = new InjectionReferences(this.runtimeWorkUnitExecution.getWorkUnitJobContext(), this.runtimeStepExecution, propList);
            try {
                this.collectorProxy = ProxyFactory.createPartitionCollectorProxy(collector.getRef(), injectionRef, this.runtimeStepExecution);
            }
            catch (ArtifactValidationException artifactValidationException) {
                void e;
                FFDCFilter.processException((Throwable)artifactValidationException, (String)"com.ibm.jbatch.container.controller.impl.SingleThreadedStepControllerImpl", (String)"94", (Object)this, (Object[])new Object[0]);
                throw new BatchContainerServiceException("Cannot create the collector [" + collector.getRef() + "]", (Throwable)e);
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.SingleThreadedStepControllerImpl", "setupStepArtifacts");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void invokePreStepArtifacts() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.SingleThreadedStepControllerImpl", "invokePreStepArtifacts", new Object[0]);
        }
        if (this.stepListeners != null && !this.isSubJobPartitionThread()) {
            for (StepListenerProxy listenerProxy : this.stepListeners) {
                listenerProxy.beforeStep();
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.SingleThreadedStepControllerImpl", "invokePreStepArtifacts");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void invokePostStepArtifacts() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.SingleThreadedStepControllerImpl", "invokePostStepArtifacts", new Object[0]);
        }
        if (this.stepListeners != null && !this.isSubJobPartitionThread()) {
            for (StepListenerProxy listenerProxy : this.stepListeners) {
                listenerProxy.afterStep();
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.SingleThreadedStepControllerImpl", "invokePostStepArtifacts");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void invokeCollectorIfPresent() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.SingleThreadedStepControllerImpl", "invokeCollectorIfPresent", new Object[0]);
        }
        if (this.collectorProxy != null) {
            Serializable data = this.collectorProxy.collectPartitionData();
            logger.finer("Got partition data: " + data + ", from collector: " + this.collectorProxy);
            this.sendCollectorDataPartitionReplyMsg(data);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.SingleThreadedStepControllerImpl", "invokeCollectorIfPresent");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void sendCollectorDataPartitionReplyMsg(Serializable data) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.SingleThreadedStepControllerImpl", "sendCollectorDataPartitionReplyMsg", new Object[]{data});
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Sending collector partition data: " + data + " to analyzer queue: " + this.getPartitionReplyQueue());
        }
        PartitionReplyMsg msg = new PartitionReplyMsg(PartitionReplyMsg.PartitionReplyMsgType.PARTITION_COLLECTOR_DATA).setCollectorData(this.serializeToByteArray(data));
        this.getPartitionReplyQueue().add(msg);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.SingleThreadedStepControllerImpl", "sendCollectorDataPartitionReplyMsg");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private byte[] serializeToByteArray(Serializable data) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.SingleThreadedStepControllerImpl", "serializeToByteArray", new Object[]{data});
        }
        byte[] retVal = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = null;
            try {
                oos = new ObjectOutputStream(baos);
                oos.writeObject(data);
                retVal = baos.toByteArray();
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.jbatch.container.controller.impl.SingleThreadedStepControllerImpl", (String)"160", (Object)this, (Object[])new Object[]{data});
                throw new IllegalStateException("Cannot serialize the message payload");
            }
            finally {
                oos.close();
            }
        }
        catch (IOException baos) {
            FFDCFilter.processException((Throwable)baos, (String)"com.ibm.jbatch.container.controller.impl.SingleThreadedStepControllerImpl", (String)"166", (Object)this, (Object[])new Object[]{data});
            throw new IllegalStateException("Cannot serialize the message payload");
        }
        byte[] byArray = retVal;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            byArray = byArray;
            logger.exiting("com.ibm.jbatch.container.controller.impl.SingleThreadedStepControllerImpl", "serializeToByteArray", byArray);
        }
        return byArray;
    }
}

