/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.concurrent.persistent;

import com.ibm.websphere.ras.annotation.Trivial;

@Trivial
public class PartitionRecord {
    private static final String EOLN = String.format("%n", new Object[0]);
    private static final int ID = 1;
    private static final int EXECUTOR = 2;
    private static final int HOSTNAME = 4;
    private static final int LSERVER = 8;
    private static final int USERDIR = 16;
    private int attrs;
    private String executor;
    private String hostName;
    private long id;
    private String libertyServer;
    private String userDir;

    public PartitionRecord(boolean allAttributesAreSpecified) {
        this.attrs = allAttributesAreSpecified ? 65535 : 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PartitionRecord) {
            PartitionRecord other = (PartitionRecord)obj;
            return !(this.attrs != other.attrs || (this.attrs & 1) != 0 && this.id != other.id || (this.attrs & 2) != 0 && !PartitionRecord.match(this.executor, other.executor) || (this.attrs & 4) != 0 && !PartitionRecord.match(this.hostName, other.hostName) || (this.attrs & 8) != 0 && !PartitionRecord.match(this.libertyServer, other.libertyServer) || (this.attrs & 0x10) != 0 && !PartitionRecord.match(this.userDir, other.userDir));
        }
        return false;
    }

    public String getExecutor() {
        if ((this.attrs & 2) == 0) {
            throw new IllegalStateException();
        }
        return this.executor;
    }

    public String getHostName() {
        if ((this.attrs & 4) == 0) {
            throw new IllegalStateException();
        }
        return this.hostName;
    }

    public final long getId() {
        if ((this.attrs & 1) == 0) {
            throw new IllegalStateException();
        }
        return this.id;
    }

    public String getLibertyServer() {
        if ((this.attrs & 8) == 0) {
            throw new IllegalStateException();
        }
        return this.libertyServer;
    }

    public String getUserDir() {
        if ((this.attrs & 0x10) == 0) {
            throw new IllegalStateException();
        }
        return this.userDir;
    }

    public final int hashCode() {
        return (int)this.id;
    }

    public final boolean hasExecutor() {
        return (this.attrs & 2) != 0;
    }

    public final boolean hasHostName() {
        return (this.attrs & 4) != 0;
    }

    public final boolean hasId() {
        return (this.attrs & 1) != 0;
    }

    public final boolean hasLibertyServer() {
        return (this.attrs & 8) != 0;
    }

    public final boolean hasUserDir() {
        return (this.attrs & 0x10) != 0;
    }

    private static final boolean match(Object obj1, Object obj2) {
        return obj1 == obj2 || obj1 != null && obj1.equals(obj2);
    }

    public final void setExecutor(String executor) {
        this.executor = executor;
        this.attrs |= 2;
    }

    public final void setHostName(String host) {
        this.hostName = host;
        this.attrs |= 4;
    }

    public final void setId(long id) {
        this.id = id;
        this.attrs |= 1;
    }

    public final void setLibertyServer(String server) {
        this.libertyServer = server;
        this.attrs |= 8;
    }

    public final void setUserDir(String userDir) {
        this.userDir = userDir;
        this.attrs |= 0x10;
    }

    public String toString() {
        StringBuilder output = new StringBuilder(200).append("PartitionRecord");
        if ((this.attrs & 1) != 0) {
            output.append('[').append(this.id).append(']');
        }
        output.append('@').append(Integer.toHexString(System.identityHashCode(this)));
        if ((this.attrs & 2) != 0) {
            output.append(EOLN).append("EXECUTOR=").append(this.executor);
        }
        if ((this.attrs & 4) != 0) {
            output.append(EOLN).append("HOSTNAME=").append(this.hostName);
        }
        if ((this.attrs & 8) != 0) {
            output.append(EOLN).append("LSERVER=").append(this.libertyServer);
        }
        if ((this.attrs & 0x10) != 0) {
            output.append(EOLN).append("USERDIR=").append(this.userDir);
        }
        return output.toString();
    }

    public final void unsetExecutor() {
        this.attrs &= 0xFFFFFFFD;
    }

    public final void unsetHostName() {
        this.attrs &= 0xFFFFFFFB;
    }

    public final void unsetId() {
        this.attrs &= 0xFFFFFFFE;
    }

    public final void unsetLibertyServer() {
        this.attrs &= 0xFFFFFFF7;
    }

    public final void unsetUserDir() {
        this.attrs &= 0xFFFFFFEF;
    }
}

