/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.classloading;

import com.ibm.websphere.ras.annotation.Trivial;
import java.util.EnumSet;

@Trivial
public enum ApiType {
    SPEC("spec"),
    IBMAPI("ibm-api"),
    API("api"),
    THIRDPARTY("third-party");

    private final String attributeName;

    private ApiType(String attributeName) {
        this.attributeName = attributeName;
    }

    public static ApiType fromString(String value) {
        if (value != null) {
            value = value.trim();
            for (ApiType t : ApiType.values()) {
                if (!t.attributeName.equals(value)) continue;
                return t;
            }
        } else {
            return API;
        }
        return null;
    }

    public static EnumSet<ApiType> createApiTypeSet(String ... apiTypes) {
        EnumSet<ApiType> set = EnumSet.noneOf(ApiType.class);
        if (apiTypes != null) {
            for (String types : apiTypes) {
                if (types == null) continue;
                for (String stype : types.split("[ ,]+")) {
                    ApiType type = ApiType.fromString(stype);
                    if (type == null) continue;
                    set.add(type);
                }
            }
        }
        return set;
    }

    public String toString() {
        return this.attributeName;
    }
}

