/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jpa.container.osgi.jndi;

import com.ibm.ejs.util.dopriv.SystemGetPropertyPrivileged;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.jpa.JPAAccessor;
import com.ibm.ws.jpa.JPAComponent;
import com.ibm.ws.jpa.JPALookupDelegate;
import com.ibm.ws.jpa.JPAPuId;
import com.ibm.ws.jpa.container.osgi.jndi.JPAJndiLookupInfo;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.injectionengine.InjectionException;
import java.security.AccessController;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={ObjectFactory.class, JPAJndiLookupObjectFactory.class})
public class JPAJndiLookupObjectFactory
implements ObjectFactory {
    private static final String CLASS_NAME = JPAJndiLookupObjectFactory.class.getName();
    private static final TraceComponent tc = Tr.register(JPAJndiLookupObjectFactory.class, (String)"JPA", (String)"com.ibm.ws.jpa.jpa");
    public static final String USE_EMF_PROXY = "com.ibm.websphere.persistence.useEntityManagerFactoryProxy";
    private static final boolean USE_EMF_PROXY_VALUE = Boolean.parseBoolean((String)AccessController.doPrivileged(new SystemGetPropertyPrivileged("com.ibm.websphere.persistence.useEntityManagerFactoryProxy", "true")));
    private final AtomicReference<JPALookupDelegate> lookupDelegate = new AtomicReference();
    protected String ivInstanceClassName = CLASS_NAME;
    static final long serialVersionUID = -5932832165591353941L;

    public JPAJndiLookupObjectFactory() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"<init>", (Object[])new Object[0]);
        }
    }

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> env) throws Exception {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (!(obj instanceof Reference)) {
            return null;
        }
        Reference ref = (Reference)obj;
        if (!this.ivInstanceClassName.equals(ref.getFactoryClassName())) {
            return null;
        }
        RefAddr addr = ref.get("JPAJndiLookupInfo");
        if (addr == null) {
            NamingException nex = new NamingException("The address for this Reference is empty (null)");
            throw nex;
        }
        Object retObj = null;
        JPAJndiLookupInfo info = (JPAJndiLookupInfo)addr.getContent();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getting EntityManagerFactory for " + info), (Object[])new Object[0]);
        }
        JPAPuId puId = info.getPuId();
        J2EEName j2eeName = info.getJ2EEName();
        String refName = info.getReferenceName();
        boolean isSFSB = this.checkSFSBAccess(info, info.isSFSB());
        JPAComponent jpaService = JPAAccessor.getJPAComponent();
        JPALookupDelegate delegate = this.lookupDelegate.get();
        if (delegate != null) {
            retObj = info.isFactory() ? delegate.getEntityManagerFactory(puId.getPuName(), j2eeName) : delegate.getEntityManager(puId.getPuName(), j2eeName, info.isExtendedContextType(), info.getPersistenceProperties());
        }
        if (retObj == null) {
            if (info.isFactory()) {
                retObj = jpaService.getEntityManagerFactory(puId, j2eeName, USE_EMF_PROXY_VALUE || isSFSB);
            } else {
                Map<?, ?> pCtxtProperties = info.getPersistenceProperties();
                retObj = jpaService.getEntityManager(puId, j2eeName, refName, info.isExtendedContextType(), info.isUnsynchronized(), pCtxtProperties);
            }
        }
        return retObj;
    }

    protected boolean checkSFSBAccess(JPAJndiLookupInfo info, boolean isSFSB) throws InjectionException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("checkSFSBAccess: " + info + ", isSFSB=" + isSFSB), (Object[])new Object[0]);
        }
        if (!isSFSB && !info.isFactory() && info.isExtendedContextType()) {
            JPAPuId puId = info.getPuId();
            Tr.error((TraceComponent)tc, (String)"EXTEND_PC_NOT_IN_SFSB_CWWJP0003E", (Object[])new Object[]{puId.getPuName()});
            throw new InjectionException("CWWJP0003E: The " + puId.getPuName() + " extended persistence context can be initiated within the scope of a stateful session bean only.");
        }
        return isSFSB;
    }

    @org.osgi.service.component.annotations.Reference(service=JPALookupDelegate.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setLookupDelegate(JPALookupDelegate ref) {
        this.lookupDelegate.set(ref);
    }

    protected void unsetLookupDelegate(JPALookupDelegate ref) {
        this.lookupDelegate.lazySet(null);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("useEntityManagerFactoryProxy = " + USE_EMF_PROXY_VALUE), (Object[])new Object[0]);
        }
    }
}

