/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jpa.container.osgi.internal.url;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.artifact.url.WSJarURLConnection;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jpa.container.osgi.internal.url.JPAWSJarURLConnection;
import com.ibm.ws.jpa.container.osgi.internal.url.WSJPAUrlUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.url.AbstractURLStreamHandlerService;
import org.osgi.service.url.URLStreamHandlerService;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={URLStreamHandlerService.class}, property={"url.handler.protocol=wsjpa"})
public class JPAURLStreamHandler
extends AbstractURLStreamHandlerService {
    static final long serialVersionUID = 4504954983792950958L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    /*
     * WARNING - void declaration
     */
    public URLConnection openConnection(URL url) throws IOException {
        URL embeddedURL = null;
        URLConnection urlConnection = null;
        if (url == null) {
            throw new IOException("JPAURLStreamHandler.openConnection cannot take a null URL argument.");
        }
        try {
            embeddedURL = WSJPAUrlUtils.extractEmbeddedURL(url);
            String embeddedURLProtocol = embeddedURL.getProtocol();
            if (embeddedURLProtocol != null && !embeddedURLProtocol.equalsIgnoreCase("wsjar")) {
                throw new IOException("The \"wsjpa\" URL protocol cannot accept embedded URL with protocol \"" + embeddedURLProtocol + "\".");
            }
        }
        catch (MalformedURLException embeddedURLProtocol) {
            void mue;
            FFDCFilter.processException((Throwable)embeddedURLProtocol, (String)"com.ibm.ws.jpa.container.osgi.internal.url.JPAURLStreamHandler", (String)"52", (Object)((Object)this), (Object[])new Object[]{url});
            throw mue;
        }
        urlConnection = embeddedURL.openConnection();
        if (urlConnection instanceof WSJarURLConnection) {
            urlConnection = new JPAWSJarURLConnection(url, (WSJarURLConnection)urlConnection);
        }
        return urlConnection;
    }

    public boolean equals(URL u1, URL u2) {
        if (super.equals(u1, u2)) {
            return true;
        }
        return this.checkEquality(u1, u2);
    }

    public boolean sameFile(URL u1, URL u2) {
        if (super.sameFile(u1, u2)) {
            return true;
        }
        return this.checkEquality(u1, u2);
    }

    /*
     * WARNING - void declaration
     */
    private boolean checkEquality(URL u1, URL u2) {
        String u1Protocol = u1.getProtocol();
        String u2Protocol = u2.getProtocol();
        if ("wsjpa".equalsIgnoreCase(u1Protocol) && "wsjpa".equalsIgnoreCase(u2Protocol)) {
            return false;
        }
        URL jpaURL = null;
        URL nonJpaURL = null;
        if (u1Protocol.equalsIgnoreCase("wsjpa")) {
            jpaURL = u1;
            nonJpaURL = u2;
        } else {
            jpaURL = u2;
            nonJpaURL = u1;
        }
        if (!"wsjar".equalsIgnoreCase(nonJpaURL.getProtocol())) {
            return false;
        }
        boolean returnValue = false;
        URI uri2 = null;
        try {
            URL jpaEncapsulatedPath = WSJPAUrlUtils.extractEmbeddedURL(jpaURL);
            URI uri1 = jpaEncapsulatedPath.toURI();
            uri2 = nonJpaURL.toURI();
            returnValue = uri1.equals(uri2);
        }
        catch (MalformedURLException jpaEncapsulatedPath) {
            void e;
            FFDCFilter.processException((Throwable)jpaEncapsulatedPath, (String)"com.ibm.ws.jpa.container.osgi.internal.url.JPAURLStreamHandler", (String)"134", (Object)((Object)this), (Object[])new Object[]{u1, u2});
            e.getClass();
            return false;
        }
        catch (URISyntaxException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jpa.container.osgi.internal.url.JPAURLStreamHandler", (String)"138", (Object)((Object)this), (Object[])new Object[]{u1, u2});
            e.getClass();
            return false;
        }
        return returnValue;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(JPAURLStreamHandler.class);
    }
}

