/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ssl.internal.GenericSSLConfigService;
import com.ibm.ws.ssl.internal.KeystoreConfig;
import com.ibm.wsspi.ssl.SSLConfiguration;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.ibm.ws.ssl.repertoire"}, configurationPolicy=ConfigurationPolicy.REQUIRE, service={RepertoireConfigService.class, SSLConfiguration.class}, property={"service.vendor=IBM"})
public class RepertoireConfigService
extends GenericSSLConfigService
implements SSLConfiguration {
    private static final TraceComponent tc = Tr.register(RepertoireConfigService.class);
    private String id = "unknownConfig";
    private String servicePid = "unknownConfig";
    private KeystoreConfig keyStore;
    private KeystoreConfig trustStore;

    @Activate
    protected void activate(Map<String, Object> properties) {
        this.id = (String)properties.get("id");
        this.servicePid = (String)properties.get("service.pid");
        super.activate(this.id, properties);
    }

    @Modified
    protected void modified(Map<String, Object> properties) {
        super.modified(this.id, properties);
    }

    @Deactivate
    protected void deactivate(int reason) {
        super.deactivate(this.id, reason);
    }

    @Override
    public String getAlias() {
        return this.id;
    }

    public String getPID() {
        return this.servicePid;
    }

    @Reference
    protected void setKeyStore(KeystoreConfig ref, Map<String, Object> properties) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("set keystore " + properties.get("id")), (Object[])new Object[]{properties});
        }
        this.keyStore = ref;
    }

    KeystoreConfig getKeyStore() {
        return this.keyStore;
    }

    @Reference
    protected void setTrustStore(KeystoreConfig ref, Map<String, Object> properties) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("set truststore " + properties.get("id")), (Object[])new Object[]{properties});
        }
        this.trustStore = ref;
    }

    KeystoreConfig getTrustStore() {
        return this.trustStore;
    }
}

