/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.task;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.SevereMessageStoreException;
import com.ibm.ws.sib.msgstore.cache.links.AbstractItemLink;
import com.ibm.ws.sib.msgstore.persistence.BatchingContext;
import com.ibm.ws.sib.msgstore.persistence.Persistable;
import com.ibm.ws.sib.msgstore.persistence.impl.CachedPersistableImpl;
import com.ibm.ws.sib.msgstore.task.Task;
import com.ibm.ws.sib.msgstore.transactions.impl.PersistentTransaction;
import com.ibm.ws.sib.msgstore.transactions.impl.TransactionState;
import com.ibm.ws.sib.utils.ras.SibTr;

public final class PersistUnlock
extends Task {
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private static TraceComponent tc = SibTr.register(PersistUnlock.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private Persistable _cachedPersistable = null;
    private Persistable _masterPersistable;

    public PersistUnlock(AbstractItemLink link) throws SevereMessageStoreException {
        super(link);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)link);
        }
        this._masterPersistable = super.getPersistable();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    @Override
    public final void abort(PersistentTransaction transaction) throws SevereMessageStoreException {
        this.getLink().abortPersistUnlock(transaction);
    }

    @Override
    public final void commitExternal(PersistentTransaction transaction) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"commitExternal", (Object)transaction);
        }
        this.getLink().commitPersistUnlock(transaction);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"commitExternal");
        }
    }

    @Override
    public final void commitInternal(PersistentTransaction transaction) {
    }

    @Override
    public final void copyDataIfVulnerable() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"copyDataIfVulnerable");
        }
        if (this._cachedPersistable == null) {
            this._cachedPersistable = new CachedPersistable(this._masterPersistable);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"copyDataIfVulnerable");
        }
    }

    @Override
    public final Persistable getPersistable() {
        if (this._cachedPersistable != null) {
            return this._cachedPersistable;
        }
        return this._masterPersistable;
    }

    @Override
    public final int getPersistableInMemorySizeApproximation(TransactionState tranState) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getPersistableInMemorySizeApproximation", (Object)tranState);
        }
        if (tranState != TransactionState.STATE_COMMITTED && tranState != TransactionState.STATE_COMMITTING_1PC) {
            throw new IllegalStateException(nls.getFormattedMessage("INVALID_TASK_OPERATION_SIMS1520", new Object[]{tranState}, null));
        }
        int size = 500;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getPersistableInMemorySizeApproximation", (Object)size);
        }
        return size;
    }

    @Override
    public final Task.Type getTaskType() {
        return Task.Type.PERSIST_UNLOCK;
    }

    @Override
    public final void persist(BatchingContext batchingContext, TransactionState tranState) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"persist", (Object)new Object[]{batchingContext, tranState});
        }
        if (tranState != TransactionState.STATE_COMMITTED && tranState != TransactionState.STATE_COMMITTING_1PC) {
            throw new IllegalStateException(nls.getFormattedMessage("INVALID_TASK_OPERATION_SIMS1520", new Object[]{tranState}, null));
        }
        batchingContext.updateLockIDOnly(this.getPersistable());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"persist");
        }
    }

    @Override
    public final void postAbort(PersistentTransaction transaction) {
    }

    @Override
    public final void postCommit(PersistentTransaction transaction) throws SevereMessageStoreException {
        AbstractItem item;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"postCommit", (Object)transaction);
        }
        if (null == (item = this.getItem())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"null item");
            }
        } else {
            item.eventUnlocked();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"postCommit");
        }
    }

    @Override
    public final void preCommit(PersistentTransaction transaction) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"preCommit");
        }
        this.getItem();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"preCommit");
        }
    }

    private final class CachedPersistable
    extends CachedPersistableImpl {
        private long _cachedLockId;

        public CachedPersistable(Persistable masterPersistable) {
            super(masterPersistable);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"<ctor>$CachedPersistable");
            }
            this._cachedLockId = PersistUnlock.this._masterPersistable.getLockID();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"<ctor>$CachedPersistable");
            }
        }

        @Override
        public long getLockID() {
            return this._cachedLockId;
        }

        @Override
        public void setLockID(long l) {
            throw new UnsupportedOperationException();
        }
    }
}

