/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jdbc.management.j2ee.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.management.ManagementFactory;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class MBeanHelper {
    private static final TraceComponent tc = Tr.register(MBeanHelper.class, (String)"RRA");
    private static final String className = "MBeanHelper : ";
    static final long serialVersionUID = -9090097213031783859L;

    protected MBeanHelper() {
    }

    public static String toObnString(String s) {
        if (s != null && !s.isEmpty()) {
            return s.replace(':', '.').replace('=', '.').replace(',', '.').replace('\"', '.');
        }
        return s;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isMbeanExist(String objName, String callingClass, String callingMethod) {
        String methodName = "isMbeanExist()";
        boolean trace = TraceComponent.isAnyTracingEnabled();
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        String cClass = callingClass != null && !callingClass.isEmpty() ? callingClass : "callingClass";
        String cMethod = callingMethod != null && !callingMethod.isEmpty() ? callingMethod : "callingMethod";
        ObjectName obnToCompare = null;
        try {
            obnToCompare = new ObjectName(objName);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jdbc.management.j2ee.internal.MBeanHelper", (String)"70", null, (Object[])new Object[]{objName, callingClass, callingMethod});
            if (trace && tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)(cClass + ": " + cMethod + " is using " + className + ": " + "isMbeanExist()" + ": Creating ObjectName failed.\n " + e.toString()), (Object[])new Object[0]);
            }
            return false;
        }
        Set<ObjectInstance> s = mbs.queryMBeans(obnToCompare, null);
        if (s.size() == 0) {
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(cClass + ": " + cMethod + " is using " + className + ": " + "isMbeanExist()" + ": s.size(): " + s.size() + ", No duplicate MBean Found"), (Object[])new Object[0]);
            }
            return false;
        }
        if (trace && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(cClass + ": " + cMethod + " is using " + className + ": " + "isMbeanExist()" + ": searching for: " + objName), (Object[])new Object[0]);
        }
        for (ObjectInstance bean : s) {
            if (!trace || !tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("**  Found a duplicate MBean: " + bean.getObjectName().toString()), (Object[])new Object[0]);
        }
        if (trace && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(cClass + ": " + cMethod + " is using " + className + ": " + "isMbeanExist()" + ": The Mbean already exist in the MBean server."), (Object[])new Object[0]);
        }
        return true;
    }

    public static void logLoudAndClear(String textToLog, String callingClass, String callingMethod) {
        String cMethod;
        String methodName = "logLoudAndClear";
        boolean trace = TraceComponent.isAnyTracingEnabled();
        String cClass = callingClass != null && !callingClass.isEmpty() ? callingClass : "callingClass";
        String string = cMethod = callingMethod != null && !callingMethod.isEmpty() ? callingMethod : "callingMethod";
        if (trace && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("#################################################################################################\n ##################################################################################################################################################################################################\n ##################################################################################################################################################################################################\n ##################################################################################################################################################################################################\n ##################################################################################################################################################################################################\n ##################################################################################################################################################################################################\n ##################################################################################################################################################################################################\n ##################################################################################################################################################################################################\n ##################################################################################################################################################################################################\n \n " + cClass + ": " + cMethod + " is using " + className + ": " + "logLoudAndClear" + " \n " + textToLog + "\n \n #################################################################################################\n ##################################################################################################################################################################################################\n ##################################################################################################################################################################################################\n ##################################################################################################################################################################################################\n ##################################################################################################################################################################################################\n ##################################################################################################################################################################################################\n ##################################################################################################################################################################################################\n ##################################################################################################################################################################################################\n ##################################################################################################################################################################################################"), (Object[])new Object[0]);
        }
    }
}

