/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.request.timing.config;

import com.ibm.ws.request.timing.config.ContextInfoPattern;
import java.io.PrintWriter;

public class Timing {
    private final long requestThreshold;
    private final String type;
    private final ContextInfoPattern contextInfo;
    private static final int HISTORICAL_REQUEST_LIMIT = 5;
    private transient long requestCount = 0L;
    private transient String[] historicalRequestData = new String[5];

    public Timing(String type, long requestThreshold) {
        this(type, null, requestThreshold);
    }

    public Timing(String type, ContextInfoPattern contextInfo, long requestThreshold) {
        this.type = type;
        this.requestThreshold = requestThreshold;
        this.contextInfo = contextInfo;
    }

    public long getRequestThreshold() {
        return this.requestThreshold;
    }

    public String getType() {
        return this.type;
    }

    public ContextInfoPattern getContextInfo() {
        return this.contextInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementCount(String requestContextInfo) {
        String[] stringArray = this.historicalRequestData;
        synchronized (this.historicalRequestData) {
            this.historicalRequestData[(int)(this.requestCount % 5L)] = requestContextInfo;
            ++this.requestCount;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeIntrospectionData(PrintWriter pw) {
        String[] stringArray = this.historicalRequestData;
        synchronized (this.historicalRequestData) {
            pw.println(" Context info pattern: " + this.contextInfo.toString() + "  Request count: " + this.requestCount);
            if (this.requestCount > 0L) {
                for (int x = 0; x < 5; ++x) {
                    if (this.historicalRequestData[x] == null) continue;
                    pw.println("   Sample context info:" + this.historicalRequestData[x]);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof Timing) {
            Timing that = (Timing)o;
            return this.requestThreshold == that.requestThreshold && this.objectEquals(this.type, that.type) && this.objectEquals(this.contextInfo, that.contextInfo);
        }
        return false;
    }

    private boolean objectEquals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null) {
            return false;
        }
        if (o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }
}

