/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.request.timing.config;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;

public final class ContextInfoPattern
implements Comparable<ContextInfoPattern> {
    private static final TraceComponent tc = Tr.register(ContextInfoPattern.class);
    public static final ContextInfoPattern ALL = new ContextInfoPattern(null, "*");
    private final String baseString;
    private final boolean isWildcarded;

    public ContextInfoPattern(String timingPid, String contextInfoPattern) {
        if (contextInfoPattern == null) {
            throw new IllegalArgumentException("Context info pattern must not be null");
        }
        String baseString = null;
        if (contextInfoPattern.endsWith("*") && !contextInfoPattern.endsWith("\\*")) {
            this.isWildcarded = true;
            baseString = contextInfoPattern.substring(0, contextInfoPattern.length() - 1);
        } else {
            this.isWildcarded = false;
            baseString = contextInfoPattern;
        }
        if (this.countMatchesInString(baseString, "\\*") != this.countMatchesInString(baseString, "*")) {
            Tr.warning((TraceComponent)tc, (String)"REQUEST_TIMING_CONFIG_WARNING_CTX_INFO_ASTERISK_LOC", (Object[])new Object[]{timingPid, contextInfoPattern});
        }
        this.baseString = baseString.replace("\\*", "*");
    }

    private int countMatchesInString(String baseString, String x) {
        if (baseString == null || baseString.length() < x.length()) {
            return 0;
        }
        int count = 0;
        int curIndex = baseString.indexOf(x, 0);
        while (curIndex >= 0) {
            ++count;
            curIndex = baseString.indexOf(x, curIndex + x.length());
        }
        return count;
    }

    public int getMatchScore(String contextInfo) {
        int matchScore = Integer.MIN_VALUE;
        if (this.isWildcarded) {
            if (contextInfo.startsWith(this.baseString)) {
                matchScore = this.baseString.length();
            }
        } else if (this.baseString.equals(contextInfo)) {
            matchScore = Integer.MAX_VALUE;
        }
        return matchScore;
    }

    public int hashCode() {
        return this.baseString.hashCode();
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof ContextInfoPattern) {
            ContextInfoPattern that = (ContextInfoPattern)o;
            return this.baseString.equals(that.baseString) && this.isWildcarded == that.isWildcarded;
        }
        return false;
    }

    public String toString() {
        if (this.isWildcarded) {
            return this.baseString + "*";
        }
        return this.baseString;
    }

    @Override
    public int compareTo(ContextInfoPattern o) {
        if (o == null) {
            throw new NullPointerException();
        }
        ContextInfoPattern that = o;
        int baseScore = this.baseString.compareTo(that.baseString);
        if (baseScore == 0 && this.isWildcarded != that.isWildcarded) {
            baseScore = !this.isWildcarded ? -1 : 1;
        }
        return baseScore;
    }
}

