/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.wim.env.was;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.wim.env.ICacheUtil;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class Cache
implements ICacheUtil {
    private static final TraceComponent tc = Tr.register(Cache.class, (String)"Authentication");
    private static int defaultTimeout;
    private ConcurrentHashMap<String, Object> primaryTable;
    private ConcurrentHashMap<String, Object> secondaryTable;
    private ConcurrentHashMap<String, Object> tertiaryTable;
    private int minSize = 0;
    private int entryLimit = 4500;
    private Timer timer;
    private ICacheUtil cache = null;
    static final long serialVersionUID = -5561247110027639551L;

    public Cache() {
    }

    private Cache(int initialSize, int cacheMaxSize, long timeoutInMilliSeconds) {
        this.primaryTable = new ConcurrentHashMap(initialSize);
        this.secondaryTable = new ConcurrentHashMap(initialSize);
        this.tertiaryTable = new ConcurrentHashMap(initialSize);
        this.minSize = initialSize;
        this.entryLimit = cacheMaxSize;
        if (timeoutInMilliSeconds > 0L) {
            this.scheduleEvictionTask(timeoutInMilliSeconds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleEvictionTask(long timeoutInMilliSeconds) {
        EvictionTask evictionTask = new EvictionTask();
        SwapTCCLAction swapTCCL = new SwapTCCLAction();
        AccessController.doPrivileged(swapTCCL);
        try {
            long period;
            this.timer = new Timer(true);
            long delay = period = timeoutInMilliSeconds;
            this.timer.schedule((TimerTask)evictionTask, delay, period);
        }
        finally {
            AccessController.doPrivileged(swapTCCL);
        }
    }

    public synchronized Object remove(String key) {
        this.primaryTable.remove(key);
        this.secondaryTable.remove(key);
        return this.tertiaryTable.remove(key);
    }

    @Override
    public synchronized Object get(Object key) {
        ConcurrentHashMap<String, Object> tableRef = this.primaryTable;
        Entry curEntry = (Entry)this.primaryTable.get(key);
        if (curEntry == null) {
            tableRef = this.secondaryTable;
            curEntry = (Entry)this.secondaryTable.get(key);
            if (curEntry == null) {
                tableRef = this.tertiaryTable;
                curEntry = (Entry)this.tertiaryTable.get(key);
            }
            if (curEntry == null) {
                tableRef = null;
            }
        }
        if (tableRef != null && tableRef != this.primaryTable) {
            this.primaryTable.put(String.valueOf(key), curEntry);
            tableRef.remove(key);
        }
        if (tableRef == null && (curEntry = (Entry)this.primaryTable.get(key)) == null) {
            curEntry = new Entry();
            this.primaryTable.put(String.valueOf(key), curEntry);
        }
        return curEntry.value;
    }

    public synchronized Object insert(String key, Object value) {
        while (this.isEvictionRequired() && this.entryLimit > 0 && this.entryLimit < Integer.MAX_VALUE) {
            this.evictStaleEntries();
        }
        Entry curEntry = new Entry(value);
        Entry oldEntry = (Entry)this.primaryTable.put(key, curEntry);
        return oldEntry;
    }

    protected boolean isEvictionRequired() {
        String METHODNAME = "isEvictionRequired";
        boolean evictionRequired = false;
        int size = this.primaryTable.size() + this.secondaryTable.size() + this.tertiaryTable.size();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isEvictionRequired The current cache (" + this.hashCode() + ") size is " + size + "( " + this.primaryTable.size() + ", " + this.secondaryTable.size() + ", " + this.tertiaryTable.size() + ")"), (Object[])new Object[0]);
        }
        if (this.entryLimit != 0 && this.entryLimit != Integer.MAX_VALUE && size > this.entryLimit) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("isEvictionRequired The cache size is " + size + "( " + this.primaryTable.size() + ", " + this.secondaryTable.size() + ", " + this.tertiaryTable.size() + ") which is greater than the cache limit of " + this.entryLimit + "."), (Object[])new Object[0]);
            }
            evictionRequired = true;
        }
        return evictionRequired;
    }

    @Trivial
    protected synchronized void evictStaleEntries() {
        this.tertiaryTable = this.secondaryTable;
        this.secondaryTable = this.primaryTable;
        this.primaryTable = new ConcurrentHashMap(this.minSize > this.secondaryTable.size() ? this.minSize : this.secondaryTable.size());
    }

    public synchronized void clearAllEntries() {
        this.tertiaryTable.putAll(this.primaryTable);
        this.tertiaryTable.putAll(this.secondaryTable);
        this.primaryTable.clear();
        this.secondaryTable.clear();
        this.evictStaleEntries();
    }

    public static long getDefaultTimeout() {
        return defaultTimeout;
    }

    public static void setDefaultTimeout(int timeout) {
        defaultTimeout = timeout;
    }

    int getEntryLimit() {
        return this.entryLimit;
    }

    @Override
    public void stopEvictionTask() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer.purge();
            this.timer = null;
        }
    }

    @Override
    public boolean isCacheInitialized() {
        return this.cache != null;
    }

    @Override
    public boolean isCacheAvailable() {
        return true;
    }

    @Override
    public int getNotSharedInt() {
        return 0;
    }

    @Override
    public int getSharedPushInt() {
        return 0;
    }

    @Override
    public int getSharedPushPullInt() {
        return 0;
    }

    @Override
    public void setSharingPolicy(int sharingPolicy) {
    }

    @Override
    public int getSharingPolicyInt(String sharingPolicyStr) {
        return 0;
    }

    @Override
    public Object put(Object key, Object value, int priority, long timeToLive, int sharingPolicy, Object[] dependencyIds) {
        return this.put(String.valueOf(key), value);
    }

    @Override
    public void invalidate(Object key) {
        this.remove(key);
    }

    @Override
    public int size(boolean includeDiskCache) {
        return this.primaryTable.size() + this.secondaryTable.size() + this.tertiaryTable.size();
    }

    @Override
    public boolean isEmpty(boolean includeDiskCache) {
        return this.primaryTable.isEmpty() && this.secondaryTable.isEmpty() && this.tertiaryTable.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.primaryTable.containsKey(key) || this.secondaryTable.containsKey(key) || this.tertiaryTable.containsKey(key);
    }

    @Override
    public boolean containsKey(Object key, boolean includeDiskCache) {
        return this.primaryTable.containsKey(key) || this.secondaryTable.containsKey(key) || this.tertiaryTable.containsKey(key);
    }

    @Override
    public Set<String> keySet(boolean includeDiskCache) {
        HashSet<String> keySet = new HashSet<String>();
        keySet.addAll(this.primaryTable.keySet());
        keySet.addAll(this.secondaryTable.keySet());
        keySet.addAll(this.tertiaryTable.keySet());
        return keySet;
    }

    @Override
    public Object put(String key, Object value) {
        return this.insert(String.valueOf(key), value);
    }

    @Override
    public void clear() {
        this.clearAllEntries();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.primaryTable.containsValue(value) || this.secondaryTable.containsValue(value) || this.tertiaryTable.containsValue(value);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> keySet = new HashSet<String>();
        keySet.addAll(this.primaryTable.keySet());
        keySet.addAll(this.secondaryTable.keySet());
        keySet.addAll(this.tertiaryTable.keySet());
        return keySet;
    }

    @Override
    public int size() {
        return this.primaryTable.size() + this.secondaryTable.size() + this.tertiaryTable.size();
    }

    @Override
    public void setTimeToLive(int timeToLive) {
        defaultTimeout = timeToLive;
    }

    @Override
    public ICacheUtil initialize(int initialSize, int cacheSize, long cachetimeOut) {
        String METHODNAME = "initialize";
        this.cache = new Cache(initialSize, cacheSize, cachetimeOut);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"initialize cache initialized successfully", (Object[])new Object[0]);
        }
        return this.cache;
    }

    @Override
    public ICacheUtil initialize(String cacheName, int cacheSize, boolean diskOffLoad) {
        return this.initialize(cacheSize, cacheSize, defaultTimeout);
    }

    @Override
    public ICacheUtil initialize(String cacheName, int cacheSize, boolean diskOffLoad, int sharingPolicy) {
        return this.initialize(cacheSize, cacheSize, defaultTimeout);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        Set<Map.Entry<String, Object>> retValue = this.primaryTable.entrySet();
        retValue.addAll(this.secondaryTable.entrySet());
        retValue.addAll(this.tertiaryTable.entrySet());
        return retValue;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> map) {
        Set<Map.Entry<? extends String, ? extends Object>> entrySet = map.entrySet();
        Iterator<Map.Entry<? extends String, ? extends Object>> iterator = entrySet.iterator();
        while (iterator.hasNext()) {
            Map.Entry<? extends String, ? extends Object> entry;
            Map.Entry<? extends String, ? extends Object> actualEntry = entry = iterator.next();
            this.put(String.valueOf(actualEntry.getKey()), actualEntry.getValue());
        }
    }

    @Override
    public Object remove(Object key) {
        return this.remove(String.valueOf(key));
    }

    @Override
    public Collection<Object> values() {
        Collection<Object> retValue = this.primaryTable.values();
        retValue.addAll(this.secondaryTable.values());
        retValue.addAll(this.tertiaryTable.values());
        return retValue;
    }

    @Override
    public void invalidate() {
        this.clearAllEntries();
    }

    @Trivial
    private class EvictionTask
    extends TimerTask {
        private EvictionTask() {
        }

        @Override
        public void run() {
            Cache.this.evictStaleEntries();
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    public static class Entry {
        public Object value;
        public int timesAccessed;
        static final long serialVersionUID = 5460734554606661448L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public Entry() {
        }

        public Entry(Object value) {
            this.value = value;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(Entry.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private class SwapTCCLAction
    implements PrivilegedAction<ClassLoader> {
        private ClassLoader savedTCCL;
        private boolean swapped = false;
        static final long serialVersionUID = 7139371906860113420L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private SwapTCCLAction() {
        }

        @Override
        public ClassLoader run() {
            ClassLoader cl;
            if (this.swapped) {
                cl = this.savedTCCL;
            } else {
                cl = ClassLoader.getSystemClassLoader();
                this.savedTCCL = Thread.currentThread().getContextClassLoader();
            }
            Thread.currentThread().setContextClassLoader(cl);
            this.swapped = !this.swapped;
            return cl;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(SwapTCCLAction.class);
        }
    }
}

