/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.wim;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.config.xml.internal.nester.Nester;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.SecurityService;
import com.ibm.ws.security.wim.RepositoryConfig;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class BaseRepository
implements RepositoryConfig {
    private static final TraceComponent tc = Tr.register(BaseRepository.class);
    static final String KEY_ID = "config.id";
    static final String BASE_ENTRY_NAME = "name";
    static final String BASE_ENTRY = "baseEntry";
    static final String REGISTRY_BASE_ENTRY = "registryBaseEntry";
    static final String BASE_DN = "baseDN";
    static final String REPOSITORY_FOR_GROUPS = "repositoriesForGroups";
    public static final String KEY_SECURITY_SERVICE = "securityService";
    protected volatile Map<String, Object> config;
    protected String reposId = null;
    private Map<String, String> baseEntryMap = new HashMap<String, String>();
    private boolean readOnly = false;
    private String[] repositoriesForGroups;
    private final AtomicServiceReference<SecurityService> securityServiceRef = new AtomicServiceReference("securityService");
    static final long serialVersionUID = -2043719308781422247L;

    protected void setSecurityService(ServiceReference<SecurityService> reference) {
        this.securityServiceRef.setReference(reference);
    }

    protected void unsetSecurityService(ServiceReference<SecurityService> reference) {
        this.securityServiceRef.unsetReference(reference);
    }

    protected void activate(Map<String, Object> properties, ComponentContext cc) {
        this.config = properties;
        this.securityServiceRef.activate(cc);
        this.initConfig();
    }

    protected void modify(Map<String, Object> newProperties) {
        this.config = newProperties;
        this.resetConfig();
        this.initConfig();
    }

    protected void deactivate(int reason, ComponentContext cc) {
        this.config = null;
        this.resetConfig();
        this.securityServiceRef.deactivate(cc);
    }

    private void initConfig() {
        this.reposId = (String)this.config.get(KEY_ID);
        Map<String, List<Map<String, Object>>> configMap = Nester.nest(this.config, BASE_ENTRY, REGISTRY_BASE_ENTRY);
        this.initBaseEntry(configMap.get(BASE_ENTRY));
        this.initBaseEntry(configMap.get(REGISTRY_BASE_ENTRY));
        if (this.config.containsKey(BASE_DN)) {
            String baseDN = (String)this.config.get(BASE_DN);
            String name = (String)this.config.get(BASE_ENTRY_NAME);
            if (name == null || name.length() == 0) {
                this.baseEntryMap.put(baseDN, baseDN);
            } else {
                this.baseEntryMap.put(name, baseDN);
            }
        }
        this.repositoriesForGroups = (String[])this.config.get(REPOSITORY_FOR_GROUPS);
        if (this.baseEntryMap.size() == 0) {
            Tr.error((TraceComponent)tc, (String)"MISSING_BASE_ENTRY", (Object[])new Object[]{this.reposId});
        }
    }

    private void initBaseEntry(List<Map<String, Object>> baseEntryList) {
        for (Map<String, Object> baseEntry : baseEntryList) {
            String baseDN = (String)baseEntry.get(BASE_DN);
            String name = (String)baseEntry.get(BASE_ENTRY_NAME);
            if (name == null || name.length() == 0) {
                Tr.error((TraceComponent)tc, (String)"INVALID_BASE_ENTRY_DEFINITION", (Object[])new Object[]{baseDN});
                continue;
            }
            this.baseEntryMap.put(name, baseDN);
        }
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void resetConfig() {
        this.reposId = null;
        this.baseEntryMap = new HashMap<String, String>();
        this.repositoriesForGroups = null;
        this.readOnly = false;
    }

    @Override
    public String getReposId() {
        return this.reposId;
    }

    @Override
    public Map<String, String> getRepositoryBaseEntries() {
        return this.baseEntryMap;
    }

    @Override
    public String[] getRepositoriesForGroups() {
        return this.repositoriesForGroups;
    }
}

