/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.concurrent.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.concurrent.internal.BaseManagedExecutorServiceConfig;
import com.ibm.ws.concurrent.internal.SubmittedTask;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.wsspi.application.lifecycle.ApplicationRecycleComponent;
import com.ibm.wsspi.application.lifecycle.ApplicationRecycleContext;
import com.ibm.wsspi.application.lifecycle.ApplicationRecycleCoordinator;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.resource.ResourceFactory;
import com.ibm.wsspi.resource.ResourceInfo;
import com.ibm.wsspi.threadcontext.ThreadContextDescriptor;
import com.ibm.wsspi.threadcontext.ThreadContextProvider;
import com.ibm.wsspi.threadcontext.WSContextService;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import javax.enterprise.concurrent.ManagedExecutorService;
import javax.enterprise.concurrent.ManagedTask;
import org.apache.felix.scr.ext.annotation.DSExt;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(configurationPid={"com.ibm.ws.concurrent.managedExecutorService"}, configurationPolicy=ConfigurationPolicy.REQUIRE, reference={@Reference(name="ApplicationRecycleCoordinator", service=ApplicationRecycleCoordinator.class)}, property={"creates.objectClass=java.util.concurrent.ExecutorService", "creates.objectClass=javax.enterprise.concurrent.ManagedExecutorService"})
@DSExt.ConfigureWithInterfaces
public class ManagedExecutorServiceImpl
implements ExecutorService,
ManagedExecutorService,
ResourceFactory,
ApplicationRecycleComponent {
    private static final TraceComponent tc = Tr.register(ManagedExecutorServiceImpl.class);
    static final String APP_RECYCLE_SERVICE = "ApplicationRecycleCoordinator";
    private static final String CONFIG_ID = "config.displayId";
    static final int FUTURE_PURGE_INTERVAL = 20;
    private final Set<String> applications = Collections.newSetFromMap(new ConcurrentHashMap());
    final PrivilegedAction<WSContextService> contextSvcAccessor = new PrivilegedAction<WSContextService>(){
        static final long serialVersionUID = -1311597716763976334L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        /*
         * WARNING - void declaration
         */
        @Override
        public WSContextService run() {
            try {
                return (WSContextService)ManagedExecutorServiceImpl.this.contextSvcRef.getServiceWithException();
            }
            catch (IllegalStateException illegalStateException) {
                void x;
                FFDCFilter.processException((Throwable)illegalStateException, (String)"com.ibm.ws.concurrent.internal.ManagedExecutorServiceImpl$1", (String)"142", (Object)this, (Object[])new Object[0]);
                throw new RejectedExecutionException((Throwable)x);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(1.class);
        }
    };
    private final AtomicServiceReference<WSContextService> contextSvcRef = new AtomicServiceReference("ContextService");
    private final AtomicReference<Map<String, String>> defaultExecutionProperties = new AtomicReference();
    @Reference(policy=ReferencePolicy.DYNAMIC, target="(id=unbound)")
    volatile ExecutorService executorService;
    volatile int futureCount;
    final ConcurrentLinkedQueue<Future<?>> futures = new ConcurrentLinkedQueue();
    private final AtomicReference<String> jndiNameRef = new AtomicReference();
    final AtomicReference<String> name = new AtomicReference();
    final PrivilegedAction<ThreadContextProvider> tranContextProviderAccessor = new PrivilegedAction<ThreadContextProvider>(){
        static final long serialVersionUID = -220575604455718022L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        public ThreadContextProvider run() {
            return (ThreadContextProvider)ManagedExecutorServiceImpl.this.tranContextProviderRef.getService();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(2.class);
        }
    };
    private final AtomicServiceReference<ThreadContextProvider> tranContextProviderRef = new AtomicServiceReference("TransactionContextProvider");
    static final long serialVersionUID = 1241822203863188273L;

    @ManualTrace
    @Activate
    protected void activate(ComponentContext context, BaseManagedExecutorServiceConfig config) {
        Dictionary properties = context.getProperties();
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"activate", (Object[])new Object[]{properties});
        }
        this.contextSvcRef.activate(context);
        this.tranContextProviderRef.activate(context);
        String jndiName = config.jndiName();
        this.jndiNameRef.set(jndiName);
        String xsvcName = jndiName == null ? config.config_displayId() : jndiName;
        this.name.set(xsvcName);
        TreeMap<String, String> execProps = new TreeMap<String, String>();
        execProps.put("com.ibm.ws.concurrent.DEFAULT_CONTEXT", "UNCONFIGURED_CONTEXT_TYPES");
        execProps.put("com.ibm.ws.concurrent.TASK_OWNER", xsvcName);
        this.defaultExecutionProperties.set(execProps);
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"activate");
        }
    }

    @ManualTrace
    @Modified
    protected void modified(final ComponentContext context, BaseManagedExecutorServiceConfig config) {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"modified", (Object[])new Object[]{config});
        }
        String jndiName = config.jndiName();
        String oldJNDIName = this.jndiNameRef.getAndSet(jndiName);
        String xsvcName = jndiName == null ? config.config_displayId() : jndiName;
        this.name.set(xsvcName);
        TreeMap<String, String> execProps = new TreeMap<String, String>();
        execProps.put("com.ibm.ws.concurrent.DEFAULT_CONTEXT", "UNCONFIGURED_CONTEXT_TYPES");
        execProps.put("com.ibm.ws.concurrent.TASK_OWNER", xsvcName);
        this.defaultExecutionProperties.set(execProps);
        if ((jndiName == null ? oldJNDIName != null : !jndiName.equals(oldJNDIName)) && !this.applications.isEmpty()) {
            ApplicationRecycleCoordinator appCoord = AccessController.doPrivileged(new PrivilegedAction<ApplicationRecycleCoordinator>(){
                static final long serialVersionUID = 222475267909177380L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public ApplicationRecycleCoordinator run() {
                    return (ApplicationRecycleCoordinator)context.locateService(ManagedExecutorServiceImpl.APP_RECYCLE_SERVICE);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(3.class);
                }
            });
            HashSet<String> members = new HashSet<String>(this.applications);
            this.applications.removeAll(members);
            appCoord.recycleApplications(members);
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"modified");
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        this.contextSvcRef.deactivate(context);
        this.tranContextProviderRef.deactivate(context);
        Future<?> future = this.futures.poll();
        while (future != null) {
            if (!future.isDone() && future.cancel(true) && trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"canceled", (Object[])new Object[]{future});
            }
            future = this.futures.poll();
        }
    }

    @Override
    @Trivial
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        throw new IllegalStateException(new UnsupportedOperationException("awaitTermination"));
    }

    private <T> ArrayList<SubmittedTask<T>> contextualize(Collection<? extends Callable<T>> tasks, boolean invokeAll) {
        WSContextService contextSvc = AccessController.doPrivileged(this.contextSvcAccessor);
        HashMap<Map<String, String>, ThreadContextDescriptor> execPropsToThreadContext = new HashMap<Map<String, String>, ThreadContextDescriptor>();
        ArrayList<SubmittedTask<T>> list = new ArrayList<SubmittedTask<T>>(tasks.size());
        for (Callable<T> task : tasks) {
            Map<String, String> execProps = this.getExecutionProperties(task);
            ThreadContextDescriptor threadContextDescriptor = (ThreadContextDescriptor)execPropsToThreadContext.get(execProps);
            if (threadContextDescriptor == null) {
                threadContextDescriptor = contextSvc.captureThreadContext(execProps, new Map[0]);
                execPropsToThreadContext.put(execProps, threadContextDescriptor);
            }
            SubmittedTask<Object> taskToSubmit = new SubmittedTask<Object>(this, task, threadContextDescriptor, null);
            if (taskToSubmit.future.isCancelled()) {
                if (!invokeAll) continue;
                throw new RejectedExecutionException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1110.task.canceled", (Object[])new Object[]{taskToSubmit.getName(), this.name}));
            }
            list.add(taskToSubmit);
        }
        if (list.isEmpty() && !tasks.isEmpty()) {
            throw new RejectedExecutionException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1112.all.tasks.canceled", (Object[])new Object[0]));
        }
        return list;
    }

    public Object createResource(ResourceInfo ref) throws Exception {
        ComponentMetaData cData = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        if (cData != null) {
            this.applications.add(cData.getJ2EEName().getApplication());
        }
        return this;
    }

    public ApplicationRecycleContext getContext() {
        return null;
    }

    public Set<String> getDependentApplications() {
        HashSet<String> members = new HashSet<String>(this.applications);
        this.applications.removeAll(members);
        return members;
    }

    @Override
    public void execute(Runnable command) {
        this.submit(command, null);
    }

    final Map<String, String> getExecutionProperties(Object task) {
        Map<String, String> execProps;
        if (task == null) {
            throw new NullPointerException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1111.task.invalid", (Object[])new Object[]{null}));
        }
        Map<String, String> map = execProps = task instanceof ManagedTask ? ((ManagedTask)task).getExecutionProperties() : null;
        if (execProps == null) {
            execProps = this.defaultExecutionProperties.get();
        } else {
            String tranProp = (execProps = new TreeMap<String, String>(execProps)).remove("javax.enterprise.concurrent.TRANSACTION");
            if (tranProp != null && !"SUSPEND".equals(tranProp)) {
                throw new RejectedExecutionException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1130.xprop.value.invalid", (Object[])new Object[]{this.name, "javax.enterprise.concurrent.TRANSACTION", tranProp}));
            }
            if (!execProps.containsKey("com.ibm.ws.concurrent.DEFAULT_CONTEXT")) {
                execProps.put("com.ibm.ws.concurrent.DEFAULT_CONTEXT", "UNCONFIGURED_CONTEXT_TYPES");
            }
            if (!execProps.containsKey("com.ibm.ws.concurrent.TASK_OWNER")) {
                execProps.put("com.ibm.ws.concurrent.TASK_OWNER", this.name.get());
            }
        }
        return execProps;
    }

    @Override
    @FFDCIgnore(value={InterruptedException.class})
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        List<Future<T>> futures;
        ExecutorService execSvc = this.getExecSvc();
        ArrayList<SubmittedTask<T>> tasksToSubmit = this.contextualize(tasks, true);
        try {
            futures = execSvc.invokeAll(tasksToSubmit);
        }
        catch (InterruptedException x) {
            for (SubmittedTask<T> task : tasksToSubmit) {
                if (task.future.isDone()) continue;
                task.future.cancel(true);
            }
            throw x;
        }
        ArrayList<Future<T>> futureList = new ArrayList<Future<T>>(tasksToSubmit.size());
        int index = 0;
        for (Future<T> future : futures) {
            SubmittedTask<T> submittedTask = tasksToSubmit.get(index++);
            submittedTask.future.set(future);
            futureList.add(submittedTask.future);
        }
        return futureList;
    }

    @Override
    @FFDCIgnore(value={InterruptedException.class})
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        List<Future<T>> futures;
        ExecutorService execSvc = this.getExecSvc();
        ArrayList<SubmittedTask<T>> tasksToSubmit = this.contextualize(tasks, true);
        try {
            futures = execSvc.invokeAll(tasksToSubmit, timeout, unit);
        }
        catch (InterruptedException x) {
            for (SubmittedTask<T> task : tasksToSubmit) {
                if (task.future.isDone()) continue;
                task.future.cancel(true);
            }
            throw x;
        }
        ArrayList<Future<T>> futureList = new ArrayList<Future<T>>(tasksToSubmit.size());
        int index = 0;
        for (Future<T> future : futures) {
            SubmittedTask<T> submittedTask = tasksToSubmit.get(index++);
            submittedTask.future.set(future);
            if (!submittedTask.future.isDone()) {
                submittedTask.future.cancel(true);
            }
            futureList.add(submittedTask.future);
        }
        return futureList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        T t;
        ExecutorService execSvc = this.getExecSvc();
        ArrayList<SubmittedTask<T>> tasksToSubmit = this.contextualize(tasks, false);
        try {
            t = execSvc.invokeAny(tasksToSubmit);
        }
        catch (Throwable throwable) {
            for (SubmittedTask submittedTask : tasksToSubmit) {
                if (submittedTask.future.isDone()) continue;
                submittedTask.future.cancel(true);
            }
            throw throwable;
        }
        for (SubmittedTask submittedTask : tasksToSubmit) {
            if (submittedTask.future.isDone()) continue;
            submittedTask.future.cancel(true);
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        T t;
        ExecutorService execSvc = this.getExecSvc();
        ArrayList<SubmittedTask<T>> tasksToSubmit = this.contextualize(tasks, false);
        try {
            t = execSvc.invokeAny(tasksToSubmit, timeout, unit);
        }
        catch (Throwable throwable) {
            for (SubmittedTask submittedTask : tasksToSubmit) {
                if (submittedTask.future.isDone()) continue;
                submittedTask.future.cancel(true);
            }
            throw throwable;
        }
        for (SubmittedTask submittedTask : tasksToSubmit) {
            if (submittedTask.future.isDone()) continue;
            submittedTask.future.cancel(true);
        }
        return t;
    }

    @Override
    @Trivial
    public boolean isShutdown() {
        throw new IllegalStateException(new UnsupportedOperationException("isShutdown"));
    }

    @Override
    @Trivial
    public boolean isTerminated() {
        throw new IllegalStateException(new UnsupportedOperationException("isTerminated"));
    }

    @Trivial
    final void purgeFutures() {
        Iterator<Future<?>> it = this.futures.iterator();
        while (it.hasNext()) {
            if (!it.next().isDone()) continue;
            it.remove();
        }
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, target="(id=unbound)")
    protected void setContextService(ServiceReference<WSContextService> ref) {
        this.contextSvcRef.setReference(ref);
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL, target="(component.name=com.ibm.ws.transaction.context.provider)")
    protected void setTransactionContextProvider(ServiceReference<ThreadContextProvider> ref) {
        this.tranContextProviderRef.setReference(ref);
    }

    @Override
    @Trivial
    public void shutdown() {
        throw new IllegalStateException(new UnsupportedOperationException("shutdown"));
    }

    @Override
    @Trivial
    public List<Runnable> shutdownNow() {
        throw new IllegalStateException(new UnsupportedOperationException("shutdownNow"));
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        Map<String, String> execProps = this.getExecutionProperties(task);
        WSContextService contextSvc = AccessController.doPrivileged(this.contextSvcAccessor);
        ExecutorService execSvc = this.getExecSvc();
        SubmittedTask<Object> taskToSubmit = new SubmittedTask<Object>(this, task, contextSvc.captureThreadContext(execProps, new Map[0]), null);
        if (taskToSubmit.future.isCancelled()) {
            throw new RejectedExecutionException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1110.task.canceled", (Object[])new Object[]{taskToSubmit.getName(), this.name}));
        }
        taskToSubmit.future.set(execSvc.submit(taskToSubmit));
        if (this.futures.add(taskToSubmit.future) && ++this.futureCount % 20 == 0) {
            this.purgeFutures();
        }
        return taskToSubmit.future;
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        Map<String, String> execProps = this.getExecutionProperties(task);
        WSContextService contextSvc = AccessController.doPrivileged(this.contextSvcAccessor);
        ExecutorService execSvc = this.getExecSvc();
        SubmittedTask<T> taskToSubmit = new SubmittedTask<T>(this, task, contextSvc.captureThreadContext(execProps, new Map[0]), result);
        if (taskToSubmit.future.isCancelled()) {
            throw new RejectedExecutionException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1110.task.canceled", (Object[])new Object[]{taskToSubmit.getName(), this.name}));
        }
        taskToSubmit.future.set(execSvc.submit(taskToSubmit, result));
        if (this.futures.add(taskToSubmit.future) && ++this.futureCount % 20 == 0) {
            this.purgeFutures();
        }
        return taskToSubmit.future;
    }

    private ExecutorService getExecSvc() {
        ExecutorService execSvc = this.executorService;
        if (execSvc == null) {
            throw new RejectedExecutionException();
        }
        return execSvc;
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.submit(task, null);
    }

    protected void unsetContextService(ServiceReference<WSContextService> ref) {
        this.contextSvcRef.unsetReference(ref);
    }

    protected void unsetTransactionContextProvider(ServiceReference<ThreadContextProvider> ref) {
        this.tranContextProviderRef.unsetReference(ref);
    }
}

