/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server;

import com.ibm.websphere.pmi.PerfModules;
import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.pmi.server.PerfLevelDescriptor;
import com.ibm.ws.pmi.server.PmiRegistry;
import java.util.ArrayList;
import java.util.StringTokenizer;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
public class PmiUtil
implements PmiConstants {
    private static final TraceComponent tc = Tr.register(PmiUtil.class);
    public static final String mySeperator = ">";
    public static final char mySeperatorChar = '>';
    public static final int pmiStringMaxLength = 0;
    public static String SHORT_LEVEL_NONE_STRING = "N";
    public static String SHORT_LEVEL_LOW_STRING = "L";
    public static String SHORT_LEVEL_MEDIUM_STRING = "M";
    public static String SHORT_LEVEL_HIGH_STRING = "H";
    public static String SHORT_LEVEL_MAX_STRING = "X";
    public static String SHORT_LEVEL_FG_STRING = "F";
    static String[] compressModuleNames = new String[PerfModules.moduleIDs.length];
    static final long serialVersionUID = 3731663161768119519L;

    public static long currentTime() {
        return System.currentTimeMillis() * 1L;
    }

    public static String getStringFromPerfLevelSpecs(PerfLevelDescriptor[] plds) {
        return PmiUtil.getStringFromPerfLevelSpecs(plds, true);
    }

    public static String getStringFromPerfLevelSpecs(PerfLevelDescriptor[] plds, boolean compressIfNeeded) {
        StringBuffer res = null;
        if (plds == null) {
            return null;
        }
        for (int i = 0; i < plds.length; ++i) {
            String morePld = PmiUtil.createPmiSpecString(plds[i]);
            if (res == null) {
                res = new StringBuffer();
                res.append(morePld);
                continue;
            }
            if (morePld == null) continue;
            res.append(":").append(morePld);
        }
        if (compressIfNeeded) {
            return PmiUtil.getCompressedPerfString(res.toString());
        }
        return res.toString();
    }

    public static PerfLevelDescriptor[] getPerfLevelSpecsFromString(String specString) {
        return PmiUtil.getPerfLevelSpecsFromString(specString, true);
    }

    public static PerfLevelDescriptor[] getPerfLevelSpecsFromString(String specString, boolean expandIfNeeded) {
        if (specString == null || specString.equals("") || specString.equals("pmi=disable")) {
            return null;
        }
        ArrayList<PerfLevelDescriptor> res = new ArrayList<PerfLevelDescriptor>();
        StringTokenizer st = new StringTokenizer(specString, ":");
        while (st.hasMoreTokens()) {
            String mName;
            PerfLevelDescriptor pld = PmiUtil.getSpecFromString(st.nextToken());
            if (pld == null) continue;
            res.add(pld);
            if (!expandIfNeeded || (mName = pld.getModuleName()) == null || !mName.equals("jvmRuntimeModule") || pld.getPath().length != 2) continue;
            String lvl = null;
            if (!lvl.equals("X")) {
                lvl = "N";
            }
            res.add(PmiUtil.getSpecFromString("jvmRuntimeModule>GC=" + lvl));
            res.add(PmiUtil.getSpecFromString("jvmRuntimeModule>Object=" + lvl));
            res.add(PmiUtil.getSpecFromString("jvmRuntimeModule>Thread=" + lvl));
            res.add(PmiUtil.getSpecFromString("jvmRuntimeModule>Monitor=" + lvl));
        }
        if (expandIfNeeded) {
            PerfLevelDescriptor pld1 = null;
            PerfLevelDescriptor pld2 = null;
            int numPlds = res.size();
            PerfLevelDescriptor parent = null;
            for (int i = 0; i < numPlds; ++i) {
                int j;
                parent = null;
                pld1 = (PerfLevelDescriptor)res.get(i);
                if (pld1 == null || pld1.getPath().length <= 2) continue;
                for (j = numPlds - 1; j >= 0; --j) {
                    if (i == j || !(pld2 = (PerfLevelDescriptor)res.get(j)).isSubPath(pld1)) continue;
                    if (pld2.getPath().length == pld1.getPath().length - 1) {
                        parent = null;
                        break;
                    }
                    if (parent != null && pld2.getPath().length <= parent.getPath().length) continue;
                    parent = pld2;
                }
                if (parent == null) continue;
                for (j = parent.getPath().length + 1; j < pld1.getPath().length; ++j) {
                    String[] path = new String[j];
                    for (int k = 0; k < j; ++k) {
                        path[k] = pld1.getPath()[k];
                    }
                    res.add(new PerfLevelDescriptor(path, parent.getLevel()));
                }
            }
        }
        PerfLevelDescriptor[] resArray = new PerfLevelDescriptor[res.size()];
        for (int i = 0; i < resArray.length; ++i) {
            resArray[i] = (PerfLevelDescriptor)res.get(i);
            String[] stringArray = resArray[i].getPath();
        }
        return resArray;
    }

    public static String updatePerfLevelSpecString(String oldSpecString, PerfLevelDescriptor[] newPlds, boolean recursive) {
        PerfLevelDescriptor[] currentPlds = PmiUtil.getPerfLevelSpecsFromString(oldSpecString, false);
        if (currentPlds == null) {
            currentPlds = PmiRegistry.getDefaultPerfLevelSpecs();
        }
        if (newPlds == null) {
            return oldSpecString;
        }
        ArrayList<PerfLevelDescriptor> tmpPds = new ArrayList<PerfLevelDescriptor>(newPlds.length);
        for (int i = 0; i < newPlds.length; ++i) {
            if (newPlds[i] == null) continue;
            String[] newPath = newPlds[i].getPath();
            if (!recursive && newPath.length == 1 && newPath[0].equalsIgnoreCase("pmi")) continue;
            boolean found = false;
            for (int j = 0; j < currentPlds.length; ++j) {
                if (recursive && newPlds[i].isSubPath(currentPlds[j])) {
                    currentPlds[j].setLevel(newPlds[i].getLevel());
                }
                if (newPlds[i].comparePath(currentPlds[j]) != 0) continue;
                found = true;
                currentPlds[j].setLevel(newPlds[i].getLevel());
                if (!recursive) break;
            }
            if (found) continue;
            tmpPds.add(newPlds[i]);
        }
        String ret = PmiUtil.getStringFromPerfLevelSpecs(currentPlds, false);
        if (tmpPds.size() > 0) {
            PerfLevelDescriptor[] extraPlds = new PerfLevelDescriptor[tmpPds.size()];
            for (int i = 0; i < extraPlds.length; ++i) {
                extraPlds[i] = (PerfLevelDescriptor)tmpPds.get(i);
            }
            String newString = PmiUtil.getStringFromPerfLevelSpecs(extraPlds, false);
            if (newString != null) {
                ret = ret + ":" + newString;
            }
        }
        return PmiUtil.getCompressedPerfString(ret);
    }

    public static String getCompressedPerfString(String str) {
        int i;
        int length = str.lastIndexOf(61);
        if (length < 0) {
            return str;
        }
        PerfLevelDescriptor[] currentPlds = PmiUtil.getPerfLevelSpecsFromString(str, false);
        ArrayList<PerfLevelDescriptor> tmpPds = new ArrayList<PerfLevelDescriptor>(currentPlds.length);
        for (i = 0; i < currentPlds.length; ++i) {
            int topParentIndex = -1;
            for (int j = currentPlds.length - 1; j >= 0 && currentPlds[i].getPath().length > 2; --j) {
                if (i == j || !currentPlds[j].isSubPath(currentPlds[i])) continue;
                if (currentPlds[j].getPath().length == currentPlds[i].getPath().length - 1) {
                    if (currentPlds[j].level == currentPlds[i].level) {
                        topParentIndex = j;
                        break;
                    }
                    topParentIndex = -1;
                    break;
                }
                if (topParentIndex != -1 && !currentPlds[topParentIndex].isSubPath(currentPlds[j])) continue;
                topParentIndex = j;
            }
            if (topParentIndex != -1 && currentPlds[topParentIndex].level == currentPlds[i].level) continue;
            tmpPds.add(currentPlds[i]);
        }
        currentPlds = new PerfLevelDescriptor[tmpPds.size()];
        for (i = 0; i < currentPlds.length; ++i) {
            currentPlds[i] = (PerfLevelDescriptor)tmpPds.get(i);
        }
        String res = PmiUtil.getStringFromPerfLevelSpecs(currentPlds, false);
        return res;
    }

    private static String createPmiSpecString(PerfLevelDescriptor pld) {
        if (pld == null) {
            return null;
        }
        StringBuffer pathString = new StringBuffer();
        String[] path = pld.getPath();
        if (path.length == 0) {
            return null;
        }
        if (path.length == 1 && path[0].equalsIgnoreCase("pmi")) {
            pathString.append("pmi");
        } else {
            for (int i = 0; i < path.length; ++i) {
                if (i == 0 && path[i].equalsIgnoreCase("pmi")) continue;
                boolean isModule = false;
                if (i == 0 || i == 1) {
                    for (int k = 0; k < PerfModules.moduleIDs.length; ++k) {
                        if (!path[i].equals(PerfModules.moduleIDs[k])) continue;
                        isModule = true;
                        pathString.append(PerfModules.moduleIDs[k]);
                        break;
                    }
                }
                if (!isModule) {
                    pathString.append(path[i]);
                }
                if (i >= path.length - 1) continue;
                pathString.append(mySeperator);
            }
        }
        if (pld.getLevel() == -1) {
            return null;
        }
        String levelString = "none";
        switch (pld.getLevel()) {
            case 0: {
                levelString = SHORT_LEVEL_NONE_STRING;
                break;
            }
            case 1: {
                levelString = SHORT_LEVEL_LOW_STRING;
                break;
            }
            case 3: {
                levelString = SHORT_LEVEL_MEDIUM_STRING;
                break;
            }
            case 7: {
                levelString = SHORT_LEVEL_HIGH_STRING;
                break;
            }
            case 15: {
                levelString = SHORT_LEVEL_MAX_STRING;
                break;
            }
            case -2: {
                levelString = SHORT_LEVEL_FG_STRING;
                break;
            }
            default: {
                Tr.warning((TraceComponent)tc, (String)"PMI0011W", (Object[])new Object[]{"level=" + pld.getLevel()});
            }
        }
        pathString.append("=").append(levelString);
        return pathString.toString();
    }

    private static PerfLevelDescriptor getSpecFromString(String str) {
        Object pathNlevel = null;
        if (str != null && !str.equals("") && (pathNlevel).length != 2) {
            Tr.warning((TraceComponent)tc, (String)"PMI0011W", (Object[])new Object[]{str});
            return null;
        }
        String[] path = null;
        if (path == null || path.length == 0) {
            Tr.warning((TraceComponent)tc, (String)"PMI0011W", (Object[])new Object[]{str});
            return null;
        }
        String moduleName = null;
        int moduleIndex = -1;
        if (!path[0].equalsIgnoreCase("pmi")) {
            moduleName = path[0];
            moduleIndex = 0;
        } else if (path.length > 1) {
            moduleName = path[1];
            moduleIndex = 1;
        } else if (path.length == 1 && path[0].equalsIgnoreCase("pmi")) {
            moduleName = "pmi";
            path = null;
        }
        if (moduleName != null) {
            boolean existingModule = false;
            if (moduleName.equals("pmi")) {
                existingModule = true;
            }
            if (!existingModule) {
                for (int i = 0; i < PerfModules.moduleIDs.length; ++i) {
                    if (!moduleName.equals(PerfModules.moduleIDs[i]) && !moduleName.equals(compressModuleNames[i])) continue;
                    existingModule = true;
                    path[moduleIndex] = PerfModules.moduleIDs[i];
                    break;
                }
            }
        }
        void strLevel = pathNlevel[1];
        int level = -1;
        if (strLevel.equalsIgnoreCase(SHORT_LEVEL_NONE_STRING) || strLevel.equalsIgnoreCase("none")) {
            level = 0;
        } else if (strLevel.equalsIgnoreCase(SHORT_LEVEL_LOW_STRING) || strLevel.equalsIgnoreCase("low")) {
            level = 1;
        } else if (strLevel.equalsIgnoreCase(SHORT_LEVEL_MEDIUM_STRING) || strLevel.equalsIgnoreCase("medium")) {
            level = 3;
        } else if (strLevel.equalsIgnoreCase(SHORT_LEVEL_HIGH_STRING) || strLevel.equalsIgnoreCase("high")) {
            level = 7;
        } else if (strLevel.equalsIgnoreCase(SHORT_LEVEL_MAX_STRING) || strLevel.equalsIgnoreCase("maximum")) {
            level = 15;
        } else if (strLevel.equalsIgnoreCase(SHORT_LEVEL_FG_STRING)) {
            level = -2;
        }
        if (level == -1) {
            Tr.warning((TraceComponent)tc, (String)"PMI0011W", (Object[])new Object[]{str});
        }
        return new PerfLevelDescriptor(path, level);
    }

    public static String normalizeName(String name) {
        if (name.indexOf(47) != -1) {
            return name.replace('/', '_');
        }
        return name;
    }

    public static String statsTypeToModuleID(String statsType) {
        if (statsType != null) {
            int hashPos = statsType.indexOf(35);
            if (hashPos > 0) {
                return statsType.substring(0, hashPos);
            }
            return statsType;
        }
        return null;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        for (int i = 0; i < PerfModules.moduleIDs.length; ++i) {
            PmiUtil.compressModuleNames[i] = PerfModules.moduleIDs[i].substring(0, 4);
        }
    }
}

