/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.monitor.internal.bci;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.monitor.internal.ProbeImpl;
import com.ibm.ws.monitor.internal.ProbeListener;
import com.ibm.ws.monitor.internal.ProbeManagerImpl;
import com.ibm.ws.monitor.internal.bci.MethodAdapters;
import com.ibm.ws.monitor.internal.bci.MethodInfo;
import com.ibm.ws.monitor.internal.bci.ProbeMethodAdapter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
public class ProbeInjectionClassAdapter
extends ClassVisitor {
    final ProbeManagerImpl probeManager;
    final Class<?> probedClasses;
    final Map<String, Method> methodMap = new HashMap<String, Method>();
    final Map<String, Constructor<?>> constructorMap = new HashMap();
    final Set<ProbeMethodAdapter> probeAdapters = new HashSet<ProbeMethodAdapter>();
    Set<ProbeListener> interestedListeners;
    static final long serialVersionUID = -3691380157628012615L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ProbeInjectionClassAdapter(ClassVisitor delegate, ProbeManagerImpl probeManager, Class<?> clazz) {
        super(327680, delegate);
        this.probeManager = probeManager;
        this.probedClasses = clazz;
        this.interestedListeners = probeManager.getInterestedByClass(clazz);
        for (Method method : clazz.getDeclaredMethods()) {
            this.methodMap.put(method.getName() + Type.getMethodDescriptor((Method)method), method);
        }
        for (Executable executable : clazz.getDeclaredConstructors()) {
            this.constructorMap.put("<init>" + Type.getConstructorDescriptor((Constructor)executable), (Constructor<?>)executable);
        }
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, descriptor, signature, exceptions);
        if (this.isStaticInitMethod(access, name)) {
            return mv;
        }
        MethodInfo methodInfo = new MethodInfo(this, access, name, descriptor, signature, exceptions);
        Set<ProbeListener> interested = this.getInterested(name, descriptor);
        ProbeMethodAdapter pma = new ProbeMethodAdapter(mv, methodInfo);
        block0: for (MethodAdapters ma : MethodAdapters.values()) {
            for (ProbeListener listener : interested) {
                if (!ma.isRequiredForListener(listener)) continue;
                pma = ma.create(pma, methodInfo, interested);
                this.probeAdapters.add(pma);
                continue block0;
            }
        }
        return pma;
    }

    public void visitEnd() {
        super.visitEnd();
        HashMap<ProbeListener, HashSet<ProbeImpl>> listenerProbes = new HashMap<ProbeListener, HashSet<ProbeImpl>>();
        for (ProbeMethodAdapter pma : this.probeAdapters) {
            for (ProbeImpl probe : pma.getEnabledProbes()) {
                for (ProbeListener listener : pma.getProbeListeners(probe)) {
                    HashSet<ProbeImpl> probes = (HashSet<ProbeImpl>)listenerProbes.get(listener);
                    if (probes == null) {
                        probes = new HashSet<ProbeImpl>();
                        listenerProbes.put(listener, probes);
                    }
                    probes.add(probe);
                }
            }
        }
        for (ProbeListener listener : listenerProbes.keySet()) {
            this.probeManager.addActiveProbesforListener(listener, (Collection)listenerProbes.get(listener));
        }
    }

    protected boolean isStaticInitMethod(int access, String name) {
        if ((access & 8) != 0) {
            return "<clinit>".equals(name);
        }
        return false;
    }

    protected boolean isConstructor(int access, String name) {
        if ((access & 8) == 0) {
            return "<init>".equals(name);
        }
        return false;
    }

    public boolean isModifiedClass() {
        for (ProbeMethodAdapter pma : this.probeAdapters) {
            if (pma.getEnabledProbes().isEmpty()) continue;
            return true;
        }
        return false;
    }

    Constructor<?> getConstructor(String name, String desc) {
        return this.constructorMap.get(name + desc);
    }

    Method getMethod(String name, String desc) {
        return this.methodMap.get(name + desc);
    }

    private Set<ProbeListener> getInterested(String name, String desc) {
        HashSet<ProbeListener> interested = new HashSet<ProbeListener>();
        String key = name + desc;
        Method m = this.methodMap.get(key);
        Constructor<?> c = this.constructorMap.get(key);
        for (ProbeListener listener : this.interestedListeners) {
            if (m != null && listener.getProbeFilter().matches(m, true)) {
                interested.add(listener);
                continue;
            }
            if (c == null || !listener.getProbeFilter().matches(c, true)) continue;
            interested.add(listener);
        }
        return interested;
    }

    ProbeManagerImpl getProbeManager() {
        return this.probeManager;
    }

    Class<?> getProbedClass() {
        return this.probedClasses;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ProbeInjectionClassAdapter.class);
    }
}

