/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.monitor.meters;

import com.ibm.websphere.monitor.annotation.Monitor;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.monitor.internal.MonitoringFrameworkExtender;
import java.lang.management.ManagementFactory;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
public final class MeterCollection<T> {
    final ConcurrentMap<String, T> meters = new ConcurrentHashMap<String, T>();
    private final TraceComponent tc = Tr.register(MeterCollection.class);
    private static final MBeanServer mbeanServer;
    private static final int REGISTER_MXBEAN = 1;
    private static final int UNREGISTER_MXBEAN = 2;
    final String collectionName;
    Object monitor;
    static final long serialVersionUID = -5546405806539033899L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public MeterCollection(String collectionName, Object monitor) {
        this.collectionName = collectionName;
        this.monitor = monitor;
    }

    public void put(String key, T meter) {
        block11: {
            try {
                if (this.tc.isDebugEnabled()) {
                    if (meter != null) {
                        Tr.debug((TraceComponent)this.tc, (String)("KEY =" + key + ",. Type of Meter =" + meter.getClass().getSimpleName()), (Object[])new Object[0]);
                    } else {
                        Tr.debug((TraceComponent)this.tc, (String)("KEY =" + key + ",. Type of Meter is NULL"), (Object[])new Object[0]);
                    }
                }
                if (meter == null) {
                    return;
                }
                ObjectName objectName = null;
                if (!this.meters.containsValue(meter)) {
                    Set s;
                    if (this.tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)this.tc, (String)("Calling MBean REGISTER operation for =" + key + ",. Type of Meter =" + meter.getClass().getSimpleName()), (Object[])new Object[0]);
                    }
                    if (MonitoringFrameworkExtender.groupList.size() > 0 && !MeterCollection.ifMonitorClassExistsInFilterGroup(this.monitor.getClass())) {
                        return;
                    }
                    objectName = this.MXBeanHelper(meter.getClass().getSimpleName(), key, 1, meter);
                    if (this.tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)this.tc, (String)("MBean REGISTER operation is successful. ObjectName =" + objectName), (Object[])new Object[0]);
                    }
                    if ((s = (Set)MonitoringFrameworkExtender.mxmap.get(this.monitor)) != null) {
                        s.add(objectName);
                    }
                }
            }
            catch (Exception t) {
                if (!this.tc.isDebugEnabled()) break block11;
                Tr.debug((TraceComponent)this.tc, (String)t.getMessage(), (Object[])new Object[0]);
            }
        }
        this.meters.put(key, meter);
    }

    private static boolean ifMonitorClassExistsInFilterGroup(Class monitorClassName) {
        boolean filterExits = false;
        Monitor groups = monitorClassName.getAnnotation(Monitor.class);
        String[] group = groups.group();
        for (int i = 0; i < group.length; ++i) {
            if (!MonitoringFrameworkExtender.groupList.contains(group[i])) continue;
            filterExits = true;
            break;
        }
        return filterExits;
    }

    @ManualTrace
    public synchronized ObjectName MXBeanHelper(String type, String name, int operation, Object mxBeanImpl) throws MalformedObjectNameException, NullPointerException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException, InstanceNotFoundException {
        if (this.tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)this.tc, (String)"MXBeanHelper", (Object[])new Object[0]);
        }
        StringBuilder sb = new StringBuilder("WebSphere:");
        sb.append("type=").append(type);
        sb.append(",name=").append(name);
        ObjectName on = new ObjectName(sb.toString());
        if (operation == 1) {
            if (this.tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)this.tc, (String)("Registering MBean to platform MBean Server " + on), (Object[])new Object[0]);
            }
            mbeanServer.registerMBean(mxBeanImpl, on);
        } else if (operation == 2) {
            if (this.tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)this.tc, (String)("UN-Registering MBean from platform MBean Server " + on), (Object[])new Object[0]);
            }
            mbeanServer.unregisterMBean(on);
        }
        if (this.tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)this.tc, (String)"MXBeanHelper");
        }
        return on;
    }

    public T get(String key) {
        return (T)this.meters.get(key);
    }

    public void remove(String key) {
        block4: {
            Object mBeanImpl = null;
            ObjectName objectName = null;
            try {
                Set s;
                Object v = this.meters.remove(key);
                mBeanImpl = v;
                if (v != null) {
                    objectName = this.MXBeanHelper(mBeanImpl.getClass().getSimpleName(), key, 2, null);
                }
                if ((s = (Set)MonitoringFrameworkExtender.mxmap.get(this.monitor)) != null && objectName != null) {
                    s.remove(objectName);
                }
            }
            catch (Throwable t) {
                if (!this.tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)this.tc, (String)t.getMessage(), (Object[])new Object[0]);
            }
        }
    }

    String getCollectionName() {
        return this.collectionName;
    }

    Set<String> getKeys() {
        return this.meters.keySet();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(MeterCollection.class);
        mbeanServer = ManagementFactory.getPlatformMBeanServer();
    }
}

