/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.internal.impl;

import com.ibm.websphere.ras.TrConfigurator;
import com.ibm.ws.kernel.security.thread.ThreadIdentityManager;
import com.ibm.ws.logging.internal.impl.BaseTraceService;
import com.ibm.ws.logging.internal.impl.CountingOutputStream;
import com.ibm.ws.logging.internal.impl.FileLogHeader;
import com.ibm.ws.logging.internal.impl.FileLogSet;
import com.ibm.ws.logging.internal.impl.LoggingConstants;
import com.ibm.ws.logging.internal.impl.LoggingFileUtils;
import com.ibm.wsspi.logging.TextFileOutputStreamFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class FileLogHolder
implements BaseTraceService.TraceWriter {
    protected FileOutputStream currentFileStream;
    protected CountingOutputStream currentCountingStream;
    private PrintStream currentPrintStream;
    protected StreamStatus currentStatus;
    private final FileLogHeader logHeader;
    protected final FileLogSet fileLogSet = new FileLogSet(true);
    protected long maxFileSizeBytes;

    public static FileLogHolder createFileLogHolder(BaseTraceService.TraceWriter oldLog, FileLogHeader logHeader, File logDirectory, String newFileName, int maxFiles, long maxSizeBytes) {
        FileLogHolder logHolder;
        String fileExtension;
        String fileName;
        int dio;
        int lio = newFileName.lastIndexOf("/");
        if (lio > 0) {
            newFileName = newFileName.substring(lio + 1);
        }
        if (File.separatorChar != '/' && (lio = newFileName.lastIndexOf(File.separatorChar)) > 0) {
            newFileName = newFileName.substring(lio + 1);
        }
        if ((dio = newFileName.lastIndexOf(".")) > 0) {
            fileName = newFileName.substring(0, dio);
            fileExtension = newFileName.substring(dio);
        } else {
            fileName = newFileName;
            fileExtension = "";
        }
        if (oldLog != null && oldLog instanceof FileLogHolder) {
            logHolder = (FileLogHolder)oldLog;
            logHolder.update(logDirectory, fileName, fileExtension, maxFiles, maxSizeBytes);
        } else {
            if (oldLog != null) {
                try {
                    oldLog.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            logHolder = new FileLogHolder(logHeader, logDirectory, fileName, fileExtension, maxFiles, maxSizeBytes);
        }
        return logHolder;
    }

    private FileLogHolder(FileLogHeader logHeader, File directory, String fileName, String fileExtension, int maxNumFiles, long maxFileSizeBytes) {
        this.logHeader = logHeader;
        this.currentPrintStream = DummyOutputStream.psInstance;
        this.update(directory, fileName, fileExtension, maxNumFiles, maxFileSizeBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void update(File newDirectory, String newFileName, String newFileExtension, int newMaxFiles, long newMaxSizeBytes) {
        boolean updateLocation;
        Object token = ThreadIdentityManager.runAsServer();
        try {
            updateLocation = this.fileLogSet.update(newDirectory, newFileName, newFileExtension, newMaxFiles);
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
        if (updateLocation) {
            this.setStreamStatus(StreamStatus.INIT, this.currentFileStream, this.currentCountingStream, this.currentPrintStream);
        }
        this.maxFileSizeBytes = newMaxSizeBytes;
    }

    @Override
    public synchronized void close() {
        if (this.currentStatus != StreamStatus.CLOSED) {
            this.currentPrintStream.flush();
            if (!LoggingFileUtils.tryToClose(this.currentPrintStream)) {
                LoggingFileUtils.tryToClose(this.currentFileStream);
            }
            this.setStreamStatus(StreamStatus.CLOSED, null, null, DummyOutputStream.psInstance);
        }
    }

    @Override
    public synchronized void writeRecord(String record) {
        long length = record.length() + LoggingConstants.nlen;
        PrintStream ps = this.getPrintStream(length);
        ps.println(record);
    }

    private synchronized PrintStream getPrintStream(long numNewChars) {
        switch (this.currentStatus) {
            case INIT: {
                return this.createStream();
            }
            case ACTIVE: {
                long bytesWritten;
                if (this.maxFileSizeBytes <= 0L || (bytesWritten = this.currentCountingStream.count()) + numNewChars <= this.maxFileSizeBytes) break;
                return this.createStream();
            }
        }
        return this.currentPrintStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized PrintStream createStream() {
        block10: {
            FileOutputStream newFileStream = null;
            CountingOutputStream newCountingStream = null;
            PrintStream newPrintStream = null;
            File targetLogFile = null;
            long realMaxFileSizeBytes = this.maxFileSizeBytes;
            this.maxFileSizeBytes = 0L;
            Object token = ThreadIdentityManager.runAsServer();
            try {
                this.currentPrintStream.flush();
                if (this.currentFileStream != null) {
                    LoggingFileUtils.tryToClose(this.currentFileStream);
                }
                if ((targetLogFile = LoggingFileUtils.createNewFile(this.fileLogSet)) != null) {
                    try {
                        TextFileOutputStreamFactory fileStreamFactory = TrConfigurator.getFileOutputStreamFactory();
                        newFileStream = fileStreamFactory.createOutputStream(targetLogFile, true);
                        newCountingStream = new CountingOutputStream(newFileStream);
                        newPrintStream = new PrintStream(newCountingStream);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (newFileStream != null && newCountingStream != null && newPrintStream != null) {
                        if (this.logHeader != null) {
                            this.logHeader.print(newPrintStream);
                        }
                        this.setStreamStatus(StreamStatus.ACTIVE, newFileStream, newCountingStream, newPrintStream);
                    } else {
                        this.setStreamStatus(StreamStatus.CLOSED, null, null, DummyOutputStream.psInstance);
                    }
                    break block10;
                }
                this.setStreamStatus(StreamStatus.CLOSED, null, null, DummyOutputStream.psInstance);
            }
            finally {
                ThreadIdentityManager.reset((Object)token);
                this.maxFileSizeBytes = realMaxFileSizeBytes;
            }
        }
        return this.currentPrintStream;
    }

    private synchronized void setStreamStatus(StreamStatus newStatus, FileOutputStream newFileStream, CountingOutputStream newCountingStream, PrintStream newPrintStream) {
        this.currentStatus = newStatus;
        this.currentFileStream = newFileStream;
        this.currentCountingStream = newCountingStream;
        this.currentPrintStream = newPrintStream;
    }

    public synchronized void releaseFile() {
        if (this.currentStatus == StreamStatus.ACTIVE) {
            this.currentPrintStream.flush();
            if (!LoggingFileUtils.tryToClose(this.currentPrintStream)) {
                LoggingFileUtils.tryToClose(this.currentFileStream);
            }
            this.setStreamStatus(StreamStatus.INIT, null, null, DummyOutputStream.psInstance);
        }
    }

    static class DummyOutputStream
    extends OutputStream {
        static final DummyOutputStream instance = new DummyOutputStream();
        static final PrintStream psInstance = new PrintStream(instance);

        DummyOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
        }
    }

    static enum StreamStatus {
        INIT,
        ACTIVE,
        CLOSED;

    }
}

