/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsoc;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.webcontainer.servlet.WsocHandler;
import com.ibm.ws.webcontainer31.osgi.webapp.WebApp31;
import com.ibm.ws.wsoc.EndpointHelper;
import com.ibm.ws.wsoc.WsocHttpSessionListener;
import com.ibm.ws.wsoc.WsocServletContextListener;
import com.ibm.ws.wsoc.external.ServerContainerExt;
import com.ibm.ws.wsoc.external.WsocHandlerImpl;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.HandlesTypes;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.server.ServerApplicationConfig;
import javax.websocket.server.ServerEndpoint;
import javax.websocket.server.ServerEndpointConfig;

@HandlesTypes(value={ServerEndpoint.class, Endpoint.class, ServerApplicationConfig.class})
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class WebSocketServletContainerInitializer
implements ServletContainerInitializer {
    private static final TraceComponent tc = Tr.register(WebSocketServletContainerInitializer.class);
    static final long serialVersionUID = -7032237970242953493L;

    /*
     * WARNING - void declaration
     */
    public void onStartup(Set<Class<?>> clazzes, ServletContext servletContext) throws ServletException {
        block5: {
            try {
                WsocHandlerImpl wsocServletHandler = new WsocHandlerImpl();
                ((WebApp31)servletContext).registerWebSocketHandler((WsocHandler)wsocServletHandler);
                ServerContainerExt serverContainer = new ServerContainerExt();
                servletContext.setAttribute("javax.websocket.server.ServerContainer", (Object)serverContainer);
                WsocServletContextListener wscl = new WsocServletContextListener();
                wscl.initialize(serverContainer.getEndpointManager());
                servletContext.addListener((EventListener)((Object)wscl));
                WsocHttpSessionListener listener = new WsocHttpSessionListener();
                listener.initialize(serverContainer.getEndpointManager());
                servletContext.addListener((EventListener)((Object)listener));
                if (clazzes != null) {
                    String endPointContext = servletContext.getContextPath();
                    Set<EndpointHelper> annotatedEndpoints = this.getAnnotatedServerEndpointClasses(clazzes, endPointContext, serverContainer);
                    Set<EndpointHelper> programmaticEndpoints = this.getServerEndpointClasses(clazzes, endPointContext);
                    Set<Class<? extends ServerApplicationConfig>> serverAppConfigs = this.getServerApplicationConfigClasses(clazzes);
                    Set<EndpointHelper> helpers = this.determineEndpoints(annotatedEndpoints, programmaticEndpoints, serverAppConfigs);
                    for (EndpointHelper helper : helpers) {
                        serverContainer.addEndpoint(helper);
                    }
                }
            }
            catch (RuntimeException wsocServletHandler) {
                void e;
                FFDCFilter.processException((Throwable)wsocServletHandler, (String)"com.ibm.ws.wsoc.WebSocketServletContainerInitializer", (String)"80", (Object)this, (Object[])new Object[]{clazzes, servletContext});
                throw e;
            }
            catch (Exception e) {
                void f;
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.wsoc.WebSocketServletContainerInitializer", (String)"82", (Object)this, (Object[])new Object[]{clazzes, servletContext});
                if (!(f instanceof DeploymentException)) break block5;
                throw new RuntimeException((Throwable)f);
            }
        }
    }

    private Set<EndpointHelper> getAnnotatedServerEndpointClasses(Set<Class<?>> classes, String contextPath, ServerContainerExt serverContainer) {
        if (classes == null) {
            return Collections.emptySet();
        }
        HashSet<EndpointHelper> endpointAnnotationHelpers = new HashSet<EndpointHelper>();
        for (Class<?> c : classes) {
            EndpointHelper eh = serverContainer.getAnnotatedEndpointClass(c);
            if (eh == null) continue;
            endpointAnnotationHelpers.add(eh);
        }
        return endpointAnnotationHelpers;
    }

    private Set<EndpointHelper> getServerEndpointClasses(Set<Class<?>> classes, String contextPath) {
        HashSet<EndpointHelper> serverEndpoints = new HashSet<EndpointHelper>();
        for (Class<?> c : classes) {
            if (!Endpoint.class.isAssignableFrom(c)) continue;
            EndpointHelper helper = new EndpointHelper();
            helper.setEndpointClass(c);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("possible programmatic endpoint of: " + c), (Object[])new Object[0]);
            }
            serverEndpoints.add(helper);
        }
        return serverEndpoints;
    }

    private Set<Class<? extends ServerApplicationConfig>> getServerApplicationConfigClasses(Set<Class<?>> classes) {
        HashSet<Class<? extends ServerApplicationConfig>> serverApplicationConfigs = new HashSet<Class<? extends ServerApplicationConfig>>();
        for (Class<?> c : classes) {
            if (!ServerApplicationConfig.class.isAssignableFrom(c)) continue;
            Class<?> x = c;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("found ServerApplicationConfig of: " + x), (Object[])new Object[0]);
            }
            serverApplicationConfigs.add(x);
        }
        return serverApplicationConfigs;
    }

    public Set<EndpointHelper> determineEndpoints(Set<EndpointHelper> annotatedEndpointHelpers, Set<EndpointHelper> programmaticEndpointHelpers, Set<Class<? extends ServerApplicationConfig>> serverAppConfigs) {
        ServerApplicationConfig config;
        Class<?> c;
        HashSet annotatedEndpointClasses = new HashSet();
        HashMap endpointMap = new HashMap();
        HashSet<EndpointHelper> returnHelpers = new HashSet<EndpointHelper>();
        HashSet programmaticEndpointClasses = new HashSet();
        HashSet endpointConfigs = new HashSet();
        if (serverAppConfigs.size() == 0) {
            return annotatedEndpointHelpers;
        }
        for (EndpointHelper endpointHelper : annotatedEndpointHelpers) {
            c = endpointHelper.getEndpointClass();
            annotatedEndpointClasses.add(c);
            endpointMap.put(c, endpointHelper);
        }
        if (annotatedEndpointClasses.size() > 0) {
            for (Class clazz : serverAppConfigs) {
                config = null;
                try {
                    config = (ServerApplicationConfig)clazz.newInstance();
                }
                catch (IllegalAccessException illegalAccessException) {
                    FFDCFilter.processException((Throwable)illegalAccessException, (String)"com.ibm.ws.wsoc.WebSocketServletContainerInitializer", (String)"179", (Object)this, (Object[])new Object[]{annotatedEndpointHelpers, programmaticEndpointHelpers, serverAppConfigs});
                }
                catch (InstantiationException instantiationException) {
                    FFDCFilter.processException((Throwable)instantiationException, (String)"com.ibm.ws.wsoc.WebSocketServletContainerInitializer", (String)"181", (Object)this, (Object[])new Object[]{annotatedEndpointHelpers, programmaticEndpointHelpers, serverAppConfigs});
                }
                if (config == null) continue;
                Set annotatedEnpointsToUse = config.getAnnotatedEndpointClasses(annotatedEndpointClasses);
                for (Class c2 : annotatedEnpointsToUse) {
                    EndpointHelper helper = (EndpointHelper)endpointMap.get(c2);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("will use annoated endpoint of: " + c2), (Object[])new Object[0]);
                    }
                    returnHelpers.add(helper);
                }
            }
        }
        endpointMap.clear();
        for (EndpointHelper endpointHelper : programmaticEndpointHelpers) {
            c = endpointHelper.getEndpointClass();
            programmaticEndpointClasses.add(c);
            endpointMap.put(c, endpointHelper);
        }
        if (programmaticEndpointClasses.size() > 0) {
            for (Class clazz : serverAppConfigs) {
                config = null;
                try {
                    config = (ServerApplicationConfig)clazz.newInstance();
                }
                catch (IllegalAccessException annotatedEnpointsToUse) {
                    FFDCFilter.processException((Throwable)annotatedEnpointsToUse, (String)"com.ibm.ws.wsoc.WebSocketServletContainerInitializer", (String)"218", (Object)this, (Object[])new Object[]{annotatedEndpointHelpers, programmaticEndpointHelpers, serverAppConfigs});
                }
                catch (InstantiationException annotatedEnpointsToUse) {
                    FFDCFilter.processException((Throwable)annotatedEnpointsToUse, (String)"com.ibm.ws.wsoc.WebSocketServletContainerInitializer", (String)"220", (Object)this, (Object[])new Object[]{annotatedEndpointHelpers, programmaticEndpointHelpers, serverAppConfigs});
                }
                if (config == null) continue;
                Set programmaticEnpointConfigsToUse = config.getEndpointConfigs(programmaticEndpointClasses);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("programmaticEnpointConfigsToUse: " + programmaticEnpointConfigsToUse), (Object[])new Object[0]);
                }
                if (programmaticEnpointConfigsToUse == null) continue;
                for (ServerEndpointConfig endpointConfig : programmaticEnpointConfigsToUse) {
                    EndpointHelper scannedHelper;
                    Class endpoint = endpointConfig.getEndpointClass();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("endpointConfig class: " + endpoint.getName()), (Object[])new Object[0]);
                    }
                    if ((scannedHelper = (EndpointHelper)endpointMap.get(endpoint)) == null) continue;
                    EndpointHelper newHelper = new EndpointHelper();
                    newHelper.setEndpointClass(scannedHelper.getEndpointClass());
                    newHelper.setServerEndpointConfig(endpointConfig);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("will use programmatic endpoint of: " + endpoint), (Object[])new Object[0]);
                    }
                    returnHelpers.add(newHelper);
                }
            }
        }
        return returnHelpers;
    }
}

