/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsoc;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.wsoc.SendFuture;
import java.net.SocketTimeoutException;
import java.util.concurrent.ExecutionException;
import javax.websocket.SendHandler;
import javax.websocket.SendResult;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SendHandlerForFuture
implements SendHandler {
    private static final TraceComponent tc = Tr.register(SendHandlerForFuture.class);
    SendFuture future = null;
    static final long serialVersionUID = 3754630335940920744L;

    public void initialize(SendFuture fut) {
        this.future = fut;
    }

    public void onResult(SendResult result) {
        if (this.future == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"returning because we have no futurenot in right state to cancel", (Object[])new Object[0]);
            }
            return;
        }
        if (result.isOK()) {
            this.future.setStatus(SendFuture.FUTURE_STATUS.DONE);
        } else {
            Throwable t = result.getException();
            boolean changed = false;
            if (t instanceof SocketTimeoutException) {
                changed = this.future.changeStatus(SendFuture.FUTURE_STATUS.CANCEL_PENDING, SendFuture.FUTURE_STATUS.CANCELLED);
            }
            if (!changed) {
                ExecutionException ex = new ExecutionException(t);
                this.future.setStatus(SendFuture.FUTURE_STATUS.ERROR, ex);
            }
        }
        this.future.notifyAllNow();
    }
}

