/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsoc;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.wsoc.MessageWriter;
import com.ibm.ws.wsoc.OpcodeType;
import com.ibm.ws.wsoc.SendFuture;
import com.ibm.ws.wsoc.SendHandlerForFuture;
import com.ibm.ws.wsoc.ServiceManager;
import com.ibm.ws.wsoc.WsocConnLink;
import com.ibm.ws.wsoc.injection.InjectionThings;
import com.ibm.ws.wsoc.util.Utils;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.bytebuffer.WsByteBufferPoolManager;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import javax.websocket.SendHandler;
import javax.websocket.SendResult;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class RemoteEndpointAsyncImpl {
    WsByteBufferPoolManager wsbbManager = null;
    WsocConnLink connLink = null;
    long sendTimeoutMillis = 0L;
    int intSendTimeoutMillis = 0;
    static final long serialVersionUID = 7599700566277112870L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public void initialize(WsocConnLink _connLink) {
        this.connLink = _connLink;
        long timeout = this.connLink.getDefaultAsyncSendTimeout();
        this.setSendTimeout(timeout);
    }

    private WsByteBufferPoolManager getBufferManager() {
        return ServiceManager.getBufferPoolManager();
    }

    public long getSendTimeout() {
        return this.sendTimeoutMillis;
    }

    public void setSendTimeout(long timeoutMillis) {
        this.sendTimeoutMillis = timeoutMillis;
        this.intSendTimeoutMillis = Utils.longToInt(this.sendTimeoutMillis);
    }

    public void sendBinary(@Sensitive ByteBuffer data, SendHandler handler) {
        WsByteBuffer wsbb = this.getBufferManager().wrap(data);
        WsocConnLink.RETURN_STATUS ret = this.connLink.writeBuffer(wsbb, OpcodeType.BINARY_WHOLE, MessageWriter.WRITE_TYPE.ASYNC, handler, this.intSendTimeoutMillis, false, false);
        if (ret != WsocConnLink.RETURN_STATUS.OK) {
            this.sendHandlerError(handler);
        }
    }

    public SendFuture sendBinary(@Sensitive ByteBuffer data) {
        WsByteBuffer wsbb = this.getBufferManager().wrap(data);
        SendFuture fut = new SendFuture();
        fut.initialize(this.connLink, SendFuture.FUTURE_STATUS.STARTED);
        SendHandlerForFuture handler = new SendHandlerForFuture();
        handler.initialize(fut);
        WsocConnLink.RETURN_STATUS ret = this.connLink.writeBuffer(wsbb, OpcodeType.BINARY_WHOLE, MessageWriter.WRITE_TYPE.ASYNC, handler, this.intSendTimeoutMillis, false, false);
        if (ret != WsocConnLink.RETURN_STATUS.OK) {
            this.setFutureStatus(fut);
        }
        return fut;
    }

    public void sendObject(@Sensitive Object data, SendHandler handler) {
        WsocConnLink.RETURN_STATUS ret = this.connLink.writeObject(data, MessageWriter.WRITE_TYPE.ASYNC, handler);
        if (ret != WsocConnLink.RETURN_STATUS.OK) {
            this.sendHandlerError(handler);
        }
    }

    public SendFuture sendObject(@Sensitive Object data) {
        SendFuture fut = new SendFuture();
        fut.initialize(this.connLink, SendFuture.FUTURE_STATUS.STARTED);
        SendHandlerForFuture handler = new SendHandlerForFuture();
        handler.initialize(fut);
        WsocConnLink.RETURN_STATUS ret = this.connLink.writeObject(data, MessageWriter.WRITE_TYPE.ASYNC, handler);
        if (ret != WsocConnLink.RETURN_STATUS.OK) {
            this.setFutureStatus(fut);
        }
        return fut;
    }

    public void sendText(@Sensitive String textToSend, SendHandler handler) {
        byte[] ba = textToSend.getBytes(Utils.UTF8_CHARSET);
        WsByteBuffer wsbb = this.getBufferManager().allocate(ba.length);
        wsbb.put(ba);
        wsbb.position(0);
        wsbb.limit(ba.length);
        WsocConnLink.RETURN_STATUS ret = this.connLink.writeBuffer(wsbb, OpcodeType.TEXT_WHOLE, MessageWriter.WRITE_TYPE.ASYNC, handler, this.intSendTimeoutMillis, false, false);
        if (ret != WsocConnLink.RETURN_STATUS.OK) {
            this.sendHandlerError(handler);
        }
    }

    public SendFuture sendText(@Sensitive String textToSend) {
        byte[] ba = textToSend.getBytes(Utils.UTF8_CHARSET);
        SendFuture fut = new SendFuture();
        fut.initialize(this.connLink, SendFuture.FUTURE_STATUS.STARTED);
        SendHandlerForFuture handler = new SendHandlerForFuture();
        handler.initialize(fut);
        WsByteBuffer wsbb = this.getBufferManager().allocate(ba.length);
        wsbb.put(ba);
        wsbb.position(0);
        wsbb.limit(ba.length);
        WsocConnLink.RETURN_STATUS ret = this.connLink.writeBuffer(wsbb, OpcodeType.TEXT_WHOLE, MessageWriter.WRITE_TYPE.ASYNC, handler, this.intSendTimeoutMillis, false, false);
        if (ret != WsocConnLink.RETURN_STATUS.OK) {
            this.setFutureStatus(fut);
        }
        return fut;
    }

    private void setFutureStatus(SendFuture fut) {
        IllegalStateException ise = new IllegalStateException("write not allowed.  Most likely cause is that another Write or Close is in progress");
        ExecutionException ex = new ExecutionException(ise);
        fut.setStatus(SendFuture.FUTURE_STATUS.DONE, ex);
    }

    private void sendHandlerError(SendHandler handler) {
        ExecutorService es = ServiceManager.getExecutorThreadService();
        if (es != null) {
            IOException ioe = new IOException("write not allowed.  Most likely cause is that another Write or Close is in progress");
            SendResult sr = new SendResult((Throwable)ioe);
            HandlerCallback hc = new HandlerCallback(handler, sr, this.connLink);
            es.execute(hc);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(RemoteEndpointAsyncImpl.class);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private class HandlerCallback
    implements Runnable {
        protected SendHandler handler;
        protected SendResult result;
        protected WsocConnLink connLink = null;
        protected InjectionThings it = null;
        static final long serialVersionUID = 1949448843135913179L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        protected HandlerCallback(SendHandler handlerInput, SendResult resultInput, WsocConnLink inConnLink) {
            this.handler = handlerInput;
            this.result = resultInput;
            this.connLink = inConnLink;
        }

        @Override
        public void run() {
            this.it = this.connLink.pushContexts();
            try {
                this.handler.onResult(this.result);
            }
            finally {
                this.connLink.popContexts(this.it);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(HandlerCallback.class);
        }
    }
}

