/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bluemix.utility.cloudfoundry;

import com.ibm.ws.bluemix.utility.cloudfoundry.CloudFoundryService;
import com.ibm.ws.bluemix.utility.cloudfoundry.CloudFoundryServiceInstance;
import com.ibm.ws.bluemix.utility.cloudfoundry.CloudFoundryServiceKey;
import com.ibm.ws.bluemix.utility.cloudfoundry.CloudFoundryServicePlan;
import com.ibm.ws.bluemix.utility.cloudfoundry.OauthToken;
import com.ibm.ws.bluemix.utility.utils.JsonUtils;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Locale;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonStructure;

public class ObjectMapping {
    public static OauthToken toOauthToken(JsonObject resource) {
        String token = resource.getString("access_token");
        String type = resource.getString("token_type");
        String refresh = resource.getString("refresh_token");
        return new OauthToken(type, token, refresh);
    }

    public static CloudFoundryService toCloudFoundryService(JsonObject resource) {
        String guid = ObjectMapping.getMetadataGuid(resource);
        JsonObject entity = resource.getJsonObject("entity");
        String label = entity.getString("label");
        String description = entity.getString("description");
        String documentationUrl = null;
        JsonObject extraJsonObject = ObjectMapping.getExtra(entity);
        if (extraJsonObject != null) {
            documentationUrl = JsonUtils.getString(extraJsonObject, "documentationUrl");
            String localizedDescription = ObjectMapping.getLocalizedDescription(extraJsonObject);
            if (localizedDescription != null) {
                description = localizedDescription;
            }
        }
        ArrayList<CloudFoundryServicePlan> servicePlans = null;
        JsonArray planResources = entity.getJsonArray("service_plans");
        if (planResources != null) {
            servicePlans = new ArrayList<CloudFoundryServicePlan>();
            for (int i = 0; i < planResources.size(); ++i) {
                JsonObject planResource = planResources.getJsonObject(i);
                CloudFoundryServicePlan plan = ObjectMapping.toCloudFoundryServicePlan(planResource);
                servicePlans.add(plan);
            }
        }
        CloudFoundryService service = new CloudFoundryService();
        service.setLabel(label);
        service.setGuid(guid);
        service.setDescription(description);
        service.setDocumentationUrl(documentationUrl);
        service.setServicePlans(servicePlans);
        return service;
    }

    private static JsonObject getExtra(JsonObject entity) {
        JsonStructure jsonValue;
        String json = JsonUtils.getString(entity, "extra");
        if (json == null) {
            return null;
        }
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(json));
        try {
            jsonValue = jsonReader.read();
        }
        catch (JsonException e) {
            return null;
        }
        if (jsonValue instanceof JsonObject) {
            return (JsonObject)jsonValue;
        }
        return null;
    }

    private static String getLocalizedDescription(JsonObject extraJsonObject) {
        String description;
        Locale locale;
        JsonObject languageJsonObject;
        JsonObject i18nJsonObject = JsonUtils.getJsonObject(extraJsonObject, "i18n");
        if (i18nJsonObject != null && (languageJsonObject = JsonUtils.getJsonObject(i18nJsonObject, (locale = Locale.getDefault()).getLanguage())) != null && (description = JsonUtils.getString(languageJsonObject, "description")) != null) {
            return description;
        }
        return null;
    }

    public static CloudFoundryServiceInstance toCloudFoundryServiceInstance(JsonObject resource) {
        String guid = ObjectMapping.getMetadataGuid(resource);
        JsonObject entity = resource.getJsonObject("entity");
        String name = entity.getString("name");
        CloudFoundryServicePlan servicePlan = null;
        JsonObject planResource = entity.getJsonObject("service_plan");
        if (planResource != null) {
            servicePlan = ObjectMapping.toCloudFoundryServicePlan(planResource);
        }
        ArrayList<CloudFoundryServiceKey> serviceKeys = null;
        JsonArray keyResources = entity.getJsonArray("service_keys");
        if (keyResources != null) {
            serviceKeys = new ArrayList<CloudFoundryServiceKey>();
            for (int i = 0; i < keyResources.size(); ++i) {
                JsonObject keyResource = keyResources.getJsonObject(i);
                CloudFoundryServiceKey serviceKey = ObjectMapping.toCloudFoundryServiceKey(keyResource);
                serviceKeys.add(serviceKey);
            }
        }
        CloudFoundryServiceInstance service = new CloudFoundryServiceInstance();
        service.setName(name);
        service.setGuid(guid);
        service.setPlan(servicePlan);
        service.setKeys(serviceKeys);
        return service;
    }

    public static CloudFoundryServicePlan toCloudFoundryServicePlan(JsonObject resource) {
        String guid = ObjectMapping.getMetadataGuid(resource);
        JsonObject entity = resource.getJsonObject("entity");
        String name = entity.getString("name");
        String description = entity.getString("description");
        String serviceGuid = entity.getString("service_guid");
        CloudFoundryServicePlan plan = new CloudFoundryServicePlan();
        plan.setDescription(description);
        plan.setName(name);
        plan.setServiceGuid(serviceGuid);
        plan.setGuid(guid);
        return plan;
    }

    public static CloudFoundryServiceKey toCloudFoundryServiceKey(JsonObject resource) {
        String guid = ObjectMapping.getMetadataGuid(resource);
        JsonObject entity = resource.getJsonObject("entity");
        String name = entity.getString("name");
        JsonObject credentials = entity.getJsonObject("credentials");
        CloudFoundryServiceKey key = new CloudFoundryServiceKey();
        key.setName(name);
        key.setCredentials(JsonUtils.jsonObjectToMap(credentials));
        key.setGuid(guid);
        return key;
    }

    private static String getMetadataGuid(JsonObject resource) {
        JsonObject metadata = resource.getJsonObject("metadata");
        String guid = metadata.getString("guid");
        return guid;
    }
}

