/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bluemix.utility.api;

import com.ibm.ws.bluemix.utility.api.ConfigurationServiceException;
import com.ibm.ws.bluemix.utility.api.ServiceConfiguration;
import com.ibm.ws.bluemix.utility.cloudfoundry.CloudFoundryServiceInstance;
import com.ibm.ws.bluemix.utility.cloudfoundry.CloudFoundryServiceKey;
import com.ibm.ws.bluemix.utility.credentials.TargetInfo;
import com.ibm.ws.bluemix.utility.utils.HttpRequest;
import com.ibm.ws.bluemix.utility.utils.HttpRequestBuilder;
import com.ibm.ws.bluemix.utility.utils.JsonUtils;
import com.ibm.ws.bluemix.utility.utils.NLS;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;

public class ConfigurationServiceClient {
    private static final Logger logger = Logger.getLogger(ConfigurationServiceClient.class.getName());
    private static final String CAAS_YP = "https://wlpcfg.ng.bluemix.net/";
    private final String caasURL;
    private final String apiEndpoint;
    private int connectionTimeout = 30000;
    private int readTimeout = 90000;

    private ConfigurationServiceClient(String caasURL, String apiEndpoint) {
        this.caasURL = caasURL;
        if (caasURL == null) {
            throw new NullPointerException("caasURL is null");
        }
        this.apiEndpoint = apiEndpoint;
    }

    public static ConfigurationServiceClient getConfigurationServiceClient(String caasURL) {
        return new ConfigurationServiceClient(caasURL, null);
    }

    public static ConfigurationServiceClient getConfigurationServiceClient(String caasURL, TargetInfo target) {
        String apiEndpoint = target.getAPI();
        if (caasURL == null) {
            Map<String, String> map = ConfigurationServiceClient.getConfigurationServiceMap();
            caasURL = map.get(apiEndpoint);
            if (caasURL == null) {
                caasURL = ConfigurationServiceClient.detectConfigurationService(apiEndpoint);
            } else {
                apiEndpoint = null;
            }
        }
        logger.log(Level.FINE, "Using configuration service at {0} for {1}.", new Object[]{caasURL, apiEndpoint});
        return new ConfigurationServiceClient(caasURL, apiEndpoint);
    }

    private static String detectConfigurationService(String apiEndpoint) {
        logger.log(Level.FINE, "Trying to detect configuration service for {0}.", new Object[]{apiEndpoint});
        String caasURL = null;
        if (apiEndpoint.startsWith("https://api.")) {
            caasURL = "https://wlpcfg." + apiEndpoint.substring(12);
        } else if (apiEndpoint.startsWith("http://api.")) {
            caasURL = "https://wlpcfg." + apiEndpoint.substring(11);
        } else {
            logger.log(Level.FINE, "Cannot guess the configuration service address from {0}. Will use the default configuration service.", new Object[]{apiEndpoint});
            return CAAS_YP;
        }
        logger.log(Level.FINE, "Trying {0} address.", new Object[]{caasURL});
        ConfigurationServiceClient caas = new ConfigurationServiceClient(caasURL, apiEndpoint);
        caas.setConnectionTimeout(15000);
        caas.setReadTimeout(45000);
        try {
            Map<String, Object> info = caas.getInfo();
            if ("wlpcfg".equals(info.get("name"))) {
                logger.log(Level.FINE, "Configuration service detected at {0}.", new Object[]{caasURL});
                return caasURL;
            }
            logger.log(Level.FINE, "Unexpected response from {0}. Will use the default configuration service.", new Object[]{caasURL});
        }
        catch (Exception e) {
            logger.log(Level.FINE, "Error connecting to {0}. Will use the default configuration service.", new Object[]{caasURL});
        }
        return CAAS_YP;
    }

    private static Map<String, String> getConfigurationServiceMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("https://api.ng.bluemix.net", CAAS_YP);
        map.put("https://api.eu-gb.bluemix.net", "https://wlpcfg.eu-gb.bluemix.net/");
        map.put("https://api.au-syd.bluemix.net", "https://wlpcfg.au-syd.bluemix.net/");
        return map;
    }

    private static String getUrl(String api, String path) {
        if (api.endsWith("/")) {
            return api + path.substring(1);
        }
        return api + path;
    }

    private URL getUrl(String path) throws ConfigurationServiceException {
        try {
            return new URL(ConfigurationServiceClient.getUrl(this.caasURL, path));
        }
        catch (MalformedURLException e) {
            throw new ConfigurationServiceException(NLS.getMessage("CAAS_UNEXPECTED_ERROR", e.getMessage()), e);
        }
    }

    public ServiceConfiguration importConfiguration(CloudFoundryServiceInstance service) throws ConfigurationServiceException {
        return this.importConfiguration(service, null, null);
    }

    public ServiceConfiguration importConfiguration(CloudFoundryServiceInstance service, String serviceKeyName, Map<String, String> parameters) throws ConfigurationServiceException {
        this.validate(service, serviceKeyName);
        JsonArray jsonArrayRequest = this.toJsonArray(service, serviceKeyName, parameters);
        String jsonPayload = JsonUtils.serialize((JsonStructure)jsonArrayRequest);
        URL uri = this.getUrl("/api/v1/config/liberty/generate");
        HttpRequestBuilder requestBuilder = this.createHttpRequestBuilder(uri);
        requestBuilder.setRequestMethod("POST");
        requestBuilder.setHeader("Content-Type", "application/json");
        requestBuilder.setMessageBody(jsonPayload);
        String json = null;
        try {
            HttpRequest request = requestBuilder.build();
            int responseCode = request.getResponseCode();
            if (responseCode != 200) {
                throw this.handleError(request, "CAAS_GENERATE_ERROR");
            }
            json = request.getResponseBody();
        }
        catch (IOException e) {
            throw this.handleIOException(e, uri);
        }
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(json));
        JsonArray jsonArrayResponse = jsonReader.readArray();
        List<ServiceConfiguration> configs = this.toServiceConfigurations(jsonArrayResponse);
        return configs.get(0);
    }

    private void validate(CloudFoundryServiceInstance service, String keyName) {
        String serviceName = service.getName();
        List<CloudFoundryServiceKey> keys = service.getServiceKeys();
        if (keys == null || keys.isEmpty()) {
            throw new IllegalArgumentException(NLS.getMessage("NO_SERVICE_KEY", serviceName));
        }
        CloudFoundryServiceKey key = this.findServiceKey(keys, keyName);
        if (key == null) {
            throw new IllegalArgumentException(NLS.getMessage("NO_SUCH_SERVICE_KEY", keyName));
        }
    }

    private CloudFoundryServiceKey findServiceKey(List<CloudFoundryServiceKey> keys, String keyName) {
        if (keyName == null) {
            return keys.get(0);
        }
        for (CloudFoundryServiceKey key : keys) {
            if (!keyName.equals(key.getName())) continue;
            return key;
        }
        return null;
    }

    private List<ServiceConfiguration> toServiceConfigurations(JsonArray jsonArray) {
        ArrayList<ServiceConfiguration> configs = new ArrayList<ServiceConfiguration>();
        if (jsonArray != null) {
            for (JsonValue jsonValue : jsonArray) {
                if (!(jsonValue instanceof JsonObject)) continue;
                JsonObject jsonItemObject = (JsonObject)jsonValue;
                ServiceConfiguration config = this.toServiceConfiguration(jsonItemObject);
                configs.add(config);
            }
        }
        return configs;
    }

    private ServiceConfiguration toServiceConfiguration(JsonObject jsonObject) {
        JsonArray jsonLicenses;
        String name = JsonUtils.getString(jsonObject, "name");
        ServiceConfiguration config = new ServiceConfiguration(name);
        JsonObject jsonServiceXml = JsonUtils.getJsonObject(jsonObject, "serviceXml");
        if (jsonServiceXml != null) {
            config.setServiceXml(this.toConfigElement(jsonServiceXml));
        }
        String instructions = JsonUtils.getString(jsonObject, "instructions");
        config.setInstructions(instructions);
        JsonArray jsonLibraries = JsonUtils.getJsonArray(jsonObject, "libraries");
        if (jsonLibraries != null) {
            ArrayList<ServiceConfiguration.Library> libraries = new ArrayList<ServiceConfiguration.Library>();
            for (JsonValue jsonValue : jsonLibraries) {
                if (!(jsonValue instanceof JsonObject)) continue;
                JsonObject jsonItemObject = (JsonObject)jsonValue;
                libraries.add(this.toLibrary(jsonItemObject));
            }
            config.setLibraries(libraries);
        }
        if ((jsonLicenses = JsonUtils.getJsonArray(jsonObject, "licenses")) != null) {
            ArrayList<ServiceConfiguration.License> licenses = new ArrayList<ServiceConfiguration.License>();
            for (JsonValue jsonValue : jsonLicenses) {
                if (!(jsonValue instanceof JsonObject)) continue;
                JsonObject jsonItemObject = (JsonObject)jsonValue;
                licenses.add(this.toLicense(jsonItemObject));
            }
            config.setLicenses(licenses);
        }
        return config;
    }

    private ServiceConfiguration.Library toLibrary(JsonObject jsonObject) {
        String url = JsonUtils.getString(jsonObject, "url");
        if (url.startsWith("/")) {
            url = ConfigurationServiceClient.getUrl(this.caasURL, url);
        }
        ServiceConfiguration.Library library = new ServiceConfiguration.Library(url);
        String targetPath = JsonUtils.getString(jsonObject, "targetPath");
        library.setTargetPath(targetPath);
        String license = JsonUtils.getString(jsonObject, "license");
        library.setLicense(license);
        String credentials = JsonUtils.getString(jsonObject, "credentials");
        library.setCredentials(credentials);
        String displayUrl = JsonUtils.getString(jsonObject, "displayUrl");
        if (displayUrl != null && displayUrl.startsWith("/")) {
            displayUrl = ConfigurationServiceClient.getUrl(this.caasURL, displayUrl);
        }
        library.setDisplayUrl(displayUrl);
        return library;
    }

    private ServiceConfiguration.License toLicense(JsonObject jsonObject) {
        String name = JsonUtils.getString(jsonObject, "name");
        ServiceConfiguration.License license = new ServiceConfiguration.License(name);
        String url = JsonUtils.getString(jsonObject, "url");
        license.setUrl(url);
        return license;
    }

    private ServiceConfiguration.ConfigElement toConfigElement(JsonObject jsonObject) {
        JsonArray children;
        String name = JsonUtils.getString(jsonObject, "name");
        ServiceConfiguration.ConfigElement configElement = new ServiceConfiguration.ConfigElement(name);
        String value = JsonUtils.getString(jsonObject, "value");
        configElement.setValue(value);
        JsonObject attributes = JsonUtils.getJsonObject(jsonObject, "attributes");
        if (attributes != null) {
            for (Map.Entry entry : attributes.entrySet()) {
                String key = (String)entry.getKey();
                JsonValue jsonValue = (JsonValue)entry.getValue();
                if (!(jsonValue instanceof JsonString)) continue;
                configElement.setAttribute(key, ((JsonString)jsonValue).getString());
            }
        }
        if ((children = JsonUtils.getJsonArray(jsonObject, "children")) != null) {
            for (JsonValue jsonValue : children) {
                if (!(jsonValue instanceof JsonObject)) continue;
                ServiceConfiguration.ConfigElement child = this.toConfigElement((JsonObject)jsonValue);
                configElement.addChild(child);
            }
        }
        return configElement;
    }

    private JsonArray toJsonArray(CloudFoundryServiceInstance service, String keyName, Map<String, String> parameters) {
        JsonArrayBuilder builder = Json.createArrayBuilder();
        builder.add((JsonValue)this.toJson(service, keyName, parameters));
        return builder.build();
    }

    private JsonObject toJson(CloudFoundryServiceInstance service, String keyName, Map<String, String> parameters) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("name", service.getName());
        builder.add("type", service.getService().getLabel());
        CloudFoundryServiceKey serviceKey = this.findServiceKey(service.getServiceKeys(), keyName);
        builder.add("credentials", (JsonValue)JsonUtils.mapToJsonObject(serviceKey.getCredentials()));
        if (parameters != null) {
            JsonObject jsonParameters = JsonUtils.mapToJsonObject(parameters);
            builder.add("parameters", (JsonValue)jsonParameters);
        }
        return builder.build();
    }

    public Set<String> getSupportedServices() throws ConfigurationServiceException {
        URL uri = this.getUrl("/api/v1/config/liberty/services");
        HttpRequestBuilder requestBuilder = this.createHttpRequestBuilder(uri);
        requestBuilder.setRequestMethod("GET");
        String json = null;
        try {
            HttpRequest request = requestBuilder.build();
            int responseCode = request.getResponseCode();
            if (responseCode != 200) {
                throw this.handleError(request, "CAAS_SERVICES_ERROR");
            }
            json = request.getResponseBody();
        }
        catch (IOException e) {
            throw this.handleIOException(e, uri);
        }
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(json));
        JsonArray jsonArrayResponse = jsonReader.readArray();
        HashSet<String> suppServices = new HashSet<String>();
        for (int i = 0; i < jsonArrayResponse.size(); ++i) {
            suppServices.add(jsonArrayResponse.getString(i));
        }
        return suppServices;
    }

    public Map<String, Object> getInfo() throws ConfigurationServiceException {
        URL uri = this.getUrl("/api/v1/info");
        HttpRequestBuilder requestBuilder = this.createHttpRequestBuilder(uri);
        requestBuilder.setRequestMethod("GET");
        String json = null;
        try {
            HttpRequest request = requestBuilder.build();
            int responseCode = request.getResponseCode();
            if (responseCode != 200) {
                throw this.handleError(request, "CAAS_SERVICES_ERROR");
            }
            json = request.getResponseBody();
        }
        catch (IOException e) {
            throw this.handleIOException(e, uri);
        }
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(json));
        JsonObject jsonObject = jsonReader.readObject();
        return JsonUtils.jsonObjectToMap(jsonObject);
    }

    private void setConnectionTimeout(int timeout) {
        this.connectionTimeout = timeout;
    }

    private void setReadTimeout(int timeout) {
        this.readTimeout = timeout;
    }

    private HttpRequestBuilder createHttpRequestBuilder(URL uri) {
        HttpRequestBuilder requestBuilder = new HttpRequestBuilder();
        requestBuilder.setURL(uri);
        requestBuilder.setConnectionTimeout(this.connectionTimeout);
        requestBuilder.setReadTimeout(this.readTimeout);
        requestBuilder.setUserAgent();
        requestBuilder.setHeader("Accept", "application/json");
        if (this.apiEndpoint != null) {
            requestBuilder.setHeader("X-Bluemix-Api", this.apiEndpoint);
        }
        requestBuilder.setAcceptLanguageHeader();
        return requestBuilder;
    }

    private Map<String, Object> parseErrorDetails(HttpRequest request) {
        if (request.isJsonContentType()) {
            try {
                String json = request.getErrorResponseBody();
                if (json != null) {
                    JsonObject jsonObject = JsonUtils.deserialize(json);
                    return JsonUtils.jsonObjectToMap(jsonObject);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private ConfigurationServiceException handleError(HttpRequest request, String errorKey) throws IOException {
        Map<String, Object> errorDetails = this.parseErrorDetails(request);
        String message = null;
        message = errorDetails == null ? request.getResponseMessage() : (String)errorDetails.get("description");
        ConfigurationServiceException exception = new ConfigurationServiceException(NLS.getMessage(errorKey, message));
        exception.setHttpStatus(request.getHttpStatus());
        return exception;
    }

    private ConfigurationServiceException handleIOException(Exception e, URL url) {
        if (e instanceof UnknownHostException) {
            return new ConfigurationServiceException(NLS.getMessage("CAAS_UNKNOWN_HOST_ERROR", e.getMessage()), e);
        }
        if (e instanceof ConnectException) {
            return new ConfigurationServiceException(NLS.getMessage("CAAS_CONNECT_ERROR", e.getMessage()), e);
        }
        if (e instanceof SocketTimeoutException) {
            return new ConfigurationServiceException(NLS.getMessage("CAAS_TIMEOUT_ERROR", e.getMessage()), e);
        }
        if (e instanceof NoRouteToHostException) {
            return new ConfigurationServiceException(NLS.getMessage("CAAS_NO_ROUTE_ERROR", e.getMessage()), e);
        }
        return new ConfigurationServiceException(NLS.getMessage("CAAS_UNEXPECTED_ERROR", e.getMessage()), e);
    }
}

