/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bluemix.utility;

import com.ibm.ws.bluemix.utility.BluemixUtilityAction;
import com.ibm.ws.bluemix.utility.TaskErrorException;
import com.ibm.ws.bluemix.utility.actions.BindServiceAction;
import com.ibm.ws.bluemix.utility.actions.CreateServiceAction;
import com.ibm.ws.bluemix.utility.actions.DeleteServiceAction;
import com.ibm.ws.bluemix.utility.actions.HelpAction;
import com.ibm.ws.bluemix.utility.actions.ImportServiceAction;
import com.ibm.ws.bluemix.utility.actions.InfoAction;
import com.ibm.ws.bluemix.utility.actions.ListImportsAction;
import com.ibm.ws.bluemix.utility.actions.ListServicesAction;
import com.ibm.ws.bluemix.utility.actions.LoginAction;
import com.ibm.ws.bluemix.utility.actions.LogoutAction;
import com.ibm.ws.bluemix.utility.actions.MarketplaceAction;
import com.ibm.ws.bluemix.utility.actions.ShowImportAction;
import com.ibm.ws.bluemix.utility.actions.ShowServiceAction;
import com.ibm.ws.bluemix.utility.actions.SwitchAction;
import com.ibm.ws.bluemix.utility.actions.UnbindServiceAction;
import com.ibm.ws.bluemix.utility.api.ConfigurationServiceException;
import com.ibm.ws.bluemix.utility.api.ServiceConfigurationException;
import com.ibm.ws.bluemix.utility.cloudfoundry.CloudFoundryException;
import com.ibm.ws.bluemix.utility.cloudfoundry.CloudFoundryLoginException;
import com.ibm.ws.bluemix.utility.utils.ConsoleWrapper;
import com.ibm.ws.bluemix.utility.utils.NLS;
import com.ibm.ws.bluemix.utility.utils.ReturnCode;
import com.ibm.ws.install.InstallException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BluemixUtility {
    private static final Logger logger = Logger.getLogger(BluemixUtility.class.getName());
    private final ConsoleWrapper stdin;
    private final PrintStream stdout;
    private final PrintStream stderr;
    private final Map<String, BluemixUtilityAction> actions = new LinkedHashMap<String, BluemixUtilityAction>();

    public BluemixUtility(ConsoleWrapper stdin, PrintStream stdout, PrintStream stderr) {
        this.stdin = stdin;
        this.stdout = stdout;
        this.stderr = stderr;
    }

    void registerAction(BluemixUtilityAction action) {
        String actionName = action.getActionName();
        if (this.actions.get(actionName) != null) {
            throw new IllegalArgumentException();
        }
        this.actions.put(actionName, action);
    }

    public BluemixUtilityAction getAction(String actionName) {
        BluemixUtilityAction action = this.actions.get(actionName);
        return action;
    }

    public Collection<BluemixUtilityAction> getActions() {
        return this.actions.values();
    }

    int runProgram(String[] args) {
        ReturnCode rc;
        if (this.stdin == null) {
            this.stderr.println(NLS.getOption("error.missingIO", "stdin"));
            return 254;
        }
        if (this.stdout == null) {
            this.stderr.println(NLS.getOption("error.missingIO", "stdout"));
            return 253;
        }
        if (this.stderr == null) {
            this.stdout.println(NLS.getOption("error.missingIO", "stderr"));
            return 252;
        }
        HelpAction helpAction = new HelpAction(this);
        this.registerAction(helpAction);
        if (args.length == 0) {
            this.stdout.println(helpAction.getScriptUsage());
            return 0;
        }
        BluemixUtilityAction action = this.getAction(args[0]);
        if (action == null) {
            if (args[0].equalsIgnoreCase("--help")) {
                this.stdout.println(helpAction.getHelpOptions());
                return 0;
            }
            this.stderr.println(NLS.getOption("task.unknown", args[0]));
            this.stderr.println(helpAction.getScriptUsage());
            return ReturnCode.BAD_ARGUMENT.getValue();
        }
        try {
            rc = action.handleAction(this.stdin, this.stdout, this.stderr, args);
        }
        catch (IllegalArgumentException e) {
            this.printError(e);
            rc = ReturnCode.BAD_ARGUMENT;
        }
        catch (CloudFoundryLoginException e) {
            this.printError(e);
            rc = ReturnCode.CF_AUTH_ERROR;
        }
        catch (CloudFoundryException e) {
            this.printError(e);
            rc = ReturnCode.CF_ERROR;
        }
        catch (ConfigurationServiceException e) {
            this.printError(e);
            rc = ReturnCode.CAAS_ERROR;
        }
        catch (ServiceConfigurationException e) {
            this.printError(e);
            rc = ReturnCode.SERVICE_CONFIGURATION_ERROR;
        }
        catch (InstallException e) {
            this.printError(e);
            rc = ReturnCode.INSTALL_FEATURE_ERROR;
        }
        catch (TaskErrorException e) {
            this.printError(e);
            rc = e.getReturnCode();
        }
        catch (RuntimeException e) {
            this.printUnknownError(action, e);
            rc = ReturnCode.RUNTIME_EXCEPTION;
        }
        catch (Throwable e) {
            this.printUnknownError(action, e);
            rc = ReturnCode.UNKNOWN_EXCEPTION;
        }
        return rc.getValue();
    }

    private void printError(Throwable e) {
        String message = e.getMessage() == null ? e.toString() : e.getMessage();
        this.stderr.println(NLS.getOption("error", message));
        logger.log(Level.FINE, "Action generated exception", e);
    }

    private void printUnknownError(BluemixUtilityAction action, Throwable e) {
        this.stderr.println(NLS.getOption("error.unknownException", action.getActionName(), e.toString()));
        e.printStackTrace(this.stderr);
        logger.log(Level.FINE, "Action generated unknown exception", e);
    }

    public static void main(String[] args) {
        ConsoleWrapper console = new ConsoleWrapper(System.console(), System.err);
        BluemixUtility utility = new BluemixUtility(console, System.out, System.err);
        utility.registerAction(new LoginAction());
        utility.registerAction(new MarketplaceAction());
        utility.registerAction(new CreateServiceAction());
        utility.registerAction(new ListServicesAction());
        utility.registerAction(new ShowServiceAction());
        utility.registerAction(new ImportServiceAction());
        utility.registerAction(new ListImportsAction());
        utility.registerAction(new ShowImportAction());
        utility.registerAction(new BindServiceAction());
        utility.registerAction(new UnbindServiceAction());
        utility.registerAction(new DeleteServiceAction());
        utility.registerAction(new SwitchAction());
        utility.registerAction(new InfoAction());
        utility.registerAction(new LogoutAction());
        int rc = utility.runProgram(args);
        System.exit(rc);
    }
}

