/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.internal.hpel;

import com.ibm.ejs.ras.hpel.HpelHelper;
import com.ibm.websphere.logging.WsLevel;
import com.ibm.websphere.logging.hpel.reader.HpelFormatter;
import com.ibm.ws.logging.internal.hpel.HpelHeader;
import com.ibm.ws.logging.internal.impl.LogProviderConfigImpl;
import com.ibm.ws.logging.internal.impl.LoggingConfigUtils;
import com.ibm.wsspi.logging.TextFileOutputStreamFactory;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;

public class HpelTraceServiceConfig
extends LogProviderConfigImpl {
    private static final long MILLIS_IN_HOURS = 3600000L;
    private static final long ONE_MEG = 0x100000L;
    protected final String ivServerName;
    protected final LogState ivLog = new LogState("log.");
    protected final TraceState ivTrace = new TraceState("trace.");
    private static String pid = null;

    public static String getPid() {
        if (pid == null) {
            int index;
            String runtimeName = ManagementFactory.getRuntimeMXBean().getName();
            pid = runtimeName == null ? "unknown" : ((index = runtimeName.indexOf(64)) < 0 ? runtimeName : runtimeName.substring(0, index));
        }
        return pid;
    }

    private static void setupHpel(Map<String, String> config) {
        HpelHelper.setPid(HpelTraceServiceConfig.getPid());
        HpelFormatter.addCustomLevel(WsLevel.FATAL, "F");
        HpelFormatter.addCustomLevel(WsLevel.AUDIT, "A");
        HpelFormatter.addCustomLevel(WsLevel.DETAIL, "D");
        HpelHelper.setCustomHeaderFormat(HpelHeader.getLibertyRuntimeHeader());
        final Properties result = new Properties();
        result.put("Version", config.get("websphere.product.info"));
        result.put("ServerName", config.get("wlp.server.name"));
        result.put("ProcessId", HpelHelper.getProcessId());
        result.put("ServerTimeZone", TimeZone.getDefault().getID());
        result.put("ServerLocaleLanguageCode", Locale.getDefault().getLanguage());
        result.put("ServerLocaleCountryCode", Locale.getDefault().getCountry());
        HpelTraceServiceConfig.addIfPresent(result, config, "java.fullversion");
        HpelTraceServiceConfig.addIfPresent(result, config, "java.version");
        HpelTraceServiceConfig.addIfPresent(result, config, "os.name");
        HpelTraceServiceConfig.addIfPresent(result, config, "os.version");
        HpelTraceServiceConfig.addIfPresent(result, config, "java.compiler");
        HpelTraceServiceConfig.addIfPresent(result, config, "java.vm.name");
        HpelTraceServiceConfig.addIfPresent(result, config, "was.install.root");
        HpelTraceServiceConfig.addIfPresent(result, config, "user.install.root");
        HpelTraceServiceConfig.addIfPresent(result, config, "java.home");
        HpelTraceServiceConfig.addIfPresent(result, config, "ws.ext.dirs");
        HpelTraceServiceConfig.addIfPresent(result, config, "java.class.path");
        HpelTraceServiceConfig.addIfPresent(result, config, "java.library.path");
        HpelTraceServiceConfig.addIfPresent(result, config, "sun.management.compiler");
        HpelTraceServiceConfig.addIfPresent(result, config, "os.arch");
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws UnknownHostException {
                    InetAddress localHost = InetAddress.getLocalHost();
                    result.put("HostName", localHost.getHostName());
                    result.put("HostAddress", localHost.getHostAddress());
                    String type = "";
                    if (localHost instanceof Inet4Address) {
                        type = "IPV4";
                    } else if (localHost instanceof Inet6Address) {
                        type = "IPV6";
                    }
                    result.put("HostType", type);
                    return null;
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        result.put("isServer", "Y");
        HpelHelper.setCustomHeaderProperties(result);
    }

    private static void addIfPresent(Properties result, Map<String, String> config, String key) {
        String value = config.get(key);
        if (value != null) {
            result.put(key, value);
        }
    }

    public HpelTraceServiceConfig(Map<String, String> config, File logLocation, TextFileOutputStreamFactory factory) {
        super(config, logLocation, factory);
        HpelTraceServiceConfig.setupHpel(config);
        this.ivServerName = config.get("wlp.server.name");
        if (this.ivServerName == null) {
            throw new RuntimeException("Boot parameters are missing required 'wlp.server.name' attribute.");
        }
        this.ivLog.readState("com.ibm.hpel.", config);
        this.ivTrace.readState("com.ibm.hpel.", config);
    }

    public synchronized void update(Map<String, Object> config) {
        super.update(config);
        this.ivLog.updateLoggingAttributes();
        this.ivTrace.updateLoggingAttributes();
    }

    public synchronized void updateLog(Map<String, Object> config) {
        this.ivLog.readState(null, config);
    }

    public synchronized void updateTrace(Map<String, Object> config) {
        this.ivTrace.readState(null, config);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(((Object)((Object)this)).getClass().getSimpleName());
        sb.append("[");
        this.ivLog.writeState(sb);
        sb.append(",");
        this.ivTrace.writeState(sb);
        sb.append("]");
        return sb.toString();
    }

    private int getLongValue(Object obj, int defaultValue) {
        if (obj instanceof String) {
            try {
                return Integer.parseInt((String)obj);
            }
            catch (NumberFormatException numberFormatException) {
            }
        } else if (obj instanceof Long) {
            try {
                return ((Long)obj).intValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    protected class TraceState
    extends LogState {
        int ivMemoryBufferSize;

        TraceState(String prefix) {
            super(prefix);
            this.ivMemoryBufferSize = -1;
            this.ivOutOfSpaceAction = OutOfSpaceAction.PurgeOld;
        }

        @Override
        public TraceState clone() {
            return (TraceState)super.clone();
        }

        @Override
        public File getLocation() {
            return new File(this.ivDataDirectory, "tracedata");
        }

        public long getMemoryBufferSize() {
            return this.ivMemoryBufferSize < 0 ? -1L : (long)this.ivMemoryBufferSize * 0x100000L;
        }

        @Override
        public void readState(String prefix, Map<String, ?> config) {
            super.readState(prefix, config);
            prefix = prefix == null ? "" : prefix + this.prefix;
            Object obj = config.get(prefix + "memoryBufferSize");
            this.ivMemoryBufferSize = LoggingConfigUtils.getIntValue(obj, (int)this.ivMemoryBufferSize);
        }

        @Override
        public void writeState(StringBuilder sb) {
            super.writeState(sb);
            sb.append(",");
            sb.append(this.prefix).append("memoryBufferSize").append("=").append(Integer.toString(this.ivMemoryBufferSize));
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + ((Object)((Object)this.getOuterType())).hashCode();
            result = 31 * result + this.ivMemoryBufferSize;
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (!(obj instanceof TraceState)) {
                return false;
            }
            TraceState other = (TraceState)obj;
            if (!((Object)((Object)this.getOuterType())).equals((Object)other.getOuterType())) {
                return false;
            }
            return this.ivMemoryBufferSize == other.ivMemoryBufferSize;
        }

        private HpelTraceServiceConfig getOuterType() {
            return HpelTraceServiceConfig.this;
        }
    }

    protected class LogState
    implements Cloneable {
        protected final String prefix;
        String ivDataDirectory = null;
        int ivPurgeMaxSize = -1;
        int ivPurgeMinTime = -1;
        OutOfSpaceAction ivOutOfSpaceAction = OutOfSpaceAction.StopLogging;
        boolean ivBufferingEnabled = true;
        int ivFileSwitchTime = -1;

        LogState(String prefix) {
            this.prefix = prefix;
        }

        public LogState clone() {
            try {
                return (LogState)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException("Cannot use Java with no support for clone() on Object class");
            }
        }

        public File getLocation() {
            return new File(this.ivDataDirectory, "logdata");
        }

        public long getPurgeMaxSize() {
            return this.ivPurgeMaxSize < 0 ? -1L : (long)this.ivPurgeMaxSize * 0x100000L;
        }

        public long getPurgeMinTime() {
            return this.ivPurgeMinTime < 0 ? -1L : (long)this.ivPurgeMinTime * 3600000L;
        }

        public void updateLoggingAttributes() {
            this.ivDataDirectory = HpelTraceServiceConfig.this.getLogDirectory().getAbsolutePath();
        }

        public void readState(String prefix, Map<String, ?> config) {
            prefix = prefix == null ? "" : prefix + this.prefix;
            this.ivDataDirectory = HpelTraceServiceConfig.this.getLogDirectory().getAbsolutePath();
            Object obj = config.get(prefix + "purgeMaxSize");
            this.ivPurgeMaxSize = LoggingConfigUtils.getIntValue(obj, (int)this.ivPurgeMaxSize);
            obj = config.get(prefix + "purgeMinTime");
            this.ivPurgeMinTime = HpelTraceServiceConfig.this.getLongValue(obj, this.ivPurgeMinTime);
            String value = (String)config.get(prefix + "outOfSpaceAction");
            if (value != null) {
                try {
                    this.ivOutOfSpaceAction = OutOfSpaceAction.valueOf(value);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if ((obj = config.get(prefix + "bufferingEnabled")) instanceof Boolean) {
                this.ivBufferingEnabled = (Boolean)obj;
            } else if (obj instanceof String) {
                this.ivBufferingEnabled = Boolean.valueOf((String)obj);
            }
            obj = config.get(prefix + "fileSwitchTime");
            this.ivFileSwitchTime = LoggingConfigUtils.getIntValue(obj, (int)this.ivFileSwitchTime);
        }

        public void writeState(StringBuilder sb) {
            sb.append(this.prefix).append("dataDirectory").append("=").append(this.ivDataDirectory).append(",");
            sb.append(this.prefix).append("purgeMaxSize").append("=").append(Long.toString(this.ivPurgeMaxSize)).append(",");
            sb.append(this.prefix).append("purgeMinTime").append("=").append(Long.toString(this.ivPurgeMinTime)).append(",");
            sb.append(this.prefix).append("outOfSpaceAction").append("=").append(this.ivOutOfSpaceAction.toString()).append(",");
            sb.append(this.prefix).append("bufferingEnabled").append("=").append(Boolean.toString(this.ivBufferingEnabled)).append(",");
            sb.append(this.prefix).append("fileSwitchTime").append("=").append(Integer.toString(this.ivFileSwitchTime));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + ((Object)((Object)this.getOuterType())).hashCode();
            result = 31 * result + (this.ivBufferingEnabled ? 1231 : 1237);
            result = 31 * result + (this.ivDataDirectory == null ? 0 : this.ivDataDirectory.hashCode());
            result = 31 * result + this.ivFileSwitchTime;
            result = 31 * result + (this.ivOutOfSpaceAction == null ? 0 : this.ivOutOfSpaceAction.hashCode());
            result = 31 * result + this.ivPurgeMaxSize;
            result = 31 * result + this.ivPurgeMinTime;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof LogState)) {
                return false;
            }
            LogState other = (LogState)obj;
            if (!((Object)((Object)this.getOuterType())).equals((Object)other.getOuterType())) {
                return false;
            }
            if (this.ivBufferingEnabled != other.ivBufferingEnabled) {
                return false;
            }
            if (this.ivDataDirectory == null ? other.ivDataDirectory != null : !this.ivDataDirectory.equals(other.ivDataDirectory)) {
                return false;
            }
            if (this.ivFileSwitchTime != other.ivFileSwitchTime) {
                return false;
            }
            if (this.ivOutOfSpaceAction == null ? other.ivOutOfSpaceAction != null : !this.ivOutOfSpaceAction.equals((Object)other.ivOutOfSpaceAction)) {
                return false;
            }
            if (this.ivPurgeMaxSize != other.ivPurgeMaxSize) {
                return false;
            }
            return this.ivPurgeMinTime == other.ivPurgeMinTime;
        }

        private HpelTraceServiceConfig getOuterType() {
            return HpelTraceServiceConfig.this;
        }
    }

    public static enum OutputFormat {
        Basic,
        Advanced;

    }

    public static enum OutOfSpaceAction {
        StopServer,
        PurgeOld,
        StopLogging;

    }
}

