/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.hpel.impl;

import com.ibm.websphere.logging.hpel.reader.RepositoryLogRecord;
import com.ibm.websphere.logging.hpel.reader.RepositoryPointer;
import com.ibm.ws.logging.hpel.LogRecordSerializer;
import com.ibm.ws.logging.hpel.LogRepositoryBrowser;
import com.ibm.ws.logging.hpel.impl.LogRecordBrowser;
import com.ibm.ws.logging.hpel.impl.OneLogFileRecordIterator;
import com.ibm.ws.logging.object.hpel.RepositoryLogRecordImpl;
import com.ibm.ws.logging.object.hpel.RepositoryPointerImpl;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;

public class OneFileBrowserImpl
implements LogRepositoryBrowser {
    private final File repositoryFile;
    private final long timestamp;
    private final String processId;
    private final String label;
    private static final Map<String, LogRepositoryBrowser> emptyMap = new HashMap<String, LogRepositoryBrowser>();

    public OneFileBrowserImpl(File repositoryLocation) throws IllegalArgumentException {
        if (!this.isFile(repositoryLocation)) {
            throw new IllegalArgumentException("Specified location is not a file.");
        }
        OneLogFileRecordIterator it = new OneLogFileRecordIterator(repositoryLocation, -1L, new AllAcceptVerifier()){

            @Override
            protected RepositoryPointer getPointer(File file, long position) {
                return new RepositoryPointerImpl(OneFileBrowserImpl.this.getIds(), file.getName(), position);
            }
        };
        if (it.header == null) {
            it.close();
            throw new IllegalArgumentException("Specified file does not contains HPEL header.");
        }
        this.processId = it.header.getProperty("ProcessId");
        this.label = "Y".equalsIgnoreCase(it.header.getProperty("isZOS", "N")) ? it.header.getProperty("jobName", "name") + "_" + it.header.getProperty("jobId", "id") : it.header.getProperty("ServerName", "server");
        RepositoryLogRecord first = it.next();
        this.timestamp = first == null ? -1L : first.getMillis();
        this.repositoryFile = repositoryLocation;
    }

    private boolean isFile(final File repositoryLocation) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return repositoryLocation.isFile();
            }
        });
    }

    @Override
    public int count(File first, File last) {
        return 1;
    }

    @Override
    public File findByMillis(long timestamp) {
        return timestamp < this.timestamp ? null : this.repositoryFile;
    }

    @Override
    public File findFile(RepositoryPointerImpl location) {
        return location.getFileId().equals(this.repositoryFile.getName()) ? this.repositoryFile : null;
    }

    @Override
    public File findNext(RepositoryPointerImpl location, long timelimit) {
        return null;
    }

    @Override
    public File findNext(File current, long timelimit) {
        return current == null ? this.repositoryFile : null;
    }

    @Override
    public File findPrev(File current, long timelimit) {
        return current == null ? this.repositoryFile : null;
    }

    @Override
    public String[] getIds() {
        return new String[0];
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getProcessId() {
        return this.processId;
    }

    @Override
    public Map<String, LogRepositoryBrowser> getSubProcesses() {
        return emptyMap;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public long getLogFileTimestamp(File file) {
        return this.repositoryFile.equals(file) ? this.timestamp : -1L;
    }

    private static class AllAcceptVerifier
    implements LogRecordBrowser.IInternalRecordFilter {
        private AllAcceptVerifier() {
        }

        @Override
        public boolean filterAccepts(LogRecordSerializer formatter, DataInputStream reader, RepositoryLogRecordImpl nextRecord) throws IOException {
            formatter.deserializeLogHead(nextRecord, reader);
            formatter.deserializeLogRecord(nextRecord, reader);
            return true;
        }
    }
}

