/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.udpchannel.internal;

import com.ibm.websphere.channelfw.ChannelData;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.udpchannel.internal.AccessLists;
import com.ibm.ws.udpchannel.internal.UDPChannelConfiguration;
import com.ibm.ws.udpchannel.internal.UDPConnLink;
import com.ibm.ws.udpchannel.internal.UDPNetworkLayer;
import com.ibm.ws.udpchannel.internal.WorkQueueManager;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.channelfw.ConnectionLink;
import com.ibm.wsspi.channelfw.DiscriminationProcess;
import com.ibm.wsspi.channelfw.Discriminator;
import com.ibm.wsspi.channelfw.InboundChannel;
import com.ibm.wsspi.channelfw.OutboundChannel;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.channelfw.exception.ChannelException;
import com.ibm.wsspi.channelfw.exception.RetryableChannelException;
import com.ibm.wsspi.udpchannel.UDPContext;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.LinkedList;

public class UDPChannel
implements OutboundChannel,
InboundChannel {
    static final TraceComponent tc = Tr.register(UDPChannel.class, (String)"UDPChannel", (String)"com.ibm.ws.udpchannel.internal.resources.UDPMessages");
    private static final Class<?> appSideClass = UDPContext.class;
    private static final Class<?>[] appSideList = new Class[]{appSideClass};
    private WorkQueueManager workQueueManager = null;
    private UDPChannelConfiguration udpChannelConfig = null;
    private DiscriminationProcess discriminationProcess = null;
    private boolean stoppedFlag = true;
    private String displayableHostName = null;
    private LinkedList<UDPConnLink> inUse = new LinkedList();
    private UDPNetworkLayer inboundNetworkLayer = null;
    private AccessLists alists;

    public UDPChannel(UDPChannelConfiguration config, WorkQueueManager workQueueManager) throws ChannelException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"UDPChannel", (Object[])new Object[0]);
        }
        this.udpChannelConfig = config;
        this.workQueueManager = workQueueManager;
        workQueueManager.addRef();
        this.alists = AccessLists.getInstance(config);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"UDPChannel");
        }
    }

    @Override
    public Class<?> getDeviceAddress() {
        throw new IllegalStateException("Not implemented and never will be");
    }

    @Override
    public Class<?>[] getApplicationAddress() {
        return appSideList;
    }

    @Override
    public Discriminator getDiscriminator() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"getDiscriminator should not be called in UDPChannel", (Object[])new Object[0]);
        }
        return null;
    }

    @Override
    public DiscriminationProcess getDiscriminationProcess() {
        return this.discriminationProcess;
    }

    @Override
    public void setDiscriminationProcess(DiscriminationProcess process) {
        this.discriminationProcess = process;
    }

    @Override
    public Class<?> getDiscriminatoryType() {
        return WsByteBuffer.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionLink getConnectionLink(VirtualConnection vc) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"getConnectionLink", (Object[])new Object[0]);
        }
        UDPConnLink connLink = new UDPConnLink(this.workQueueManager, vc, this, this.getConfig());
        LinkedList<UDPConnLink> linkedList = this.inUse;
        synchronized (linkedList) {
            this.inUse.add(connLink);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)("getConnectionLink: " + connLink));
        }
        return connLink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnLink(UDPConnLink connLink) {
        LinkedList<UDPConnLink> linkedList = this.inUse;
        synchronized (linkedList) {
            this.inUse.remove(connLink);
        }
    }

    @Override
    public void start() throws ChannelException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)("start; " + this.getName()), (Object[])new Object[0]);
        }
        if (this.stoppedFlag) {
            this.stoppedFlag = false;
            if (this.getConfig().isInboundChannel()) {
                this.inboundNetworkLayer = new UDPNetworkLayer(this, this.workQueueManager, this.getConfig().getHostname(), this.getConfig().getPort());
                try {
                    this.inboundNetworkLayer.initDatagramSocket(null);
                }
                catch (IOException e) {
                    this.stoppedFlag = true;
                    throw new RetryableChannelException(e);
                }
                String IPvType = "IPv4";
                if (this.inboundNetworkLayer.getDatagramSocket().getInetAddress() instanceof Inet6Address) {
                    IPvType = "IPv6";
                }
                String hostname = this.getConfig().getHostname();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("getHostname():  >" + hostname + "<"), (Object[])new Object[0]);
                }
                if (hostname == null || hostname.equals("*")) {
                    this.displayableHostName = "*  (" + IPvType + ")";
                } else {
                    InetAddress addr = this.inboundNetworkLayer.getDatagramSocket().getLocalAddress();
                    this.displayableHostName = addr.getHostName() + "  (" + IPvType + ": " + addr.getHostAddress() + ")";
                }
                Tr.info((TraceComponent)tc, (String)"CWUDP0001I", (Object[])new Object[]{this.getConfig().getExternalName(), this.displayableHostName, String.valueOf(this.inboundNetworkLayer.getListenPort())});
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"start");
        }
    }

    @Override
    public void stop(long millisec) throws ChannelException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)("stop " + millisec + "; " + this.getName()), (Object[])new Object[0]);
        }
        if (millisec == 0L) {
            block6: {
                this.stoppedFlag = true;
                if (this.getConfig().isInboundChannel()) {
                    try {
                        Tr.info((TraceComponent)tc, (String)"CWUDP0002I", (Object[])new Object[]{this.getConfig().getExternalName(), this.displayableHostName, String.valueOf(this.getConfig().getPort())});
                    }
                    catch (Exception e) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block6;
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("Got exception auditing UDP Channel Stop: " + e), (Object[])new Object[0]);
                    }
                }
            }
            this.destroyConnLinks();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"stop");
        }
    }

    @Override
    public void init() throws ChannelException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("UDP Channel: " + this.getConfig().getExternalName() + " listening port: " + String.valueOf(this.getConfig().getPort())), (Object[])new Object[0]);
        }
    }

    @Override
    public void destroy() throws ChannelException {
        block4: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry((Object)this, (TraceComponent)tc, (String)("destroy; " + this.getName()), (Object[])new Object[0]);
            }
            try {
                this.workQueueManager.shutdown();
            }
            catch (IOException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Error trying to shutdown work queue manager " + e.getMessage()), (Object[])new Object[0]);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"destroy");
        }
    }

    @Override
    public String getName() {
        return this.udpChannelConfig.getChannelData().getName();
    }

    @Override
    public Class<?> getApplicationInterface() {
        return appSideClass;
    }

    @Override
    public Class<?> getDeviceInterface() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(ChannelData channelData) {
        UDPChannelConfiguration uDPChannelConfiguration = this.udpChannelConfig;
        synchronized (uDPChannelConfiguration) {
            block5: {
                try {
                    this.udpChannelConfig.setChannelData(channelData);
                }
                catch (ChannelException e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block5;
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("Error updating config:" + e.getMessage()), (Object[])new Object[0]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyConnLinks() {
        LinkedList<UDPConnLink> linkedList = this.inUse;
        synchronized (linkedList) {
            int numlinks = this.inUse.size();
            for (int i = 0; i < numlinks; ++i) {
                this.inUse.removeFirst().destroy(null);
            }
        }
    }

    protected UDPChannelConfiguration getConfig() {
        return this.udpChannelConfig;
    }

    public boolean verifySender(InetAddress remoteAddr) {
        boolean returnValue = true;
        if (this.alists != null) {
            returnValue = !this.alists.accessDenied(remoteAddr);
        }
        return returnValue;
    }
}

