/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcpchannel.internal;

import com.ibm.websphere.channelfw.ChannelData;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.tcpchannel.internal.ValidateUtils;
import com.ibm.wsspi.channelfw.exception.ChannelException;
import com.ibm.wsspi.tcpchannel.TCPConfigConstants;
import java.util.ArrayList;
import java.util.Map;

public class TCPChannelConfiguration
implements TCPConfigConstants,
FFDCSelfIntrospectable {
    protected static final String NEW_BUFF_SIZE = "newConnectionBufferSize";
    protected static final String LINGER = "soLinger";
    protected static final String NO_DELAY = "tcpNoDelay";
    protected static final String REUSE_ADDR = "soReuseAddr";
    protected static final String KEEP_ALIVE = "keepAlive";
    protected static final String BACKLOG = "listenBacklog";
    protected static final String DIRECT_BUFFS = "allocateBuffersDirect";
    protected static final String ACCEPT_THREAD = "acceptThread";
    protected static final String WAIT_TO_ACCEPT = "waitToAccept";
    protected static final String COMM_OPTION = "commOption";
    protected static final String DUMP_STATS_INTERVAL = "dumpStatsInterval";
    protected static final String GROUPNAME = "workGroup";
    protected static final String ENDPOINT_NAME = "endPointName";
    protected static final String CHAIN_TYPE_KEY = "chainType";
    protected static final String ZAIO_RESOLVE_FOREIGN_HOSTNAMES_KEY = "zaioResolveForeignHostnames";
    protected static final String ZAIO_FREE_INITIAL_BUFFER_KEY = "zaioFreeInitialBuffers";
    private static final TraceComponent tc = Tr.register(TCPChannelConfiguration.class, (String)"TCPChannel", (String)"com.ibm.ws.tcpchannel.internal.resources.TCPChannelMessages");
    private ChannelData channelData = null;
    private Map<Object, Object> channelProperties = null;
    private int maxOpenConnections = 128000;
    private String workGroupName = "Default";
    private int listenBacklog = 511;
    private int newConnectionBufferSize = 8192;
    private int port = 80;
    private String hostname = "*";
    private int inactivityTimeout = 60000;
    private String[] addressExcludeList = null;
    private String[] hostNameExcludeList = null;
    private String[] addressIncludeList = null;
    private String[] hostNameIncludeList = null;
    private boolean allocateBuffersDirect = true;
    private boolean tcpNoDelay = true;
    private int soLinger = -1;
    private boolean soReuseAddress = true;
    private boolean keepAlive = true;
    private int receiveBufferSize = -1;
    private int sendBufferSize = -1;
    private boolean acceptThread = false;
    private boolean waitToAccept = false;
    private int dumpStatsInterval = 0;
    private String endPointName = null;
    private static final int COMM_OPTION_FORCE_NIO = 0;
    private static final int COMM_OPTION_DONT_FORCE_NIO = 1;
    private int commOption = 1;
    private final boolean inbound;
    private String externalName = null;
    private boolean caseInsensitiveHostnames = true;

    public TCPChannelConfiguration(ChannelData chanData) throws ChannelException {
        this.channelData = chanData;
        this.inbound = chanData.isInbound();
        this.channelProperties = chanData.getPropertyBag();
        this.externalName = chanData.getExternalName();
        if (this.channelProperties == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"TCPChannelConfiguration object constructed with null properties", (Object[])new Object[0]);
            }
            throw new ChannelException("TCPChannelConfiguration constructed with null properties");
        }
        this.setValues();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            this.outputConfigToTrace();
        }
    }

    private boolean skipKey(String key) {
        return key.equals("id") || key.equals("type") || key.startsWith("service.") || key.startsWith("component.") || key.startsWith("config.") || key.startsWith("objectClass");
    }

    private void setValues() throws ChannelException {
        String key = null;
        Object value = null;
        int result = 0;
        int minValue = 0;
        int maxValue = 0;
        int keyType = 0;
        ChannelException e = null;
        if (this.channelProperties.containsKey("caseInsensitiveHostnames")) {
            key = (String)this.channelProperties.get("caseInsensitiveHostnames");
            this.caseInsensitiveHostnames = Boolean.parseBoolean(key);
        }
        for (Map.Entry<Object, Object> entry : this.channelProperties.entrySet()) {
            if (0 != result) break;
            key = (String)entry.getKey();
            value = entry.getValue();
            if (this.skipKey(key) || key.equalsIgnoreCase("caseInsensitiveHostnames")) continue;
            try {
                if (this.isInbound()) {
                    if (key.equalsIgnoreCase("hostname")) {
                        keyType = 1;
                        this.hostname = (String)value;
                        if (value != null) continue;
                        result = 1;
                        continue;
                    }
                    if (key.equalsIgnoreCase("port")) {
                        keyType = 0;
                        minValue = 0;
                        maxValue = 65535;
                        this.port = this.convertIntegerValue(value);
                        result = ValidateUtils.testPort(this.port);
                        continue;
                    }
                    if (key.equalsIgnoreCase("maxOpenConnections")) {
                        keyType = 0;
                        minValue = 1;
                        maxValue = 1280000;
                        this.maxOpenConnections = this.convertIntegerValue(value);
                        result = ValidateUtils.testMaxConnections(this.maxOpenConnections);
                        continue;
                    }
                    if (key.equalsIgnoreCase(NEW_BUFF_SIZE)) {
                        keyType = 0;
                        minValue = 32;
                        maxValue = 65536;
                        this.newConnectionBufferSize = this.convertIntegerValue(value);
                        result = ValidateUtils.testNewBuffSize(this.newConnectionBufferSize);
                        continue;
                    }
                    if (key.equalsIgnoreCase(BACKLOG)) {
                        keyType = 0;
                        minValue = 0;
                        maxValue = 512;
                        this.listenBacklog = this.convertIntegerValue(value);
                        result = ValidateUtils.testListenBacklog(this.listenBacklog);
                        continue;
                    }
                    if (key.equalsIgnoreCase("addressExcludeList")) {
                        keyType = 3;
                        this.addressExcludeList = value instanceof String ? this.convertToArray((String)value) : (String[])value;
                        result = ValidateUtils.testIsStringIPAddressesValid(this.addressExcludeList);
                        if (result == 0) continue;
                        Tr.error((TraceComponent)tc, (String)"ADDRESS_EXCLUDE_LIST_INVALID", (Object[])new Object[]{this.externalName});
                        e = new ChannelException("An entry in the address exclude list for a TCP Channel was not valid.  Valid values consist of a valid String. Channel Name: " + this.externalName);
                        break;
                    }
                    if (key.equalsIgnoreCase("addressIncludeList")) {
                        keyType = 3;
                        this.addressIncludeList = value instanceof String ? this.convertToArray((String)value) : (String[])value;
                        result = ValidateUtils.testIsStringIPAddressesValid(this.addressIncludeList);
                        if (result == 0) continue;
                        Tr.error((TraceComponent)tc, (String)"ADDRESS_INCLUDE_LIST_INVALID", (Object[])new Object[]{this.externalName});
                        e = new ChannelException("An entry in the address include list for a TCP Channel was not valid.  Valid values consist of a valid String. Channel Name: " + this.externalName);
                        break;
                    }
                    if (key.equalsIgnoreCase("hostNameExcludeList")) {
                        keyType = 3;
                        if (value instanceof String) {
                            if (this.caseInsensitiveHostnames) {
                                this.hostNameExcludeList = this.convertToArray(((String)value).toLowerCase());
                                continue;
                            }
                            this.hostNameExcludeList = this.convertToArray((String)value);
                            continue;
                        }
                        this.hostNameExcludeList = (String[])value;
                        if (!this.caseInsensitiveHostnames) continue;
                        for (int i = 0; i < this.hostNameExcludeList.length; ++i) {
                            if (this.hostNameExcludeList[i] == null) continue;
                            this.hostNameExcludeList[i] = this.hostNameExcludeList[i].toLowerCase();
                        }
                        continue;
                    }
                    if (key.equalsIgnoreCase("hostNameIncludeList")) {
                        keyType = 3;
                        if (value instanceof String) {
                            this.hostNameIncludeList = this.convertToArray((String)value);
                            continue;
                        }
                        this.hostNameIncludeList = (String[])value;
                        continue;
                    }
                    if (key.equalsIgnoreCase(ACCEPT_THREAD)) {
                        keyType = 0;
                        minValue = 0;
                        maxValue = 1;
                        this.acceptThread = this.convertBooleanValue(value);
                        result = 0;
                        if (!this.waitToAccept) continue;
                        this.acceptThread = true;
                        continue;
                    }
                    if (key.equalsIgnoreCase(WAIT_TO_ACCEPT)) {
                        keyType = 0;
                        minValue = 0;
                        maxValue = 1;
                        this.waitToAccept = this.convertBooleanValue(value);
                        result = 0;
                        if (!this.waitToAccept) continue;
                        this.acceptThread = true;
                        continue;
                    }
                    if (key.equalsIgnoreCase(DIRECT_BUFFS)) {
                        keyType = 2;
                        this.allocateBuffersDirect = this.convertBooleanValue(value);
                        result = 0;
                        continue;
                    }
                    if (key.equalsIgnoreCase(ENDPOINT_NAME)) {
                        keyType = 1;
                        this.endPointName = (String)value;
                        if (value != null) continue;
                        result = 1;
                        continue;
                    }
                    if (key.equalsIgnoreCase("listeningPort")) continue;
                }
                if (key.equalsIgnoreCase(REUSE_ADDR)) {
                    keyType = 2;
                    this.soReuseAddress = this.convertBooleanValue(value);
                    result = 0;
                    continue;
                }
                if (key.equalsIgnoreCase(NO_DELAY)) {
                    keyType = 2;
                    this.tcpNoDelay = this.convertBooleanValue(value);
                    result = 0;
                    continue;
                }
                if (key.equalsIgnoreCase(LINGER)) {
                    keyType = 0;
                    minValue = -1;
                    maxValue = 3600;
                    this.soLinger = this.convertIntegerValue(value);
                    result = ValidateUtils.testLinger(this.soLinger);
                    continue;
                }
                if (key.equalsIgnoreCase(KEEP_ALIVE)) {
                    keyType = 2;
                    this.keepAlive = this.convertBooleanValue(value);
                    result = 0;
                    continue;
                }
                if (key.equalsIgnoreCase("receiveBufferSize")) {
                    keyType = 0;
                    minValue = 4;
                    maxValue = 0x1000000;
                    this.receiveBufferSize = this.convertIntegerValue(value);
                    result = ValidateUtils.testReceiveBufferSize(this.receiveBufferSize);
                    continue;
                }
                if (key.equalsIgnoreCase("sendBufferSize")) {
                    keyType = 0;
                    minValue = 4;
                    maxValue = 0x1000000;
                    this.sendBufferSize = this.convertIntegerValue(value);
                    result = ValidateUtils.testSendBufferSize(this.sendBufferSize);
                    continue;
                }
                if (key.equalsIgnoreCase(GROUPNAME)) {
                    keyType = 1;
                    this.workGroupName = (String)value;
                    if (null != this.workGroupName) continue;
                    result = 1;
                    continue;
                }
                if (key.equalsIgnoreCase("inactivityTimeout")) {
                    keyType = 0;
                    minValue = 0;
                    maxValue = 3600000;
                    this.inactivityTimeout = this.convertIntegerValue(value);
                    result = ValidateUtils.testInactivityTimeout(this.inactivityTimeout);
                    continue;
                }
                if (key.equalsIgnoreCase(COMM_OPTION)) {
                    keyType = 0;
                    minValue = 0;
                    maxValue = 1;
                    this.commOption = this.convertIntegerValue(value);
                    result = ValidateUtils.testCommOption(this.commOption);
                    continue;
                }
                if (key.equalsIgnoreCase(DUMP_STATS_INTERVAL)) {
                    keyType = 0;
                    minValue = 0;
                    maxValue = 3600;
                    this.dumpStatsInterval = this.convertIntegerValue(value);
                    result = ValidateUtils.testDumpStatsInterval(this.dumpStatsInterval);
                    continue;
                }
                if (key.equalsIgnoreCase("chainData") || key.equalsIgnoreCase(CHAIN_TYPE_KEY) || key.equalsIgnoreCase(ZAIO_RESOLVE_FOREIGN_HOSTNAMES_KEY) || key.equalsIgnoreCase(ZAIO_FREE_INITIAL_BUFFER_KEY)) continue;
                if (value instanceof String) {
                    Tr.warning((TraceComponent)tc, (String)"CONFIG_KEY_NOT_VALID", (Object[])new Object[]{this.externalName, key, value});
                    continue;
                }
                Tr.warning((TraceComponent)tc, (String)"CONFIG_KEY_NOT_VALID", (Object[])new Object[]{this.externalName, key, ""});
            }
            catch (NumberFormatException x) {
                Tr.error((TraceComponent)tc, (String)"CONFIG_VALUE_NUMBER_EXCEPTION", (Object[])new Object[]{this.externalName, key, value});
                e = new ChannelException("TCP Channel Caught a NumberFormatException processing property, Channel Name: " + this.externalName + " Property name: " + key + " value: " + value, x);
                FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"101", (Object)this);
                throw e;
            }
        }
        if (result != 0) {
            if (keyType == 0) {
                Tr.error((TraceComponent)tc, (String)"CONFIG_VALUE_NOT_VALID_INT", (Object[])new Object[]{this.externalName, key, value, String.valueOf(minValue), String.valueOf(maxValue)});
                e = new ChannelException("A TCP Channel has been constructed with incorrect configuration property value, Channel Name: " + this.externalName + " name: " + key + " value: " + value + " minimum Value: " + minValue + " maximum Value: " + maxValue);
            } else if (keyType == 2) {
                Tr.error((TraceComponent)tc, (String)"CONFIG_VALUE_NOT_VALID_BOOLEAN", (Object[])new Object[]{this.externalName, key, value});
                e = new ChannelException("A TCP Channel has been constructed with incorrect configuration property value, Channel Name: " + this.externalName + " name: " + key + " value: " + value + " Valid Range: false, true");
            } else if (keyType == 1) {
                if (value == null) {
                    Tr.error((TraceComponent)tc, (String)"CONFIG_VALUE_NOT_VALID_NULL_STRING", (Object[])new Object[]{this.externalName, key});
                    e = new ChannelException("A TCP Channel has been constructed with incorrect configuration property value, Channel Name: " + this.externalName + " name: " + key + " value: null");
                } else {
                    Tr.error((TraceComponent)tc, (String)"CONFIG_VALUE_NOT_VALID_STRING", (Object[])new Object[]{this.externalName, key, value});
                    e = new ChannelException("A TCP Channel has been constructed with incorrect configuration property value, Channel Name: " + this.externalName + " name: " + key + " value: " + value);
                }
            }
            if (e != null) {
                FFDCFilter.processException(e, (String)this.getClass().getName(), (String)"102", (Object)this);
                throw e;
            }
        }
    }

    protected boolean checkAndSetValues(ChannelData chanData) {
        boolean _inbound = chanData.isInbound();
        String key = null;
        Object value = null;
        int result = 0;
        int minValue = 0;
        int maxValue = 0;
        int keyType = 0;
        int oldValue = 0;
        String strOldValue = null;
        boolean oldBool = false;
        boolean update = true;
        int maxOpenConnectionsNew = this.maxOpenConnections;
        int inactivityTimeoutNew = this.inactivityTimeout;
        String[] addressExcludeListNew = null;
        String[] addressIncludeListNew = null;
        String[] hostNameExcludeListNew = null;
        String[] hostNameIncludeListNew = null;
        for (Map.Entry<Object, Object> entry : chanData.getPropertyBag().entrySet()) {
            if (0 != result) break;
            key = (String)entry.getKey();
            value = entry.getValue();
            if (this.skipKey(key)) continue;
            try {
                if (_inbound) {
                    if (key.equalsIgnoreCase("hostname")) {
                        keyType = 1;
                        strOldValue = this.hostname;
                        if (((String)value).equals(strOldValue)) continue;
                        result = 2;
                        continue;
                    }
                    if (key.equalsIgnoreCase("port")) {
                        keyType = 0;
                        oldValue = this.port;
                        if (this.convertIntegerValue(value) == oldValue) continue;
                        result = 2;
                        continue;
                    }
                    if (key.equalsIgnoreCase("maxOpenConnections")) {
                        keyType = 0;
                        minValue = 1;
                        maxValue = 1280000;
                        maxOpenConnectionsNew = this.convertIntegerValue(value);
                        result = ValidateUtils.testMaxConnections(maxOpenConnectionsNew);
                        continue;
                    }
                    if (key.equalsIgnoreCase(NEW_BUFF_SIZE)) {
                        keyType = 0;
                        oldValue = this.newConnectionBufferSize;
                        if (this.convertIntegerValue(value) == oldValue) continue;
                        result = 2;
                        continue;
                    }
                    if (key.equalsIgnoreCase(BACKLOG)) {
                        keyType = 0;
                        oldValue = this.listenBacklog;
                        if (this.convertIntegerValue(value) == oldValue) continue;
                        result = 2;
                        continue;
                    }
                    if (key.equalsIgnoreCase("addressExcludeList")) {
                        keyType = 3;
                        addressExcludeListNew = value instanceof String ? this.convertToArray((String)value) : (String[])value;
                        result = ValidateUtils.testIsStringIPAddressesValid(addressExcludeListNew);
                        if (result == 0) continue;
                        Tr.error((TraceComponent)tc, (String)"ADDRESS_EXCLUDE_LIST_INVALID", (Object[])new Object[]{this.externalName});
                        break;
                    }
                    if (key.equalsIgnoreCase("addressIncludeList")) {
                        keyType = 3;
                        addressIncludeListNew = value instanceof String ? this.convertToArray((String)value) : (String[])value;
                        result = ValidateUtils.testIsStringIPAddressesValid(addressExcludeListNew);
                        if (result == 0) continue;
                        Tr.error((TraceComponent)tc, (String)"ADDRESS_INCLUDE_LIST_INVALID", (Object[])new Object[]{this.externalName});
                        break;
                    }
                    if (key.equalsIgnoreCase("hostNameExcludeList")) {
                        keyType = 3;
                        if (value instanceof String) {
                            hostNameExcludeListNew = this.convertToArray((String)value);
                            continue;
                        }
                        hostNameExcludeListNew = (String[])value;
                        continue;
                    }
                    if (key.equalsIgnoreCase("hostNameIncludeList")) {
                        keyType = 3;
                        if (value instanceof String) {
                            hostNameIncludeListNew = this.convertToArray((String)value);
                            continue;
                        }
                        hostNameIncludeListNew = (String[])value;
                        continue;
                    }
                    if (key.equalsIgnoreCase(ENDPOINT_NAME)) {
                        keyType = 1;
                        strOldValue = this.endPointName;
                        if (((String)value).equals(strOldValue)) continue;
                        result = 2;
                        continue;
                    }
                    if (key.equalsIgnoreCase("listeningPort")) continue;
                }
                if (key.equalsIgnoreCase(NO_DELAY)) {
                    keyType = 2;
                    oldBool = this.tcpNoDelay;
                    if (this.convertBooleanValue(value) == oldBool) continue;
                    result = 2;
                    continue;
                }
                if (key.equalsIgnoreCase(REUSE_ADDR)) {
                    keyType = 2;
                    oldBool = this.soReuseAddress;
                    if (this.convertBooleanValue(value) == oldBool) continue;
                    result = 2;
                    continue;
                }
                if (key.equalsIgnoreCase(LINGER)) {
                    keyType = 0;
                    oldValue = this.soLinger;
                    if (this.convertIntegerValue(value) == oldValue) continue;
                    result = 2;
                    continue;
                }
                if (key.equalsIgnoreCase(ACCEPT_THREAD)) {
                    keyType = 0;
                    oldBool = this.acceptThread;
                    if (this.convertBooleanValue(value) == oldBool) continue;
                    result = 2;
                    continue;
                }
                if (key.equalsIgnoreCase(WAIT_TO_ACCEPT)) {
                    keyType = 0;
                    oldBool = this.waitToAccept;
                    if (this.convertBooleanValue(value) == oldBool) continue;
                    result = 2;
                    continue;
                }
                if (key.equalsIgnoreCase(DIRECT_BUFFS)) {
                    keyType = 2;
                    oldBool = this.allocateBuffersDirect;
                    if (this.convertBooleanValue(value) == oldBool) continue;
                    result = 2;
                    continue;
                }
                if (key.equalsIgnoreCase(KEEP_ALIVE)) {
                    keyType = 2;
                    oldBool = this.keepAlive;
                    if (this.convertBooleanValue(value) == oldBool) continue;
                    result = 2;
                    continue;
                }
                if (key.equalsIgnoreCase("receiveBufferSize")) {
                    keyType = 0;
                    oldValue = this.receiveBufferSize;
                    if (this.convertIntegerValue(value) == oldValue) continue;
                    result = 2;
                    continue;
                }
                if (key.equalsIgnoreCase("sendBufferSize")) {
                    keyType = 0;
                    oldValue = this.sendBufferSize;
                    if (this.convertIntegerValue(value) == oldValue) continue;
                    result = 2;
                    continue;
                }
                if (key.equalsIgnoreCase(GROUPNAME)) {
                    keyType = 1;
                    strOldValue = this.workGroupName;
                    this.workGroupName = (String)value;
                    if (null != this.workGroupName) continue;
                    result = 1;
                    continue;
                }
                if (key.equalsIgnoreCase("inactivityTimeout")) {
                    keyType = 0;
                    inactivityTimeoutNew = this.convertIntegerValue(value);
                    result = ValidateUtils.testInactivityTimeout(inactivityTimeoutNew);
                    continue;
                }
                if (key.equalsIgnoreCase(COMM_OPTION)) {
                    keyType = 0;
                    oldValue = this.commOption;
                    if (this.convertIntegerValue(value) == oldValue) continue;
                    result = 2;
                    continue;
                }
                if (key.equalsIgnoreCase("chainData") || key.equalsIgnoreCase(CHAIN_TYPE_KEY) || key.equalsIgnoreCase(ZAIO_RESOLVE_FOREIGN_HOSTNAMES_KEY) || key.equalsIgnoreCase(ZAIO_FREE_INITIAL_BUFFER_KEY)) continue;
                if (value instanceof String) {
                    Tr.warning((TraceComponent)tc, (String)"CONFIG_KEY_NOT_VALID", (Object[])new Object[]{this.externalName, key, value});
                    continue;
                }
                Tr.warning((TraceComponent)tc, (String)"CONFIG_KEY_NOT_VALID", (Object[])new Object[]{this.externalName, key, ""});
            }
            catch (NumberFormatException x) {
                update = false;
                Tr.error((TraceComponent)tc, (String)"CONFIG_VALUE_NUMBER_EXCEPTION", (Object[])new Object[]{this.externalName, key, value});
            }
        }
        if (result == 1) {
            update = false;
            if (keyType == 0) {
                Tr.error((TraceComponent)tc, (String)"CONFIG_VALUE_NOT_VALID_INT", (Object[])new Object[]{this.externalName, key, value, String.valueOf(minValue), String.valueOf(maxValue)});
            } else if (keyType == 2) {
                Tr.error((TraceComponent)tc, (String)"CONFIG_VALUE_NOT_VALID_BOOLEAN", (Object[])new Object[]{this.externalName, key, value});
            } else if (keyType == 1) {
                if (value == null) {
                    Tr.error((TraceComponent)tc, (String)"CONFIG_VALUE_NOT_VALID_NULL_STRING", (Object[])new Object[]{this.externalName, key});
                } else {
                    Tr.error((TraceComponent)tc, (String)"CONFIG_VALUE_NOT_VALID_STRING", (Object[])new Object[]{this.externalName, key, value});
                }
            }
            Tr.error((TraceComponent)tc, (String)"UPDATED_CONFIG_NOT_IMPLEMENTED", (Object[])new Object[]{this.externalName});
        }
        if (result == 2) {
            update = false;
            if (keyType == 0) {
                Tr.error((TraceComponent)tc, (String)"NEW_CONFIG_VALUE_NOT_EQUAL", (Object[])new Object[]{this.externalName, key, String.valueOf(oldValue), value});
            } else if (keyType == 1) {
                Tr.error((TraceComponent)tc, (String)"NEW_CONFIG_VALUE_NOT_EQUAL", (Object[])new Object[]{this.externalName, key, strOldValue, value});
            } else if (keyType == 2) {
                Tr.error((TraceComponent)tc, (String)"NEW_CONFIG_VALUE_NOT_EQUAL", (Object[])new Object[]{this.externalName, key, Boolean.toString(oldBool), value});
            }
            Tr.error((TraceComponent)tc, (String)"UPDATED_CONFIG_NOT_IMPLEMENTED", (Object[])new Object[]{this.externalName});
        }
        if (update) {
            this.maxOpenConnections = maxOpenConnectionsNew;
            this.inactivityTimeout = inactivityTimeoutNew;
            this.addressExcludeList = addressExcludeListNew;
            this.addressIncludeList = addressIncludeListNew;
            this.hostNameExcludeList = hostNameExcludeListNew;
            this.hostNameIncludeList = hostNameIncludeListNew;
        }
        return update;
    }

    private String[] convertToArray(String allEntries) {
        int start = 0;
        int end = 0;
        String newAddress = null;
        if (allEntries == null) {
            return null;
        }
        int length = allEntries.length();
        ArrayList<String> entryList = new ArrayList<String>();
        while (start != length) {
            end = allEntries.indexOf(44, start);
            if (end > start) {
                newAddress = allEntries.substring(start, end);
                newAddress = newAddress.trim();
                entryList.add(newAddress);
            } else if (end != start) {
                newAddress = allEntries.substring(start);
                newAddress = newAddress.trim();
                entryList.add(newAddress);
            }
            if (end == -1) break;
            start = end + 1;
        }
        if (entryList.isEmpty()) {
            return null;
        }
        return entryList.toArray(new String[entryList.size()]);
    }

    private int convertIntegerValue(Object value) {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return Integer.parseInt(value.toString().trim());
    }

    private boolean convertBooleanValue(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return Boolean.parseBoolean(value.toString().trim());
    }

    protected ChannelData getChannelData() {
        return this.channelData;
    }

    protected int getMaxOpenConnections() {
        return this.maxOpenConnections;
    }

    public String getWorkGroupName() {
        return this.workGroupName;
    }

    protected int getListenBacklog() {
        return this.listenBacklog;
    }

    protected int getNewConnectionBufferSize() {
        return this.newConnectionBufferSize;
    }

    protected boolean getAllocateBuffersDirect() {
        return this.allocateBuffersDirect;
    }

    protected boolean getTcpNoDelay() {
        return this.tcpNoDelay;
    }

    protected boolean getSoReuseAddress() {
        return this.soReuseAddress;
    }

    protected boolean getKeepAlive() {
        return this.keepAlive;
    }

    public String getHostname() {
        if (this.hostname.equals("*")) {
            return null;
        }
        return this.hostname;
    }

    public String getDisplayableHostname() {
        return this.hostname;
    }

    protected int getInactivityTimeout() {
        return this.inactivityTimeout;
    }

    protected String getChannelId() {
        return "TCPChannel";
    }

    protected String[] getAddressExcludeList() {
        return this.addressExcludeList;
    }

    protected String[] getHostNameExcludeList() {
        return this.hostNameExcludeList;
    }

    protected String[] getAddressIncludeList() {
        return this.addressIncludeList;
    }

    protected String[] getHostNameIncludeList() {
        return this.hostNameIncludeList;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isNIOOnly() {
        return this.commOption == 0;
    }

    protected void outputConfigToTrace() {
        Tr.debug((TraceComponent)tc, (String)("Config parameters for TCP Channel: " + this.getChannelData().getExternalName()), (Object[])new Object[0]);
        if (this.isInbound()) {
            Tr.debug((TraceComponent)tc, (String)("hostname: " + this.getHostname()), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("port: " + this.getPort()), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("maxOpenConnections: " + this.getMaxOpenConnections()), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("addressExcludeList: " + this.debugStringArray(this.getAddressExcludeList())), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("hostNameExcludeList: " + this.debugStringArray(this.getHostNameExcludeList())), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("addressIncludeList: " + this.debugStringArray(this.getAddressIncludeList())), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("hostNameIncludeList: " + this.debugStringArray(this.getHostNameIncludeList())), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("listenBacklog: " + this.getListenBacklog()), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("newConnectionBufferSize: " + this.getNewConnectionBufferSize()), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("caseInsensitiveHostnames: " + this.getCaseInsensitiveHostnames()), (Object[])new Object[0]);
        }
        Tr.debug((TraceComponent)tc, (String)("soReuseAddr: " + this.getSoReuseAddress()), (Object[])new Object[0]);
        Tr.debug((TraceComponent)tc, (String)("inactivityTimeout: " + this.getInactivityTimeout()), (Object[])new Object[0]);
        Tr.debug((TraceComponent)tc, (String)("workGroup: " + this.getWorkGroupName()), (Object[])new Object[0]);
        Tr.debug((TraceComponent)tc, (String)("allocateBuffersDirect: " + this.getAllocateBuffersDirect()), (Object[])new Object[0]);
        Tr.debug((TraceComponent)tc, (String)("tcpNoDelay: " + this.getTcpNoDelay()), (Object[])new Object[0]);
        Tr.debug((TraceComponent)tc, (String)("receiveBufferSize: " + this.getReceiveBufferSize()), (Object[])new Object[0]);
        Tr.debug((TraceComponent)tc, (String)("sendBufferSize: " + this.getSendBufferSize()), (Object[])new Object[0]);
        Tr.debug((TraceComponent)tc, (String)("commOption: " + this.commOption), (Object[])new Object[0]);
        Tr.debug((TraceComponent)tc, (String)("soLinger: " + this.getSoLinger()), (Object[])new Object[0]);
    }

    public String[] introspectSelf() {
        ArrayList<String> output = new ArrayList<String>();
        if (this.isInbound()) {
            output.add("hostname=" + this.hostname);
            output.add("port=" + this.port);
            output.add("maxOpenConnections=" + this.maxOpenConnections);
            output.add("addressExcludeList=" + this.debugStringArray(this.addressExcludeList));
            output.add("hostNameExcludeList=" + this.debugStringArray(this.hostNameExcludeList));
            output.add("addressIncludeList=" + this.debugStringArray(this.addressIncludeList));
            output.add("hostNameIncludeList=" + this.debugStringArray(this.hostNameIncludeList));
            output.add("listenBacklog=" + this.listenBacklog);
            output.add("newConnectionBufferSize=" + this.newConnectionBufferSize);
        }
        output.add("soReuseAddr=" + this.soReuseAddress);
        output.add("inactivityTimeout=" + this.inactivityTimeout);
        output.add("workGroup=" + this.workGroupName);
        output.add("allocateBuffersDirect=" + this.allocateBuffersDirect);
        output.add("tcpNoDelay=" + this.tcpNoDelay);
        output.add("receiveBufferSize=" + this.receiveBufferSize);
        output.add("sendBufferSize=" + this.sendBufferSize);
        output.add("commOption=" + this.commOption);
        output.add("soLinger=" + this.soLinger);
        return output.toArray(new String[output.size()]);
    }

    private String debugStringArray(String[] list) {
        if (null == list || 0 == list.length) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(list[0]);
        for (int i = 1; i < list.length; ++i) {
            sb.append(',').append(list[i]);
        }
        return sb.toString();
    }

    public boolean isInbound() {
        return this.inbound;
    }

    protected int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    protected int getSendBufferSize() {
        return this.sendBufferSize;
    }

    protected int getSoLinger() {
        return this.soLinger;
    }

    public int getDumpStatsInterval() {
        return this.dumpStatsInterval;
    }

    protected boolean getAcceptThread() {
        return this.acceptThread;
    }

    protected boolean getCaseInsensitiveHostnames() {
        return this.caseInsensitiveHostnames;
    }

    protected boolean getWaitToAccept() {
        return this.waitToAccept;
    }
}

