/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.channelfw;

import com.ibm.websphere.channelfw.ChainData;
import com.ibm.websphere.channelfw.ChainGroupData;
import com.ibm.websphere.channelfw.ChannelData;
import com.ibm.websphere.channelfw.EndPointInfo;
import com.ibm.websphere.channelfw.EndPointMgr;
import com.ibm.websphere.channelfw.FlowType;
import com.ibm.websphere.channelfw.osgi.CHFWBundle;
import com.ibm.websphere.event.ScheduledEventService;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.channelfw.internal.CHFWEventHandler;
import com.ibm.ws.channelfw.internal.ChannelFrameworkImpl;
import com.ibm.ws.channelfw.internal.ChannelUtilsBase;
import com.ibm.ws.channelfw.internal.UtilsChainListener;
import com.ibm.ws.channelfw.internal.chains.EndPointMgrImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.channelfw.ChannelFactory;
import com.ibm.wsspi.channelfw.ChannelFramework;
import com.ibm.wsspi.channelfw.ChannelFrameworkFactory;
import com.ibm.wsspi.channelfw.exception.ChannelException;
import com.ibm.wsspi.channelfw.exception.ChannelFactoryException;
import com.ibm.wsspi.channelfw.exception.RetryableChannelException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

public final class ChannelUtils
extends ChannelUtilsBase {
    private static final TraceComponent tc = Tr.register(ChannelUtils.class, (String)"ChannelFramework", (String)"com.ibm.ws.channelfw.internal.resources.ChannelfwMessages");
    private static Map<String, Object> delayedConfig = new HashMap<String, Object>();
    private static Map<String, Boolean> delayedStarts = new HashMap<String, Boolean>();
    private static boolean delayCheckSignaled = false;
    private static ChannelUtils chTrace = new ChannelUtils();
    public static final String CHANNEL_PREFIX = "channel.";
    public static final String CHAIN_PREFIX = "chain.";
    public static final String GROUP_PREFIX = "group.";
    public static final String FACTORY_PREFIX = "factory.";
    public static final String ENDPOINT_PREFIX = "endpoint.";

    public static void printDebugStackTrace(TraceComponent logger, Throwable t, String message) {
        if (logger.isDebugEnabled()) {
            chTrace.traceDebugStack(logger, t, message);
        }
    }

    public static void printThreadStackTrace(TraceComponent logger, Thread thread) {
        if (logger.isDebugEnabled()) {
            chTrace.traceThreadStack(logger, thread);
        }
    }

    public static void displayChannels(TraceComponent logger, ChannelFramework cfw, String message, String prefix) {
        if (logger.isDebugEnabled()) {
            chTrace.traceChannels(logger, cfw, message, prefix);
        }
    }

    public static void displayChains(TraceComponent logger, ChannelFramework cfw, Class<?> factory, String message, String prefix) {
        if (logger.isDebugEnabled()) {
            chTrace.traceChains((Object)logger, cfw, factory, message, prefix);
        }
    }

    public static void displayChains(TraceComponent logger, ChannelFramework cfw, String groupName, String message, String prefix) {
        if (logger.isDebugEnabled()) {
            chTrace.traceChains((Object)logger, cfw, groupName, message, prefix);
        }
    }

    public static void displayChains(TraceComponent logger, ChainData[] chains, String message, String prefix) {
        if (!logger.isDebugEnabled()) {
            return;
        }
        if (chains == null || chains.length == 0) {
            chTrace.debugTrace(logger, prefix + ", no chains to trace (" + message + ")", new Object[0]);
        } else {
            chTrace.traceChains(logger, Arrays.asList(chains), message, prefix);
        }
    }

    public static void displayChains(TraceComponent logger, List<?> lchain, String message, String prefix) {
        if (logger.isDebugEnabled()) {
            chTrace.traceChains(logger, lchain, message, prefix);
        }
    }

    @Override
    protected void debugTrace(Object logTool, String msg, Object ... parameters) {
        Tr.debug((TraceComponent)((TraceComponent)logTool), (String)msg, (Object[])parameters);
    }

    public static String[] extractList(String input, char delimiter) {
        int end = input.indexOf(delimiter);
        if (-1 == end) {
            return new String[]{input.trim()};
        }
        LinkedList<String> output = new LinkedList<String>();
        int start = 0;
        do {
            output.add(input.substring(start, end).trim());
        } while (-1 != (end = input.indexOf(delimiter, start = end + 1)));
        if (start < input.length()) {
            output.add(input.substring(start).trim());
        }
        return output.toArray(new String[output.size()]);
    }

    public static String extractKey(String input) {
        int index = input.indexOf(61);
        if (-1 == index) {
            return input.trim();
        }
        return input.substring(0, index).trim();
    }

    public static String extractValue(String input) {
        int index = input.indexOf(61) + 1;
        if (0 == index || index >= input.length()) {
            return "";
        }
        return input.substring(index).trim();
    }

    private static Map<String, Map<String, String[]>> extractConfig(Map<String, Object> config) {
        HashMap<String, String[]> factories = new HashMap<String, String[]>();
        HashMap<String, String[]> channels = new HashMap<String, String[]>();
        HashMap<String, String[]> chains = new HashMap<String, String[]>();
        HashMap<String, String[]> groups = new HashMap<String, String[]>();
        HashMap<String, String[]> endpoints = new HashMap<String, String[]>();
        for (Map.Entry<String, Object> entry : config.entrySet()) {
            String name;
            String key = entry.getKey();
            if (key.startsWith(CHANNEL_PREFIX)) {
                name = key.substring(CHANNEL_PREFIX.length()).trim();
                if (0 == name.length()) continue;
                channels.put(name, (String[])entry.getValue());
                continue;
            }
            if (key.startsWith(CHAIN_PREFIX)) {
                name = key.substring(CHAIN_PREFIX.length()).trim();
                if (0 == name.length()) continue;
                chains.put(name, (String[])entry.getValue());
                continue;
            }
            if (key.startsWith(GROUP_PREFIX)) {
                name = key.substring(GROUP_PREFIX.length()).trim();
                if (0 == name.length()) continue;
                groups.put(name, (String[])entry.getValue());
                continue;
            }
            if (key.startsWith(FACTORY_PREFIX)) {
                name = key.substring(FACTORY_PREFIX.length()).trim();
                if (0 == name.length()) continue;
                factories.put(name, (String[])entry.getValue());
                continue;
            }
            if (!key.startsWith(ENDPOINT_PREFIX) || 0 == (name = key.substring(ENDPOINT_PREFIX.length()).trim()).length()) continue;
            endpoints.put(name, (String[])entry.getValue());
        }
        HashMap<String, Map<String, String[]>> rc = new HashMap<String, Map<String, String[]>>();
        rc.put("factories", factories);
        rc.put("channels", channels);
        rc.put("chains", chains);
        rc.put("groups", groups);
        rc.put("endpoints", endpoints);
        return rc;
    }

    private static synchronized Map<String, List<String>> load(Map<String, Object> config, boolean start, boolean restart) {
        boolean bTrace = TraceComponent.isAnyTracingEnabled();
        if (bTrace && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Loading CHFW config from " + config), (Object[])new Object[0]);
        }
        Map<String, Map<String, String[]>> parsed = ChannelUtils.extractConfig(config);
        if (restart) {
            ChannelUtils.unloadChains(parsed.get("chains").keySet().iterator());
        }
        List<String> createdFactories = ChannelUtils.loadFactories(parsed.get("factories"));
        List<String> createdEndpoints = ChannelUtils.loadEndPoints(parsed.get("endpoints"));
        List<String> createdChannels = ChannelUtils.loadChannels(parsed.get("channels"));
        List<String> createdChains = ChannelUtils.loadChains(parsed.get("chains"), start, restart);
        List<String> createdGroups = ChannelUtils.loadGroups(parsed.get("groups"), start, restart);
        HashMap<String, List<String>> rc = new HashMap<String, List<String>>();
        rc.put("factory", createdFactories);
        rc.put("channel", createdChannels);
        rc.put("chain", createdChains);
        rc.put("group", createdGroups);
        rc.put("endpoint", createdEndpoints);
        return rc;
    }

    public static synchronized Map<String, List<String>> loadConfig(Map<String, Object> config) {
        boolean bTrace = TraceComponent.isAnyTracingEnabled();
        boolean usingDelayed = false;
        if (null == config) {
            if (delayedConfig.isEmpty()) {
                return null;
            }
            if (bTrace && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"loadConfig using delayed config information", (Object[])new Object[0]);
            }
            config = delayedConfig;
            delayedConfig = new HashMap<String, Object>();
            usingDelayed = true;
        }
        Map<String, List<String>> rc = ChannelUtils.load(config, false, true);
        if (usingDelayed && !delayedStarts.isEmpty()) {
            ChannelUtils.start(rc, false, false);
        }
        return rc;
    }

    private static Map<String, List<String>> start(Map<String, List<String>> config, boolean start, boolean restart) {
        boolean bTrace = TraceComponent.isAnyTracingEnabled();
        ChannelFramework cf = ChannelFrameworkFactory.getChannelFramework();
        List<String> groups = config.get("group");
        LinkedList<String> chains = new LinkedList<String>((Collection)config.get("chain"));
        for (String group : groups) {
            ChainGroupData cgd = cf.getChainGroup(group);
            if (null == cgd) continue;
            for (ChainData cd : cgd.getChains()) {
                if (chains.contains(cd.getName())) continue;
                chains.add(cd.getName());
            }
        }
        for (String chain : chains) {
            ChainData cd = cf.getChain(chain);
            if (null == cd || cd.getType().equals(FlowType.OUTBOUND)) continue;
            boolean doStart = start;
            boolean doRestart = restart;
            Boolean bRestart = delayedStarts.remove(chain);
            if (null != bRestart) {
                doStart = true;
                doRestart = bRestart;
            }
            if (!doStart) continue;
            try {
                if (cf.isChainRunning(cd)) {
                    if (!doRestart) continue;
                    if (bTrace && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Restarting chain; " + chain), (Object[])new Object[0]);
                    }
                    cf.stopChain(cd, 0L);
                    cf.startChain(cd);
                    continue;
                }
                cf.startChain(cd);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"ChannelUtils.start", (String)"chain", (Object[])new Object[]{chain, cf});
                if (!bTrace || !tc.isEventEnabled()) continue;
                Tr.event((TraceComponent)tc, (String)("Exception during start; " + chain + " " + e), (Object[])new Object[0]);
            }
        }
        HashMap<String, List<String>> rc = new HashMap<String, List<String>>();
        rc.put("chain", chains);
        rc.put("group", groups);
        return rc;
    }

    public static Map<String, List<String>> startConfig(Dictionary<String, Object> properties, boolean restart) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (properties instanceof Hashtable) {
            map.putAll((Hashtable)properties);
        } else {
            Enumeration<String> keys = properties.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                map.put(key, properties.get(key));
            }
        }
        return ChannelUtils.startConfig(map, restart);
    }

    public static Map<String, List<String>> startConfig(Map<String, Object> config, boolean restart) {
        Map<String, List<String>> rc = ChannelUtils.load(config, true, restart);
        return ChannelUtils.start(rc, true, restart);
    }

    private static boolean hasChanged(String[] oldValues, String[] newValues) {
        if (oldValues.length != newValues.length) {
            return true;
        }
        for (String oldattr : oldValues) {
            boolean changed = true;
            for (String newattr : newValues) {
                if (!oldattr.equalsIgnoreCase(newattr)) continue;
                changed = false;
                break;
            }
            if (!changed) continue;
            return true;
        }
        return false;
    }

    public static synchronized Map<String, List<String>> startConfig(Map<String, Object> oldconfig, Map<String, Object> newconfig) {
        if (null == oldconfig) {
            return ChannelUtils.startConfig(newconfig, false);
        }
        boolean bTrace = TraceComponent.isAnyTracingEnabled();
        if (bTrace && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"startConfig(old,new)", (Object[])new Object[0]);
        }
        ChannelFramework cf = ChannelFrameworkFactory.getChannelFramework();
        Map<String, Map<String, String[]>> oldc = ChannelUtils.extractConfig(oldconfig);
        Map<String, Map<String, String[]>> newc = ChannelUtils.extractConfig(newconfig);
        LinkedList<Object> runningChains = new LinkedList<Object>();
        Map<String, String[]> oldlist = oldc.get("chains");
        Map<String, String[]> newlist = newc.get("chains");
        LinkedList<String> chainsToDelete = new LinkedList<String>();
        LinkedList<String> chainsToStop = new LinkedList<String>();
        HashMap<String, String[]> chainsToStart = new HashMap<String, String[]>();
        for (String string : oldlist.keySet()) {
            if (newlist.containsKey(string)) continue;
            if (bTrace && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Defunct chain; " + string), (Object[])new Object[0]);
            }
            chainsToDelete.add(string);
        }
        for (Map.Entry entry : newlist.entrySet()) {
            String newname = (String)entry.getKey();
            String[] oldobj = oldlist.get(newname);
            if (null == oldobj) {
                if (bTrace && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("New chain; " + (String)newname), (Object[])new Object[0]);
                }
                chainsToStart.put(newname, (String[])entry.getValue());
                continue;
            }
            String[] newobj = (String[])entry.getValue();
            if (ChannelUtils.hasChanged(oldobj, newobj)) {
                if (bTrace && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Chain updated; " + newname), (Object[])new Object[0]);
                }
                chainsToStop.add(newname);
                chainsToStart.put(newname, newobj);
                continue;
            }
            if (bTrace && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Chain unchanged; " + newname), (Object[])new Object[0]);
            }
            runningChains.add(newname);
        }
        LinkedList<String> runningChannels = new LinkedList<String>();
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        oldlist = oldc.get("channels");
        newlist = newc.get("channels");
        for (String oldname : oldlist.keySet()) {
            if (newlist.containsKey(oldname)) continue;
            if (bTrace && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Defunct channel: " + oldname), (Object[])new Object[0]);
            }
            try {
                ChainData[] existingchains;
                for (ChainData cd : existingchains = cf.getAllChains(oldname)) {
                    String name = cd.getName();
                    if (bTrace && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Deleting chain; " + name), (Object[])new Object[0]);
                    }
                    chainsToDelete.add(name);
                    chainsToStart.remove(name);
                    runningChains.remove(name);
                }
            }
            catch (ChannelException e) {
                FFDCFilter.processException((Throwable)e, (String)"ChannelUtils.startConfig", (String)"defunctChannel", (Object[])new Object[]{oldname, cf});
                if (!bTrace || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Unable to query defunct channel; " + e), (Object[])new Object[0]);
            }
        }
        for (String newname : newlist.keySet()) {
            String[] oldobj = oldlist.get(newname);
            String[] newobj = newlist.get(newname);
            if (null == oldobj) {
                if (bTrace && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("New channel; " + newname), (Object[])new Object[0]);
                }
                hashMap.put(newname, newobj);
                continue;
            }
            if (ChannelUtils.hasChanged(oldobj, newobj)) {
                if (bTrace && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Channel updated; " + newname), (Object[])new Object[0]);
                }
                hashMap.put(newname, newobj);
                try {
                    ChainData[] c;
                    for (ChainData chainData : c = cf.getAllChains(newname)) {
                        String name = chainData.getName();
                        if (!runningChains.contains(name)) continue;
                        if (bTrace && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Restarting chain; " + name), (Object[])new Object[0]);
                        }
                        chainsToStop.add(name);
                        runningChains.remove(name);
                        if (chainsToStart.containsKey(name)) continue;
                        chainsToStart.put(name, newc.get("chains").get(name));
                    }
                    continue;
                }
                catch (ChannelException e) {
                    FFDCFilter.processException((Throwable)e, (String)"ChannelUtils.startConfig", (String)"updatedChannel", (Object[])new Object[]{newname, cf});
                    if (!bTrace || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Unable to query updated channel; " + e), (Object[])new Object[0]);
                    continue;
                }
            }
            if (bTrace && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Channel unchanged; " + newname), (Object[])new Object[0]);
            }
            runningChannels.add(newname);
        }
        LinkedList<String> runningFactories = new LinkedList<String>();
        HashMap<String, String[]> factoriesToCreate = new HashMap<String, String[]>();
        oldlist = oldc.get("factories");
        newlist = newc.get("factories");
        for (String oldname : oldlist.keySet()) {
            if (newlist.containsKey(oldname) || !bTrace || !tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("Defunct factory; " + oldname), (Object[])new Object[0]);
        }
        for (String newname : newlist.keySet()) {
            String[] oldobj = oldlist.get(newname);
            String[] newobj = newlist.get(newname);
            if (null == oldobj) {
                if (bTrace && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("New factory; " + newname), (Object[])new Object[0]);
                }
                factoriesToCreate.put(newname, newobj);
                continue;
            }
            if (ChannelUtils.hasChanged(oldobj, newobj)) {
                if (bTrace && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Factory updated; " + newname), (Object[])new Object[0]);
                }
                factoriesToCreate.put(newname, newobj);
                continue;
            }
            if (bTrace && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Factory unchanged; " + newname), (Object[])new Object[0]);
            }
            runningFactories.add(newname);
        }
        LinkedList<String> runningEndpoints = new LinkedList<String>();
        HashMap<String, String[]> endpointsToCreate = new HashMap<String, String[]>();
        LinkedList<String> updatedEndpoints = new LinkedList<String>();
        oldlist = oldc.get("endpoints");
        newlist = newc.get("endpoints");
        for (String oldname : oldlist.keySet()) {
            if (newlist.containsKey(oldname)) continue;
            if (bTrace && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Defunct endpoint; " + oldname), (Object[])new Object[0]);
            }
            EndPointMgrImpl.getRef().removeEndPoint(oldname);
        }
        for (String newname : newlist.keySet()) {
            String[] oldobj = oldlist.get(newname);
            String[] stringArray = newlist.get(newname);
            if (null == oldobj) {
                if (bTrace && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("New endpoint; " + newname), (Object[])new Object[0]);
                }
                endpointsToCreate.put(newname, stringArray);
                continue;
            }
            if (ChannelUtils.hasChanged(oldobj, stringArray)) {
                if (bTrace && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Endpoint updated; " + newname), (Object[])new Object[0]);
                }
                endpointsToCreate.put(newname, stringArray);
                updatedEndpoints.add(newname);
                continue;
            }
            if (bTrace && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Endpoint unchanged; " + newname), (Object[])new Object[0]);
            }
            runningEndpoints.add(newname);
        }
        runningEndpoints.addAll(ChannelUtils.loadEndPoints(endpointsToCreate));
        if (!updatedEndpoints.isEmpty()) {
            Map<String, String[]> newchains = newc.get("chains");
            Map<String, String[]> newchannels = newc.get("channels");
            for (String string : runningChains) {
                String ep;
                ChainData cd = cf.getChain(string);
                ChannelData[] channels = null != cd ? cd.getChannelList() : null;
                if (null == channels || 0 >= channels.length || null == (ep = (String)channels[0].getPropertyBag().get("endPointName")) || !updatedEndpoints.contains(ep)) continue;
                if (bTrace && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Chain [" + string + "] using updated endpoint " + ep), (Object[])new Object[0]);
                }
                chainsToStop.add(string);
                chainsToStart.put(string, newchains.get(string));
                String tcp = channels[0].getExternalName();
                hashMap.put(tcp, newchannels.get(tcp));
            }
        }
        HashMap<String, List<String>> rc = new HashMap<String, List<String>>();
        if (!chainsToDelete.isEmpty()) {
            ChannelUtils.unloadChains(chainsToDelete.iterator());
        }
        ChannelUtils.stopChains(chainsToStop, -1L, null);
        for (String chainname : chainsToStop) {
            runningChains.remove(chainname);
            try {
                ChainData chainData = cf.getChain(chainname);
                if (null == chainData) continue;
                cf.destroyChain(chainData);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"ChannelUtils.startConfig", (String)"stopChain", (Object[])new Object[]{chainname, cf});
                if (bTrace && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Error destroying chain; " + chainname + " " + exception), (Object[])new Object[0]);
                }
                chainsToStart.remove(chainname);
            }
        }
        runningFactories.addAll(ChannelUtils.loadFactories(factoriesToCreate));
        rc.put("factory", runningFactories);
        rc.put("endpoint", runningEndpoints);
        runningChannels.addAll(ChannelUtils.loadChannels(hashMap));
        rc.put("channel", runningChannels);
        runningChains.addAll(ChannelUtils.loadChains(chainsToStart, true, true));
        for (String chain : chainsToStart.keySet()) {
            try {
                if (bTrace && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Starting chain: " + chain), (Object[])new Object[0]);
                }
                cf.startChain(chain);
            }
            catch (RetryableChannelException retryableChannelException) {
                if (!bTrace || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Error starting chain; " + retryableChannelException), (Object[])new Object[0]);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"ChannelUtils.startConfig", (String)"chain", (Object[])new Object[]{chain, cf});
                if (!bTrace || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Error starting chain; " + exception), (Object[])new Object[0]);
            }
        }
        rc.put("chain", runningChains);
        rc.put("group", new LinkedList());
        return rc;
    }

    public static void stopChains(List<String> chains, long timeout, final Runnable runOnStop) {
        ExecutorService executorService;
        if (null == chains || chains.isEmpty()) {
            return;
        }
        boolean bTrace = TraceComponent.isAnyTracingEnabled();
        ChannelFramework cf = ChannelFrameworkFactory.getChannelFramework();
        final long quiesceTimeout = -1L == timeout ? cf.getDefaultChainQuiesceTimeout() : timeout;
        final UtilsChainListener listener = new UtilsChainListener();
        for (String chain : chains) {
            ChainData cd = cf.getChain(chain);
            if (null == cd) {
                if (!bTrace || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Skipping unknown chain; " + chain), (Object[])new Object[0]);
                continue;
            }
            if (FlowType.OUTBOUND.equals(cd.getType()) || !cf.isChainRunning(cd)) {
                if (!bTrace || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Skipping chain; " + chain), (Object[])new Object[0]);
                continue;
            }
            try {
                if (bTrace && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Stopping chain: " + chain), (Object[])new Object[0]);
                }
                if (quiesceTimeout > 0L) {
                    listener.watchChain(cd);
                }
                cf.stopChain(cd, quiesceTimeout);
            }
            catch (Throwable t) {
                if (!bTrace || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Error stopping chain: " + t), (Object[])new Object[0]);
            }
        }
        if (runOnStop != null && null != (executorService = CHFWBundle.getExecutorService())) {
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    listener.waitOnChains(quiesceTimeout);
                    runOnStop.run();
                }
            };
            executorService.execute(runner);
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Waiting for chains to stop", (Object[])new Object[0]);
        }
        listener.waitOnChains(quiesceTimeout);
    }

    private static List<String> loadFactories(Map<String, String[]> factories) {
        boolean bTrace = TraceComponent.isAnyTracingEnabled();
        ChannelFramework cf = ChannelFrameworkFactory.getChannelFramework();
        ArrayList<String> createdFactories = new ArrayList<String>(factories.size());
        for (Map.Entry<String, String[]> entry : factories.entrySet()) {
            Class<? extends ChannelFactory> factoryType = cf.lookupFactory(entry.getKey());
            if (null == factoryType) {
                if (bTrace && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Delay; missing factory type " + entry.getKey()), (Object[])new Object[0]);
                }
                delayedConfig.put(FACTORY_PREFIX + entry.getKey(), entry.getValue());
                createdFactories.add(entry.getKey());
                continue;
            }
            String[] props = entry.getValue();
            for (int i = 0; i < props.length; ++i) {
                String key = ChannelUtils.extractKey(props[i]);
                String value = ChannelUtils.extractValue(props[i]);
                if (null == key || null == value) continue;
                try {
                    cf.updateChannelFactoryProperty(factoryType, key, value);
                    continue;
                }
                catch (ChannelFactoryException e) {
                    FFDCFilter.processException((Throwable)e, (String)"ChannelUtils.loadFactories", (String)"update", (Object[])new Object[]{entry, cf});
                    if (!bTrace || !tc.isEventEnabled()) continue;
                    Tr.event((TraceComponent)tc, (String)("Unable to update factory prop; " + factoryType + " " + key + "=" + value), (Object[])new Object[0]);
                }
            }
            try {
                cf.getChannelFactory(factoryType);
                createdFactories.add(entry.getKey());
            }
            catch (ChannelFactoryException channelFactoryException) {}
        }
        return createdFactories;
    }

    private static EndPointInfo defineEndPoint(EndPointMgr epm, String name, String[] config) {
        String host = null;
        String port = null;
        for (int i = 0; i < config.length; ++i) {
            String key = ChannelUtils.extractKey(config[i]);
            if ("host".equalsIgnoreCase(key)) {
                host = ChannelUtils.extractValue(config[i]);
                continue;
            }
            if (!"port".equalsIgnoreCase(key)) continue;
            port = ChannelUtils.extractValue(config[i]);
        }
        return epm.defineEndPoint(name, host, Integer.parseInt(port));
    }

    private static List<String> loadEndPoints(Map<String, String[]> endpoints) {
        boolean bTrace = TraceComponent.isAnyTracingEnabled();
        EndPointMgr epm = EndPointMgrImpl.getRef();
        ArrayList<String> createdEndpoints = new ArrayList<String>(endpoints.size());
        for (Map.Entry<String, String[]> entry : endpoints.entrySet()) {
            try {
                EndPointInfo ep = ChannelUtils.defineEndPoint(epm, entry.getKey(), entry.getValue());
                createdEndpoints.add(ep.getName());
            }
            catch (IllegalArgumentException e) {
                FFDCFilter.processException((Throwable)e, (String)"ChannelUtils.loadEndPoints", (String)"create", (Object[])new Object[]{epm, entry});
                if (!bTrace || !tc.isEventEnabled()) continue;
                Tr.event((TraceComponent)tc, (String)("Unable to load endpoint: " + e), (Object[])new Object[0]);
            }
        }
        return createdEndpoints;
    }

    private static List<String> loadChannels(Map<String, String[]> channels) {
        boolean bTrace = TraceComponent.isAnyTracingEnabled();
        ChannelFramework cf = ChannelFrameworkFactory.getChannelFramework();
        ArrayList<String> createdChannels = new ArrayList<String>(channels.size());
        boolean fireMissingEvent = false;
        EndPointMgr epm = EndPointMgrImpl.getRef();
        for (Map.Entry<String, String[]> entry : channels.entrySet()) {
            String channel = entry.getKey();
            HashMap<Object, Object> props = new HashMap<Object, Object>();
            int weight = -1;
            Class<? extends ChannelFactory> factoryType = null;
            for (String prop : entry.getValue()) {
                String key = ChannelUtils.extractKey(prop);
                String value = ChannelUtils.extractValue(prop);
                if ("type".equalsIgnoreCase(key)) {
                    if (null != factoryType) continue;
                    factoryType = cf.lookupFactory(value);
                    continue;
                }
                if ("endpoint".equalsIgnoreCase(key)) {
                    if (props.containsKey("hostname")) continue;
                    if (null != epm) {
                        EndPointInfo ep = epm.getEndPoint(value);
                        if (null != ep) {
                            if (bTrace && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Using endpoint: " + ep), (Object[])new Object[0]);
                            }
                            props.put("endPointName", value);
                            props.put("hostname", ep.getHost());
                            props.put("port", String.valueOf(ep.getPort()));
                            continue;
                        }
                        if (!bTrace || !tc.isEventEnabled()) continue;
                        Tr.event((TraceComponent)tc, (String)("Unknown endpoint: " + value), (Object[])new Object[0]);
                        continue;
                    }
                    if (!bTrace || !tc.isEventEnabled()) continue;
                    Tr.event((TraceComponent)tc, (String)("Unable to convert endpoint: " + value), (Object[])new Object[0]);
                    continue;
                }
                if ("weight".equalsIgnoreCase(key)) {
                    if (0 > weight) continue;
                    try {
                        weight = Integer.parseInt(value);
                    }
                    catch (NumberFormatException nfe) {
                        FFDCFilter.processException((Throwable)nfe, (String)"ChannelUtils.loadChannels", (String)"weight", (Object[])new Object[]{entry, cf});
                        if (!bTrace || !tc.isEventEnabled()) continue;
                        Tr.event((TraceComponent)tc, (String)("Invalid discrimination weight: " + value), (Object[])new Object[0]);
                    }
                    continue;
                }
                props.put(key, value);
            }
            if (null == factoryType) {
                if (bTrace && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Delay; channel missing factory; " + channel), (Object[])new Object[0]);
                }
                delayedConfig.put(CHANNEL_PREFIX + channel, entry.getValue());
                createdChannels.add(channel);
                fireMissingEvent = true;
                continue;
            }
            if (0 > weight) {
                weight = 10;
            }
            try {
                ChannelData cd = cf.getChannel(channel);
                if (null == cd) {
                    cd = cf.addChannel(channel, factoryType, props, weight);
                } else {
                    cf.updateAllChannelProperties(channel, props);
                }
                createdChannels.add(channel);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"ChannelUtils.loadChannels", (String)"update", (Object[])new Object[]{entry, cf});
                if (!bTrace || !tc.isEventEnabled()) continue;
                Tr.event((TraceComponent)tc, (String)("Unable to add channel: " + channel + "; " + e), (Object[])new Object[0]);
            }
        }
        if (fireMissingEvent) {
            ChannelUtils.fireMissingEvent();
        }
        return createdChannels;
    }

    private static void fireMissingEvent() {
        if (delayCheckSignaled) {
            return;
        }
        ScheduledEventService scheduler = CHFWBundle.getScheduleService();
        if (null != scheduler) {
            delayCheckSignaled = true;
            ChannelFrameworkImpl cf = (ChannelFrameworkImpl)ChannelFrameworkFactory.getChannelFramework();
            scheduler.schedule(CHFWEventHandler.EVENT_CHECK_MISSING, cf.getMissingConfigDelay(), TimeUnit.MILLISECONDS);
        }
    }

    private static void unloadChains(Iterator<String> chains) {
        boolean bTrace = TraceComponent.isAnyTracingEnabled();
        ChannelFramework cf = ChannelFrameworkFactory.getChannelFramework();
        LinkedList<String> runningChains = new LinkedList<String>();
        while (chains.hasNext()) {
            ChainData cd = cf.getChain(chains.next());
            if (null == cd || !FlowType.INBOUND.equals(cd.getType())) continue;
            if (bTrace && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Unloading chain; " + cd.getName()), (Object[])new Object[0]);
            }
            try {
                if (cf.isChainRunning(cd)) {
                    runningChains.add(cd.getName());
                    continue;
                }
                cf.destroyChain(cd);
                cf.removeChain(cd);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"ChannelUtils", (String)"unloadChains", (Object[])new Object[]{cd, cf});
                if (!bTrace || !tc.isEventEnabled()) continue;
                Tr.event((TraceComponent)tc, (String)("Unable to remove chain; " + cd.getName()), (Object[])new Object[0]);
            }
        }
        ChannelUtils.stopChains(runningChains, -1L, null);
        for (String name : runningChains) {
            ChainData cd = cf.getChain(name);
            if (bTrace && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Unloading stopped chain; " + name), (Object[])new Object[0]);
            }
            try {
                cf.destroyChain(cd);
                cf.removeChain(cd);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"ChannelUtils", (String)"unloadChains", (Object[])new Object[]{cd, cf});
                if (!bTrace || !tc.isEventEnabled()) continue;
                Tr.event((TraceComponent)tc, (String)("Unable to remove chain; " + name), (Object[])new Object[0]);
            }
        }
    }

    private static List<String> loadChains(Map<String, String[]> chains, boolean start, boolean restart) {
        boolean bTrace = TraceComponent.isAnyTracingEnabled();
        ChannelFramework cf = ChannelFrameworkFactory.getChannelFramework();
        ArrayList<String> createdChains = new ArrayList<String>(chains.size());
        for (Map.Entry<String, String[]> entry : chains.entrySet()) {
            String chain = entry.getKey();
            FlowType flow = FlowType.INBOUND;
            boolean enable = true;
            boolean missingChannels = false;
            String[] chanList = null;
            block3: for (String prop : entry.getValue()) {
                String key = ChannelUtils.extractKey(prop);
                String value = ChannelUtils.extractValue(prop);
                if ("enable".equalsIgnoreCase(key)) {
                    enable = Boolean.parseBoolean(value);
                    continue;
                }
                if ("channels".equalsIgnoreCase(key)) {
                    for (String channel : chanList = ChannelUtils.extractList(value, ',')) {
                        if (null != cf.getChannel(channel)) continue;
                        if (bTrace && tc.isEventEnabled()) {
                            Tr.event((TraceComponent)tc, (String)("Chain contains missing channel: " + channel), (Object[])new Object[0]);
                        }
                        chanList = null;
                        missingChannels = true;
                        continue block3;
                    }
                    continue;
                }
                if (!"flow".equalsIgnoreCase(key)) continue;
                flow = "inbound".equalsIgnoreCase(value) ? FlowType.INBOUND : FlowType.OUTBOUND;
            }
            if (null == chanList) {
                if (!missingChannels) {
                    if (!bTrace || !tc.isEventEnabled()) continue;
                    Tr.event((TraceComponent)tc, (String)("Chain had no channels; " + chain), (Object[])new Object[0]);
                    continue;
                }
                if (bTrace && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Delay; chain missing channels; " + chain), (Object[])new Object[0]);
                }
                if (start) {
                    delayedStarts.put(chain, restart);
                }
                delayedConfig.put(CHAIN_PREFIX + chain, entry.getValue());
                createdChains.add(chain);
                continue;
            }
            try {
                ChainData cd = cf.getChain(chain);
                cd = null == cd ? cf.addChain(chain, flow, chanList) : cf.updateChain(chain, chanList);
                cd.setEnabled(enable);
                createdChains.add(chain);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"ChannelUtils.loadChains", (String)"create", (Object[])new Object[]{entry, cf});
                if (!bTrace || !tc.isEventEnabled()) continue;
                Tr.event((TraceComponent)tc, (String)("Unable to add chain " + chain + "; " + e), (Object[])new Object[0]);
            }
        }
        return createdChains;
    }

    private static List<String> loadGroups(Map<String, String[]> groups, boolean start, boolean restart) {
        boolean bTrace = TraceComponent.isAnyTracingEnabled();
        ChannelFramework cf = ChannelFrameworkFactory.getChannelFramework();
        ArrayList<String> createdGroups = new ArrayList<String>(groups.size());
        for (Map.Entry<String, String[]> entry : groups.entrySet()) {
            String group = entry.getKey();
            ArrayList<String> chains = new ArrayList<String>(entry.getValue().length);
            LinkedList<String> delayed = new LinkedList<String>();
            for (String chain : entry.getValue()) {
                if (null != cf.getChain(chain)) {
                    chains.add(chain);
                    continue;
                }
                delayed.add(chain);
            }
            if (!delayed.isEmpty()) {
                if (bTrace && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Delay; group missing chains; " + group), (Object[])new Object[0]);
                }
                if (start) {
                    delayedStarts.put(group, restart);
                }
                delayedConfig.put(GROUP_PREFIX + group, delayed.toArray(new String[delayed.size()]));
                createdGroups.add(group);
            }
            if (0 == chains.size()) {
                if (!bTrace || !tc.isEventEnabled()) continue;
                Tr.event((TraceComponent)tc, (String)("Group has no current chains; " + group), (Object[])new Object[0]);
                continue;
            }
            try {
                ChainGroupData cgd = cf.getChainGroup(group);
                if (null == cgd) {
                    cgd = cf.addChainGroup(group, chains.toArray(new String[chains.size()]));
                } else {
                    for (String newchain : chains) {
                        cf.addChainToGroup(group, newchain);
                    }
                }
                createdGroups.add(group);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"ChannelUtils.loadGroups", (String)"add", (Object[])new Object[]{entry, cf});
                if (!bTrace || !tc.isEventEnabled()) continue;
                Tr.event((TraceComponent)tc, (String)("Unable to configure group " + group + "; " + e), (Object[])new Object[0]);
            }
        }
        return createdGroups;
    }

    public static synchronized void checkMissingConfig() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Checking for missing config", (Object[])new Object[0]);
        }
        if (delayedConfig.isEmpty()) {
            return;
        }
        delayCheckSignaled = false;
        ChannelFramework cf = ChannelFrameworkFactory.getChannelFramework();
        Map<String, Map<String, String[]>> parsed = ChannelUtils.extractConfig(delayedConfig);
        for (Map.Entry<String, String[]> entry : parsed.get("channels").entrySet()) {
            for (String prop : entry.getValue()) {
                String factory;
                if (!"type".equals(ChannelUtils.extractKey(prop)) || null != cf.lookupFactory(factory = ChannelUtils.extractValue(prop)) || !tc.isWarningEnabled()) continue;
                Tr.warning((TraceComponent)tc, (String)"missing.factory", (Object[])new Object[]{factory});
            }
        }
    }
}

