/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.io.async;

import java.security.AccessController;
import java.security.PrivilegedAction;

class AsyncProperties {
    static final String aio_handle_unavailable = "Unable to get socket handle";
    static final String aio_invalid_mode = "Mode must be one of 'r' or 'rw' ";
    static final String aio_internal_error = "Async IO Internal Error";
    static final String aio_direct_buffers_only = "Only direct buffers allowed";
    static final String aio_error_setting_buffer_position = "Failed to set new buffer position";
    static final String aio_operation_failed = "Async IO operation failed";
    static final String aio_operation_cancelled = "Async operation was cancelled";
    static final String aio_operation_timedout = "Async operation timed out";
    static final String aio_failed_to_set_buffer_position = "Failed to set new buffer position to {0}";
    static int maxHandlers = 10;
    static int minEventHandlers = 1;
    static int completionTimeout = 0;
    static int timerSleepTime = 1024;
    static int timerBatchSize = 500;
    static int numTimerQueues = 2;
    static boolean timerSleepAlways = true;
    static int maxThreadsWaitingForEvents = 1;
    static boolean disableTimeouts = false;
    static String libraryName = "ibmaio";
    static int COMPLETION_KEY_POOL_SIZE_DEFAULT = 4096;
    static String sCompKeyPoolSize = null;
    static int maximumBatchedEvents = 32;
    static int maxIdentifiers;

    AsyncProperties() {
    }

    static {
        AccessController.doPrivileged(new PrivSysPropCheck());
        maxIdentifiers = 256;
    }

    static class PrivSysPropCheck
    implements PrivilegedAction<Object> {
        @Override
        public Object run() {
            if (System.getProperty("com.ibm.io.async.AIOTimerSleepTime") != null) {
                timerSleepTime = Integer.parseInt(System.getProperty("com.ibm.io.async.AIOTimerSleepTime"));
            }
            if (System.getProperty("com.ibm.io.async.AIOTimerBatchSize") != null) {
                timerBatchSize = Integer.parseInt(System.getProperty("com.ibm.io.async.AIOTimerBatchSize"));
            }
            if (System.getProperty("com.ibm.io.async.AIOTimerNumQueues") != null) {
                numTimerQueues = Integer.parseInt(System.getProperty("com.ibm.io.async.AIOTimerNumQueues"));
            }
            timerSleepAlways = Boolean.parseBoolean(System.getProperty("com.ibm.io.async.AIOTimerSleepAlways"));
            maxThreadsWaitingForEvents = System.getProperty("com.ibm.io.async.AIOMaxThreadsWaitingForEvents") != null ? Integer.parseInt(System.getProperty("com.ibm.io.async.AIOMaxThreadsWaitingForEvents")) : Runtime.getRuntime().availableProcessors();
            disableTimeouts = Boolean.parseBoolean(System.getProperty("com.ibm.io.async.AIODisableTimeouts"));
            if (System.getProperty("com.ibm.io.async.AIOCompKeyPoolSize") != null) {
                sCompKeyPoolSize = System.getProperty("com.ibm.io.async.AIOCompKeyPoolSize");
            }
            if (System.getProperty("com.ibm.io.async.AIOMaxBatchedCompletedEvents") != null) {
                maximumBatchedEvents = Integer.parseInt(System.getProperty("com.ibm.io.async.AIOMaxBatchedCompletedEvents"));
            }
            if (System.getProperty("com.ibm.io.async.AIOHandlerCompletionTimeout") != null) {
                completionTimeout = Integer.parseInt(System.getProperty("com.ibm.io.async.AIOHandlerCompletionTimeout"));
            }
            return null;
        }
    }
}

