/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.ParameterNameProvider;
import javax.validation.TraversableResolver;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorContext;
import org.apache.bval.IntrospectorMetaBeanFactory;
import org.apache.bval.MetaBeanBuilder;
import org.apache.bval.MetaBeanFactory;
import org.apache.bval.MetaBeanFinder;
import org.apache.bval.MetaBeanManager;
import org.apache.bval.jsr.ApacheFactoryContext$createMetaBeanFactory$$Ljava_lang_Class$_ACTION;
import org.apache.bval.jsr.ApacheFactoryContext$org_apache_bval_util_reflection_Reflection$$getClassLoader$$Ljava_lang_Class$_ACTION;
import org.apache.bval.jsr.ApacheValidatorFactory;
import org.apache.bval.jsr.ClassValidator;
import org.apache.bval.jsr.JsrMetaBeanFactory;
import org.apache.bval.util.reflection.Reflection;
import org.apache.bval.xml.XMLMetaBeanBuilder;
import org.apache.bval.xml.XMLMetaBeanFactory;
import org.apache.bval.xml.XMLMetaBeanManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.commons.weaver.privilizer.Privileged;
import org.apache.commons.weaver.privilizer.Privilized;
import org.apache.commons.weaver.privilizer.Privilizing;

@Privilizing(value={@Privilizing.CallTo(value=Reflection.class)})
@Privilized(value="DYNAMIC")
public class ApacheFactoryContext
implements ValidatorContext {
    private final ApacheValidatorFactory factory;
    private final MetaBeanFinder metaBeanFinder;
    private MessageInterpolator messageInterpolator;
    private TraversableResolver traversableResolver;
    private ParameterNameProvider parameterNameProvider;
    private ConstraintValidatorFactory constraintValidatorFactory;

    public ApacheFactoryContext(ApacheValidatorFactory factory) {
        this.factory = factory;
        this.metaBeanFinder = this.buildMetaBeanFinder();
    }

    protected ApacheFactoryContext(ApacheValidatorFactory factory, MetaBeanFinder metaBeanFinder) {
        this.factory = factory;
        this.metaBeanFinder = metaBeanFinder;
    }

    public ApacheValidatorFactory getFactory() {
        return this.factory;
    }

    public final MetaBeanFinder getMetaBeanFinder() {
        return this.metaBeanFinder;
    }

    public ValidatorContext messageInterpolator(MessageInterpolator messageInterpolator) {
        this.messageInterpolator = messageInterpolator;
        return this;
    }

    public ValidatorContext traversableResolver(TraversableResolver traversableResolver) {
        this.traversableResolver = traversableResolver;
        return this;
    }

    public ValidatorContext constraintValidatorFactory(ConstraintValidatorFactory constraintValidatorFactory) {
        this.constraintValidatorFactory = constraintValidatorFactory;
        return this;
    }

    public ValidatorContext parameterNameProvider(ParameterNameProvider parameterNameProvider) {
        this.parameterNameProvider = parameterNameProvider;
        return this;
    }

    public ConstraintValidatorFactory getConstraintValidatorFactory() {
        return this.constraintValidatorFactory == null ? this.factory.getConstraintValidatorFactory() : this.constraintValidatorFactory;
    }

    public Validator getValidator() {
        return new ClassValidator(this);
    }

    public MessageInterpolator getMessageInterpolator() {
        return this.messageInterpolator == null ? this.factory.getMessageInterpolator() : this.messageInterpolator;
    }

    public TraversableResolver getTraversableResolver() {
        return this.traversableResolver == null ? this.factory.getTraversableResolver() : this.traversableResolver;
    }

    public ParameterNameProvider getParameterNameProvider() {
        return this.parameterNameProvider == null ? this.factory.getParameterNameProvider() : this.parameterNameProvider;
    }

    boolean isTreatMapsLikeBeans() {
        return Boolean.parseBoolean(this.factory.getProperties().get("apache.bval.treat-maps-like-beans"));
    }

    protected MetaBeanFinder buildMetaBeanFinder() {
        boolean enableMetaBeansXml;
        String[] factoryClassNames;
        ArrayList<MetaBeanFactory> builders = new ArrayList<MetaBeanFactory>();
        if (Boolean.parseBoolean(this.factory.getProperties().get("apache.bval.enable-introspector"))) {
            builders.add(new IntrospectorMetaBeanFactory());
        }
        if ((factoryClassNames = StringUtils.split((String)this.factory.getProperties().get("apache.bval.metabean-factory-classnames"))) != null) {
            for (String clsName : factoryClassNames) {
                Class<?> factoryClass = this.loadClass(clsName);
                builders.add((MetaBeanFactory)this.createMetaBeanFactory(factoryClass));
            }
        }
        boolean jsrFound = false;
        for (MetaBeanFactory builder : builders) {
            jsrFound |= builder instanceof JsrMetaBeanFactory;
        }
        if (!jsrFound) {
            builders.add(new JsrMetaBeanFactory(this));
        }
        if (enableMetaBeansXml = Boolean.parseBoolean(this.factory.getProperties().get("apache.bval.enable-metabeans-xml"))) {
            XMLMetaBeanManagerCreator.addFactory(builders);
        }
        return this.createMetaBeanManager(builders);
    }

    protected MetaBeanFinder createMetaBeanManager(List<MetaBeanFactory> builders) {
        if (Boolean.parseBoolean(this.factory.getProperties().get("apache.bval.enable-metabeans-xml"))) {
            return XMLMetaBeanManagerCreator.createXMLMetaBeanManager(builders);
        }
        return new MetaBeanManager(new MetaBeanBuilder(builders.toArray(new MetaBeanFactory[builders.size()])));
    }

    @Privileged
    private <F extends MetaBeanFactory> F createMetaBeanFactory(Class<F> clazz) {
        if (!(System.getSecurityManager() != null)) {
            return this.__privileged_createMetaBeanFactory(clazz);
        }
        return (F)((MetaBeanFactory)AccessController.doPrivileged(new ApacheFactoryContext$createMetaBeanFactory$$Ljava_lang_Class$_ACTION(this, clazz)));
    }

    static /* synthetic */ MetaBeanFactory __privileged_access$0(ApacheFactoryContext apacheFactoryContext, Class clazz) {
        return apacheFactoryContext.__privileged_createMetaBeanFactory(clazz);
    }

    private <F extends MetaBeanFactory> F __privileged_createMetaBeanFactory(Class<F> cls) {
        try {
            Constructor c = ConstructorUtils.getMatchingAccessibleConstructor(cls, (Class[])new Class[]{this.getClass()});
            if (c != null) {
                return (F)((MetaBeanFactory)c.newInstance(this));
            }
            c = ConstructorUtils.getMatchingAccessibleConstructor(cls, (Class[])new Class[]{this.getFactory().getClass()});
            if (c != null) {
                return (F)((MetaBeanFactory)c.newInstance(this.getFactory()));
            }
            return (F)((MetaBeanFactory)cls.newInstance());
        }
        catch (Exception e) {
            throw new ValidationException((Throwable)e);
        }
    }

    private Class<?> loadClass(String className) {
        try {
            return Class.forName(className, true, ApacheFactoryContext.org_apache_bval_util_reflection_Reflection$$getClassLoader(ApacheFactoryContext.class));
        }
        catch (ClassNotFoundException ex) {
            throw new ValidationException("Unable to load class: " + className, (Throwable)ex);
        }
    }

    @Privileged
    private static /* synthetic */ ClassLoader org_apache_bval_util_reflection_Reflection$$getClassLoader(Class<?> clazz) {
        if (!(System.getSecurityManager() != null)) {
            return ApacheFactoryContext.__privileged_org_apache_bval_util_reflection_Reflection$$getClassLoader(clazz);
        }
        return (ClassLoader)AccessController.doPrivileged(new ApacheFactoryContext$org_apache_bval_util_reflection_Reflection$$getClassLoader$$Ljava_lang_Class$_ACTION(clazz));
    }

    static /* synthetic */ ClassLoader __privileged_access$1(Class clazz) {
        return ApacheFactoryContext.__privileged_org_apache_bval_util_reflection_Reflection$$getClassLoader(clazz);
    }

    private static /* synthetic */ ClassLoader __privileged_org_apache_bval_util_reflection_Reflection$$getClassLoader(Class<?> clazz) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return classLoader == null ? clazz.getClassLoader() : classLoader;
    }

    private static class XMLMetaBeanManagerCreator {
        private XMLMetaBeanManagerCreator() {
        }

        static void addFactory(List<MetaBeanFactory> builders) {
            builders.add((MetaBeanFactory)new XMLMetaBeanFactory());
        }

        protected static MetaBeanManager createXMLMetaBeanManager(List<MetaBeanFactory> builders) {
            return new XMLMetaBeanManager(new XMLMetaBeanBuilder(builders.toArray(new MetaBeanFactory[builders.size()])));
        }
    }
}

