/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.cdi;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.interceptor.AroundConstruct;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;
import javax.validation.executable.ExecutableType;
import javax.validation.executable.ExecutableValidator;
import javax.validation.executable.ValidateOnExecution;
import javax.validation.metadata.ConstructorDescriptor;
import javax.validation.metadata.MethodDescriptor;
import org.apache.bval.cdi.BValBinding;
import org.apache.bval.cdi.BValExtension;
import org.apache.bval.cdi.BValInterceptor$org_apache_bval_util_reflection_Reflection$$getConstructor$$Ljava_lang_Class$arrayOfLjava_lang_Class$_ACTION;
import org.apache.bval.cdi.BValInterceptor$org_apache_bval_util_reflection_Reflection$$getDeclaredMethod$$Ljava_lang_Class$Ljava_lang_String$arrayOfLjava_lang_Class$_ACTION;
import org.apache.bval.jsr.util.ClassHelper;
import org.apache.bval.jsr.util.Proxies;
import org.apache.bval.util.reflection.Reflection;
import org.apache.commons.weaver.privilizer.Privileged;
import org.apache.commons.weaver.privilizer.Privilized;
import org.apache.commons.weaver.privilizer.Privilizing;

@Interceptor
@BValBinding
@Priority(value=4800)
@Privilizing(value={@Privilizing.CallTo(value=Reflection.class)})
@Privilized(value="DYNAMIC")
public class BValInterceptor {
    private final Map<Method, Boolean> methodConfiguration = new ConcurrentHashMap<Method, Boolean>();
    private Set<ExecutableType> classConfiguration;
    private Boolean constructorValidated;
    @Inject
    private Validator validator;
    @Inject
    private BValExtension globalConfiguration;
    private ExecutableValidator executableValidator;

    @AroundConstruct
    public Object construct(InvocationContext context) throws Exception {
        Constructor constructor = context.getConstructor();
        Class targetClass = constructor.getDeclaringClass();
        if (!this.isConstructorValidated(targetClass, constructor)) {
            return context.proceed();
        }
        ConstructorDescriptor constraints = this.validator.getConstraintsForClass(targetClass).getConstraintsForConstructor((Class[])constructor.getParameterTypes());
        if (constraints == null) {
            return context.proceed();
        }
        this.initExecutableValidator();
        Set violations = this.executableValidator.validateConstructorParameters(constructor, context.getParameters(), new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
        Object result = context.proceed();
        Set violations2 = this.executableValidator.validateConstructorReturnValue(constructor, context.getTarget(), new Class[0]);
        if (!violations2.isEmpty()) {
            throw new ConstraintViolationException(violations2);
        }
        return result;
    }

    @AroundInvoke
    public Object invoke(InvocationContext context) throws Throwable {
        Method method = context.getMethod();
        Class<?> targetClass = Proxies.classFor(context.getTarget().getClass());
        if (!this.isMethodValidated(targetClass, method)) {
            return context.proceed();
        }
        MethodDescriptor constraintsForMethod = this.validator.getConstraintsForClass(targetClass).getConstraintsForMethod(method.getName(), (Class[])method.getParameterTypes());
        if (constraintsForMethod == null) {
            return context.proceed();
        }
        this.initExecutableValidator();
        Set violations = this.executableValidator.validateParameters(context.getTarget(), method, context.getParameters(), new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
        Object result = context.proceed();
        Set violations2 = this.executableValidator.validateReturnValue(context.getTarget(), method, result, new Class[0]);
        if (!violations2.isEmpty()) {
            throw new ConstraintViolationException(violations2);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isConstructorValidated(Class<?> targetClass, Constructor<?> constructor) throws NoSuchMethodException {
        this.initClassConfig(targetClass);
        if (this.constructorValidated == null) {
            BValInterceptor bValInterceptor = this;
            synchronized (bValInterceptor) {
                if (this.constructorValidated == null) {
                    List<ExecutableType> types;
                    ValidateOnExecution annotation = BValInterceptor.org_apache_bval_util_reflection_Reflection$$getConstructor(targetClass, constructor.getParameterTypes()).getAnnotation(ValidateOnExecution.class);
                    this.constructorValidated = annotation == null ? Boolean.valueOf(this.classConfiguration.contains(ExecutableType.CONSTRUCTORS)) : Boolean.valueOf((types = Arrays.asList(annotation.type())).contains(ExecutableType.CONSTRUCTORS) || types.contains(ExecutableType.IMPLICIT) || types.contains(ExecutableType.ALL));
                }
            }
        }
        return this.constructorValidated;
    }

    @Privileged
    private static /* synthetic */ <T> Constructor<T> org_apache_bval_util_reflection_Reflection$$getConstructor(Class<T> clazz, Class<?>[] classArray) {
        if (!(System.getSecurityManager() != null)) {
            return BValInterceptor.__privileged_org_apache_bval_util_reflection_Reflection$$getConstructor(clazz, classArray);
        }
        return (Constructor)AccessController.doPrivileged(new BValInterceptor$org_apache_bval_util_reflection_Reflection$$getConstructor$$Ljava_lang_Class$arrayOfLjava_lang_Class$_ACTION(clazz, classArray));
    }

    static /* synthetic */ Constructor __privileged_access$0(Class clazz, Class[] classArray) {
        return BValInterceptor.__privileged_org_apache_bval_util_reflection_Reflection$$getConstructor(clazz, classArray);
    }

    private static /* synthetic */ <T> Constructor<T> __privileged_org_apache_bval_util_reflection_Reflection$$getConstructor(Class<T> clazz, Class<?>[] classArray) {
        try {
            return clazz.getConstructor(classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isMethodValidated(Class<?> targetClass, Method method) throws NoSuchMethodException {
        this.initClassConfig(targetClass);
        Boolean methodConfig = this.methodConfiguration.get(method);
        if (methodConfig == null) {
            BValInterceptor bValInterceptor = this;
            synchronized (bValInterceptor) {
                methodConfig = this.methodConfiguration.get(method);
                if (methodConfig == null) {
                    List<Class<?>> classHierarchy = ClassHelper.fillFullClassHierarchyAsList(new ArrayList(), targetClass);
                    Class<?> lastClassWithTheMethod = null;
                    Collections.reverse(classHierarchy);
                    ValidateOnExecution validateOnExecution = null;
                    for (Class<?> c : classHierarchy) {
                        try {
                            validateOnExecution = BValInterceptor.org_apache_bval_util_reflection_Reflection$$getDeclaredMethod(c, method.getName(), method.getParameterTypes()).getAnnotation(ValidateOnExecution.class);
                            if (lastClassWithTheMethod == null) {
                                lastClassWithTheMethod = c;
                            }
                            if (validateOnExecution == null) continue;
                            lastClassWithTheMethod = null;
                            break;
                        }
                        catch (Throwable h) {
                        }
                    }
                    if (validateOnExecution == null && lastClassWithTheMethod != null) {
                        validateOnExecution = lastClassWithTheMethod.getAnnotation(ValidateOnExecution.class);
                    }
                    if (validateOnExecution == null) {
                        methodConfig = BValInterceptor.doValidMethod(method, this.classConfiguration);
                    } else {
                        EnumSet<ExecutableType> config = EnumSet.noneOf(ExecutableType.class);
                        for (ExecutableType type : validateOnExecution.type()) {
                            if (ExecutableType.NONE == type) continue;
                            if (ExecutableType.ALL == type) {
                                config.add(ExecutableType.NON_GETTER_METHODS);
                                config.add(ExecutableType.GETTER_METHODS);
                                break;
                            }
                            if (ExecutableType.IMPLICIT == type) {
                                config.add(ExecutableType.NON_GETTER_METHODS);
                                if (lastClassWithTheMethod != null) continue;
                                config.add(ExecutableType.GETTER_METHODS);
                                continue;
                            }
                            config.add(type);
                        }
                        methodConfig = BValInterceptor.doValidMethod(method, config);
                    }
                }
                this.methodConfiguration.put(method, methodConfig);
            }
        }
        return methodConfig;
    }

    @Privileged
    private static /* synthetic */ Method org_apache_bval_util_reflection_Reflection$$getDeclaredMethod(Class<?> clazz, String string, Class<?>[] classArray) {
        if (!(System.getSecurityManager() != null)) {
            return BValInterceptor.__privileged_org_apache_bval_util_reflection_Reflection$$getDeclaredMethod(clazz, string, classArray);
        }
        return (Method)AccessController.doPrivileged(new BValInterceptor$org_apache_bval_util_reflection_Reflection$$getDeclaredMethod$$Ljava_lang_Class$Ljava_lang_String$arrayOfLjava_lang_Class$_ACTION(clazz, string, classArray));
    }

    static /* synthetic */ Method __privileged_access$1(Class clazz, String string, Class[] classArray) {
        return BValInterceptor.__privileged_org_apache_bval_util_reflection_Reflection$$getDeclaredMethod(clazz, string, classArray);
    }

    private static /* synthetic */ Method __privileged_org_apache_bval_util_reflection_Reflection$$getDeclaredMethod(Class<?> clazz, String string, Class<?>[] classArray) {
        try {
            return clazz.getDeclaredMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initClassConfig(Class<?> targetClass) {
        if (this.classConfiguration == null) {
            BValInterceptor bValInterceptor = this;
            synchronized (bValInterceptor) {
                if (this.classConfiguration == null) {
                    this.classConfiguration = EnumSet.noneOf(ExecutableType.class);
                    ValidateOnExecution annotation = targetClass.getAnnotation(ValidateOnExecution.class);
                    if (annotation == null) {
                        this.classConfiguration.addAll(this.globalConfiguration.getGlobalExecutableTypes());
                    } else {
                        for (ExecutableType type : annotation.type()) {
                            if (ExecutableType.NONE == type) continue;
                            if (ExecutableType.ALL == type) {
                                this.classConfiguration.add(ExecutableType.CONSTRUCTORS);
                                this.classConfiguration.add(ExecutableType.NON_GETTER_METHODS);
                                this.classConfiguration.add(ExecutableType.GETTER_METHODS);
                                break;
                            }
                            if (ExecutableType.IMPLICIT == type) {
                                this.classConfiguration.add(ExecutableType.CONSTRUCTORS);
                                this.classConfiguration.add(ExecutableType.NON_GETTER_METHODS);
                                continue;
                            }
                            this.classConfiguration.add(type);
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initExecutableValidator() {
        if (this.executableValidator == null) {
            BValInterceptor bValInterceptor = this;
            synchronized (bValInterceptor) {
                if (this.executableValidator == null) {
                    this.executableValidator = this.validator.forExecutables();
                }
            }
        }
    }

    private static boolean doValidMethod(Method method, Set<ExecutableType> config) {
        return BValInterceptor.isGetter(method) ? config.contains(ExecutableType.GETTER_METHODS) : config.contains(ExecutableType.NON_GETTER_METHODS);
    }

    private static boolean isGetter(Method method) {
        String name = method.getName();
        return method.getParameterTypes().length == 0 && !Void.TYPE.equals(method.getReturnType()) && (name.startsWith("get") || name.startsWith("is") && Boolean.TYPE.equals(method.getReturnType()));
    }
}

