/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.xml.internal;

import com.ibm.websphere.config.ConfigUpdateException;
import com.ibm.websphere.config.ConfigValidationException;
import com.ibm.websphere.config.WSConfigurationHelper;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.config.admin.SystemConfigSupport;
import com.ibm.ws.config.xml.internal.BaseConfiguration;
import com.ibm.ws.config.xml.internal.BundleProcessor;
import com.ibm.ws.config.xml.internal.ChangeHandler;
import com.ibm.ws.config.xml.internal.ConfigEvaluator;
import com.ibm.ws.config.xml.internal.ConfigParserTolerableException;
import com.ibm.ws.config.xml.internal.ConfigRefresher;
import com.ibm.ws.config.xml.internal.ConfigRetriever;
import com.ibm.ws.config.xml.internal.ConfigUpdater;
import com.ibm.ws.config.xml.internal.ConfigValidator;
import com.ibm.ws.config.xml.internal.ConfigVariableRegistry;
import com.ibm.ws.config.xml.internal.DefaultConfiguration;
import com.ibm.ws.config.xml.internal.ErrorHandler;
import com.ibm.ws.config.xml.internal.ExtendedMetatypeManager;
import com.ibm.ws.config.xml.internal.MetaTypeRegistry;
import com.ibm.ws.config.xml.internal.ServerConfiguration;
import com.ibm.ws.config.xml.internal.ServerXMLConfiguration;
import com.ibm.ws.config.xml.internal.WSConfigurationHelperImpl;
import com.ibm.ws.config.xml.internal.XMLConfigParser;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.location.VariableRegistry;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.OnErrorUtil;
import java.io.InputStream;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Hashtable;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.util.tracker.ServiceTracker;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
class SystemConfiguration {
    static final TraceComponent tc = Tr.register(SystemConfiguration.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
    private final ServerXMLConfiguration serverXMLConfig;
    private final ConfigVariableRegistry variableRegistry;
    private final DefaultConfiguration defaultConfiguration;
    private final BundleProcessor bundleProcessor;
    private final ConfigUpdater configUpdater;
    private final ChangeHandler changeHandler;
    private final ConfigValidator validator;
    private final ExtendedMetatypeManager extendedMetatypeManager;
    private final ConfigRetriever configRetriever;
    private final ConfigRefresher configRefresher;
    private ServiceTracker<WsLocationAdmin, WsLocationAdmin> locationTracker = null;
    private ServiceTracker<VariableRegistry, VariableRegistry> variableRegistryTracker = null;
    private ServiceTracker<MetaTypeRegistry, MetaTypeRegistry> metatypeRegistryTracker = null;
    static final long serialVersionUID = -2497058531404779824L;

    SystemConfiguration(BundleContext bc, SystemConfigSupport caSupport, ConfigurationAdmin configAdmin, OnErrorUtil.OnError onError) {
        if (onError != OnErrorUtil.OnError.WARN) {
            ErrorHandler.INSTANCE.setOnError(onError);
        }
        this.locationTracker = new ServiceTracker(bc, WsLocationAdmin.class.getName(), null);
        this.locationTracker.open();
        this.variableRegistryTracker = new ServiceTracker(bc, VariableRegistry.class.getName(), null);
        this.variableRegistryTracker.open();
        this.metatypeRegistryTracker = new ServiceTracker(bc, MetaTypeRegistry.class.getName(), null);
        this.metatypeRegistryTracker.open();
        WsLocationAdmin locationService = (WsLocationAdmin)this.locationTracker.getService();
        VariableRegistry variableRegistryService = (VariableRegistry)this.variableRegistryTracker.getService();
        ConfigVariableRegistry variableRegistry = new ConfigVariableRegistry(variableRegistryService, bc.getDataFile("variableCache"));
        MetaTypeRegistry metatypeRegistry = (MetaTypeRegistry)this.metatypeRegistryTracker.getService();
        this.extendedMetatypeManager = new ExtendedMetatypeManager(metatypeRegistry, configAdmin);
        this.configRetriever = new ConfigRetriever(caSupport, configAdmin, variableRegistry);
        this.validator = new ConfigValidator(metatypeRegistry);
        XMLConfigParser parser = new XMLConfigParser(locationService);
        this.serverXMLConfig = new ServerXMLConfiguration(bc, locationService, parser);
        ConfigEvaluator ce = new ConfigEvaluator(this.configRetriever, metatypeRegistry, variableRegistry, this.serverXMLConfig);
        this.configUpdater = new ConfigUpdater(ce, caSupport, variableRegistry, metatypeRegistry, this.extendedMetatypeManager);
        this.changeHandler = new ChangeHandler(caSupport, variableRegistry, this.extendedMetatypeManager, this.configRetriever, this.validator, this.configUpdater, metatypeRegistry);
        this.variableRegistry = variableRegistry;
        this.defaultConfiguration = new DefaultConfiguration(parser);
        this.validator.setConfiguration(this.serverXMLConfig);
        this.bundleProcessor = new BundleProcessor(bc, this, locationService, variableRegistryService, this.configUpdater, this.changeHandler, this.validator, this.configRetriever);
        this.configRefresher = new ConfigRefresher(bc, this.changeHandler, this.serverXMLConfig);
        this.extendedMetatypeManager.init();
        WSConfigurationHelperImpl wsConfigHelper = new WSConfigurationHelperImpl(metatypeRegistry, ce, this.bundleProcessor);
        this.registerService(bc, WSConfigurationHelper.class.getName(), wsConfigHelper);
    }

    private void registerService(BundleContext bc, String name, Object serviceInstance) {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("service.vendor", "IBM");
        bc.registerService(name, serviceInstance, properties);
    }

    void start() throws ConfigUpdateException, ConfigValidationException, ConfigParserTolerableException {
        boolean reprocessConfig;
        if (this.serverXMLConfig.hasConfigRoot()) {
            this.configRefresher.start();
            this.serverXMLConfig.loadInitialConfiguration(this.variableRegistry);
        }
        if (this.serverXMLConfig.isModified() || this.variableRegistry.variablesChanged()) {
            this.variableRegistry.clearVariableCache();
            this.changeHandler.updateAtStartup(this.serverXMLConfig.getConfiguration());
            this.serverXMLConfig.setConfigReadTime();
            reprocessConfig = true;
        } else {
            reprocessConfig = false;
        }
        this.bundleProcessor.startProcessor(reprocessConfig);
    }

    void stop() {
        this.bundleProcessor.stopProcessor();
        this.configRefresher.stop();
        if (null != this.locationTracker) {
            this.locationTracker.close();
            this.locationTracker = null;
        }
        if (null != this.variableRegistryTracker) {
            this.variableRegistryTracker.close();
            this.variableRegistryTracker = null;
        }
        if (null != this.metatypeRegistryTracker) {
            this.metatypeRegistryTracker.close();
            this.metatypeRegistryTracker = null;
        }
    }

    ServerConfiguration getServerConfiguration() {
        return this.serverXMLConfig.getConfiguration();
    }

    ServerConfiguration copyServerConfiguration() {
        return this.serverXMLConfig.copyConfiguration();
    }

    Collection<String> fetchConfigurationFilePaths() {
        return this.serverXMLConfig.getFilesToMonitor();
    }

    BaseConfiguration loadDefaultConfiguration(Bundle bundle) throws ConfigUpdateException, ConfigValidationException {
        return this.defaultConfiguration.load(bundle, this.serverXMLConfig, this.variableRegistry);
    }

    BaseConfiguration addDefaultConfiguration(String pid, Dictionary<String, String> props) throws ConfigUpdateException {
        return this.defaultConfiguration.add(pid, props, this.serverXMLConfig, this.variableRegistry);
    }

    BaseConfiguration addDefaultConfiguration(InputStream defaultConfig) throws ConfigValidationException, ConfigUpdateException {
        return this.defaultConfiguration.add(defaultConfig, this.serverXMLConfig, this.variableRegistry);
    }

    void bundleRemoved(Bundle bundle) {
        BaseConfiguration config = this.serverXMLConfig.getDefaultConfiguration();
        config.remove(this.defaultConfiguration.remove(bundle));
    }

    boolean removeDefaultConfiguration(String pid, String id) throws ConfigUpdateException {
        ServerConfiguration oldConfig = this.serverXMLConfig.copyConfiguration();
        BaseConfiguration cfg = this.serverXMLConfig.getDefaultConfiguration();
        boolean removed = cfg.remove(pid, id);
        BaseConfiguration runtimeCfg = this.defaultConfiguration.getRuntimeDefaultConfiguration(pid);
        if (runtimeCfg != null) {
            runtimeCfg.remove(pid, id);
        }
        if (removed) {
            this.variableRegistry.setDefaultVariables(cfg.getVariables());
            this.removeDefaultConfiguration(oldConfig);
        }
        return removed;
    }

    void removeDefaultConfiguration(ServerConfiguration oldConfig) throws ConfigUpdateException {
        this.changeHandler.removeDefaultConfiguration(oldConfig, this.serverXMLConfig);
    }
}

