/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.xml.internal;

import com.ibm.websphere.config.ConfigEvaluatorException;
import com.ibm.websphere.config.ConfigUpdateException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.config.admin.ConfigID;
import com.ibm.ws.config.admin.ConfigurationDictionary;
import com.ibm.ws.config.admin.ExtendedConfiguration;
import com.ibm.ws.config.admin.SystemConfigSupport;
import com.ibm.ws.config.xml.internal.AttributeValidationException;
import com.ibm.ws.config.xml.internal.ConfigElement;
import com.ibm.ws.config.xml.internal.ConfigEvaluator;
import com.ibm.ws.config.xml.internal.ConfigMergeException;
import com.ibm.ws.config.xml.internal.ConfigVariableRegistry;
import com.ibm.ws.config.xml.internal.ConfigurationInfo;
import com.ibm.ws.config.xml.internal.ExtendedMetatypeManager;
import com.ibm.ws.config.xml.internal.MetaTypeRegistry;
import com.ibm.ws.config.xml.internal.ServerXMLConfiguration;
import com.ibm.ws.config.xml.internal.metatype.ExtendedAttributeDefinition;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.OnErrorUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
class ConfigUpdater {
    private static final TraceComponent tc = Tr.register(ConfigUpdater.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
    private final ConfigEvaluator configEvaluator;
    private final ConfigVariableRegistry variableRegistry;
    private final SystemConfigSupport caSupport;
    private final ExtendedMetatypeManager extendedMetatypeManager;
    private final Set<ConfigEvaluator.UnresolvedPidType> unresolvedReferences = new HashSet<ConfigEvaluator.UnresolvedPidType>();
    private final MetaTypeRegistry metatypeRegistry;
    private final Map<Object, ConfigurationInfo> failedUpdateInfo = new HashMap<Object, ConfigurationInfo>();
    private final Map<Object, ExtendedAttributeDefinition> failedUpdateAttrDef = new HashMap<Object, ExtendedAttributeDefinition>();
    private final List<ConfigurationInfo> retryUpdateInfoList = new ArrayList<ConfigurationInfo>();
    private boolean ranUpdateRetry = false;
    static final long serialVersionUID = 4618814127728183361L;

    public ConfigUpdater(ConfigEvaluator ce, SystemConfigSupport caSupport, ConfigVariableRegistry variableRegistry, MetaTypeRegistry metatypeRegistry, ExtendedMetatypeManager emm) {
        this.configEvaluator = ce;
        this.caSupport = caSupport;
        this.variableRegistry = variableRegistry;
        this.metatypeRegistry = metatypeRegistry;
        this.extendedMetatypeManager = emm;
    }

    @Trivial
    public Collection<ConfigurationInfo> update(boolean encourageUpdates, Collection<ConfigurationInfo> updatedConfigurations) throws ConfigUpdateException {
        Iterator<ConfigEvaluator.UnresolvedPidType> iter = this.unresolvedReferences.iterator();
        while (iter.hasNext()) {
            ConfigEvaluator.UnresolvedPidType ref = iter.next();
            if (ref.permanent()) continue;
            iter.remove();
        }
        return this.update(updatedConfigurations, false, encourageUpdates);
    }

    @FFDCIgnore(value={AttributeValidationException.class, ConfigUpdateException.class, ConfigEvaluatorException.class})
    private Collection<ConfigurationInfo> update(Collection<ConfigurationInfo> updatedConfigurations, boolean failOnError, boolean encourageUpdates) throws ConfigUpdateException {
        ArrayList<ConfigurationInfo> retVal = new ArrayList<ConfigurationInfo>();
        for (ConfigurationInfo info : updatedConfigurations) {
            String nodeName;
            try {
                this.updateConfiguration(info, retVal, encourageUpdates);
            }
            catch (ConfigUpdateException e) {
                nodeName = this.getNodeNameForExceptions(info.configElement);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("update(). Exception while trying to update " + nodeName + " configuration on disk. Exception message = " + e.getMessage()), (Object[])new Object[0]);
                }
                if (failOnError) {
                    throw e;
                }
                Tr.error((TraceComponent)tc, (String)"error.config.update.exception", (Object[])new Object[]{nodeName, e.getMessage(), info.configElement.getId()});
                this.warnIfOldConfigExists(info, nodeName);
            }
            catch (AttributeValidationException e) {
                nodeName = this.getNodeNameForExceptions(info.configElement);
                if (failOnError) {
                    throw new ConfigUpdateException(e);
                }
                Tr.error((TraceComponent)tc, (String)"error.attribute.validation.exception", (Object[])new Object[]{nodeName, e.getAttributeDefintion().getID(), e.getValue(), e.getMessage()});
                this.warnIfOldConfigExists(info, nodeName);
            }
            catch (ConfigEvaluatorException e) {
                nodeName = this.getNodeNameForExceptions(info.configElement);
                if (failOnError) {
                    throw new ConfigUpdateException(e);
                }
                Tr.error((TraceComponent)tc, (String)"error.config.update.exception", (Object[])new Object[]{nodeName, e.getMessage(), info.configElement.getId()});
                this.warnIfOldConfigExists(info, nodeName);
            }
        }
        if (!this.ranUpdateRetry) {
            this.retryFailedUpdate(failOnError);
        }
        this.ranUpdateRetry = false;
        return retVal;
    }

    private void warnIfOldConfigExists(ConfigurationInfo info, String nodeName) {
        ExtendedConfiguration config = null;
        config = info.configElement.getId() == null ? this.caSupport.findConfiguration(info.configElement.getNodeName()) : this.caSupport.lookupConfiguration(info.configElement.getConfigID());
        if (config != null && config.getProperties() != null) {
            Tr.warning((TraceComponent)tc, (String)"warning.old.config.still.in.use", (Object[])new Object[]{nodeName, info.configElement.getId()});
        }
    }

    private String getNodeNameForExceptions(ConfigElement configElement) {
        MetaTypeRegistry.RegistryEntry entry = this.metatypeRegistry.getRegistryEntry(configElement.getNodeName());
        if (entry != null) {
            if (entry.getAlias() != null) {
                return entry.getAlias();
            }
            if (entry.getChildAlias() != null) {
                return entry.getChildAlias();
            }
            return entry.getPid();
        }
        return configElement.getNodeName();
    }

    private void updateConfiguration(ConfigurationInfo info, Collection<ConfigurationInfo> infos, boolean encourageUpdates) throws ConfigEvaluatorException, ConfigUpdateException {
        ConfigEvaluator.EvaluationResult result = this.configEvaluator.evaluate(info.configElement, info.registryEntry);
        this.unresolvedReferences.addAll(result.getAllUnresolvedReferences());
        if (result.isValid()) {
            this.updateConfiguration(result, info, infos, encourageUpdates);
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean updateConfiguration(ConfigEvaluator.EvaluationResult result, ConfigurationInfo info, Collection<ConfigurationInfo> infos, boolean encourageUpdates) throws ConfigUpdateException {
        encourageUpdates &= result.getRegistryEntry() == null || !result.getRegistryEntry().supportsHiddenExtensions();
        boolean nestedUpdates = false;
        boolean propertiesUpdated = false;
        Map<ConfigID, ConfigEvaluator.EvaluationResult> nested = result.getNested();
        for (Map.Entry<ConfigID, ConfigEvaluator.EvaluationResult> entry : nested.entrySet()) {
            ConfigEvaluator.EvaluationResult nestedResult = entry.getValue();
            ExtendedConfiguration nestedConfig = this.caSupport.findConfiguration(nestedResult.getPid());
            if (nestedConfig == null) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Configuration not found: " + nestedResult.getPid()), (Object[])new Object[0]);
                continue;
            }
            ConfigurationInfo nestedInfo = new ConfigurationInfo(nestedResult.getConfigElement(), nestedConfig, nestedResult.getRegistryEntry(), false);
            boolean updated = this.updateConfiguration(nestedResult, nestedInfo, infos, encourageUpdates);
            if (updated && result.getRegistryEntry() != null && result.getRegistryEntry().supportsHiddenExtensions()) {
                updated = false;
            }
            nestedUpdates |= updated;
        }
        ExtendedConfiguration config = info.config;
        config.setInOverridesFile(true);
        Set<ConfigID> oldReferences = config.getReferences();
        Set<ConfigID> newReferences = result.getReferences();
        Dictionary<String, Object> oldProperties = config.getReadOnlyProperties();
        Dictionary<String, Object> newProperties = result.getProperties();
        if (encourageUpdates || nestedUpdates || !ConfigUpdater.equalConfigProperties(oldProperties, newProperties, encourageUpdates) || !ConfigUpdater.equalConfigReferences(oldReferences, newReferences)) {
            propertiesUpdated = true;
            this.crossReference(oldProperties, newProperties);
            this.variableRegistry.updateVariableCache(result.getVariables());
            Dictionary<String, Object> newProp = ConfigUpdater.massageNewConfig(oldProperties, newProperties);
            Set<String> newUniques = this.updateUniqueVariables(info, oldProperties, newProp);
            try {
                config.updateCache(newProp, newReferences, newUniques);
            }
            catch (IOException iOException) {
                void ex;
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.config.xml.internal.ConfigUpdater", (String)"267", (Object)this, (Object[])new Object[]{result, info, infos, encourageUpdates});
                throw new ConfigUpdateException((Exception)ex);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Updated configuration: " + ConfigUpdater.toTraceString(config, result.getConfigElement())), (Object[])new Object[0]);
            }
            if (infos != null) {
                infos.add(info);
            }
        }
        this.extendedMetatypeManager.createSuperTypes(info);
        return propertiesUpdated || nestedUpdates;
    }

    private static Dictionary<String, Object> massageNewConfig(Dictionary<String, Object> oldProps, Dictionary<String, Object> newProps) {
        String key;
        Enumeration<String> keyItr;
        ConfigurationDictionary ret = new ConfigurationDictionary();
        if (oldProps != null) {
            keyItr = oldProps.keys();
            while (keyItr.hasMoreElements()) {
                key = keyItr.nextElement();
                if ((!key.startsWith("config.") || key.equals("config.parentPID")) && !key.startsWith("service.")) continue;
                ret.put(key, oldProps.get(key));
            }
        }
        if (newProps != null) {
            keyItr = newProps.keys();
            while (keyItr.hasMoreElements()) {
                key = keyItr.nextElement();
                ret.put(key, newProps.get(key));
            }
        }
        if (ret.isEmpty()) {
            ret = null;
        } else {
            ret.put("config.source", (Object)"file");
        }
        return ret;
    }

    @Trivial
    private static Map<String, Object> toMap(Dictionary<String, Object> d) {
        if (d == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> ret = new HashMap<String, Object>(d.size());
        Enumeration<String> keyIter = d.keys();
        while (keyIter.hasMoreElements()) {
            String key = keyIter.nextElement();
            ret.put(key, d.get(key));
        }
        return ret;
    }

    private static boolean equalConfigProperties(Dictionary<String, Object> oldProperties, Dictionary<String, Object> newProperties, boolean encourageUpdates) {
        String keyObj;
        if ((oldProperties == null || oldProperties.isEmpty()) && (newProperties == null || newProperties.isEmpty())) {
            return true;
        }
        Map<String, Object> oriMapC = ConfigUpdater.toMap(oldProperties);
        Map<String, Object> newMapC = ConfigUpdater.toMap(newProperties);
        if (oriMapC.isEmpty() && !newMapC.isEmpty()) {
            return false;
        }
        ArrayList<String> removeKeyList = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : oriMapC.entrySet()) {
            keyObj = entry.getKey();
            if (ConfigUpdater.ignoreKey(keyObj, encourageUpdates)) continue;
            if (newMapC.containsKey(keyObj)) {
                if (ConfigUpdater.equalConfigValues(entry.getValue(), newMapC.get(keyObj))) {
                    removeKeyList.add(keyObj);
                    continue;
                }
                return false;
            }
            return false;
        }
        for (Map.Entry<String, Object> entry : removeKeyList) {
            if (entry == null) continue;
            newMapC.remove(entry);
        }
        for (Map.Entry<String, Object> entry : newMapC.entrySet()) {
            keyObj = entry.getKey();
            if (keyObj == null || ConfigUpdater.ignoreKey(keyObj, encourageUpdates)) continue;
            if (oriMapC.containsKey(keyObj)) {
                if (ConfigUpdater.equalConfigValues(entry.getValue(), oriMapC.get(keyObj))) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private static boolean ignoreKey(String keyObj, boolean encourageUpdates) {
        return keyObj.startsWith("config.") && !keyObj.equals("config.parentPID") || keyObj.startsWith("service.") || !encourageUpdates && keyObj.equals("id");
    }

    private static boolean equalConfigReferences(Set<ConfigID> oldReferences, Set<ConfigID> newReferences) {
        if (oldReferences == null || oldReferences.isEmpty()) {
            return newReferences == null || newReferences.isEmpty();
        }
        return oldReferences.equals(newReferences);
    }

    private static boolean equalConfigValues(Object c1, Object c2) {
        if (c1 instanceof String && c2 instanceof String) {
            return c1.equals(c2);
        }
        if (c1 instanceof String[] && c2 instanceof String[]) {
            return Arrays.equals((String[])c1, (String[])c2);
        }
        if (c1 instanceof Map && c2 instanceof Map) {
            return c1.equals(c2);
        }
        if (c1 != null) {
            return c1.equals(c2);
        }
        return c2 == null;
    }

    private Set<String> updateUniqueVariables(ConfigurationInfo info, Dictionary<String, Object> oldProperties, Dictionary<String, Object> newProperties) throws ConfigUpdateException {
        Map<String, ExtendedAttributeDefinition> metaTypeAttributes = info.metaTypeAttributes;
        HashSet<String> uniques = new HashSet<String>();
        if (metaTypeAttributes != null) {
            for (Map.Entry<String, ExtendedAttributeDefinition> entry : metaTypeAttributes.entrySet()) {
                Object newValue;
                ExtendedAttributeDefinition attrDef = entry.getValue();
                if (!attrDef.isUnique()) continue;
                Object oldValue = oldProperties == null ? null : oldProperties.get(attrDef.getID());
                Object object = newValue = newProperties == null ? null : newProperties.get(attrDef.getID());
                if (oldValue != null) {
                    this.variableRegistry.removeUniqueVariable(attrDef, oldValue.toString());
                }
                if (newValue == null) continue;
                String variable = this.variableRegistry.getUniqueVarString(attrDef, newValue.toString());
                String varSymbol = "${" + variable + "}";
                String existing = this.variableRegistry.resolveRawString(varSymbol);
                if (existing == null || existing.equals(varSymbol)) {
                    uniques.add(variable);
                    this.variableRegistry.addVariableInUse(variable);
                    continue;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("updateUniqueVariables(). The value " + newValue + " for attribute " + attrDef.getID() + " is not unique. The update will be retried if possible."), (Object[])new Object[0]);
                }
                this.failedUpdateInfo.put(newValue, info);
                this.failedUpdateAttrDef.put(newValue, attrDef);
            }
        }
        return uniques;
    }

    private static String toTraceString(ExtendedConfiguration config, ConfigElement configElement) {
        if (config.getFactoryPid() == null) {
            return config.getPid();
        }
        StringBuilder builder = new StringBuilder();
        builder.append(config.getFactoryPid());
        if (configElement != null) {
            builder.append("-");
            builder.append(configElement.getId());
        }
        builder.append(" (");
        builder.append(config.getPid());
        builder.append(")");
        return builder.toString();
    }

    public void fireConfigurationEvents(Collection<ConfigurationInfo> allInfos) {
        for (ConfigurationInfo info : allInfos) {
            info.fireEvents(null);
        }
    }

    public void updateSystemVariables(ServerXMLConfiguration serverXMLConfig) throws ConfigMergeException {
        this.variableRegistry.updateSystemVariables(serverXMLConfig.getVariables());
    }

    synchronized void processUnresolvedReferences(OnErrorUtil.OnError onError) throws ConfigUpdateException {
        ArrayList<ConfigurationInfo> infos = new ArrayList<ConfigurationInfo>();
        for (ConfigEvaluator.UnresolvedPidType ref : this.unresolvedReferences) {
            ConfigurationInfo referringConfigInfo = ref.getReferringConfigurationInfo();
            if (referringConfigInfo == null) continue;
            infos.add(referringConfigInfo);
        }
        this.unresolvedReferences.clear();
        this.updateAndFireEvents(infos, onError);
        Iterator<ConfigEvaluator.UnresolvedPidType> iter = this.unresolvedReferences.iterator();
        while (iter.hasNext()) {
            ConfigEvaluator.UnresolvedPidType ref;
            ref = iter.next();
            ref.reportError();
            if (ref.permanent()) continue;
            iter.remove();
        }
    }

    void crossReference(Dictionary<String, Object> oldProperties, Dictionary<String, Object> newProperties) {
        if (oldProperties != null && !this.failedUpdateInfo.isEmpty()) {
            Enumeration<String> keys = oldProperties.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                String oldValue = oldProperties.get(key).toString();
                if (!this.failedUpdateInfo.containsKey(oldValue)) continue;
                String retryValue = oldValue;
                String newValue = newProperties.get(key).toString();
                if (oldValue.equals(newValue)) continue;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("crossReference(). Found a value change match for the value " + retryValue + ". The update for attribute " + this.failedUpdateAttrDef.get(retryValue).getID() + " will be retried."), (Object[])new Object[0]);
                }
                this.retryUpdateInfoList.add(this.failedUpdateInfo.get(retryValue));
                this.failedUpdateInfo.remove(retryValue);
            }
        }
    }

    void retryFailedUpdate(boolean failOnError) throws ConfigUpdateException {
        this.ranUpdateRetry = true;
        if (!this.failedUpdateInfo.isEmpty()) {
            Set<Object> failedUpdates = this.failedUpdateInfo.keySet();
            for (Object value : failedUpdates) {
                ConfigurationInfo info = this.failedUpdateInfo.get(value);
                if (info == null) continue;
                String id = this.failedUpdateAttrDef.get(value).getID();
                Tr.error((TraceComponent)tc, (String)"error.unique.value.conflict", (Object[])new Object[]{id, value});
                String nodeName = this.getNodeNameForExceptions(info.configElement);
                String exceptionMessage = "The value " + value + " for attribute " + id + " is not unique";
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("update(). Exception while trying to update " + nodeName + " configuration on disk. Exception message = " + exceptionMessage), (Object[])new Object[0]);
                }
                if (failOnError) {
                    throw new ConfigUpdateException(exceptionMessage);
                }
                Tr.error((TraceComponent)tc, (String)"error.config.update.exception", (Object[])new Object[]{nodeName, exceptionMessage, info.configElement.getId()});
                this.warnIfOldConfigExists(info, nodeName);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("retryFailedUpdate(). Attempting to retry the following updates: " + this.retryUpdateInfoList), (Object[])new Object[0]);
            }
            this.updateAndFireEvents(this.retryUpdateInfoList, failOnError ? OnErrorUtil.OnError.FAIL : OnErrorUtil.OnError.WARN);
            this.failedUpdateInfo.clear();
        }
        this.retryUpdateInfoList.clear();
    }

    void updateAndFireEvents(List<ConfigurationInfo> infos, OnErrorUtil.OnError onError) throws ConfigUpdateException {
        Collection<ConfigurationInfo> allInfos = this.update(infos, onError == OnErrorUtil.OnError.FAIL, false);
        this.fireConfigurationEvents(allInfos);
    }

    public void fireMetatypeAddedEvents(Set<String> updatedPids) {
        for (String pid : updatedPids) {
            this.caSupport.fireMetatypeAddedEvent(pid);
        }
    }

    public void fireMetatypeDeletedEvents(Set<String> updatedPids) {
        for (String pid : updatedPids) {
            this.caSupport.fireMetatypeRemovedEvent(pid);
        }
    }
}

