/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.wsdl11;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLElement;
import javax.wsdl.extensions.AttributeExtensible;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap12.SOAP12Binding;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.binding.BindingFactory;
import org.apache.cxf.binding.WSDLBindingFactory;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.xmlschema.SchemaCollection;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.service.model.AbstractMessageContainer;
import org.apache.cxf.service.model.AbstractPropertiesHolder;
import org.apache.cxf.service.model.BindingFaultInfo;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.DescriptionInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.FaultInfo;
import org.apache.cxf.service.model.InterfaceInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.service.model.ServiceSchemaInfo;
import org.apache.cxf.service.model.UnwrappedOperationInfo;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.wsdl.WSDLManager;
import org.apache.cxf.wsdl11.SchemaUtil;
import org.apache.cxf.wsdl11.WSDLEndpointFactory;
import org.apache.cxf.wsdl11.WSDLRuntimeException;
import org.apache.cxf.wsdl11.WSDLServiceUtils;
import org.apache.ws.commons.schema.XmlSchemaAnnotated;
import org.apache.ws.commons.schema.XmlSchemaComplexContentExtension;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaSequenceMember;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class WSDLServiceBuilder {
    public static final String WSDL_SCHEMA_LIST = WSDLServiceBuilder.class.getName() + ".SCHEMA";
    public static final String WSDL_DEFINITION = WSDLServiceBuilder.class.getName() + ".DEFINITION";
    public static final String WSDL_SERVICE = WSDLServiceBuilder.class.getName() + ".SERVICE";
    public static final String WSDL_PORTTYPE = WSDLServiceBuilder.class.getName() + ".WSDL_PORTTYPE";
    public static final String WSDL_PORT = WSDLServiceBuilder.class.getName() + ".PORT";
    public static final String WSDL_BINDING = WSDLServiceBuilder.class.getName() + ".BINDING";
    public static final String WSDL_SCHEMA_ELEMENT_LIST = WSDLServiceBuilder.class.getName() + ".SCHEMA_ELEMENTS";
    public static final String WSDL_OPERATION = WSDLServiceBuilder.class.getName() + ".OPERATION";
    public static final String WSDL_BINDING_OPERATION = WSDLServiceBuilder.class.getName() + ".BINDING_OPERATION";
    private static final Logger LOG = LogUtils.getL7dLogger(WSDLServiceBuilder.class);
    private Bus bus;
    private Map<String, Element> schemaList;
    private boolean recordOriginal;
    private boolean allowRefs;
    private boolean ignoreUnknownBindings;
    private Level unwrapLogLevel;
    static final long serialVersionUID = -4019054389766178439L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WSDLServiceBuilder(Bus bus) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.wsdl11.WSDLServiceBuilder", "<init>", new Object[]{bus});
        }
        this.schemaList = new HashMap<String, Element>();
        this.recordOriginal = true;
        this.unwrapLogLevel = Level.FINE;
        this.bus = bus;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.wsdl11.WSDLServiceBuilder", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WSDLServiceBuilder(Bus bus, boolean record) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.wsdl11.WSDLServiceBuilder", "<init>", new Object[]{bus, record});
        }
        this.schemaList = new HashMap<String, Element>();
        this.recordOriginal = true;
        this.unwrapLogLevel = Level.FINE;
        this.bus = bus;
        this.recordOriginal = record;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.wsdl11.WSDLServiceBuilder", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setUnwrapLogLevel(Level l) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.wsdl11.WSDLServiceBuilder", "setUnwrapLogLevel", new Object[]{l});
        }
        this.unwrapLogLevel = l;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.wsdl11.WSDLServiceBuilder", "setUnwrapLogLevel");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setIgnoreUnknownBindings(boolean b) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.wsdl11.WSDLServiceBuilder", "setIgnoreUnknownBindings", new Object[]{b});
        }
        this.ignoreUnknownBindings = b;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.wsdl11.WSDLServiceBuilder", "setIgnoreUnknownBindings");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setAllowElementRefs(boolean b) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.wsdl11.WSDLServiceBuilder", "setAllowElementRefs", new Object[]{b});
        }
        this.allowRefs = b;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.wsdl11.WSDLServiceBuilder", "setAllowElementRefs");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void copyExtensors(AbstractPropertiesHolder info, List<?> extList) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.wsdl11.WSDLServiceBuilder", "copyExtensors", new Object[]{info, extList});
        }
        if (info != null) {
            for (ExtensibilityElement ext : CastUtils.cast(extList, ExtensibilityElement.class)) {
                if (info.containsExtensor((Object)ext)) continue;
                info.addExtensor((Object)ext);
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.wsdl11.WSDLServiceBuilder", "copyExtensors");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void copyExtensionAttributes(AbstractPropertiesHolder info, AttributeExtensible ae) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.wsdl11.WSDLServiceBuilder", "copyExtensionAttributes", new Object[]{info, ae});
        }
        Map attrs = CastUtils.cast((Map)ae.getExtensionAttributes());
        if (!attrs.isEmpty()) {
            info.setExtensionAttributes(attrs);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.wsdl11.WSDLServiceBuilder", "copyExtensionAttributes");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void copyDocumentation(AbstractPropertiesHolder info, WSDLElement el) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.wsdl11.WSDLServiceBuilder", "copyDocumentation", new Object[]{info, el});
        }
        if (el.getDocumentationElement() != null) {
            String doc = DOMUtils.getRawContent((Node)el.getDocumentationElement());
            info.setDocumentation(doc);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.wsdl11.WSDLServiceBuilder", "copyDocumentation");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<ServiceInfo> buildServices(Definition d) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.wsdl11.WSDLServiceBuilder", "buildServices", new Object[]{d});
        }
        DescriptionInfo description = new DescriptionInfo();
        if (this.recordOriginal) {
            description.setProperty(WSDL_DEFINITION, (Object)d);
        }
        description.setName(d.getQName());
        description.setBaseURI(d.getDocumentBaseURI());
        this.copyExtensors((AbstractPropertiesHolder)description, d.getExtensibilityElements());
        this.copyExtensionAttributes((AbstractPropertiesHolder)description, (AttributeExtensible)d);
        ArrayList<ServiceInfo> serviceList = new ArrayList<ServiceInfo>();
        Iterator ite = CastUtils.cast(d.getServices().keySet().iterator());
        while (ite.hasNext()) {
            QName qn = (QName)ite.next();
            serviceList.addAll(this.buildServices(d, qn, null, description));
        }
        ArrayList<ServiceInfo> arrayList = serviceList;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            arrayList = arrayList;
            LOG.exiting("org.apache.cxf.wsdl11.WSDLServiceBuilder", "buildServices", arrayList);
        }
        return arrayList;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<ServiceInfo> buildServices(Definition d, QName name) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.wsdl11.WSDLServiceBuilder", "buildServices", new Object[]{d, name});
        }
        List<ServiceInfo> list = this.buildServices(d, name, null, null);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            list = list;
            LOG.exiting("org.apache.cxf.wsdl11.WSDLServiceBuilder", "buildServices", list);
        }
        return list;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<ServiceInfo> buildServices(Definition d, QName name, QName endpointName) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.wsdl11.WSDLServiceBuilder", "buildServices", new Object[]{d, name, endpointName});
        }
        List<ServiceInfo> list = this.buildServices(d, name, endpointName, null);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            list = list;
            LOG.exiting("org.apache.cxf.wsdl11.WSDLServiceBuilder", "buildServices", list);
        }
        return list;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private List<ServiceInfo> buildServices(Definition d, QName name, QName endpointName, DescriptionInfo description) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.wsdl11.WSDLServiceBuilder", "buildServices", new Object[]{d, name, endpointName, description});
        }
        Service service = d.getService(name);
        if (service == null) {
            org.apache.cxf.common.i18n.Message msg = new org.apache.cxf.common.i18n.Message("MISSING_SERVICE", LOG, new Object[]{name});
            throw new WSDLRuntimeException(msg);
        }
        List<ServiceInfo> list = this.buildServices(d, service, endpointName, description);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            list = list;
            LOG.exiting("org.apache.cxf.wsdl11.WSDLServiceBuilder", "buildServices", list);
        }
        return list;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<ServiceInfo> buildServices(Definition def, Service serv) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.wsdl11.WSDLServiceBuilder", "buildServices", new Object[]{def, serv});
        }
        List<ServiceInfo> list = this.buildServices(def, serv, null, null);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            list = list;
            LOG.exiting("org.apache.cxf.wsdl11.WSDLServiceBuilder", "buildServices", list);
        }
        return list;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<ServiceInfo> buildServices(Definition def, Service serv, QName endpointName) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.wsdl11.WSDLServiceBuilder", "buildServices", new Object[]{def, serv, endpointName});
        }
        List<ServiceInfo> list = this.buildServices(def, serv, endpointName, null);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            list = list;
            LOG.exiting("org.apache.cxf.wsdl11.WSDLServiceBuilder", "buildServices", list);
        }
        return list;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<ServiceInfo> buildMockServices(Definition d) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.wsdl11.WSDLServiceBuilder", "buildMockServices", new Object[]{d});
        }
        ArrayList<ServiceInfo> serviceList = new ArrayList<ServiceInfo>();
        ArrayList<Definition> defList = new ArrayList<Definition>();
        defList.add(d);
        this.parseImports(d, defList);
        for (Definition def : defList) {
            block1: for (Map.Entry entry : def.getPortTypes().entrySet()) {
                PortType portType = def.getPortType((QName)entry.getKey());
                ServiceInfo serviceInfo = this.buildMockService(def, portType);
                serviceList.add(serviceInfo);
                for (Binding b : d.getAllBindings().values()) {
                    if (b.getPortType() != portType) continue;
                    this.buildBinding(serviceInfo, b);
                    continue block1;
                }
            }
            if (def.getPortTypes().size() != 0) continue;
            DescriptionInfo description = new DescriptionInfo();
            if (this.recordOriginal) {
                description.setProperty(WSDL_DEFINITION, (Object)def);
            }
            description.setName(def.getQName());
            description.setBaseURI(def.getDocumentBaseURI());
            this.copyExtensors((AbstractPropertiesHolder)description, def.getExtensibilityElements());
            this.copyExtensionAttributes((AbstractPropertiesHolder)description, (AttributeExtensible)def);
            ServiceInfo service = new ServiceInfo();
            service.setDescription(description);
            if (this.recordOriginal) {
                service.setProperty(WSDL_DEFINITION, (Object)def);
            }
            this.getSchemas(def, service);
            service.setProperty(WSDL_SCHEMA_ELEMENT_LIST, this.schemaList);
            serviceList.add(service);
        }
        ArrayList<ServiceInfo> arrayList = serviceList;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            arrayList = arrayList;
            LOG.exiting("org.apache.cxf.wsdl11.WSDLServiceBuilder", "buildMockServices", arrayList);
        }
        return arrayList;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ServiceInfo buildMockService(Definition def, PortType p) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.wsdl11.WSDLServiceBuilder", "buildMockService", new Object[]{def, p});
        }
        DescriptionInfo description = new DescriptionInfo();
        if (this.recordOriginal) {
            description.setProperty(WSDL_DEFINITION, (Object)def);
        }
        description.setName(def.getQName());
        description.setBaseURI(def.getDocumentBaseURI());
        this.copyExtensors((AbstractPropertiesHolder)description, def.getExtensibilityElements());
        this.copyExtensionAttributes((AbstractPropertiesHolder)description, (AttributeExtensible)def);
        ServiceInfo service = new ServiceInfo();
        service.setDescription(description);
        if (this.recordOriginal) {
            service.setProperty(WSDL_DEFINITION, (Object)def);
        }
        this.getSchemas(def, service);
        service.setProperty(WSDL_SCHEMA_ELEMENT_LIST, this.schemaList);
        this.buildInterface(service, p);
        ServiceInfo serviceInfo = service;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            serviceInfo = serviceInfo;
            LOG.exiting("org.apache.cxf.wsdl11.WSDLServiceBuilder", "buildMockService", serviceInfo);
        }
        return serviceInfo;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private List<ServiceInfo> buildServices(Definition def, Service serv, QName endpointName, DescriptionInfo d) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.wsdl11.WSDLServiceBuilder", "buildServices", new Object[]{def, serv, endpointName, d});
        }
        LinkedHashMap<QName, ServiceInfo> services = new LinkedHashMap<QName, ServiceInfo>();
        DescriptionInfo description = d;
        if (null == description) {
            description = new DescriptionInfo();
            if (this.recordOriginal) {
                description.setProperty(WSDL_DEFINITION, (Object)def);
            }
            description.setName(def.getQName());
            description.setBaseURI(def.getDocumentBaseURI());
            this.copyExtensors((AbstractPropertiesHolder)description, def.getExtensibilityElements());
            this.copyExtensionAttributes((AbstractPropertiesHolder)description, (AttributeExtensible)def);
            HashSet<Definition> done = new HashSet<Definition>();
            done.add(def);
            Collection values = CastUtils.cast(def.getImports().values());
            for (List imports : values) {
                for (Import imp : imports) {
                    if (done.contains(imp.getDefinition())) continue;
                    done.add(imp.getDefinition());
                    this.copyExtensors((AbstractPropertiesHolder)description, imp.getExtensibilityElements());
                    this.copyExtensionAttributes((AbstractPropertiesHolder)description, (AttributeExtensible)imp);
                    this.copyExtensors((AbstractPropertiesHolder)description, imp.getDefinition().getExtensibilityElements());
                    this.copyExtensionAttributes((AbstractPropertiesHolder)description, (AttributeExtensible)imp.getDefinition());
                }
            }
        }
        for (Port port : CastUtils.cast(serv.getPorts().values(), Port.class)) {
            BindingInfo bi;
            ServiceInfo service;
            if (endpointName != null && !endpointName.getLocalPart().equals(port.getName())) continue;
            Binding binding = port.getBinding();
            PortType bindingPt = binding.getPortType();
            if (bindingPt == null) {
                org.apache.cxf.common.i18n.Message msg = new org.apache.cxf.common.i18n.Message("BINDING_MISSING_TYPE", LOG, new Object[]{binding.getQName()});
                throw new WSDLRuntimeException(msg);
            }
            PortType pt = def.getPortType(bindingPt.getQName());
            if (pt == null) {
                pt = bindingPt;
            }
            if ((service = (ServiceInfo)services.get(pt.getQName())) == null) {
                service = new ServiceInfo();
                service.setDescription(description);
                description.getDescribed().add(service);
                if (this.recordOriginal) {
                    service.setProperty(WSDL_DEFINITION, (Object)def);
                    service.setProperty(WSDL_SERVICE, (Object)serv);
                }
                this.getSchemas(def, service);
                this.copyDocumentation((AbstractPropertiesHolder)service, (WSDLElement)serv);
                service.setProperty(WSDL_SCHEMA_ELEMENT_LIST, this.schemaList);
                service.setTargetNamespace(def.getTargetNamespace());
                service.setName(serv.getQName());
                this.copyExtensors((AbstractPropertiesHolder)service, serv.getExtensibilityElements());
                this.copyExtensionAttributes((AbstractPropertiesHolder)service, (AttributeExtensible)serv);
                this.buildInterface(service, pt);
                services.put(pt.getQName(), service);
            }
            if ((bi = service.getBinding(binding.getQName())) == null) {
                bi = this.buildBinding(service, binding);
            }
            this.buildEndpoint(service, bi, port);
        }
        ArrayList<ServiceInfo> arrayList = new ArrayList<ServiceInfo>(services.values());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            arrayList = arrayList;
            LOG.exiting("org.apache.cxf.wsdl11.WSDLServiceBuilder", "buildServices", arrayList);
        }
        return arrayList;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void getSchemas(Definition def, ServiceInfo serviceInfo) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.wsdl11.WSDLServiceBuilder", "getSchemas", new Object[]{def, serviceInfo});
        }
        ServiceSchemaInfo serviceSchemaInfo = null;
        WSDLManager wsdlManager = (WSDLManager)this.bus.getExtension(WSDLManager.class);
        if (wsdlManager != null) {
            serviceSchemaInfo = wsdlManager.getSchemasForDefinition(def);
        }
        if (serviceSchemaInfo == null) {
            SchemaUtil schemaUtil = new SchemaUtil(this.bus, this.schemaList);
            schemaUtil.getSchemas(def, serviceInfo);
            serviceSchemaInfo = new ServiceSchemaInfo();
            serviceSchemaInfo.setSchemaElementList(this.schemaList);
            serviceSchemaInfo.setSchemaCollection(serviceInfo.getXmlSchemaCollection());
            serviceSchemaInfo.setSchemaInfoList(serviceInfo.getSchemas());
            if (wsdlManager != null) {
                wsdlManager.putSchemasForDefinition(def, serviceSchemaInfo);
            }
        } else {
            serviceInfo.setServiceSchemaInfo(serviceSchemaInfo);
            this.schemaList.putAll(serviceSchemaInfo.getSchemaElementList());
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.wsdl11.WSDLServiceBuilder", "getSchemas");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void parseImports(Definition def, List<Definition> defList) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.wsdl11.WSDLServiceBuilder", "parseImports", new Object[]{def, defList});
        }
        ArrayList importList = new ArrayList();
        Collection ilist = CastUtils.cast(def.getImports().values());
        for (List list : ilist) {
            importList.addAll(list);
        }
        for (Import impt : importList) {
            if (defList.contains(impt.getDefinition())) continue;
            defList.add(impt.getDefinition());
            this.parseImports(impt.getDefinition(), defList);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.wsdl11.WSDLServiceBuilder", "parseImports");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public EndpointInfo buildEndpoint(ServiceInfo service, BindingInfo bi, Port port) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.wsdl11.WSDLServiceBuilder", "buildEndpoint", new Object[]{service, bi, port});
        }
        List elements = port.getExtensibilityElements();
        String ns = null;
        DestinationFactory factory = null;
        EndpointInfo ei = null;
        if (null != elements && elements.size() > 0) {
            for (ExtensibilityElement el : CastUtils.cast((List)elements, ExtensibilityElement.class)) {
                ns = el.getElementType().getNamespaceURI();
                try {
                    factory = ((DestinationFactoryManager)this.bus.getExtension(DestinationFactoryManager.class)).getDestinationFactory(ns);
                }
                catch (BusException busException) {
                    FFDCFilter.processException((Throwable)busException, (String)"org.apache.cxf.wsdl11.WSDLServiceBuilder", (String)"414", (Object)this, (Object[])new Object[]{service, bi, port});
                }
                if (factory == null) continue;
                break;
            }
            if (factory == null) {
                ns = ((ExtensibilityElement)elements.get(0)).getElementType().getNamespaceURI();
            }
        }
        if (factory == null) {
            elements = port.getBinding().getExtensibilityElements();
            if (null != elements && elements.size() > 0) {
                for (ExtensibilityElement el : CastUtils.cast((List)elements, ExtensibilityElement.class)) {
                    if (el instanceof SOAPBinding) {
                        ns = ((SOAPBinding)el).getTransportURI();
                        break;
                    }
                    if (!(el instanceof SOAP12Binding)) continue;
                    ns = ((SOAP12Binding)el).getTransportURI();
                    break;
                }
            }
            if (ns == null) {
                if (this.ignoreUnknownBindings) {
                    EndpointInfo endpointInfo = null;
                    if (LOG != null && LOG.isLoggable(Level.FINER)) {
                        endpointInfo = endpointInfo;
                        LOG.exiting("org.apache.cxf.wsdl11.WSDLServiceBuilder", "buildEndpoint", endpointInfo);
                    }
                    return endpointInfo;
                }
                org.apache.cxf.common.i18n.Message msg = new org.apache.cxf.common.i18n.Message("MISSING_DESTINATION_FACTORY", LOG, new Object[]{port.getName()});
                throw new WSDLRuntimeException(msg);
            }
            try {
                factory = ((DestinationFactoryManager)this.bus.getExtension(DestinationFactoryManager.class)).getDestinationFactory(ns);
            }
            catch (BusException msg) {
                FFDCFilter.processException((Throwable)msg, (String)"org.apache.cxf.wsdl11.WSDLServiceBuilder", (String)"453", (Object)this, (Object[])new Object[]{service, bi, port});
            }
        }
        if (factory instanceof WSDLEndpointFactory) {
            WSDLEndpointFactory wFactory = (WSDLEndpointFactory)factory;
            ei = wFactory.createEndpointInfo(service, bi, port.getExtensibilityElements());
        }
        if (ei == null) {
            ei = new EndpointInfo(service, ns);
        }
        this.copyDocumentation((AbstractPropertiesHolder)ei, (WSDLElement)port);
        ei.setName(new QName(service.getName().getNamespaceURI(), port.getName()));
        ei.setBinding(bi);
        this.copyExtensors((AbstractPropertiesHolder)ei, port.getExtensibilityElements());
        this.copyExtensionAttributes((AbstractPropertiesHolder)ei, (AttributeExtensible)port);
        service.addEndpoint(ei);
        DescriptionInfo d = service.getDescription();
        if (null != d) {
            d.getDescribed().add(ei);
        }
        EndpointInfo endpointInfo = ei;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            endpointInfo = endpointInfo;
            LOG.exiting("org.apache.cxf.wsdl11.WSDLServiceBuilder", "buildEndpoint", endpointInfo);
        }
        return endpointInfo;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public BindingInfo buildBinding(ServiceInfo service, Binding binding) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.wsdl11.WSDLServiceBuilder", "buildBinding", new Object[]{service, binding});
        }
        BindingInfo bi = null;
        StringBuilder ns = new StringBuilder(100);
        BindingFactory factory = WSDLServiceUtils.getBindingFactory(binding, this.bus, ns);
        if (factory instanceof WSDLBindingFactory) {
            WSDLBindingFactory wFactory = (WSDLBindingFactory)factory;
            bi = wFactory.createBindingInfo(service, binding, ns.toString());
            this.copyExtensors((AbstractPropertiesHolder)bi, binding.getExtensibilityElements());
            this.copyExtensionAttributes((AbstractPropertiesHolder)bi, (AttributeExtensible)binding);
        }
        if (bi == null) {
            bi = new BindingInfo(service, ns.toString());
            bi.setName(binding.getQName());
            this.copyExtensors((AbstractPropertiesHolder)bi, binding.getExtensibilityElements());
            this.copyExtensionAttributes((AbstractPropertiesHolder)bi, (AttributeExtensible)binding);
            for (BindingOperation bop : CastUtils.cast((List)binding.getBindingOperations(), BindingOperation.class)) {
                BindingOperationInfo bop2;
                LOG.finer("binding operation name is " + bop.getName());
                String inName = null;
                String outName = null;
                if (bop.getBindingInput() != null) {
                    inName = bop.getBindingInput().getName();
                }
                if (bop.getBindingOutput() != null) {
                    outName = bop.getBindingOutput().getName();
                }
                if ((bop2 = bi.buildOperation(new QName(service.getName().getNamespaceURI(), bop.getName()), inName, outName)) == null) continue;
                this.copyExtensors((AbstractPropertiesHolder)bop2, bop.getExtensibilityElements());
                this.copyExtensionAttributes((AbstractPropertiesHolder)bop2, (AttributeExtensible)bop);
                bi.addOperation(bop2);
                if (bop.getBindingInput() != null) {
                    this.copyExtensors((AbstractPropertiesHolder)bop2.getInput(), bop.getBindingInput().getExtensibilityElements());
                    this.copyExtensionAttributes((AbstractPropertiesHolder)bop2.getInput(), (AttributeExtensible)bop.getBindingInput());
                    this.handleHeader(bop2.getInput());
                }
                if (bop.getBindingOutput() != null) {
                    this.copyExtensors((AbstractPropertiesHolder)bop2.getOutput(), bop.getBindingOutput().getExtensibilityElements());
                    this.copyExtensionAttributes((AbstractPropertiesHolder)bop2.getOutput(), (AttributeExtensible)bop.getBindingOutput());
                    this.handleHeader(bop2.getOutput());
                }
                for (BindingFault f : CastUtils.cast(bop.getBindingFaults().values(), BindingFault.class)) {
                    BindingFaultInfo bif = bop2.getFault(new QName(service.getTargetNamespace(), f.getName()));
                    this.copyExtensors((AbstractPropertiesHolder)bif, bop.getBindingFault(f.getName()).getExtensibilityElements());
                    this.copyExtensionAttributes((AbstractPropertiesHolder)bif, (AttributeExtensible)bop.getBindingFault(f.getName()));
                }
            }
        }
        service.addBinding(bi);
        DescriptionInfo d = service.getDescription();
        if (null != d) {
            d.getDescribed().add(bi);
        }
        BindingInfo bindingInfo = bi;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bindingInfo = bindingInfo;
            LOG.exiting("org.apache.cxf.wsdl11.WSDLServiceBuilder", "buildBinding", bindingInfo);
        }
        return bindingInfo;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void handleHeader(BindingMessageInfo bindingMessageInfo) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.wsdl11.WSDLServiceBuilder", "handleHeader", new Object[]{bindingMessageInfo});
        }
        List extensiblilityElement = bindingMessageInfo.getExtensors(ExtensibilityElement.class);
        if (extensiblilityElement == null) {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.wsdl11.WSDLServiceBuilder", "handleHeader");
            }
            return;
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.wsdl11.WSDLServiceBuilder", "handleHeader");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void buildInterface(ServiceInfo si, PortType p) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.wsdl11.WSDLServiceBuilder", "buildInterface", new Object[]{si, p});
        }
        InterfaceInfo inf = si.createInterface(p.getQName());
        DescriptionInfo d = si.getDescription();
        if (null != d) {
            d.getDescribed().add(inf);
        }
        this.copyDocumentation((AbstractPropertiesHolder)inf, (WSDLElement)p);
        this.copyExtensors((AbstractPropertiesHolder)inf, p.getExtensibilityElements());
        this.copyExtensionAttributes((AbstractPropertiesHolder)inf, (AttributeExtensible)p);
        if (this.recordOriginal) {
            inf.setProperty(WSDL_PORTTYPE, (Object)p);
        }
        for (Operation op : CastUtils.cast((List)p.getOperations(), Operation.class)) {
            this.buildInterfaceOperation(inf, op);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.wsdl11.WSDLServiceBuilder", "buildInterface");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void buildInterfaceOperation(InterfaceInfo inf, Operation op) {
        Output output;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.wsdl11.WSDLServiceBuilder", "buildInterfaceOperation", new Object[]{inf, op});
        }
        OperationInfo opInfo = inf.addOperation(new QName(inf.getName().getNamespaceURI(), op.getName()));
        if (this.recordOriginal) {
            opInfo.setProperty(WSDL_OPERATION, (Object)op);
        }
        this.copyDocumentation((AbstractPropertiesHolder)opInfo, (WSDLElement)op);
        List porderList = CastUtils.cast((List)op.getParameterOrdering());
        opInfo.setParameterOrdering(porderList);
        this.copyExtensors((AbstractPropertiesHolder)opInfo, op.getExtensibilityElements());
        this.copyExtensionAttributes((AbstractPropertiesHolder)opInfo, (AttributeExtensible)op);
        Input input = op.getInput();
        if (input != null) {
            if (input.getMessage() == null) {
                throw new WSDLRuntimeException(LOG, "NO_MESSAGE", "input", op.getName(), input.getName());
            }
            MessageInfo minfo = opInfo.createMessage(input.getMessage().getQName(), MessageInfo.Type.INPUT);
            opInfo.setInput(input.getName(), minfo);
            this.buildMessage((AbstractMessageContainer)minfo, input.getMessage());
            this.copyExtensors((AbstractPropertiesHolder)minfo, input.getExtensibilityElements());
            this.copyExtensionAttributes((AbstractPropertiesHolder)minfo, (AttributeExtensible)input);
        }
        if ((output = op.getOutput()) != null) {
            if (output.getMessage() == null) {
                throw new WSDLRuntimeException(LOG, "NO_MESSAGE", "output", op.getName(), output.getName());
            }
            MessageInfo minfo = opInfo.createMessage(output.getMessage().getQName(), MessageInfo.Type.OUTPUT);
            opInfo.setOutput(output.getName(), minfo);
            this.buildMessage((AbstractMessageContainer)minfo, output.getMessage());
            this.copyExtensors((AbstractPropertiesHolder)minfo, output.getExtensibilityElements());
            this.copyExtensionAttributes((AbstractPropertiesHolder)minfo, (AttributeExtensible)output);
        }
        Map m = op.getFaults();
        for (Map.Entry rawentry : m.entrySet()) {
            Map.Entry entry = CastUtils.cast(rawentry, String.class, Fault.class);
            FaultInfo finfo = opInfo.addFault(new QName(inf.getName().getNamespaceURI(), (String)entry.getKey()), ((Fault)entry.getValue()).getMessage().getQName());
            this.copyDocumentation((AbstractPropertiesHolder)finfo, (WSDLElement)entry.getValue());
            this.buildMessage((AbstractMessageContainer)finfo, ((Fault)entry.getValue()).getMessage());
            this.copyExtensors((AbstractPropertiesHolder)finfo, ((Fault)entry.getValue()).getExtensibilityElements());
            this.copyExtensionAttributes((AbstractPropertiesHolder)finfo, (AttributeExtensible)entry.getValue());
        }
        WSDLServiceBuilder.checkForWrapped(opInfo, this.allowRefs, false, this.unwrapLogLevel);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.wsdl11.WSDLServiceBuilder", "buildInterfaceOperation");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void checkForWrapped(OperationInfo opInfo, boolean relaxed) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.wsdl11.WSDLServiceBuilder", "checkForWrapped", new Object[]{opInfo, relaxed});
        }
        WSDLServiceBuilder.checkForWrapped(opInfo, relaxed, relaxed);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.wsdl11.WSDLServiceBuilder", "checkForWrapped");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void checkForWrapped(OperationInfo opInfo, boolean allowRefs, boolean relaxed) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.wsdl11.WSDLServiceBuilder", "checkForWrapped", new Object[]{opInfo, allowRefs, relaxed});
        }
        WSDLServiceBuilder.checkForWrapped(opInfo, allowRefs, relaxed, Level.FINE);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.wsdl11.WSDLServiceBuilder", "checkForWrapped");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void checkForWrapped(OperationInfo opInfo, boolean allowRefs, boolean relaxed, Level logLevel) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.wsdl11.WSDLServiceBuilder", "checkForWrapped", new Object[]{opInfo, allowRefs, relaxed, logLevel});
        }
        MessageInfo inputMessage = opInfo.getInput();
        MessageInfo outputMessage = opInfo.getOutput();
        boolean passedRule = true;
        if (inputMessage == null || inputMessage.size() == 0 || inputMessage.size() > 1 && !relaxed) {
            passedRule = false;
        }
        if (outputMessage != null && outputMessage.size() > 1) {
            passedRule = false;
        }
        if (!passedRule) {
            org.apache.cxf.common.i18n.Message message = new org.apache.cxf.common.i18n.Message("WRAPPED_RULE_1", LOG, new Object[]{opInfo.getName()});
            LOG.log(logLevel, message.toString());
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.wsdl11.WSDLServiceBuilder", "checkForWrapped");
            }
            return;
        }
        SchemaCollection schemas = opInfo.getInterface().getService().getXmlSchemaCollection();
        XmlSchemaElement inputEl = null;
        XmlSchemaElement outputEl = null;
        MessagePartInfo inputPart = inputMessage.getMessagePartByIndex(0);
        if (!inputPart.isElement()) {
            passedRule = false;
        } else {
            QName inputElementName = inputPart.getElementQName();
            inputEl = schemas.getElementByQName(inputElementName);
            if (inputEl == null) {
                passedRule = false;
            } else if (!opInfo.getName().getLocalPart().equals(inputElementName.getLocalPart())) {
                passedRule = relaxed;
            }
        }
        if (!passedRule) {
            org.apache.cxf.common.i18n.Message message = new org.apache.cxf.common.i18n.Message("WRAPPED_RULE_2", LOG, new Object[]{opInfo.getName()});
            LOG.log(logLevel, message.toString());
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.wsdl11.WSDLServiceBuilder", "checkForWrapped");
            }
            return;
        }
        MessagePartInfo outputPart = null;
        if (outputMessage != null && outputMessage.size() == 1 && (outputPart = outputMessage.getMessagePartByIndex(0)) != null) {
            if (!outputPart.isElement() || schemas.getElementByQName(outputPart.getElementQName()) == null) {
                passedRule = false;
            } else {
                outputEl = schemas.getElementByQName(outputPart.getElementQName());
            }
        }
        if (!passedRule) {
            org.apache.cxf.common.i18n.Message message = new org.apache.cxf.common.i18n.Message("WRAPPED_RULE_3", LOG, new Object[]{opInfo.getName()});
            LOG.log(logLevel, message.toString());
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.wsdl11.WSDLServiceBuilder", "checkForWrapped");
            }
            return;
        }
        UnwrappedOperationInfo unwrapped = new UnwrappedOperationInfo(opInfo);
        MessageInfo unwrappedInput = new MessageInfo((OperationInfo)unwrapped, MessageInfo.Type.INPUT, inputMessage.getName());
        MessageInfo unwrappedOutput = null;
        XmlSchemaComplexType xsct = null;
        if (inputEl.getSchemaType() instanceof XmlSchemaComplexType) {
            xsct = (XmlSchemaComplexType)inputEl.getSchemaType();
            if (WSDLServiceBuilder.hasAttributes(xsct) || inputEl.isNillable() && !relaxed || !WSDLServiceBuilder.isWrappableSequence(xsct, inputEl.getQName().getNamespaceURI(), unwrappedInput, allowRefs)) {
                passedRule = false;
            }
        } else {
            passedRule = false;
        }
        if (!passedRule) {
            org.apache.cxf.common.i18n.Message message = new org.apache.cxf.common.i18n.Message("WRAPPED_RULE_4", LOG, new Object[]{opInfo.getName()});
            LOG.log(logLevel, message.toString());
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.wsdl11.WSDLServiceBuilder", "checkForWrapped");
            }
            return;
        }
        if (outputMessage != null) {
            unwrappedOutput = new MessageInfo((OperationInfo)unwrapped, MessageInfo.Type.OUTPUT, outputMessage.getName());
            if (outputEl != null && outputEl.getSchemaType() instanceof XmlSchemaComplexType) {
                xsct = (XmlSchemaComplexType)outputEl.getSchemaType();
                if (xsct.isAbstract()) {
                    passedRule = false;
                }
                if (WSDLServiceBuilder.hasAttributes(xsct) || outputEl.isNillable() && !relaxed || !WSDLServiceBuilder.isWrappableSequence(xsct, outputEl.getQName().getNamespaceURI(), unwrappedOutput, allowRefs)) {
                    passedRule = false;
                }
            } else {
                passedRule = false;
            }
        }
        if (!passedRule) {
            org.apache.cxf.common.i18n.Message message = new org.apache.cxf.common.i18n.Message("WRAPPED_RULE_5", LOG, new Object[]{opInfo.getName()});
            LOG.log(logLevel, message.toString());
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.wsdl11.WSDLServiceBuilder", "checkForWrapped");
            }
            return;
        }
        opInfo.setUnwrappedOperation((OperationInfo)unwrapped);
        unwrapped.setInput(opInfo.getInputName(), unwrappedInput);
        if (outputMessage != null) {
            unwrapped.setOutput(opInfo.getOutputName(), unwrappedOutput);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.wsdl11.WSDLServiceBuilder", "checkForWrapped");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static boolean hasAttributes(XmlSchemaComplexType complexType) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.wsdl11.WSDLServiceBuilder", "hasAttributes", new Object[]{complexType});
        }
        if (complexType.getAnyAttribute() != null || !complexType.getAttributes().isEmpty()) {
            boolean bl = true;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.wsdl11.WSDLServiceBuilder", "hasAttributes", bl);
            }
            return bl;
        }
        boolean bl = false;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.wsdl11.WSDLServiceBuilder", "hasAttributes", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static boolean isWrappableSequence(XmlSchemaComplexType type, String namespaceURI, MessageInfo wrapper, boolean allowRefs) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.wsdl11.WSDLServiceBuilder", "isWrappableSequence", new Object[]{type, namespaceURI, wrapper, allowRefs});
        }
        if (type.getParticle() instanceof XmlSchemaSequence) {
            XmlSchemaSequence seq = (XmlSchemaSequence)type.getParticle();
            boolean bl = WSDLServiceBuilder.buildMessageParts(seq, namespaceURI, wrapper, allowRefs);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.wsdl11.WSDLServiceBuilder", "isWrappableSequence", bl);
            }
            return bl;
        }
        if (type.getParticle() == null) {
            if (type.getContentModel() == null) {
                boolean bl = true;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    bl = bl;
                    LOG.exiting("org.apache.cxf.wsdl11.WSDLServiceBuilder", "isWrappableSequence", bl);
                }
                return bl;
            }
            if (type.getContentModel().getContent() instanceof XmlSchemaComplexContentExtension) {
                XmlSchemaComplexContentExtension extension = (XmlSchemaComplexContentExtension)type.getContentModel().getContent();
                QName baseTypeName = extension.getBaseTypeName();
                ServiceInfo serviceInfo = wrapper.getOperation().getInterface().getService();
                XmlSchemaType schemaType = serviceInfo.getXmlSchemaCollection().getTypeByQName(baseTypeName);
                if (!(schemaType instanceof XmlSchemaComplexType) || !WSDLServiceBuilder.isWrappableSequence((XmlSchemaComplexType)schemaType, namespaceURI, wrapper, allowRefs)) {
                    boolean bl = false;
                    if (LOG != null && LOG.isLoggable(Level.FINER)) {
                        bl = bl;
                        LOG.exiting("org.apache.cxf.wsdl11.WSDLServiceBuilder", "isWrappableSequence", bl);
                    }
                    return bl;
                }
                if (extension.getParticle() instanceof XmlSchemaSequence) {
                    XmlSchemaSequence seq = (XmlSchemaSequence)extension.getParticle();
                    boolean bl = WSDLServiceBuilder.buildMessageParts(seq, namespaceURI, wrapper, allowRefs);
                    if (LOG != null && LOG.isLoggable(Level.FINER)) {
                        bl = bl;
                        LOG.exiting("org.apache.cxf.wsdl11.WSDLServiceBuilder", "isWrappableSequence", bl);
                    }
                    return bl;
                }
            }
            boolean bl = true;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.wsdl11.WSDLServiceBuilder", "isWrappableSequence", bl);
            }
            return bl;
        }
        boolean bl = false;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.wsdl11.WSDLServiceBuilder", "isWrappableSequence", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static boolean buildMessageParts(XmlSchemaSequence seq, String namespaceURI, MessageInfo wrapper, boolean allowRefs) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.wsdl11.WSDLServiceBuilder", "buildMessageParts", new Object[]{seq, namespaceURI, wrapper, allowRefs});
        }
        List items = seq.getItems();
        boolean ret = true;
        for (XmlSchemaSequenceMember seqItem : items) {
            MessagePartInfo mpi;
            if (!(seqItem instanceof XmlSchemaElement)) {
                boolean bl = false;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    bl = bl;
                    LOG.exiting("org.apache.cxf.wsdl11.WSDLServiceBuilder", "buildMessageParts", bl);
                }
                return bl;
            }
            XmlSchemaElement el = (XmlSchemaElement)seqItem;
            if (el.getSchemaTypeName() != null) {
                mpi = wrapper.addMessagePart(new QName(namespaceURI, el.getName()));
                mpi.setTypeQName(el.getSchemaTypeName());
                mpi.setElement(true);
                mpi.setElementQName(el.getWireName());
                mpi.setConcreteName(el.getWireName());
                mpi.setXmlSchema((XmlSchemaAnnotated)el);
                continue;
            }
            if (el.getRef().getTargetQName() != null) {
                mpi = wrapper.addMessagePart(el.getRef().getTargetQName());
                mpi.setTypeQName(el.getRef().getTargetQName());
                mpi.setElementQName(el.getRef().getTargetQName());
                mpi.setElement(true);
                mpi.setXmlSchema((XmlSchemaAnnotated)el);
                mpi.setProperty("isRefElement", (Object)true);
                if (allowRefs) continue;
                ret = false;
                continue;
            }
            mpi = wrapper.addMessagePart(new QName(namespaceURI, el.getName()));
            mpi.setElementQName(mpi.getName());
            mpi.setConcreteName(el.getWireName());
            mpi.setElement(true);
            mpi.setXmlSchema((XmlSchemaAnnotated)el);
        }
        boolean bl = ret;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.wsdl11.WSDLServiceBuilder", "buildMessageParts", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void buildMessage(AbstractMessageContainer minfo, Message msg) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.wsdl11.WSDLServiceBuilder", "buildMessage", new Object[]{minfo, msg});
        }
        SchemaCollection schemas = minfo.getOperation().getInterface().getService().getXmlSchemaCollection();
        List orderedParam = msg.getOrderedParts(null);
        for (Part part : CastUtils.cast((List)orderedParam, Part.class)) {
            MessagePartInfo pi = minfo.addMessagePart(new QName(minfo.getName().getNamespaceURI(), part.getName()));
            if (part.getTypeName() != null) {
                pi.setTypeQName(part.getTypeName());
                pi.setElement(false);
                pi.setXmlSchema((XmlSchemaAnnotated)schemas.getTypeByQName(part.getTypeName()));
                continue;
            }
            if (part.getElementName() != null) {
                pi.setElementQName(part.getElementName());
                XmlSchemaElement schemaElement = schemas.getElementByQName(part.getElementName());
                if (null == schemaElement) {
                    org.apache.cxf.common.i18n.Message errorMessage = new org.apache.cxf.common.i18n.Message("WSDL4J_BAD_ELEMENT_PART", LOG, new Object[]{part.getName(), part.getElementName()});
                    throw new WSDLRuntimeException(errorMessage);
                }
                pi.setElement(true);
                pi.setXmlSchema((XmlSchemaAnnotated)schemaElement);
                continue;
            }
            org.apache.cxf.common.i18n.Message errorMessage = new org.apache.cxf.common.i18n.Message("PART_NO_NAME_NO_TYPE", LOG, new Object[]{part.getName()});
            throw new WSDLRuntimeException(errorMessage);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.wsdl11.WSDLServiceBuilder", "buildMessage");
        }
    }
}

