/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.csi;

import java.security.AccessController;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.apache.yoko.orb.csi.AuthenticationInfo;
import org.apache.yoko.orb.csi.SecurityContextDelegate;
import org.apache.yoko.orb.util.GetSystemPropertyAction;
import org.apache.yoko.osgi.ProviderLocator;

public abstract class SecurityContext {
    private static SecurityContextDelegate delegate;

    public static void setAuthenticatedSubject(Subject subject) {
        SecurityContext.getDelegate().setAuthenticatedSubject(subject);
    }

    private static SecurityContextDelegate getDelegate() {
        if (delegate == null) {
            delegate = SecurityContext.allocateDelegate();
        }
        return delegate;
    }

    private static SecurityContextDelegate allocateDelegate() {
        String className = (String)AccessController.doPrivileged(new GetSystemPropertyAction("org.freeorb.csi.SecurityContextClass", "org.freeorb.csi.DefaultSecurityContextDelegate"));
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class c = ProviderLocator.loadClass((String)className, SecurityContext.class, (ClassLoader)loader);
            return (SecurityContextDelegate)c.newInstance();
        }
        catch (Exception ex) {
            throw new InternalError("unable to attach to SecurityContext");
        }
    }

    public static Subject anonymousLogin() throws LoginException {
        return SecurityContext.getDelegate().anonymousLogin();
    }

    public static Subject login(String name, String realm, String password) throws LoginException {
        return SecurityContext.getDelegate().login(name, realm, password);
    }

    public static Subject delegate(String user, String domain) {
        return SecurityContext.getDelegate().delegate(user, domain);
    }

    public static AuthenticationInfo getAuthenticationInfo() {
        return SecurityContext.getDelegate().getAuthenticationInfo();
    }
}

