/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OCI;

import org.apache.yoko.orb.OB.Assert;
import org.apache.yoko.orb.OB.IORUtil;
import org.apache.yoko.orb.OB.MinorCodes;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.NO_MEMORY;

public final class Buffer {
    private int max_;
    public byte[] data_;
    public int len_;
    public int pos_;

    public byte[] data() {
        return this.data_;
    }

    public int length() {
        return this.len_;
    }

    public int rest_length() {
        return this.len_ - this.pos_;
    }

    public int pos() {
        return this.pos_;
    }

    public void pos(int pos) {
        this.pos_ = pos;
    }

    public void advance(int delta) {
        this.pos_ += delta;
    }

    public boolean is_full() {
        return this.pos_ >= this.len_;
    }

    public String dumpData() {
        StringBuilder dump = new StringBuilder();
        dump.append(String.format("Buffer pos=0x%x Buffer len=0x%x Remaining buffer data=%n%n", this.pos_, this.len_));
        IORUtil.dump_octets(this.data_, this.pos_, this.rest_length(), dump);
        return dump.toString();
    }

    public void alloc(int len) {
        this.max_ = len;
        this.len_ = len;
        try {
            this.data_ = new byte[this.max_];
        }
        catch (OutOfMemoryError ex) {
            throw new NO_MEMORY(MinorCodes.describeNoMemory(1095974913), 1095974913, CompletionStatus.COMPLETED_MAYBE);
        }
        this.pos_ = 0;
    }

    public void realloc(int len) {
        if (this.data_ == null) {
            this.alloc(len);
        } else {
            Assert._OB_assert(len >= this.len_);
            if (len <= this.max_) {
                this.len_ = len;
            } else {
                int newMax = len > 2 * this.max_ ? len : 2 * this.max_;
                byte[] newData = null;
                try {
                    newData = new byte[newMax];
                }
                catch (OutOfMemoryError ex) {
                    throw new NO_MEMORY(MinorCodes.describeNoMemory(1095974913), 1095974913, CompletionStatus.COMPLETED_MAYBE);
                }
                System.arraycopy(this.data_, 0, newData, 0, this.len_);
                this.data_ = newData;
                this.len_ = len;
                this.max_ = newMax;
            }
        }
    }

    public void data(byte[] data, int len) {
        this.data_ = data;
        this.len_ = len;
        this.max_ = len;
        this.pos_ = 0;
    }

    public void consume(Buffer buf) {
        this.data_ = buf.data_;
        this.len_ = buf.len_;
        this.max_ = buf.max_;
        this.pos_ = buf.pos_;
        buf.data_ = null;
        buf.len_ = 0;
        buf.max_ = 0;
        buf.pos_ = 0;
    }

    public Buffer() {
    }

    public Buffer(byte[] data, int len) {
        this.data_ = data;
        this.len_ = len;
        this.max_ = len;
        this.pos_ = 0;
    }

    public Buffer(int len) {
        this.alloc(len);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int pos = this.pos_;
        int len = this.len_;
        IORUtil.dump_octets(this.data_, 0, pos, sb);
        sb.append(String.format("------------------ pos = 0x%08X -------------------%n", pos));
        IORUtil.dump_octets(this.data_, pos, this.len_ - pos, sb);
        return sb.toString();
    }
}

