/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OBPortableServer;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Logger;
import org.apache.yoko.orb.CORBA.Delegate;
import org.apache.yoko.orb.CORBA.InputStream;
import org.apache.yoko.orb.CORBA.OutputStream;
import org.apache.yoko.orb.OB.Assert;
import org.apache.yoko.orb.OB.DispatchRequest_impl;
import org.apache.yoko.orb.OB.DispatchStrategy;
import org.apache.yoko.orb.OB.InitialServiceManager;
import org.apache.yoko.orb.OB.LocationForward;
import org.apache.yoko.orb.OB.MessageRoutingUtil;
import org.apache.yoko.orb.OB.MinorCodes;
import org.apache.yoko.orb.OB.ORBInstance;
import org.apache.yoko.orb.OB.ObjectKey;
import org.apache.yoko.orb.OB.ObjectKeyData;
import org.apache.yoko.orb.OB.PIManager;
import org.apache.yoko.orb.OB.PIUpcall;
import org.apache.yoko.orb.OB.PolicyFactoryManager;
import org.apache.yoko.orb.OB.RecursiveMutex;
import org.apache.yoko.orb.OB.RefCountPolicyList;
import org.apache.yoko.orb.OB.UnknownExceptionInfo_impl;
import org.apache.yoko.orb.OB.UnknownExceptionStrategy;
import org.apache.yoko.orb.OB.Upcall;
import org.apache.yoko.orb.OB.UpcallReturn;
import org.apache.yoko.orb.OBMessageRouting.DecayPolicy_impl;
import org.apache.yoko.orb.OBMessageRouting.ImmediateSuspendPolicy_impl;
import org.apache.yoko.orb.OBPortableInterceptor.PersistentORT_impl;
import org.apache.yoko.orb.OBPortableInterceptor.TransientORT_impl;
import org.apache.yoko.orb.OBPortableServer.AdapterActivatorHolder;
import org.apache.yoko.orb.OBPortableServer.DefaultServantHolder;
import org.apache.yoko.orb.OBPortableServer.DirectServant;
import org.apache.yoko.orb.OBPortableServer.DispatchStrategyPolicy;
import org.apache.yoko.orb.OBPortableServer.DispatchStrategyPolicy_impl;
import org.apache.yoko.orb.OBPortableServer.IdGenerationStrategy;
import org.apache.yoko.orb.OBPortableServer.IdGenerationStrategyFactory;
import org.apache.yoko.orb.OBPortableServer.POA;
import org.apache.yoko.orb.OBPortableServer.POAControl;
import org.apache.yoko.orb.OBPortableServer.POAManager;
import org.apache.yoko.orb.OBPortableServer.POAManagerFactory;
import org.apache.yoko.orb.OBPortableServer.POAManagerFactoryHelper;
import org.apache.yoko.orb.OBPortableServer.POAManagerHelper;
import org.apache.yoko.orb.OBPortableServer.POAManager_impl;
import org.apache.yoko.orb.OBPortableServer.POAPolicies;
import org.apache.yoko.orb.OBPortableServer.ServantDispatcher;
import org.apache.yoko.orb.OBPortableServer.ServantLocationStrategy;
import org.apache.yoko.orb.OBPortableServer.ServantLocationStrategyFactory;
import org.apache.yoko.orb.OBPortableServer.ServantManagerStrategy;
import org.apache.yoko.orb.OBPortableServer.SynchronizationPolicy;
import org.apache.yoko.orb.OBPortableServer.SynchronizationPolicyValue;
import org.apache.yoko.orb.OBPortableServer.SynchronizationPolicy_impl;
import org.apache.yoko.orb.OCI.Acceptor;
import org.apache.yoko.orb.OCI.Current_impl;
import org.apache.yoko.orb.OCI.ProfileInfo;
import org.apache.yoko.orb.OCI.TransportInfo;
import org.apache.yoko.orb.PortableInterceptor.IORInfo_impl;
import org.apache.yoko.orb.PortableInterceptor.POAPolicyFactory_impl;
import org.apache.yoko.orb.PortableServer.IdAssignmentPolicy_impl;
import org.apache.yoko.orb.PortableServer.IdUniquenessPolicy_impl;
import org.apache.yoko.orb.PortableServer.ImplicitActivationPolicy_impl;
import org.apache.yoko.orb.PortableServer.LifespanPolicy_impl;
import org.apache.yoko.orb.PortableServer.RequestProcessingPolicy_impl;
import org.apache.yoko.orb.PortableServer.ServantRetentionPolicy_impl;
import org.apache.yoko.orb.PortableServer.ThreadPolicy_impl;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.OBJ_ADAPTER;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyError;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.IOP.IOR;
import org.omg.IOP.IORHolder;
import org.omg.IOP.ServiceContext;
import org.omg.IOP.TaggedProfile;
import org.omg.MessageRouting.DecayPolicy;
import org.omg.MessageRouting.InvalidState;
import org.omg.MessageRouting.RetryPolicy;
import org.omg.MessageRouting.Router;
import org.omg.MessageRouting.RouterAdmin;
import org.omg.MessageRouting.RouterListHolder;
import org.omg.PortableInterceptor.IORInfo;
import org.omg.PortableInterceptor.ObjectReferenceFactory;
import org.omg.PortableInterceptor.ObjectReferenceTemplate;
import org.omg.PortableServer.AdapterActivator;
import org.omg.PortableServer.CurrentPackage.NoContext;
import org.omg.PortableServer.IdAssignmentPolicy;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.IdUniquenessPolicy;
import org.omg.PortableServer.IdUniquenessPolicyValue;
import org.omg.PortableServer.ImplicitActivationPolicy;
import org.omg.PortableServer.ImplicitActivationPolicyValue;
import org.omg.PortableServer.LifespanPolicy;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POAManagerFactoryPackage.ManagerAlreadyExists;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAPackage.AdapterAlreadyExists;
import org.omg.PortableServer.POAPackage.AdapterNonExistent;
import org.omg.PortableServer.POAPackage.InvalidPolicy;
import org.omg.PortableServer.POAPackage.NoServant;
import org.omg.PortableServer.POAPackage.ObjectAlreadyActive;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.POAPackage.ServantNotActive;
import org.omg.PortableServer.POAPackage.WrongAdapter;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.RequestProcessingPolicy;
import org.omg.PortableServer.RequestProcessingPolicyValue;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantLocatorPackage.CookieHolder;
import org.omg.PortableServer.ServantManager;
import org.omg.PortableServer.ServantRetentionPolicy;
import org.omg.PortableServer.ServantRetentionPolicyValue;
import org.omg.PortableServer.ThreadPolicy;
import org.omg.PortableServer.ThreadPolicyValue;

public final class POA_impl
extends LocalObject
implements POA {
    static final Logger logger = Logger.getLogger(POA_impl.class.getName());
    private ORB orb_;
    private ORBInstance orbInstance_;
    private String name_;
    private byte[] adapterId_;
    String serverId_;
    private String[] poaId_;
    private POA_impl parent_;
    private POAManager manager_;
    private ServantLocationStrategy servantLocationStrategy_;
    private POAControl poaControl_;
    private AdapterActivatorHolder adapterActivator_;
    private Hashtable children_;
    private POAPolicies policies_;
    private IdGenerationStrategy idGenerationStrategy_;
    private int poaCreateTime_;
    private RecursiveMutex poaSyncMutex_ = new RecursiveMutex();
    private DispatchStrategy dispatchStrategy_;
    private org.apache.yoko.orb.PortableServer.Current_impl poaCurrent_;
    private Current_impl ociCurrent_;
    private Policy[] rawPolicies_;
    private ObjectReferenceTemplate adapterTemplate_;
    private ObjectReferenceFactory currentFactory_;
    private ObjectReferenceFactory ort_;
    private IORInfo iorInfo_;
    private Vector childTemplates_;
    boolean callAdapterStateChange_;

    private ObjectReferenceFactory ort() {
        if (this.ort_ == null) {
            this.ort_ = this.current_factory();
            if (this.ort_ == null) {
                this.ort_ = this.adapterTemplate_;
            }
        }
        return this.ort_;
    }

    private byte[] createObjectKey(byte[] id) {
        return ObjectKey.CreateObjectKey(new ObjectKeyData(this.serverId_, this.poaId_, id, this.policies_.lifespanPolicy() == LifespanPolicyValue.PERSISTENT, this.poaCreateTime_));
    }

    private boolean findPolicyIndex(Policy[] p, int type, IntHolder i) {
        i.value = 0;
        while (i.value < p.length) {
            if (p[i.value].policy_type() == type) {
                return true;
            }
            ++i.value;
        }
        return false;
    }

    private boolean validatePolicies(POAPolicies policies, Policy[] policyList, IntHolder i) {
        if (policies.servantRetentionPolicy() == ServantRetentionPolicyValue.NON_RETAIN && policies.requestProcessingPolicy() != RequestProcessingPolicyValue.USE_SERVANT_MANAGER && policies.requestProcessingPolicy() != RequestProcessingPolicyValue.USE_DEFAULT_SERVANT) {
            boolean ok = this.findPolicyIndex(policyList, 21, i);
            Assert._OB_assert(ok);
            return false;
        }
        if (policies.requestProcessingPolicy() == RequestProcessingPolicyValue.USE_ACTIVE_OBJECT_MAP_ONLY && policies.servantRetentionPolicy() != ServantRetentionPolicyValue.RETAIN) {
            boolean ok = this.findPolicyIndex(policyList, 21, i);
            if (!ok) {
                ok = this.findPolicyIndex(policyList, 22, i);
            }
            Assert._OB_assert(ok);
            return false;
        }
        if (policies.requestProcessingPolicy() == RequestProcessingPolicyValue.USE_DEFAULT_SERVANT && policies.idUniquenessPolicy() != IdUniquenessPolicyValue.MULTIPLE_ID) {
            boolean ok = this.findPolicyIndex(policyList, 22, i);
            Assert._OB_assert(ok);
            return false;
        }
        if (policies.implicitActivationPolicy() == ImplicitActivationPolicyValue.IMPLICIT_ACTIVATION && policies.servantRetentionPolicy() != ServantRetentionPolicyValue.RETAIN && policies.idAssignmentPolicy() != IdAssignmentPolicyValue.SYSTEM_ID) {
            boolean ok = this.findPolicyIndex(policyList, 20, i);
            Assert._OB_assert(ok);
            return false;
        }
        return true;
    }

    private void handleUnknownException(Upcall upcall, Exception ex) {
        UnknownExceptionStrategy strategy = this.orbInstance_.getUnknownExceptionStrategy();
        UnknownExceptionInfo_impl info = new UnknownExceptionInfo_impl(upcall.operation(), upcall.responseExpected(), upcall.transportInfo(), (RuntimeException)ex);
        try {
            strategy.unknown_exception(info);
            upcall.setSystemException((SystemException)new UNKNOWN());
        }
        catch (SystemException sysEx) {
            upcall.setSystemException(sysEx);
        }
        catch (RuntimeException rex) {
            upcall.setSystemException((SystemException)new UNKNOWN());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeDestroy() {
        logger.fine("Completing destroy of POA " + this.name_ + " using POAContrl " + this.poaControl_);
        if (this.poaControl_.waitPendingRequests()) {
            if (this.parent_ != null) {
                Hashtable hashtable = this.parent_.children_;
                synchronized (hashtable) {
                    Assert._OB_assert(this.parent_.children_.containsKey(this.name_));
                    this.parent_.children_.remove(this.name_);
                }
            }
            if (this.manager_ != null) {
                POAManager_impl m = (POAManager_impl)this.manager_;
                m._OB_removePOA(this.poaId_);
                this.manager_ = null;
            }
            if (this.callAdapterStateChange_) {
                java.lang.Object[] orts = new ObjectReferenceTemplate[this.childTemplates_.size()];
                this.childTemplates_.copyInto(orts);
                PIManager piManager = this.orbInstance_.getPIManager();
                piManager.adapterStateChange((ObjectReferenceTemplate[])orts, (short)4);
            }
            this.servantLocationStrategy_.destroy(this, this.poaControl_.etherealize());
            this.adapterActivator_.destroy();
            this.orb_ = null;
            this.poaControl_.markDestroyCompleted();
            logger.fine("POA " + this.name_ + " is in a destroyed state");
            this.iorInfo_ = null;
        }
    }

    private void init() {
        this.poaCreateTime_ = (int)(System.currentTimeMillis() / 1000L);
        byte[] oid = new byte[]{};
        ObjectKeyData data = new ObjectKeyData(this.serverId_, this.poaId_, oid, this.policies_.lifespanPolicy() == LifespanPolicyValue.PERSISTENT, this.poaCreateTime_);
        this.adapterId_ = ObjectKey.CreateObjectKey(data);
        POAManager_impl m = (POAManager_impl)this.manager_;
        Acceptor[] acceptors = m._OB_getAcceptors();
        IORInfo_impl iorInfoImpl = new IORInfo_impl(this.orbInstance_, acceptors, this.rawPolicies_, this.policies_, m._OB_getAdapterManagerId(), m._OB_getAdapterState());
        this.iorInfo_ = iorInfoImpl;
        PIManager piManager = this.orbInstance_.getPIManager();
        piManager.establishComponents(this.iorInfo_);
        IOR iorTemplate = new IOR();
        iorTemplate.profiles = new TaggedProfile[0];
        iorTemplate.type_id = new String();
        IORHolder iorH = new IORHolder(iorTemplate);
        iorInfoImpl._OB_addComponents(iorH, m._OB_getGIOPVersion());
        String orbId = this.orbInstance_.getOrbId();
        String serverId = this.orbInstance_.getServerId();
        logger.fine("POA " + this.name_ + " activated on ORB " + orbId + " and server " + serverId);
        this.adapterTemplate_ = this.policies_.lifespanPolicy() == LifespanPolicyValue.PERSISTENT ? new PersistentORT_impl(this.orbInstance_, serverId, orbId, this.poaId_, iorTemplate) : new TransientORT_impl(this.orbInstance_, serverId, orbId, this.poaId_, this.poaCreateTime_, iorTemplate);
        iorInfoImpl._OB_adapterTemplate(this.adapterTemplate_);
        piManager.componentsEstablished(this.iorInfo_);
        this.idGenerationStrategy_ = IdGenerationStrategyFactory.createIdGenerationStrategy(this.policies_);
        this.adapterActivator_ = new AdapterActivatorHolder();
        this.poaControl_ = new POAControl();
        this.servantLocationStrategy_ = ServantLocationStrategyFactory.createServantLocationStrategy(this.policies_, this.orbInstance_);
        this.children_ = new Hashtable(31);
        this.dispatchStrategy_ = this.policies_.dispatchStrategyPolicy();
        m._OB_addPOA(this, this.poaId_);
    }

    private POA_impl(ORB orb, ORBInstance orbInstance, String serverId, String name, POA_impl parent, POAManager manager, org.apache.yoko.orb.PortableServer.Current_impl poaCurrent, Current_impl ociCurrent, POAPolicies policies, Policy[] rawPolicies) {
        this.orb_ = orb;
        this.orbInstance_ = orbInstance;
        this.serverId_ = serverId;
        this.name_ = name;
        this.parent_ = parent;
        this.manager_ = manager;
        this.policies_ = policies;
        this.poaCurrent_ = poaCurrent;
        this.ociCurrent_ = ociCurrent;
        this.rawPolicies_ = rawPolicies;
        this.adapterTemplate_ = null;
        this.currentFactory_ = null;
        this.ort_ = null;
        this.childTemplates_ = new Vector();
        this.callAdapterStateChange_ = true;
        logger.fine("Creating POA " + name + " using manager " + manager.get_id());
        Assert._OB_assert(parent != null);
        this.poaId_ = new String[parent.poaId_.length + 1];
        System.arraycopy(parent.poaId_, 0, this.poaId_, 0, parent.poaId_.length);
        this.poaId_[parent.poaId_.length] = name;
        this.init();
    }

    public POA_impl(ORB orb, ORBInstance orbInstance, String name, POAManager manager) {
        this.orb_ = orb;
        this.orbInstance_ = orbInstance;
        this.serverId_ = name;
        this.name_ = name;
        this.parent_ = null;
        this.manager_ = manager;
        this.policies_ = null;
        this.poaCurrent_ = null;
        this.ociCurrent_ = null;
        this.adapterTemplate_ = null;
        this.currentFactory_ = null;
        this.ort_ = null;
        this.childTemplates_ = new Vector();
        this.callAdapterStateChange_ = true;
        Policy[] pl = new Policy[]{new ImplicitActivationPolicy_impl(ImplicitActivationPolicyValue.IMPLICIT_ACTIVATION)};
        this.policies_ = new POAPolicies(this.orbInstance_, pl);
        this.rawPolicies_ = new Policy[7];
        this.rawPolicies_[0] = new ThreadPolicy_impl(ThreadPolicyValue.ORB_CTRL_MODEL);
        this.rawPolicies_[1] = new LifespanPolicy_impl(LifespanPolicyValue.TRANSIENT);
        this.rawPolicies_[2] = new IdUniquenessPolicy_impl(IdUniquenessPolicyValue.UNIQUE_ID);
        this.rawPolicies_[3] = new IdAssignmentPolicy_impl(IdAssignmentPolicyValue.SYSTEM_ID);
        this.rawPolicies_[4] = new ServantRetentionPolicy_impl(ServantRetentionPolicyValue.RETAIN);
        this.rawPolicies_[5] = new RequestProcessingPolicy_impl(RequestProcessingPolicyValue.USE_ACTIVE_OBJECT_MAP_ONLY);
        this.rawPolicies_[6] = new ImplicitActivationPolicy_impl(ImplicitActivationPolicyValue.IMPLICIT_ACTIVATION);
        this.poaCurrent_ = new org.apache.yoko.orb.PortableServer.Current_impl();
        this.ociCurrent_ = new Current_impl();
        InitialServiceManager ism = this.orbInstance_.getInitialServiceManager();
        try {
            ism.addInitialReference("POACurrent", (Object)this.poaCurrent_);
            ism.addInitialReference("OCICurrent", (Object)this.ociCurrent_);
        }
        catch (InvalidName ex) {
            Assert._OB_assert(ex);
        }
        this.poaId_ = new String[0];
        this.init();
    }

    protected void finalize() throws Throwable {
        Assert._OB_assert(this.poaControl_.getDestroyed());
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.omg.PortableServer.POA create_POA(String adapter, org.omg.PortableServer.POAManager manager, Policy[] rawPolicies) throws AdapterAlreadyExists, InvalidPolicy {
        Assert._OB_assert(adapter != null);
        if (this.poaControl_.getDestroyed()) {
            throw new OBJECT_NOT_EXIST("POA " + this.name_ + " has been destroyed");
        }
        logger.fine("POA " + this.name_ + " creating new POA with name " + adapter);
        POAPolicies policies = new POAPolicies(this.orbInstance_, rawPolicies);
        IntHolder idx = new IntHolder();
        if (!this.validatePolicies(policies, rawPolicies, idx)) {
            throw new InvalidPolicy((short)idx.value);
        }
        POA_impl child = null;
        Hashtable hashtable = this.children_;
        synchronized (hashtable) {
            if (this.children_.containsKey(adapter)) {
                throw new AdapterAlreadyExists();
            }
            POAManager obmanager = null;
            if (manager == null) {
                try {
                    InitialServiceManager ism = this.orbInstance_.getInitialServiceManager();
                    POAManagerFactory factory = POAManagerFactoryHelper.narrow(ism.resolveInitialReferences("POAManagerFactory"));
                    Policy[] emptyPl = new Policy[]{};
                    obmanager = (POAManager)factory.create_POAManager(adapter, emptyPl);
                }
                catch (InvalidName ex) {
                    Assert._OB_assert(ex);
                }
                catch (ManagerAlreadyExists ex) {
                    Assert._OB_assert(ex);
                }
                catch (PolicyError ex) {
                    Assert._OB_assert(ex);
                }
            } else {
                try {
                    obmanager = POAManagerHelper.narrow((Object)manager);
                }
                catch (BAD_PARAM ex) {
                    Assert._OB_assert(ex);
                }
            }
            try {
                child = new POA_impl(this.orb_, this.orbInstance_, this.serverId_, adapter, this, obmanager, this.poaCurrent_, this.ociCurrent_, policies, rawPolicies);
            }
            catch (SystemException ex) {
                if (manager == null) {
                    Assert._OB_assert(obmanager != null);
                    try {
                        obmanager.deactivate(true, true);
                    }
                    catch (AdapterInactive adapterInactive) {
                        // empty catch block
                    }
                }
                throw ex;
            }
            this.children_.put(adapter, child);
        }
        return child;
    }

    public org.omg.PortableServer.POA find_POA(String adapter, boolean activate) throws AdapterNonExistent {
        AdapterActivator adapterActivator;
        Assert._OB_assert(adapter != null);
        if (this.poaControl_.getDestroyed()) {
            throw new OBJECT_NOT_EXIST("POA " + this.name_ + " has been destroyed");
        }
        logger.fine("POA " + this.name_ + " finding POA with name " + adapter);
        boolean check = true;
        if (!this.children_.containsKey(adapter) && activate && (adapterActivator = this.adapterActivator_.getAdapterActivator()) != null) {
            try {
                check = adapterActivator.unknown_adapter((org.omg.PortableServer.POA)this, adapter);
            }
            catch (SystemException ex) {
                throw new OBJ_ADAPTER(MinorCodes.describeObjAdapter(1330446337), 1330446337, CompletionStatus.COMPLETED_NO);
            }
        }
        org.omg.PortableServer.POA poa = null;
        if (check) {
            poa = (org.omg.PortableServer.POA)this.children_.get(adapter);
        }
        if (poa == null) {
            throw new AdapterNonExistent();
        }
        return poa;
    }

    public void destroy(boolean etherealize, boolean waitForCompletion) {
        this._OB_destroy(etherealize, waitForCompletion, null);
    }

    public ThreadPolicy create_thread_policy(ThreadPolicyValue value) {
        return new ThreadPolicy_impl(value);
    }

    public LifespanPolicy create_lifespan_policy(LifespanPolicyValue value) {
        return new LifespanPolicy_impl(value);
    }

    public IdUniquenessPolicy create_id_uniqueness_policy(IdUniquenessPolicyValue value) {
        return new IdUniquenessPolicy_impl(value);
    }

    public IdAssignmentPolicy create_id_assignment_policy(IdAssignmentPolicyValue value) {
        return new IdAssignmentPolicy_impl(value);
    }

    public ImplicitActivationPolicy create_implicit_activation_policy(ImplicitActivationPolicyValue value) {
        return new ImplicitActivationPolicy_impl(value);
    }

    public ServantRetentionPolicy create_servant_retention_policy(ServantRetentionPolicyValue value) {
        return new ServantRetentionPolicy_impl(value);
    }

    public RequestProcessingPolicy create_request_processing_policy(RequestProcessingPolicyValue value) {
        return new RequestProcessingPolicy_impl(value);
    }

    @Override
    public SynchronizationPolicy create_synchronization_policy(SynchronizationPolicyValue value) {
        return new SynchronizationPolicy_impl(value);
    }

    @Override
    public DispatchStrategyPolicy create_dispatch_strategy_policy(DispatchStrategy value) {
        return new DispatchStrategyPolicy_impl(value);
    }

    public String the_name() {
        if (this.poaControl_.getDestroyed()) {
            throw new OBJECT_NOT_EXIST("POA " + this.name_ + " has been destroyed");
        }
        return this.name_;
    }

    public org.omg.PortableServer.POA the_parent() {
        if (this.poaControl_.getDestroyed()) {
            throw new OBJECT_NOT_EXIST("POA " + this.name_ + " has been destroyed");
        }
        return this.parent_;
    }

    public org.omg.PortableServer.POA[] the_children() {
        if (this.poaControl_.getDestroyed()) {
            throw new OBJECT_NOT_EXIST("POA " + this.name_ + " has been destroyed");
        }
        Vector<org.omg.PortableServer.POA> content = new Vector<org.omg.PortableServer.POA>();
        Enumeration e = this.children_.elements();
        while (e.hasMoreElements()) {
            org.omg.PortableServer.POA child = (org.omg.PortableServer.POA)e.nextElement();
            if (child == null) continue;
            content.addElement(child);
        }
        java.lang.Object[] children = new org.omg.PortableServer.POA[content.size()];
        content.copyInto(children);
        return children;
    }

    public org.omg.PortableServer.POAManager the_POAManager() {
        if (this.poaControl_.getDestroyed()) {
            throw new OBJECT_NOT_EXIST("POA " + this.name_ + " has been destroyed");
        }
        return this.manager_;
    }

    public org.omg.PortableServer.POAManagerFactory the_POAManagerFactory() {
        return this.orbInstance_.getPOAManagerFactory();
    }

    public AdapterActivator the_activator() {
        if (this.poaControl_.getDestroyed()) {
            throw new OBJECT_NOT_EXIST("POA " + this.name_ + " has been destroyed");
        }
        return this.adapterActivator_.getAdapterActivator();
    }

    public void the_activator(AdapterActivator activator) {
        if (this.poaControl_.getDestroyed()) {
            throw new OBJECT_NOT_EXIST("POA " + this.name_ + " has been destroyed");
        }
        this.adapterActivator_.setAdapterActivator(activator);
    }

    @Override
    public Policy[] the_policies() {
        return this.policies_.recreate();
    }

    @Override
    public DispatchStrategy the_dispatch_strategy() {
        return this.policies_.dispatchStrategyPolicy();
    }

    @Override
    public ObjectReferenceTemplate adapter_template() {
        return this.adapterTemplate_;
    }

    @Override
    public ObjectReferenceFactory current_factory() {
        if (this.iorInfo_ != null) {
            try {
                return ((IORInfo_impl)this.iorInfo_).current_factory();
            }
            catch (ClassCastException e) {
                return this.iorInfo_.current_factory();
            }
        }
        return null;
    }

    @Override
    public ORB the_ORB() {
        return this.orb_;
    }

    public ServantManager get_servant_manager() throws WrongPolicy {
        if (this.poaControl_.getDestroyed()) {
            throw new OBJECT_NOT_EXIST("POA " + this.name_ + " has been destroyed");
        }
        ServantManagerStrategy servantManagerStrategy = this.servantLocationStrategy_.getServantManagerStrategy();
        if (servantManagerStrategy == null) {
            throw new WrongPolicy();
        }
        return servantManagerStrategy.getServantManager();
    }

    public void set_servant_manager(ServantManager mgr) throws WrongPolicy {
        if (this.poaControl_.getDestroyed()) {
            throw new OBJECT_NOT_EXIST("POA " + this.name_ + " has been destroyed");
        }
        ServantManagerStrategy servantManagerStrategy = this.servantLocationStrategy_.getServantManagerStrategy();
        if (servantManagerStrategy == null) {
            throw new WrongPolicy();
        }
        servantManagerStrategy.setServantManager(mgr);
    }

    public Servant get_servant() throws NoServant, WrongPolicy {
        if (this.poaControl_.getDestroyed()) {
            throw new OBJECT_NOT_EXIST("POA " + this.name_ + " has been destroyed");
        }
        DefaultServantHolder defaultServantHolder = this.servantLocationStrategy_.getDefaultServantHolder();
        if (defaultServantHolder == null) {
            throw new WrongPolicy();
        }
        Servant servant = defaultServantHolder.getDefaultServant();
        if (servant == null) {
            throw new NoServant();
        }
        return servant;
    }

    public void set_servant(Servant servant) throws WrongPolicy {
        Assert._OB_assert(servant != null);
        if (this.poaControl_.getDestroyed()) {
            throw new OBJECT_NOT_EXIST("POA " + this.name_ + " has been destroyed");
        }
        DefaultServantHolder defaultServantHolder = this.servantLocationStrategy_.getDefaultServantHolder();
        if (defaultServantHolder == null) {
            throw new WrongPolicy();
        }
        ((org.omg.CORBA_2_3.ORB)this.orbInstance_.getORB()).set_delegate((java.lang.Object)servant);
        defaultServantHolder.setDefaultServant(servant);
    }

    public byte[] activate_object(Servant servant) throws ServantAlreadyActive, WrongPolicy {
        Assert._OB_assert(servant != null);
        if (this.poaControl_.getDestroyed()) {
            throw new OBJECT_NOT_EXIST("POA " + this.name_ + " has been destroyed");
        }
        byte[] oid = this.idGenerationStrategy_.createId();
        try {
            this.servantLocationStrategy_.activate(oid, servant);
        }
        catch (ObjectAlreadyActive ex) {
            Assert._OB_assert(ex);
        }
        return oid;
    }

    public void notifyRouters(boolean activate, byte[] oid) {
        RouterListHolder configRouterList = new RouterListHolder();
        configRouterList.value = new Router[0];
        MessageRoutingUtil.getRouterListFromConfig(this.orbInstance_, configRouterList);
        for (Router curRouter : configRouterList.value) {
            Object dest;
            RouterAdmin routerAdmin = null;
            try {
                routerAdmin = curRouter.admin();
            }
            catch (SystemException systemException) {
                // empty catch block
            }
            if (routerAdmin == null) continue;
            try {
                dest = this.id_to_reference(oid);
            }
            catch (ObjectNotActive ex) {
                break;
            }
            catch (WrongPolicy ex) {
                break;
            }
            if (activate) {
                ImmediateSuspendPolicy_impl retryPolicy = new ImmediateSuspendPolicy_impl();
                int decaySeconds = 0;
                DecayPolicy_impl decayPolicy = new DecayPolicy_impl(decaySeconds);
                try {
                    routerAdmin.register_destination(dest, false, (RetryPolicy)retryPolicy, (DecayPolicy)decayPolicy);
                }
                catch (SystemException systemException) {}
                continue;
            }
            try {
                routerAdmin.unregister_destination(dest);
            }
            catch (InvalidState invalidState) {
            }
            catch (SystemException systemException) {
                // empty catch block
            }
        }
    }

    public void activate_object_with_id(byte[] oid, Servant servant) throws ServantAlreadyActive, ObjectAlreadyActive, WrongPolicy {
        Assert._OB_assert(servant != null);
        if (this.poaControl_.getDestroyed()) {
            throw new OBJECT_NOT_EXIST("POA " + this.name_ + " has been destroyed");
        }
        if (!this.idGenerationStrategy_.isValid(oid)) {
            throw new BAD_PARAM(MinorCodes.describeBadParam(1330446350) + ": POA has SYSTEM_ID policy but the object ID was not generated by this POA", 1330446350, CompletionStatus.COMPLETED_NO);
        }
        this.servantLocationStrategy_.activate(oid, servant);
        this.notifyRouters(true, oid);
    }

    public void deactivate_object(byte[] oid) throws ObjectNotActive, WrongPolicy {
        if (this.poaControl_.getDestroyed()) {
            throw new OBJECT_NOT_EXIST("POA " + this.name_ + " has been destroyed");
        }
        this.servantLocationStrategy_.deactivate(this, oid);
        this.notifyRouters(false, oid);
    }

    public Object create_reference(String intf) throws WrongPolicy {
        Assert._OB_assert(intf != null);
        if (this.poaControl_.getDestroyed()) {
            throw new OBJECT_NOT_EXIST("POA " + this.name_ + " has been destroyed");
        }
        byte[] oid = this.idGenerationStrategy_.createId();
        return this.ort().make_object(intf, oid);
    }

    public Object create_reference_with_id(byte[] oid, String intf) {
        Assert._OB_assert(intf != null);
        if (this.poaControl_.getDestroyed()) {
            throw new OBJECT_NOT_EXIST("POA " + this.name_ + " has been destroyed");
        }
        if (!this.idGenerationStrategy_.isValid(oid)) {
            throw new BAD_PARAM(MinorCodes.describeBadParam(1330446350) + ": POA has SYSTEM_ID policy but the object ID was not generated by this POA", 1330446350, CompletionStatus.COMPLETED_NO);
        }
        return this.ort().make_object(intf, oid);
    }

    public byte[] servant_to_id(Servant servant) throws ServantNotActive, WrongPolicy {
        Assert._OB_assert(servant != null);
        if (this.poaControl_.getDestroyed()) {
            throw new OBJECT_NOT_EXIST("POA " + this.name_ + " has been destroyed");
        }
        if (this.policies_.requestProcessingPolicy() != RequestProcessingPolicyValue.USE_DEFAULT_SERVANT && (this.policies_.servantRetentionPolicy() != ServantRetentionPolicyValue.RETAIN || this.policies_.idUniquenessPolicy() != IdUniquenessPolicyValue.UNIQUE_ID && this.policies_.implicitActivationPolicy() != ImplicitActivationPolicyValue.IMPLICIT_ACTIVATION)) {
            throw new WrongPolicy();
        }
        byte[] oid = this.servantLocationStrategy_.servantToId(servant, this.poaCurrent_);
        if (oid == null) {
            if (this.policies_.implicitActivationPolicy() != ImplicitActivationPolicyValue.IMPLICIT_ACTIVATION) {
                throw new ServantNotActive();
            }
            try {
                oid = this.activate_object(servant);
            }
            catch (ServantAlreadyActive ex) {
                Assert._OB_assert(ex);
            }
        }
        return oid;
    }

    public Object servant_to_reference(Servant servant) throws ServantNotActive, WrongPolicy {
        Assert._OB_assert(servant != null);
        if (this.poaControl_.getDestroyed()) {
            throw new OBJECT_NOT_EXIST("POA " + this.name_ + " has been destroyed");
        }
        if (this.poaCurrent_._OB_inUpcall() && this.poaCurrent_._OB_getServant() == servant) {
            try {
                byte[] oid = this.poaCurrent_.get_object_id();
                String intf = servant._all_interfaces((org.omg.PortableServer.POA)this, oid)[0];
                return this.ort().make_object(intf, oid);
            }
            catch (NoContext ex) {
                Assert._OB_assert(ex);
            }
        }
        byte[] oid = this.servant_to_id(servant);
        String intf = servant._all_interfaces((org.omg.PortableServer.POA)this, oid)[0];
        return this.create_reference_with_id(oid, intf);
    }

    public Servant reference_to_servant(Object reference) throws ObjectNotActive, WrongAdapter, WrongPolicy {
        Assert._OB_assert(reference != null);
        if (this.poaControl_.getDestroyed()) {
            throw new OBJECT_NOT_EXIST("POA " + this.name_ + " has been destroyed");
        }
        if (this.policies_.servantRetentionPolicy() != ServantRetentionPolicyValue.RETAIN && this.policies_.requestProcessingPolicy() != RequestProcessingPolicyValue.USE_DEFAULT_SERVANT) {
            throw new WrongPolicy();
        }
        byte[] oid = this.reference_to_id(reference);
        Servant servant = this.servantLocationStrategy_.idToServant(oid, true);
        if (servant == null) {
            throw new ObjectNotActive();
        }
        return servant;
    }

    public byte[] reference_to_id(Object reference) throws WrongAdapter, WrongPolicy {
        ObjectKeyData keyData;
        Assert._OB_assert(reference != null);
        if (this.poaControl_.getDestroyed()) {
            throw new OBJECT_NOT_EXIST("POA " + this.name_ + " has been destroyed");
        }
        Delegate d = (Delegate)((ObjectImpl)reference)._get_delegate();
        IOR ior = d._OB_IOR();
        POAManager_impl m = (POAManager_impl)this.manager_;
        Acceptor[] acceptors = m._OB_getAcceptors();
        boolean local = false;
        ProfileInfo[] profileInfos = null;
        for (int i = 0; i < acceptors.length && !local; ++i) {
            profileInfos = acceptors[i].get_local_profiles(ior);
            if (profileInfos.length <= 0) continue;
            local = true;
        }
        if (local && ObjectKey.ParseObjectKey(profileInfos[0].key, keyData = new ObjectKeyData()) && this._OB_poaMatches(keyData, true)) {
            return keyData.oid;
        }
        throw new WrongAdapter();
    }

    public Servant id_to_servant(byte[] oid) throws ObjectNotActive, WrongPolicy {
        if (this.poaControl_.getDestroyed()) {
            throw new OBJECT_NOT_EXIST("POA " + this.name_ + " has been destroyed");
        }
        if (this.policies_.servantRetentionPolicy() != ServantRetentionPolicyValue.RETAIN && this.policies_.requestProcessingPolicy() != RequestProcessingPolicyValue.USE_DEFAULT_SERVANT) {
            throw new WrongPolicy();
        }
        Servant servant = this.servantLocationStrategy_.idToServant(oid, true);
        if (servant == null) {
            throw new ObjectNotActive();
        }
        return servant;
    }

    public Object id_to_reference(byte[] oid) throws ObjectNotActive, WrongPolicy {
        if (this.poaControl_.getDestroyed()) {
            throw new OBJECT_NOT_EXIST("POA " + this.name_ + " has been destroyed");
        }
        if (this.policies_.servantRetentionPolicy() != ServantRetentionPolicyValue.RETAIN) {
            throw new WrongPolicy();
        }
        Servant servant = this.servantLocationStrategy_.idToServant(oid, false);
        if (servant == null) {
            throw new ObjectNotActive();
        }
        String intf = servant._all_interfaces((org.omg.PortableServer.POA)this, oid)[0];
        return this.ort().make_object(intf, oid);
    }

    public byte[] id() {
        if (this.poaControl_.getDestroyed()) {
            throw new OBJECT_NOT_EXIST("POA " + this.name_ + " has been destroyed");
        }
        return this.adapterId_;
    }

    public void _OB_preinvoke(String op, byte[] oid, Servant servant, java.lang.Object cookie, TransportInfo info) {
        this.servantLocationStrategy_.preinvoke(oid);
        this.ociCurrent_._OB_preinvoke(info);
        this.poaCurrent_._OB_preinvoke(this, servant, op, oid, cookie);
        switch (this.policies_.synchronizationPolicy().value()) {
            case 0: {
                break;
            }
            case 1: {
                this.poaSyncMutex_.lock();
                break;
            }
            case 2: {
                this.orbInstance_.getORBSyncMutex().lock();
            }
        }
    }

    public void _OB_postinvoke() {
        byte[] oid = this.poaCurrent_._OB_getObjectId();
        String op = this.poaCurrent_._OB_getOp();
        Servant servant = this.poaCurrent_._OB_getServant();
        java.lang.Object cookie = this.poaCurrent_._OB_getCookie();
        switch (this.policies_.synchronizationPolicy().value()) {
            case 0: {
                break;
            }
            case 1: {
                this.poaSyncMutex_.unlock();
                break;
            }
            case 2: {
                this.orbInstance_.getORBSyncMutex().unlock();
            }
        }
        this.poaCurrent_._OB_postinvoke();
        this.ociCurrent_._OB_postinvoke();
        this.servantLocationStrategy_.postinvoke(oid, this, op, cookie, servant);
    }

    void _OB_locateServant(byte[] oid) throws LocationForward {
        String op = "_locate";
        CookieHolder cookieHolder = new CookieHolder();
        Servant servant = this.servantLocationStrategy_.locate(oid, this, op, cookieHolder);
        if (servant == null) {
            throw new OBJECT_NOT_EXIST(MinorCodes.describeObjectNotExist(1330446338), 1330446338, CompletionStatus.COMPLETED_NO);
        }
        this.servantLocationStrategy_.preinvoke(oid);
        this.servantLocationStrategy_.postinvoke(oid, this, op, cookieHolder.value, servant);
    }

    Upcall _OB_createUpcall(byte[] oid, UpcallReturn upcallReturn, ProfileInfo profileInfo, TransportInfo transportInfo, int requestId, String op, InputStream in, ServiceContext[] requestSCL) throws LocationForward {
        Upcall upcall = null;
        if (this.poaControl_.incrementRequestCount()) {
            try {
                if (this.policies_.interceptorCallPolicy()) {
                    PIManager piManager = this.orbInstance_.getPIManager();
                    if (piManager.haveServerInterceptors()) {
                        PIUpcall piUpcall = new PIUpcall(this.orbInstance_, upcallReturn, profileInfo, transportInfo, requestId, op, in, requestSCL, piManager);
                        upcall = piUpcall;
                        piUpcall.receiveRequestServiceContexts(this.rawPolicies_, this.adapterId_, oid, this.adapterTemplate_);
                        piUpcall.contextSwitch();
                    } else {
                        upcall = new Upcall(this.orbInstance_, upcallReturn, profileInfo, transportInfo, requestId, op, in, requestSCL);
                    }
                } else {
                    upcall = new Upcall(this.orbInstance_, upcallReturn, profileInfo, transportInfo, requestId, op, in, requestSCL);
                }
                DispatchRequest_impl dispatchRequestImpl = new DispatchRequest_impl(this, oid, upcall);
                upcall.setDispatchInfo(dispatchRequestImpl, this.dispatchStrategy_);
            }
            catch (SystemException ex) {
                upcall.setSystemException(ex);
                this._OB_decrementRequestCount();
            }
            catch (LocationForward ex) {
                upcall.setLocationForward(ex.ior, ex.perm);
                this._OB_decrementRequestCount();
            }
        }
        if (upcall != null) {
            this._OB_handleBidirSCL(transportInfo, requestSCL);
        }
        return upcall;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _OB_dispatch(byte[] oid, Upcall upcall) {
        block12: {
            String op = upcall.operation();
            upcall.contextSwitch();
            try {
                CookieHolder cookieHolder = new CookieHolder();
                Servant servant = this.servantLocationStrategy_.locate(oid, this, op, cookieHolder);
                if (servant != null) {
                    TransportInfo transportInfo = upcall.transportInfo();
                    this._OB_preinvoke(op, oid, servant, cookieHolder.value, transportInfo);
                    upcall.setServantAndPOA(servant, this);
                    try {
                        ServantDispatcher dispatcher = new ServantDispatcher(upcall, servant);
                        dispatcher.dispatch();
                        break block12;
                    }
                    finally {
                        if (!upcall.postinvokeCalled()) {
                            this._OB_postinvoke();
                        }
                    }
                }
                if (op.equals("_non_existent") || op.equals("_not_existent")) {
                    upcall.preUnmarshal();
                    upcall.postUnmarshal();
                    upcall.postinvoke();
                    OutputStream out = upcall.preMarshal();
                    out.write_boolean(true);
                    upcall.postMarshal();
                } else {
                    upcall.setSystemException((SystemException)((java.lang.Object)new OBJECT_NOT_EXIST(MinorCodes.describeObjectNotExist(1330446338), 1330446338, CompletionStatus.COMPLETED_NO)));
                }
            }
            catch (LocationForward ex) {
                upcall.setLocationForward(ex.ior, ex.perm);
            }
            catch (SystemException ex) {
                upcall.setSystemException(ex);
            }
            catch (Exception ex) {
                this.handleUnknownException(upcall, ex);
            }
        }
        if (upcall.userException()) {
            upcall.endUserException();
        }
        this._OB_decrementRequestCount();
    }

    DirectServant _OB_getDirectServant(byte[] oid, RefCountPolicyList policies) throws LocationForward {
        return this.servantLocationStrategy_.createDirectStubImpl(this, oid, policies);
    }

    public org.apache.yoko.orb.PortableServer.Current_impl _OB_POACurrent() {
        return this.poaCurrent_;
    }

    public void _OB_removeDirectServant(byte[] oid, DirectServant directServant) {
        this.servantLocationStrategy_.removeDirectStubImpl(oid, directServant);
    }

    boolean _OB_poaMatches(ObjectKeyData data, boolean full) {
        if (full) {
            if (!data.serverId.equals(this.serverId_)) {
                return false;
            }
            if (data.poaId.length != this.poaId_.length) {
                return false;
            }
            for (int i = 0; i < data.poaId.length; ++i) {
                if (data.poaId[i].equals(this.poaId_[i])) continue;
                return false;
            }
        }
        if (this.policies_.lifespanPolicy() == LifespanPolicyValue.PERSISTENT) {
            return data.persistent;
        }
        if (data.persistent) {
            return false;
        }
        return data.createTime == this.poaCreateTime_;
    }

    public boolean _OB_incrementRequestCount() {
        return this.poaControl_.incrementRequestCount();
    }

    public void _OB_decrementRequestCount() {
        if (this.poaControl_.decrementRequestCount()) {
            this.completeDestroy();
        }
    }

    public void _OB_waitPendingRequests() {
        this.poaControl_.waitPendingRequests();
    }

    public ORBInstance _OB_ORBInstance() {
        return this.orbInstance_;
    }

    public void _OB_addPolicyFactory() {
        PolicyFactoryManager pfm = this.orbInstance_.getPolicyFactoryManager();
        POAPolicyFactory_impl factory = new POAPolicyFactory_impl();
        pfm.registerPolicyFactory(16, factory, true);
        pfm.registerPolicyFactory(17, factory, true);
        pfm.registerPolicyFactory(18, factory, true);
        pfm.registerPolicyFactory(19, factory, true);
        pfm.registerPolicyFactory(20, factory, true);
        pfm.registerPolicyFactory(21, factory, true);
        pfm.registerPolicyFactory(22, factory, true);
        pfm.registerPolicyFactory(1330577665, factory, true);
        pfm.registerPolicyFactory(1330577666, factory, true);
        pfm.registerPolicyFactory(1330577667, factory, true);
    }

    public void _OB_validateManagerState() {
        POAManager_impl m = (POAManager_impl)this.manager_;
        m._OB_validateState();
    }

    public void _OB_etherealize(POAManager_impl manager) {
        Enumeration e = this.children_.elements();
        while (e.hasMoreElements()) {
            POA_impl child = (POA_impl)e.nextElement();
            child._OB_etherealize(manager);
        }
        if (manager == this.manager_) {
            this.servantLocationStrategy_.etherealize(this);
        }
    }

    public void _OB_destroy(boolean etherealize, boolean waitForCompletion, Vector templates) {
        logger.fine("Destroying POA " + this.name_);
        if (this.poaControl_.getDestroyed()) {
            return;
        }
        if (waitForCompletion && this.poaCurrent_._OB_inUpcall()) {
            try {
                POA_impl p = (POA_impl)this.poaCurrent_.get_POA();
                if (p._OB_ORBInstance() == this.orbInstance_) {
                    throw new BAD_INV_ORDER("Invocation in progress");
                }
            }
            catch (NoContext p) {
                // empty catch block
            }
        }
        if (templates != null) {
            templates.addElement(this.adapter_template());
            this.callAdapterStateChange_ = false;
        }
        if (this.poaControl_.markDestroyPending(etherealize, waitForCompletion)) {
            Enumeration e = this.children_.elements();
            while (e.hasMoreElements()) {
                POA_impl child = (POA_impl)e.nextElement();
                if (child == null) continue;
                if (templates == null) {
                    child._OB_destroy(etherealize, waitForCompletion, this.childTemplates_);
                    continue;
                }
                child._OB_destroy(etherealize, waitForCompletion, templates);
            }
            if (!waitForCompletion && this.poaControl_.hasPendingRequests()) {
                return;
            }
            this.completeDestroy();
        }
    }

    private void _OB_handleBidirSCL(TransportInfo transportInfo, ServiceContext[] contexts) {
        if (this.policies_.bidirPolicy() != 1) {
            return;
        }
        if (transportInfo != null) {
            transportInfo.handle_service_contexts(contexts);
        }
    }
}

