/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OB;

import java.util.logging.Logger;
import org.apache.yoko.orb.OB.Assert;
import org.apache.yoko.orb.OB.GIOPServerStarter;
import org.apache.yoko.orb.OB.GIOPServerStarterThreaded;
import org.apache.yoko.orb.OB.OAInterface;
import org.apache.yoko.orb.OB.ORBInstance;
import org.apache.yoko.orb.OB.Server;
import org.apache.yoko.orb.OCI.Acceptor;

final class GIOPServer
extends Server {
    static final Logger logger = Logger.getLogger(GIOPServer.class.getName());
    protected ORBInstance orbInstance_;
    protected boolean destroy_;
    protected Acceptor acceptor_;
    protected OAInterface oaInterface_;
    protected GIOPServerStarter starter_;

    protected void finalize() throws Throwable {
        Assert._OB_assert(this.destroy_);
        Assert._OB_assert(this.starter_ == null);
        super.finalize();
    }

    GIOPServer(ORBInstance orbInstance, Acceptor acceptor, OAInterface oaInterface, int concModel) {
        super(concModel);
        this.orbInstance_ = orbInstance;
        this.destroy_ = false;
        this.acceptor_ = acceptor;
        this.oaInterface_ = oaInterface;
        logger.fine("GIOPServer " + System.identityHashCode(this) + " created for orb instance " + this.orbInstance_.getOrbId() + " and server " + this.orbInstance_.getServerId() + " identityHash=" + System.identityHashCode(this.orbInstance_));
        try {
            switch (this.concModel_) {
                case 2: {
                    this.starter_ = new GIOPServerStarterThreaded(this.orbInstance_, this.acceptor_, this.oaInterface_);
                }
            }
        }
        catch (RuntimeException ex) {
            this.destroy_ = true;
            throw ex;
        }
    }

    @Override
    public void destroy() {
        logger.fine("Destroying GIOPServer " + System.identityHashCode(this) + " started for orb instance " + this.orbInstance_.getOrbId() + " and server " + this.orbInstance_.getServerId() + System.identityHashCode(this.orbInstance_));
        if (this.destroy_) {
            return;
        }
        this.destroy_ = true;
        Assert._OB_assert(this.starter_ != null);
        this.starter_.setState(2);
        this.starter_ = null;
    }

    @Override
    public void hold() {
        logger.fine("Holding GIOPServer " + System.identityHashCode(this) + " started for orb instance " + this.orbInstance_.getOrbId() + " and server " + this.orbInstance_.getServerId() + System.identityHashCode(this.orbInstance_));
        Assert._OB_assert(!this.destroy_);
        Assert._OB_assert(this.starter_ != null);
        this.starter_.setState(1);
    }

    @Override
    public void activate() {
        logger.fine("Activating GIOPServer " + System.identityHashCode(this) + " started for orb instance " + this.orbInstance_.getOrbId() + " and server " + this.orbInstance_.getServerId() + System.identityHashCode(this.orbInstance_));
        Assert._OB_assert(!this.destroy_);
        Assert._OB_assert(this.starter_ != null);
        this.starter_.setState(0);
    }

    public GIOPServerStarter _OB_getGIOPServerStarter() {
        return this.starter_;
    }
}

