/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OB;

import java.util.Properties;
import java.util.Vector;
import java.util.logging.Logger;
import org.apache.yoko.orb.OB.Assert;
import org.apache.yoko.orb.OB.DispatchSameThread_impl;
import org.apache.yoko.orb.OB.DispatchStrategy;
import org.apache.yoko.orb.OB.DispatchStrategyFactory;
import org.apache.yoko.orb.OB.DispatchThreadPerRequest_impl;
import org.apache.yoko.orb.OB.DispatchThreadPool_impl;
import org.apache.yoko.orb.OB.InvalidThreadPool;
import org.apache.yoko.orb.OB.MinorCodes;
import org.apache.yoko.orb.OB.ORBInstance;
import org.apache.yoko.orb.OB.ThreadPool;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.LocalObject;

public class DispatchStrategyFactory_impl
extends LocalObject
implements DispatchStrategyFactory {
    static final Logger logger = Logger.getLogger(DispatchStrategyFactory.class.getName());
    private Vector pools_ = new Vector();
    private boolean haveDefaultThreadPool_ = false;
    private int defaultThreadPool_;
    private boolean destroy_ = false;
    private ORBInstance orbInstance_ = null;

    @Override
    public synchronized int create_thread_pool(int nthreads) {
        int i;
        if (this.destroy_) {
            throw new INITIALIZE(MinorCodes.describeInitialize(1095974913), 1095974913, CompletionStatus.COMPLETED_NO);
        }
        for (i = 0; i < this.pools_.size() && this.pools_.elementAt(i) != null; ++i) {
        }
        if (i >= this.pools_.size()) {
            this.pools_.addElement(null);
        }
        this.pools_.setElementAt(new ThreadPool(i, nthreads), i);
        return i;
    }

    @Override
    public synchronized void destroy_thread_pool(int id) throws InvalidThreadPool {
        if (this.destroy_) {
            throw new INITIALIZE(MinorCodes.describeInitialize(1095974913), 1095974913, CompletionStatus.COMPLETED_NO);
        }
        if (id < 0 || id > this.pools_.size() || this.pools_.elementAt(id) == null) {
            throw new InvalidThreadPool();
        }
        ((ThreadPool)this.pools_.elementAt(id)).destroy();
        this.pools_.setElementAt(null, id);
    }

    @Override
    public synchronized DispatchStrategy create_thread_pool_strategy(int id) throws InvalidThreadPool {
        if (this.destroy_) {
            throw new INITIALIZE(MinorCodes.describeInitialize(1095974913), 1095974913, CompletionStatus.COMPLETED_NO);
        }
        if (id < 0 || id > this.pools_.size() || this.pools_.elementAt(id) == null) {
            throw new InvalidThreadPool();
        }
        return new DispatchThreadPool_impl(id, (ThreadPool)this.pools_.elementAt(id));
    }

    @Override
    public synchronized DispatchStrategy create_same_thread_strategy() {
        if (this.destroy_) {
            throw new INITIALIZE(MinorCodes.describeInitialize(1095974913), 1095974913, CompletionStatus.COMPLETED_NO);
        }
        return new DispatchSameThread_impl();
    }

    @Override
    public synchronized DispatchStrategy create_thread_per_request_strategy() {
        if (this.destroy_) {
            throw new INITIALIZE(MinorCodes.describeInitialize(1095974913), 1095974913, CompletionStatus.COMPLETED_NO);
        }
        return new DispatchThreadPerRequest_impl();
    }

    @Override
    public synchronized DispatchStrategy create_default_dispatch_strategy() {
        if (this.destroy_) {
            throw new INITIALIZE(MinorCodes.describeInitialize(1095974913), 1095974913, CompletionStatus.COMPLETED_NO);
        }
        Properties properties = this.orbInstance_.getProperties();
        String value = properties.getProperty("yoko.orb.oa.conc_model");
        if (value != null) {
            logger.fine("Defined concurrency model is " + value);
            if (value.equals("threaded") || value.equals("thread_per_client")) {
                logger.fine("Using same thread dispatch strategy");
                return this.create_same_thread_strategy();
            }
            if (value.equals("thread_per_request")) {
                logger.fine("Using thread per request dispatch strategy");
                return this.create_thread_per_request_strategy();
            }
            if (value.equals("thread_pool")) {
                if (!this.haveDefaultThreadPool_) {
                    this.haveDefaultThreadPool_ = true;
                    value = properties.getProperty("yoko.orb.oa.thread_pool");
                    int nthreads = 0;
                    if (value != null) {
                        nthreads = Integer.parseInt(value);
                    }
                    if (nthreads == 0) {
                        nthreads = 10;
                    }
                    logger.fine("Creating a thread pool of size " + nthreads);
                    this.defaultThreadPool_ = this.create_thread_pool(nthreads);
                }
                try {
                    logger.fine("Using a thread pool dispatch strategy");
                    return this.create_thread_pool_strategy(this.defaultThreadPool_);
                }
                catch (InvalidThreadPool ex) {
                    Assert._OB_assert((Throwable)((Object)ex));
                }
            } else {
                String err = "yoko.orb.oa.conc_model: Unknown value `";
                err = err + value;
                err = err + "'";
                this.orbInstance_.getLogger().warning(err);
            }
        }
        logger.fine("Using default thread per request strategy");
        return this.create_thread_per_request_strategy();
    }

    public synchronized void _OB_setORBInstance(ORBInstance orbInstance) {
        this.orbInstance_ = orbInstance;
    }

    protected synchronized void _OB_destroy() {
        if (this.destroy_) {
            throw new INITIALIZE(MinorCodes.describeInitialize(1095974913), 1095974913, CompletionStatus.COMPLETED_NO);
        }
        this.destroy_ = true;
        this.orbInstance_ = null;
        for (int i = 0; i < this.pools_.size(); ++i) {
            ThreadPool pool = (ThreadPool)this.pools_.elementAt(i);
            if (pool == null) continue;
            pool.destroy();
            this.pools_.setElementAt(null, i);
        }
    }
}

