/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.crypto.ltpakeyutil;

import java.security.PublicKey;

public final class LTPAPublicKey
implements PublicKey {
    private static final long serialVersionUID = 6585779055758956436L;
    private static final int MODULUS = 0;
    private static final int EXPONENT = 1;
    private static final int MODULUS_LENGTH = 129;
    private static final int EXPONENT_LENGTH = 3;
    private final byte[][] rawKey;
    private final byte[] encodedKey;

    LTPAPublicKey(byte[][] rawKey) {
        this.rawKey = rawKey;
        this.encodedKey = this.encode();
    }

    public LTPAPublicKey(byte[] encodedKey) {
        this.encodedKey = (byte[])encodedKey.clone();
        this.rawKey = this.decode(encodedKey);
    }

    private byte[][] decode(byte[] encodedPublicKey) {
        byte[][] decodedKey = new byte[][]{new byte[129], new byte[3]};
        System.arraycopy(encodedPublicKey, 0, decodedKey[0], 0, 129);
        System.arraycopy(encodedPublicKey, 129, decodedKey[1], 0, 3);
        return decodedKey;
    }

    private byte[] encode() {
        int publicKeyLength = 132;
        byte[] encodedPublicKey = new byte[publicKeyLength];
        System.arraycopy(this.rawKey[0], 0, encodedPublicKey, 0, 129);
        System.arraycopy(this.rawKey[1], 0, encodedPublicKey, 129, 3);
        return encodedPublicKey;
    }

    @Override
    public final String getAlgorithm() {
        return "RSA/SHA-1";
    }

    @Override
    public final byte[] getEncoded() {
        return (byte[])this.encodedKey.clone();
    }

    @Override
    public final String getFormat() {
        return "LTPAFormat";
    }

    protected final byte[][] getRawKey() {
        return (byte[][])this.rawKey.clone();
    }
}

