/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.javaspi.util;

import com.ibm.icu.impl.javaspi.ICULocaleServiceProvider;
import com.ibm.icu.text.TimeZoneNames;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.util.Locale;
import java.util.spi.TimeZoneNameProvider;

public class TimeZoneNameProviderICU
extends TimeZoneNameProvider {
    @Override
    public String getDisplayName(String ID, boolean daylight, int style, Locale locale) {
        String dispName = null;
        boolean[] isSystemID = new boolean[1];
        String canonicalID = TimeZone.getCanonicalID((String)ID, (boolean[])isSystemID);
        if (isSystemID[0]) {
            long date = System.currentTimeMillis();
            TimeZoneNames tznames = TimeZoneNames.getInstance((ULocale)ICULocaleServiceProvider.toULocaleNoSpecialVariant(locale));
            String lstd = tznames.getDisplayName(canonicalID, TimeZoneNames.NameType.LONG_STANDARD, date);
            String ldst = tznames.getDisplayName(canonicalID, TimeZoneNames.NameType.LONG_DAYLIGHT, date);
            String sstd = tznames.getDisplayName(canonicalID, TimeZoneNames.NameType.SHORT_STANDARD, date);
            String sdst = tznames.getDisplayName(canonicalID, TimeZoneNames.NameType.SHORT_DAYLIGHT, date);
            if (lstd != null && ldst != null && sstd != null && sdst != null) {
                switch (style) {
                    case 1: {
                        dispName = daylight ? ldst : lstd;
                        break;
                    }
                    case 0: {
                        dispName = daylight ? sdst : sstd;
                    }
                }
            }
        }
        return dispName;
    }

    @Override
    public Locale[] getAvailableLocales() {
        return ICULocaleServiceProvider.getAvailableLocales();
    }
}

