/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.sdk.core.security;

import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.security.BasicAuthenticator;
import com.ibm.cloud.sdk.core.security.BearerTokenAuthenticator;
import com.ibm.cloud.sdk.core.security.CloudPakForDataAuthenticator;
import com.ibm.cloud.sdk.core.security.CloudPakForDataServiceAuthenticator;
import com.ibm.cloud.sdk.core.security.IamAuthenticator;
import com.ibm.cloud.sdk.core.security.NoAuthAuthenticator;
import com.ibm.cloud.sdk.core.util.CredentialUtils;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ConfigBasedAuthenticatorFactory {
    public static final String ERRORMSG_AUTHTYPE_UNKNOWN = "Unrecognized authentication type: %s";

    protected ConfigBasedAuthenticatorFactory() {
    }

    public static Authenticator getAuthenticator(String serviceName) {
        Authenticator authenticator = null;
        Map<String, String> authProps = CredentialUtils.getServiceProperties(serviceName);
        if (!authProps.isEmpty()) {
            authenticator = ConfigBasedAuthenticatorFactory.createAuthenticator(authProps);
        }
        return authenticator;
    }

    private static Authenticator createAuthenticator(Map<String, String> props) {
        Authenticator authenticator = null;
        String authType = props.get("AUTH_TYPE");
        if (StringUtils.isEmpty((CharSequence)authType)) {
            authType = "iam";
        }
        if (authType.equalsIgnoreCase("basic")) {
            authenticator = BasicAuthenticator.fromConfiguration(props);
        } else if (authType.equalsIgnoreCase("bearerToken")) {
            authenticator = BearerTokenAuthenticator.fromConfiguration(props);
        } else if (authType.equalsIgnoreCase("cp4d")) {
            authenticator = CloudPakForDataAuthenticator.fromConfiguration(props);
        } else if (authType.equalsIgnoreCase("cp4dService")) {
            authenticator = CloudPakForDataServiceAuthenticator.fromConfiguration(props);
        } else if (authType.equalsIgnoreCase("iam")) {
            authenticator = IamAuthenticator.fromConfiguration(props);
        } else if (authType.equalsIgnoreCase("noAuth")) {
            authenticator = new NoAuthAuthenticator(props);
        } else {
            throw new IllegalArgumentException(String.format(ERRORMSG_AUTHTYPE_UNKNOWN, authType));
        }
        return authenticator;
    }
}

