/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.sdk.core.security;

import com.ibm.cloud.sdk.core.http.RequestBuilder;
import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.security.IamToken;
import com.ibm.cloud.sdk.core.security.TokenRequestBasedAuthenticator;
import com.ibm.cloud.sdk.core.util.CredentialUtils;
import java.util.Map;
import okhttp3.FormBody;
import okhttp3.RequestBody;
import org.apache.commons.lang3.StringUtils;

public class IamAuthenticator
extends TokenRequestBasedAuthenticator<IamToken, IamToken>
implements Authenticator {
    private String apikey;
    private String url;
    private String scope;
    private static final String DEFAULT_IAM_URL = "https://iam.cloud.ibm.com/identity/token";
    private static final String GRANT_TYPE = "grant_type";
    private static final String REQUEST_GRANT_TYPE = "urn:ibm:params:oauth:grant-type:apikey";
    private static final String API_KEY = "apikey";
    private static final String RESPONSE_TYPE = "response_type";
    private static final String CLOUD_IAM = "cloud_iam";
    private static final String SCOPE = "scope";

    protected IamAuthenticator() {
    }

    public IamAuthenticator(String apikey) {
        this.init(apikey, null, null, null, false, null, null);
    }

    public IamAuthenticator(String apikey, String url, String clientId, String clientSecret, boolean disableSSLVerification, Map<String, String> headers) {
        this.init(apikey, url, clientId, clientSecret, disableSSLVerification, headers, null);
    }

    public IamAuthenticator(String apikey, String url, String clientId, String clientSecret, boolean disableSSLVerification, Map<String, String> headers, String scope) {
        this.init(apikey, url, clientId, clientSecret, disableSSLVerification, headers, scope);
    }

    public IamAuthenticator(Map<String, String> config) {
        String apikey = config.get("APIKEY");
        if (StringUtils.isEmpty((CharSequence)apikey)) {
            apikey = config.get("IAM_APIKEY");
        }
        this.init(apikey, config.get("AUTH_URL"), config.get("CLIENT_ID"), config.get("CLIENT_SECRET"), Boolean.valueOf(config.get("AUTH_DISABLE_SSL")), null, config.get("SCOPE"));
    }

    protected void init(String apikey, String url, String clientId, String clientSecret, boolean disableSSLVerification, Map<String, String> headers, String scope) {
        this.apikey = apikey;
        if (StringUtils.isEmpty((CharSequence)url)) {
            url = DEFAULT_IAM_URL;
        }
        this.url = url;
        this.setDisableSSLVerification(disableSSLVerification);
        this.setHeaders(headers);
        this.setClientIdAndSecret(clientId, clientSecret);
        this.setScope(scope);
    }

    @Override
    public void validate() {
        if (StringUtils.isEmpty((CharSequence)this.apikey)) {
            throw new IllegalArgumentException(String.format("The %s property is required but was not specified.", API_KEY));
        }
        if (CredentialUtils.hasBadStartOrEndChar(this.apikey)) {
            throw new IllegalArgumentException(String.format("The %s property is invalid. Please remove any surrounding {, }, or \" characters.", API_KEY));
        }
        if (!StringUtils.isEmpty((CharSequence)this.getUsername()) || !StringUtils.isEmpty((CharSequence)this.getPassword())) {
            if (StringUtils.isEmpty((CharSequence)this.getUsername())) {
                throw new IllegalArgumentException(String.format("The %s property is required but was not specified.", "clientId"));
            }
            if (StringUtils.isEmpty((CharSequence)this.getPassword())) {
                throw new IllegalArgumentException(String.format("The %s property is required but was not specified.", "clientSecret"));
            }
        }
    }

    @Override
    public String authenticationType() {
        return "iam";
    }

    public String getApiKey() {
        return this.apikey;
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String url) {
        if (StringUtils.isEmpty((CharSequence)url)) {
            url = DEFAULT_IAM_URL;
        }
        this.url = url;
    }

    public String getClientId() {
        return this.getUsername();
    }

    public String getClientSecret() {
        return this.getPassword();
    }

    public void setClientIdAndSecret(String clientId, String clientSecret) {
        this.setBasicAuthInfo(clientId, clientSecret);
        this.validate();
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String value) {
        this.scope = value;
    }

    @Override
    public IamToken requestToken() {
        IamToken token;
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.constructHttpUrl(this.url, new String[0]));
        builder.header("Content-Type", "application/x-www-form-urlencoded");
        FormBody.Builder formBodyBuilder = new FormBody.Builder().add(GRANT_TYPE, REQUEST_GRANT_TYPE).add(API_KEY, this.apikey).add(RESPONSE_TYPE, CLOUD_IAM);
        if (!StringUtils.isEmpty((CharSequence)this.getScope())) {
            formBodyBuilder.add(SCOPE, this.getScope());
        }
        FormBody formBody = formBodyBuilder.build();
        builder.body((RequestBody)formBody);
        try {
            token = this.invokeRequest(builder, IamToken.class);
        }
        catch (Throwable t) {
            token = new IamToken(t);
        }
        return token;
    }
}

