/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.sdk.core.util;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LoggingUtils {
    private static final String[] redactedKeywords = new String[]{"apikey", "api_key", "passcode", "password", "token", "aadClientId", "aadClientSecret", "auth", "auth_provider_x509_cert_url", "auth_uri", "client_email", "client_id", "client_x509_cert_url", "key", "project_id", "secret", "subscriptionId", "tenantId", "thumbprint", "token_uri"};
    private static final String redactedTokens = String.join((CharSequence)"|", Arrays.asList(redactedKeywords));
    private static final String redacted = "[redacted]";
    private static final Pattern reAuthHeader = Pattern.compile("(?m)^(Authorization|X-Auth\\S*): .*");
    private static final Pattern rePropertySetting = Pattern.compile("(?i)(" + redactedTokens + ")=[^&]*(&|$)");
    private static final Pattern reJsonField = Pattern.compile("(?i)\"([^\"]*(" + redactedTokens + ")[^\"_]*)\":\\s*\"[^\\,]*\"");

    private LoggingUtils() {
    }

    public static String redactSecrets(String s) {
        String redactedString = s;
        Matcher matcher1 = reAuthHeader.matcher(redactedString);
        redactedString = matcher1.replaceAll("$1: [redacted]");
        Matcher matcher2 = rePropertySetting.matcher(redactedString);
        redactedString = matcher2.replaceAll("$1=[redacted]$2");
        Matcher matcher3 = reJsonField.matcher(redactedString);
        redactedString = matcher3.replaceAll("\"$1\":\"[redacted]\"");
        return redactedString;
    }
}

