/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.sdk.core.security;

import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.security.BasicAuthenticator;
import com.ibm.cloud.sdk.core.security.BearerTokenAuthenticator;
import com.ibm.cloud.sdk.core.security.CloudPakForDataAuthenticator;
import com.ibm.cloud.sdk.core.security.CloudPakForDataServiceAuthenticator;
import com.ibm.cloud.sdk.core.security.CloudPakForDataServiceInstanceAuthenticator;
import com.ibm.cloud.sdk.core.security.ContainerAuthenticator;
import com.ibm.cloud.sdk.core.security.IamAssumeAuthenticator;
import com.ibm.cloud.sdk.core.security.IamAuthenticator;
import com.ibm.cloud.sdk.core.security.MCSPAuthenticator;
import com.ibm.cloud.sdk.core.security.MCSPV2Authenticator;
import com.ibm.cloud.sdk.core.security.NoAuthAuthenticator;
import com.ibm.cloud.sdk.core.security.VpcInstanceAuthenticator;
import com.ibm.cloud.sdk.core.util.CredentialUtils;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class ConfigBasedAuthenticatorFactory {
    private static final Logger LOG = Logger.getLogger(ConfigBasedAuthenticatorFactory.class.getName());
    public static final String ERRORMSG_AUTHTYPE_UNKNOWN = "Unrecognized authentication type: %s";

    protected ConfigBasedAuthenticatorFactory() {
    }

    public static Authenticator getAuthenticator(String serviceName) {
        LOG.log(Level.FINE, "Get authenticator from environment, key={0}", serviceName);
        Authenticator authenticator = null;
        Map<String, String> authProps = CredentialUtils.getServiceProperties(serviceName);
        if (!authProps.isEmpty() && (authenticator = ConfigBasedAuthenticatorFactory.createAuthenticator(authProps)) != null) {
            LOG.log(Level.FINE, "Returning authenticator, type={0}", authenticator.authenticationType());
        }
        return authenticator;
    }

    protected static Authenticator createAuthenticator(Map<String, String> props) {
        Authenticator authenticator = null;
        String authType = props.get("AUTH_TYPE");
        if (StringUtils.isEmpty((CharSequence)authType)) {
            authType = props.get("AUTHTYPE");
        }
        if (StringUtils.isEmpty((CharSequence)authType)) {
            authType = props.get("APIKEY") != null || props.get("IAM_APIKEY") != null ? "iam" : "container";
            LOG.log(Level.FINE, "Assuming default authentication type: {0}", authType);
        }
        if (authType.equalsIgnoreCase("basic")) {
            authenticator = BasicAuthenticator.fromConfiguration(props);
        } else if (authType.equalsIgnoreCase("bearerToken")) {
            authenticator = BearerTokenAuthenticator.fromConfiguration(props);
        } else if (authType.equalsIgnoreCase("cp4d")) {
            authenticator = CloudPakForDataAuthenticator.fromConfiguration(props);
        } else if (authType.equalsIgnoreCase("cp4dService")) {
            authenticator = CloudPakForDataServiceAuthenticator.fromConfiguration(props);
        } else if (authType.equalsIgnoreCase("cp4dServiceInstance")) {
            authenticator = CloudPakForDataServiceInstanceAuthenticator.fromConfiguration(props);
        } else if (authType.equalsIgnoreCase("iam")) {
            authenticator = IamAuthenticator.fromConfiguration(props);
        } else if (authType.equalsIgnoreCase("iamAssume")) {
            authenticator = IamAssumeAuthenticator.fromConfiguration(props);
        } else if (authType.equalsIgnoreCase("container")) {
            authenticator = ContainerAuthenticator.fromConfiguration(props);
        } else if (authType.equalsIgnoreCase("vpc")) {
            authenticator = VpcInstanceAuthenticator.fromConfiguration(props);
        } else if (authType.equalsIgnoreCase("mcsp")) {
            authenticator = MCSPAuthenticator.fromConfiguration(props);
        } else if (authType.equalsIgnoreCase("mcspv2")) {
            authenticator = MCSPV2Authenticator.fromConfiguration(props);
        } else if (authType.equalsIgnoreCase("noAuth")) {
            authenticator = new NoAuthAuthenticator(props);
        } else {
            throw new IllegalArgumentException(String.format(ERRORMSG_AUTHTYPE_UNKNOWN, authType));
        }
        return authenticator;
    }
}

