/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.sdk.core.http;

import com.ibm.cloud.sdk.core.http.DefaultRetryStrategy;
import com.ibm.cloud.sdk.core.http.HttpConfigOptions;
import com.ibm.cloud.sdk.core.http.HttpLogger;
import com.ibm.cloud.sdk.core.http.IRetryInterceptor;
import com.ibm.cloud.sdk.core.http.IRetryStrategy;
import com.ibm.cloud.sdk.core.http.ServiceCookieJar;
import com.ibm.cloud.sdk.core.http.gzip.GzipRequestInterceptor;
import com.ibm.cloud.sdk.core.service.security.DelegatingSSLSocketFactory;
import java.io.IOException;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.Proxy;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Authenticator;
import okhttp3.ConnectionSpec;
import okhttp3.CookieJar;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.TlsVersion;

public class HttpClientSingleton {
    private static HttpClientSingleton instance = null;
    private static final Logger LOG = Logger.getLogger(HttpClientSingleton.class.getName());
    private static IRetryStrategy retryStrategy = new DefaultRetryStrategy();
    private static final TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }};
    private OkHttpClient okHttpClient = this.configureHttpClient();

    public static synchronized IRetryStrategy setRetryStrategy(IRetryStrategy strategy) {
        IRetryStrategy previousStrategy = retryStrategy;
        retryStrategy = strategy;
        return previousStrategy;
    }

    public static synchronized HttpClientSingleton getInstance() {
        if (instance == null) {
            instance = new HttpClientSingleton();
        }
        return instance;
    }

    protected HttpClientSingleton() {
    }

    public OkHttpClient getHttpClient() {
        return this.okHttpClient;
    }

    public void setHttpClient(OkHttpClient client) {
        this.okHttpClient = client;
    }

    private OkHttpClient configureHttpClient() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        this.addCookieJar(builder);
        builder.connectTimeout(60L, TimeUnit.SECONDS);
        builder.writeTimeout(60L, TimeUnit.SECONDS);
        builder.readTimeout(90L, TimeUnit.SECONDS);
        ConnectionSpec spec = new ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS).allEnabledCipherSuites().build();
        builder.connectionSpecs(Arrays.asList(spec, ConnectionSpec.CLEARTEXT));
        HttpClientSingleton.setupTLSProtocol(builder);
        return builder.build();
    }

    private void addCookieJar(OkHttpClient.Builder builder) {
        CookieManager cookieManager = new CookieManager();
        cookieManager.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
        builder.cookieJar((CookieJar)new ServiceCookieJar(cookieManager));
    }

    private OkHttpClient disableSslVerification(OkHttpClient client) {
        SSLContext trustAllSslContext;
        try {
            trustAllSslContext = SSLContext.getInstance("SSL");
            trustAllSslContext.init(null, trustAllCerts, new SecureRandom());
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        FilteredSSLSocketFactory trustAllSslSocketFactory = new FilteredSSLSocketFactory(trustAllSslContext.getSocketFactory());
        OkHttpClient.Builder builder = client.newBuilder();
        builder.sslSocketFactory((SSLSocketFactory)trustAllSslSocketFactory, (X509TrustManager)trustAllCerts[0]);
        builder.hostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        });
        return builder.build();
    }

    private OkHttpClient setProxy(OkHttpClient client, Proxy proxy) {
        OkHttpClient.Builder builder = client.newBuilder().proxy(proxy);
        return builder.build();
    }

    private OkHttpClient setProxyAuthenticator(OkHttpClient client, Authenticator proxyAuthenticator) {
        OkHttpClient.Builder builder = client.newBuilder().proxyAuthenticator(proxyAuthenticator);
        return builder.build();
    }

    private OkHttpClient setLoggingLevel(OkHttpClient client, HttpConfigOptions.LoggingLevel loggingLevel) {
        HttpLogger loggingInterceptor = null;
        for (Interceptor i : client.networkInterceptors()) {
            if (!(i instanceof HttpLogger)) continue;
            loggingInterceptor = (HttpLogger)i;
        }
        OkHttpClient updatedClient = client;
        if (loggingInterceptor == null) {
            loggingInterceptor = new HttpLogger();
            OkHttpClient.Builder builder = client.newBuilder().addNetworkInterceptor((Interceptor)loggingInterceptor);
            updatedClient = builder.build();
        }
        switch (loggingLevel) {
            case BODY: {
                loggingInterceptor.setLevel(HttpLogger.Level.BODY);
                break;
            }
            case HEADERS: {
                loggingInterceptor.setLevel(HttpLogger.Level.HEADERS);
                break;
            }
            case BASIC: {
                loggingInterceptor.setLevel(HttpLogger.Level.BASIC);
                break;
            }
            default: {
                loggingInterceptor.setLevel(HttpLogger.Level.NONE);
            }
        }
        return updatedClient;
    }

    public static void setupTLSProtocol(OkHttpClient.Builder builder) {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)null);
            Object[] trustManagers = trustManagerFactory.getTrustManagers();
            if (trustManagers.length != 1 || !(trustManagers[0] instanceof X509TrustManager)) {
                throw new IllegalStateException("Unexpected default trust managers:" + Arrays.toString(trustManagers));
            }
            X509TrustManager trustManager = (X509TrustManager)trustManagers[0];
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{trustManager}, null);
            FilteredSSLSocketFactory sslSocketFactory = new FilteredSSLSocketFactory(sslContext.getSocketFactory());
            builder.sslSocketFactory((SSLSocketFactory)sslSocketFactory, trustManager);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.log(Level.SEVERE, "The cryptographic algorithm requested is not available in the environment.", e);
        }
        catch (KeyStoreException e) {
            LOG.log(Level.SEVERE, "Error using the keystore.", e);
        }
        catch (KeyManagementException e) {
            LOG.log(Level.SEVERE, "Error initializing the SSL Context.", e);
        }
    }

    private OkHttpClient reconfigureClientInterceptors(OkHttpClient client, String interceptorToRemove) {
        OkHttpClient.Builder builder = client.newBuilder();
        if (!builder.interceptors().isEmpty()) {
            Iterator iter = builder.interceptors().iterator();
            while (iter.hasNext()) {
                Interceptor element = (Interceptor)iter.next();
                if (!interceptorToRemove.equals(element.getClass().getSimpleName())) continue;
                iter.remove();
            }
        }
        return builder.build();
    }

    private OkHttpClient reconfigureClientInterceptors(OkHttpClient client, Class<? extends Interceptor> interfaceToRemove) {
        OkHttpClient.Builder builder = client.newBuilder();
        if (!builder.interceptors().isEmpty()) {
            Iterator iter = builder.interceptors().iterator();
            while (iter.hasNext()) {
                Interceptor element = (Interceptor)iter.next();
                if (!interfaceToRemove.isAssignableFrom(element.getClass())) continue;
                iter.remove();
            }
        }
        return builder.build();
    }

    public OkHttpClient createHttpClient() {
        OkHttpClient.Builder builder = this.okHttpClient.newBuilder();
        this.addCookieJar(builder);
        return builder.build();
    }

    public OkHttpClient configureClient(HttpConfigOptions options) {
        this.okHttpClient = this.configureClient(this.okHttpClient, options);
        return this.okHttpClient;
    }

    public OkHttpClient configureClient(OkHttpClient client, HttpConfigOptions options) {
        if (options != null) {
            Boolean enableGzip;
            Boolean enableRetries;
            if (options.shouldDisableSslVerification()) {
                client = this.disableSslVerification(client);
            }
            if (options.getProxy() != null) {
                client = this.setProxy(client, options.getProxy());
            }
            if (options.getProxyAuthenticator() != null) {
                client = this.setProxyAuthenticator(client, options.getProxyAuthenticator());
            }
            if (options.getLoggingLevel() != null) {
                client = this.setLoggingLevel(client, options.getLoggingLevel());
            }
            if ((enableRetries = options.getRetries()) != null) {
                client = this.reconfigureClientInterceptors(client, IRetryInterceptor.class);
                if (enableRetries.booleanValue()) {
                    IRetryInterceptor retryInterceptor = retryStrategy.createRetryInterceptor(options.getMaxRetries(), options.getMaxRetryInterval(), options.getAuthenticator());
                    if (retryInterceptor != null) {
                        client = client.newBuilder().addInterceptor((Interceptor)retryInterceptor).build();
                    } else {
                        LOG.log(Level.WARNING, "The retry interceptor factory returned a null IRetryInterceptor instance. Retries are disabled.");
                    }
                }
            }
            if ((enableGzip = options.getGzipCompression()) != null) {
                client = this.reconfigureClientInterceptors(client, "GzipRequestInterceptor");
                if (enableGzip.booleanValue()) {
                    client = client.newBuilder().addInterceptor((Interceptor)new GzipRequestInterceptor()).build();
                }
            }
        }
        return client;
    }

    private static final class FilteredSSLSocketFactory
    extends DelegatingSSLSocketFactory {
        private static final List<String> MODERN_TLS_NAMES = new ArrayList<String>();

        private FilteredSSLSocketFactory(SSLSocketFactory delegate) {
            super(delegate);
        }

        @Override
        protected SSLSocket configureSocket(SSLSocket socket) throws IOException {
            List<String> supportedTlsNames = Arrays.asList(socket.getSupportedProtocols());
            LOG.log(Level.FINEST, "Socket supported TLS protocols: {0}", supportedTlsNames);
            ArrayList<String> protocolsToEnable = new ArrayList<String>();
            protocolsToEnable.addAll(supportedTlsNames);
            protocolsToEnable.retainAll(MODERN_TLS_NAMES);
            LOG.log(Level.FINEST, "Filtered TLS protocols to enable: {0}", protocolsToEnable);
            socket.setEnabledProtocols(protocolsToEnable.toArray(new String[0]));
            return socket;
        }

        static {
            for (TlsVersion tlsVersion : ConnectionSpec.MODERN_TLS.tlsVersions()) {
                MODERN_TLS_NAMES.add(tlsVersion.javaName());
            }
            LOG.log(Level.FINEST, "Modern TLS names: {0}", MODERN_TLS_NAMES);
        }
    }
}

