/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.sdk.core.http;

import com.ibm.cloud.sdk.core.util.LoggingUtils;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import okhttp3.Connection;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.GzipSource;
import okio.Source;
import org.apache.commons.lang3.StringUtils;

public class HttpLogger
implements Interceptor {
    private static final Logger LOG = Logger.getLogger(HttpLogger.class.getName());
    private Level level = Level.NONE;

    public void setLevel(Level l) {
        this.level = l;
    }

    public Level getLevel() {
        return this.level;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Response response;
        Request request = chain.request();
        if (this.getLevel() == Level.NONE) {
            return chain.proceed(request);
        }
        boolean logBody = this.getLevel() == Level.BODY;
        boolean logHeaders = logBody || this.getLevel() == Level.HEADERS;
        RequestBody requestBody = request.body();
        Connection c = chain.connection();
        Protocol p = c != null ? c.protocol() : null;
        String protocol = p != null ? " " + p.toString() : "";
        StringBuilder msg = new StringBuilder();
        String requestBodyMsg = "";
        if (!logHeaders && requestBody != null) {
            requestBodyMsg = String.format(" (%d-byte body)", requestBody.contentLength());
        }
        msg.append(String.format("--> HTTP Request:\n%s %s%s%s\n", request.method(), request.url().toString(), protocol, requestBodyMsg));
        if (logHeaders) {
            this.logHeaders(request.headers(), msg);
            if (!logBody || requestBody == null) {
                msg.append(String.format("--> END %s", request.method()));
            } else if (this.bodyHasUnknownEncoding(request.headers())) {
                msg.append(String.format("--> END %s (encoded body omitted)", request.method()));
            } else if (requestBody.isDuplex()) {
                msg.append(String.format("--> END %s (duplex request body omitted)", request.method()));
            } else if (requestBody.isOneShot()) {
                msg.append(String.format("--> END %s (one-shot body omitted)", request.method()));
            } else {
                Buffer buffer = new Buffer();
                requestBody.writeTo((BufferedSink)buffer);
                Long gzippedLength = null;
                String contentEncoding = request.headers().get("Content-Encoding");
                if ("gzip".equalsIgnoreCase(contentEncoding)) {
                    gzippedLength = buffer.size();
                    GzipSource gzippedBody = null;
                    try {
                        gzippedBody = new GzipSource((Source)buffer.clone());
                        buffer = new Buffer();
                        buffer.writeAll((Source)gzippedBody);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                MediaType contentType = requestBody.contentType();
                Charset charset = null;
                if (contentType != null) {
                    charset = contentType.charset(StandardCharsets.UTF_8);
                }
                if (charset == null) {
                    charset = StandardCharsets.UTF_8;
                }
                long buflen = buffer.size();
                try {
                    String s = buffer.readString(charset);
                    msg.append("\n").append(s).append("\n");
                    if (gzippedLength != null) {
                        msg.append(String.format("--> END %s (%d-byte, %d-gzipped-byte body)", request.method(), buflen, gzippedLength.intValue()));
                    } else {
                        msg.append(String.format("--> END %s (%d-byte body)", request.method(), buflen));
                    }
                }
                catch (Throwable t) {
                    msg.append(String.format("--> END %s (binary %d-byte body omitted)", request.method(), buflen));
                }
            }
        }
        LOG.fine(LoggingUtils.redactSecrets(msg.toString()));
        long startNS = System.nanoTime();
        try {
            response = chain.proceed(request);
        }
        catch (Throwable t) {
            LOG.log(java.util.logging.Level.SEVERE, "<-- HTTP FAILED: ", t);
            throw t;
        }
        msg = new StringBuilder();
        long tookMS = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNS);
        ResponseBody responseBody = response != null ? response.body() : null;
        long contentLength = responseBody != null ? responseBody.contentLength() : -1L;
        String bodySize = contentLength >= 0L ? String.format("%d-byte", contentLength) : "unknown-length";
        msg.append(String.format("<-- HTTP Response:\n%d", response.code()));
        if (StringUtils.isNotEmpty((CharSequence)response.message())) {
            msg.append(" ").append(response.message());
        }
        msg.append(" ").append(response.request().url().toString());
        msg.append(String.format(" (%dms", tookMS));
        if (!logHeaders) {
            msg.append(String.format(", %s body", bodySize));
        }
        msg.append(")\n");
        if (logHeaders) {
            this.logHeaders(response.headers(), msg);
            if (!logBody || responseBody == null) {
                msg.append("<-- END HTTP");
            } else if (this.bodyHasUnknownEncoding(response.headers())) {
                msg.append("--> END HTTP (encoded body omitted)");
            } else {
                BufferedSource source = responseBody.source();
                source.request(Long.MAX_VALUE);
                Buffer buffer = source.buffer();
                Long gzippedLength = null;
                String contentEncoding = response.headers().get("Content-Encoding");
                if ("gzip".equalsIgnoreCase(contentEncoding)) {
                    gzippedLength = buffer.size();
                    GzipSource gzippedBody = null;
                    try {
                        gzippedBody = new GzipSource((Source)buffer.clone());
                        buffer = new Buffer();
                        buffer.writeAll((Source)gzippedBody);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                MediaType contentType = responseBody.contentType();
                Charset charset = null;
                if (contentType != null) {
                    charset = contentType.charset(StandardCharsets.UTF_8);
                }
                if (charset != null) {
                    charset = StandardCharsets.UTF_8;
                }
                try {
                    if (contentLength > 0L) {
                        String s = buffer.clone().readString(charset);
                        msg.append("\n").append(s).append("\n");
                        if (gzippedLength != null) {
                            msg.append(String.format("<-- END HTTP (%d-byte, %d-gzipped-byte body)", buffer.size(), gzippedLength.intValue()));
                        } else {
                            msg.append(String.format("<-- END HTTP (%d-byte body)", buffer.size()));
                        }
                    }
                }
                catch (Throwable t) {
                    if (gzippedLength != null) {
                        msg.append(String.format("<-- END HTTP (binary %d-byte, %d-gzipped-byte body omitted)", buffer.size(), gzippedLength.intValue()));
                    }
                    msg.append(String.format("<-- END HTTP (binary %d-byte body omitted)", buffer.size()));
                }
            }
        }
        LOG.fine(LoggingUtils.redactSecrets(msg.toString()));
        return response;
    }

    private void logHeaders(Headers headers, StringBuilder sb) {
        for (int i = 0; i < headers.size(); ++i) {
            sb.append(String.format("%s: %s\n", headers.name(i), headers.value(i)));
        }
    }

    private boolean bodyHasUnknownEncoding(Headers headers) {
        String contentEncoding = headers.get("Content-Encoding");
        if (StringUtils.isEmpty((CharSequence)contentEncoding)) {
            return false;
        }
        return !"identity".equalsIgnoreCase(contentEncoding) && !"gzip".equalsIgnoreCase(contentEncoding);
    }

    static enum Level {
        NONE,
        BASIC,
        HEADERS,
        BODY;

    }
}

