/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.sdk.core.security;

import com.ibm.cloud.sdk.core.http.RequestBuilder;
import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.security.Cp4dServiceInstanceTokenResponse;
import com.ibm.cloud.sdk.core.security.Cp4dToken;
import com.ibm.cloud.sdk.core.security.TokenRequestBasedAuthenticator;
import com.ibm.cloud.sdk.core.util.RequestUtils;
import java.net.Proxy;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class CloudPakForDataServiceInstanceAuthenticator
extends TokenRequestBasedAuthenticator<Cp4dToken, Cp4dServiceInstanceTokenResponse>
implements Authenticator {
    private String url;
    private String username;
    private String apikey;
    private String serviceInstanceId;

    protected CloudPakForDataServiceInstanceAuthenticator() {
        this.setUserAgent(RequestUtils.buildUserAgent("cp4d-service-instance-authenticator"));
    }

    protected CloudPakForDataServiceInstanceAuthenticator(Builder builder) {
        this();
        this.url = builder.url;
        this.username = builder.username;
        this.apikey = builder.apikey;
        this.serviceInstanceId = builder.serviceInstanceId;
        this.setDisableSSLVerification(builder.disableSSLVerification);
        this.setHeaders(builder.headers);
        this.setProxy(builder.proxy);
        this.setProxyAuthenticator(builder.proxyAuthenticator);
        this.validate();
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public static CloudPakForDataServiceInstanceAuthenticator fromConfiguration(Map<String, String> config) {
        return new Builder().url(config.get("AUTH_URL")).username(config.get("USERNAME")).apikey(config.get("APIKEY")).serviceInstanceId(config.get("SERVICE_INSTANCE_ID")).disableSSLVerification(Boolean.valueOf(config.get("AUTH_DISABLE_SSL"))).build();
    }

    @Override
    public String authenticationType() {
        return "cp4dServiceInstance";
    }

    @Override
    public void validate() {
        if (StringUtils.isEmpty((CharSequence)this.url)) {
            throw new IllegalArgumentException(String.format("The %s property is required but was not specified.", "url"));
        }
        if (StringUtils.isEmpty((CharSequence)this.username)) {
            throw new IllegalArgumentException(String.format("The %s property is required but was not specified.", "username"));
        }
        if (StringUtils.isEmpty((CharSequence)this.apikey)) {
            throw new IllegalArgumentException(String.format("The %s property is required but was not specified.", "apikey"));
        }
        if (StringUtils.isEmpty((CharSequence)this.serviceInstanceId)) {
            throw new IllegalArgumentException(String.format("The %s property is required but was not specified.", "serviceInstanceId"));
        }
    }

    public String getURL() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getApikey() {
        return this.apikey;
    }

    public String getServiceInstanceId() {
        return this.serviceInstanceId;
    }

    @Override
    public Cp4dToken requestToken() {
        Cp4dToken token;
        Map<String, String> pathParams = Collections.singletonMap("service_instance_id", this.serviceInstanceId);
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.url, "/v3/service_instances/{service_instance_id}/token", pathParams));
        builder.header("User-Agent", this.getUserAgent());
        builder.header("Authorization", CloudPakForDataServiceInstanceAuthenticator.constructBasicAuthHeader(this.username, this.apikey));
        try {
            Cp4dServiceInstanceTokenResponse response = this.invokeRequest(builder, Cp4dServiceInstanceTokenResponse.class);
            token = new Cp4dToken(response);
        }
        catch (Throwable t) {
            token = new Cp4dToken(t);
        }
        return token;
    }

    public static class Builder {
        private String url;
        private String username;
        private String serviceInstanceId;
        private String apikey;
        private boolean disableSSLVerification;
        private Map<String, String> headers;
        private Proxy proxy;
        private okhttp3.Authenticator proxyAuthenticator;

        public Builder() {
        }

        private Builder(CloudPakForDataServiceInstanceAuthenticator obj) {
            this.url = obj.url;
            this.username = obj.username;
            this.apikey = obj.apikey;
            this.serviceInstanceId = obj.serviceInstanceId;
            this.disableSSLVerification = obj.getDisableSSLVerification();
            this.headers = obj.getHeaders();
            this.proxy = obj.getProxy();
            this.proxyAuthenticator = obj.getProxyAuthenticator();
        }

        public CloudPakForDataServiceInstanceAuthenticator build() {
            return new CloudPakForDataServiceInstanceAuthenticator(this);
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder apikey(String apikey) {
            this.apikey = apikey;
            return this;
        }

        public Builder serviceInstanceId(String serviceInstanceId) {
            this.serviceInstanceId = serviceInstanceId;
            return this;
        }

        public Builder disableSSLVerification(boolean disableSSLVerification) {
            this.disableSSLVerification = disableSSLVerification;
            return this;
        }

        public Builder headers(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public Builder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder proxyAuthenticator(okhttp3.Authenticator proxyAuthenticator) {
            this.proxyAuthenticator = proxyAuthenticator;
            return this;
        }
    }
}

