/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.sdk.core.http;

import java.net.Proxy;
import okhttp3.Authenticator;

public class HttpConfigOptions {
    private boolean disableSslVerification;
    private Boolean enableGzipCompression;
    private Boolean enableRetries;
    private int maxRetries;
    private int maxRetryInterval;
    private Proxy proxy;
    private Authenticator proxyAuthenticator;
    private LoggingLevel loggingLevel;
    private com.ibm.cloud.sdk.core.security.Authenticator authenticator;

    public boolean shouldDisableSslVerification() {
        return this.disableSslVerification;
    }

    public Boolean getGzipCompression() {
        return this.enableGzipCompression;
    }

    public Boolean getRetries() {
        return this.enableRetries;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public int getMaxRetryInterval() {
        return this.maxRetryInterval;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public Authenticator getProxyAuthenticator() {
        return this.proxyAuthenticator;
    }

    public LoggingLevel getLoggingLevel() {
        return this.loggingLevel;
    }

    public com.ibm.cloud.sdk.core.security.Authenticator getAuthenticator() {
        return this.authenticator;
    }

    @Deprecated
    public int getDefaultRetryInterval() {
        return this.getMaxRetryInterval();
    }

    private HttpConfigOptions(Builder builder) {
        this.disableSslVerification = builder.disableSslVerification;
        this.enableGzipCompression = builder.enableGzipCompression;
        this.enableRetries = builder.enableRetries;
        this.maxRetries = builder.maxRetries;
        this.maxRetryInterval = builder.maxRetryInterval;
        this.proxy = builder.proxy;
        this.proxyAuthenticator = builder.proxyAuthenticator;
        this.loggingLevel = builder.loggingLevel;
        this.authenticator = builder.authenticator;
    }

    public static class Builder {
        private boolean disableSslVerification;
        private Boolean enableGzipCompression;
        private Boolean enableRetries;
        private int maxRetries;
        private int maxRetryInterval;
        private Proxy proxy;
        private Authenticator proxyAuthenticator;
        private LoggingLevel loggingLevel;
        private com.ibm.cloud.sdk.core.security.Authenticator authenticator;

        public HttpConfigOptions build() {
            return new HttpConfigOptions(this);
        }

        public Builder disableSslVerification(boolean disableSslVerification) {
            this.disableSslVerification = disableSslVerification;
            return this;
        }

        public Builder enableGzipCompression(Boolean enableGzipCompression) {
            this.enableGzipCompression = enableGzipCompression;
            return this;
        }

        @Deprecated
        public Builder enableRateLimitRetry(com.ibm.cloud.sdk.core.security.Authenticator authenticator, int defaultInterval, int maxRetries) {
            return this.enableRetries(authenticator, maxRetries, defaultInterval);
        }

        public Builder enableRetries(com.ibm.cloud.sdk.core.security.Authenticator authenticator, int maxRetries, int maxRetryInterval) {
            this.enableRetries = true;
            this.authenticator = authenticator;
            this.maxRetries = maxRetries;
            this.maxRetryInterval = maxRetryInterval;
            return this;
        }

        public Builder disableRetries() {
            this.enableRetries = false;
            this.maxRetries = 0;
            this.maxRetryInterval = 0;
            return this;
        }

        public Builder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder proxyAuthenticator(Authenticator proxyAuthenticator) {
            this.proxyAuthenticator = proxyAuthenticator;
            return this;
        }

        public Builder loggingLevel(LoggingLevel loggingLevel) {
            this.loggingLevel = loggingLevel;
            return this;
        }
    }

    public static enum LoggingLevel {
        NONE,
        BASIC,
        HEADERS,
        BODY;

    }
}

