/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.sdk.core.security;

import com.ibm.cloud.sdk.core.http.RequestBuilder;
import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.security.IamToken;
import com.ibm.cloud.sdk.core.security.TokenRequestBasedAuthenticator;
import com.ibm.cloud.sdk.core.security.VpcTokenResponse;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class VpcInstanceAuthenticator
extends TokenRequestBasedAuthenticator<IamToken, VpcTokenResponse>
implements Authenticator {
    private static final Logger LOG = Logger.getLogger(VpcInstanceAuthenticator.class.getName());
    private static final String defaultIMSEndpoint = "http://169.254.169.254";
    private static final String operationPathCreateAccessToken = "/instance_identity/v1/token";
    private static final String operationPathCreateIamToken = "/instance_identity/v1/iam_token";
    private static final String metadataFlavor = "ibm";
    private static final String metadataServiceVersion = "2022-03-01";
    private static final int instanceIdentityTokenLifetime = 300;
    private String iamProfileCrn;
    private String iamProfileId;
    private String url;

    protected VpcInstanceAuthenticator() {
    }

    protected VpcInstanceAuthenticator(Builder builder) {
        this.iamProfileCrn = builder.iamProfileCrn;
        this.iamProfileId = builder.iamProfileId;
        this.url = builder.url;
        this.validate();
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public static VpcInstanceAuthenticator fromConfiguration(Map<String, String> config) {
        return new Builder().iamProfileCrn(config.get("IAM_PROFILE_CRN")).iamProfileId(config.get("IAM_PROFILE_ID")).url(config.get("AUTH_URL")).build();
    }

    @Override
    public void validate() {
        if (StringUtils.isNotEmpty((CharSequence)this.getIamProfileCrn()) && StringUtils.isNotEmpty((CharSequence)this.getIamProfileId())) {
            throw new IllegalArgumentException(String.format("At most one of %s or %s may be specified.", "iamProfileCrn", "iamProfileId"));
        }
    }

    @Override
    public String authenticationType() {
        return "vpc";
    }

    public String getIamProfileCrn() {
        return this.iamProfileCrn;
    }

    protected void setIamProfileCrn(String iamProfileCrn) {
        this.iamProfileCrn = iamProfileCrn;
    }

    public String getIamProfileId() {
        return this.iamProfileId;
    }

    protected void setIamProfileId(String iamProfileId) {
        this.iamProfileId = iamProfileId;
    }

    public String getURL() {
        return this.url;
    }

    protected void setURL(String url) {
        if (StringUtils.isEmpty((CharSequence)url)) {
            url = defaultIMSEndpoint;
        }
        this.url = url;
    }

    private String getImsEndpoint() {
        return StringUtils.isEmpty((CharSequence)this.url) ? defaultIMSEndpoint : this.url;
    }

    @Override
    public IamToken requestToken() {
        IamToken token = null;
        try {
            String instanceIdentityToken = this.retrieveInstanceIdentityToken();
            token = this.retrieveIamAccessToken(instanceIdentityToken);
        }
        catch (Throwable t) {
            token = new IamToken(t);
        }
        return token;
    }

    protected String retrieveInstanceIdentityToken() throws Throwable {
        String instanceIdentityToken = null;
        try {
            RequestBuilder builder = RequestBuilder.put(RequestBuilder.resolveRequestUrl(this.getImsEndpoint(), operationPathCreateAccessToken));
            builder.query("version", metadataServiceVersion);
            builder.header("Accept", "application/json");
            builder.header("Content-Type", "application/json");
            builder.header("Metadata-Flavor", metadataFlavor);
            String requestBody = String.format("{\"expires_in\": %d}", 300);
            builder.bodyContent(requestBody, "application/json");
            LOG.log(Level.FINE, "Invoking VPC 'create_access_token' operation: {0}", builder.toUrl());
            VpcTokenResponse vpcResponse = this.invokeRequest(builder, VpcTokenResponse.class);
            LOG.log(Level.FINE, "Returned from VPC 'create_access_token' operation.");
            instanceIdentityToken = vpcResponse.getAccessToken();
        }
        catch (Throwable t) {
            LOG.log(Level.FINE, "Caught exception from VPC 'create_access_token' operation: ", t);
            throw t;
        }
        return instanceIdentityToken;
    }

    protected IamToken retrieveIamAccessToken(String instanceIdentityToken) {
        IamToken iamToken = null;
        try {
            RequestBuilder builder = RequestBuilder.post(RequestBuilder.resolveRequestUrl(this.getImsEndpoint(), operationPathCreateIamToken));
            builder.query("version", metadataServiceVersion);
            builder.header("Accept", "application/json");
            builder.header("Content-Type", "application/json");
            builder.header("Authorization", "Bearer " + instanceIdentityToken);
            String requestBody = null;
            if (!StringUtils.isEmpty((CharSequence)this.getIamProfileCrn())) {
                requestBody = String.format("{\"trusted_profile\": {\"crn\": \"%s\"}}", this.getIamProfileCrn());
            }
            if (!StringUtils.isEmpty((CharSequence)this.getIamProfileId())) {
                requestBody = String.format("{\"trusted_profile\": {\"id\": \"%s\"}}", this.getIamProfileId());
            }
            if (!StringUtils.isEmpty(requestBody)) {
                builder.bodyContent(requestBody, "application/json");
            }
            LOG.log(Level.FINE, "Invoking VPC 'create_iam_token' operation: {0}", builder.toUrl());
            VpcTokenResponse vpcResponse = this.invokeRequest(builder, VpcTokenResponse.class);
            LOG.log(Level.FINE, "Returned from VPC 'create_iam_token' operation.");
            iamToken = new IamToken(vpcResponse);
        }
        catch (Throwable t) {
            iamToken = new IamToken(t);
            LOG.log(Level.FINE, "Caught exception from VPC 'create_iam_token' operation: ", t);
        }
        return iamToken;
    }

    public static class Builder {
        private String iamProfileCrn;
        private String iamProfileId;
        private String url;

        public Builder() {
        }

        private Builder(VpcInstanceAuthenticator obj) {
            this.iamProfileCrn = obj.iamProfileCrn;
            this.iamProfileId = obj.iamProfileId;
            this.url = obj.url;
        }

        public VpcInstanceAuthenticator build() {
            return new VpcInstanceAuthenticator(this);
        }

        public Builder iamProfileCrn(String iamProfileCrn) {
            this.iamProfileCrn = iamProfileCrn;
            return this;
        }

        public Builder iamProfileId(String iamProfileId) {
            this.iamProfileId = iamProfileId;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }
    }
}

